﻿using AsReaderP3xU;
using System;
using System.Collections;
using System.Data;
using System.IO;
using System.IO.Ports;
using System.Text;
using System.Threading;
using System.Windows.Forms;
using System.Xml;
using static AsReaderP3xU.Types;
using System.Configuration;
using Microsoft.Win32;
using System.Diagnostics;

namespace AsReaderP3xU_Demo
{
    public partial class Form1 : Form
    {
        Device device1 = new Device();
        Device device2 = new Device();
        private int total_time = 0;//The total time.
        private int total_time2 = 0;//The total time.
        int singluationCount = 0;
        int singluationCount2 = 0;
        volatile bool m_bInventory = false;
        volatile bool m_bInventory2 = false;
        bool isConnected = false;
        bool isConnected2 = false;
        int selectedIndex = 0;
        int selectedIndex2 = 0;
        string connType = "";

        uint defaultMinPower = 13;
        uint defaultMaxPower = 23;
        uint defaultMinPower2 = 13;
        uint defaultMaxPower2 = 23;

        private Hashtable mTagHashTable = new Hashtable();
        private Hashtable mTagHashTable2 = new Hashtable();
        private AsReader.InventoryResult mReadTag;
        private AsReader.InventoryResult mReadTag2;
        private delegate void ProcessDelegate();

        public int KeyPressNum = 0;
        public int KeyFreeNum = 0;
        public int KeyPressNum2 = 0;
        public int KeyFreeNum2 = 0;

        string FileName;
        string FileName2;

        bool TodatAutoStart = false;
        bool TodatAutoStart2 = false;
        int AutoStart = 0;
        int AutoStart2 = 0;

        LongPressTracking longPress;
        LongPressTracking longPress2;
        PasswordPopup passwordPopupWindow = new PasswordPopup();
        bool isDebug = false;
        public Form1()
        {
            InitializeComponent();
            this.FormClosing += new System.Windows.Forms.FormClosingEventHandler(this.AsReaderP3xU_Demo_FormClosing);
            //dt.Columns.Add("Index", typeof(string));
            //dt.Columns.Add("PC", typeof(string));
            //dt.Columns.Add("EPC", typeof(string));
            //dt.Columns.Add("Time", typeof(string));
            longPress = new LongPressTracking(grpFirmwareUpdate);
            longPress2 = new LongPressTracking(grpFirmwareUpdate2);
            longPress.LongPress += LongPress_LongPress;
            longPress2.LongPress += LongPress_LongPress;

            SystemEvents.PowerModeChanged += SystemEvents_PowerModeChanged;
        }

        bool _resume = false;

        private void SystemEvents_PowerModeChanged(object sender, PowerModeChangedEventArgs e)
        {
            if (e.Mode == PowerModes.Suspend)
            {
                if (isConnected)
                { 
                    UInt32 error = 0;
                    error = device1.DisConnect();

                    if (error == 1)
                    {
                        this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " DisConnect failed." + Environment.NewLine);
                        this.Devmes.ScrollToCaret();
                    }

                isConnected = false;
                _resume = true;
                this.ControlsEnabled();
                // 计算机进入休眠状态时关闭串口
                Debug.WriteLine("休眠");
                }
            }
            else if (e.Mode == PowerModes.Resume)
            {
                // 计算机唤醒时重新连接串口
                try
                {
                    if (!isConnected && _resume)
                    { 
                        uint error = 0;
                        Thread.Sleep(3000);//这里的延时是用于等待计算机对COM口的重新初始化，与设备的性能有关，所以写的可以大一些，防止一些比较旧的机器初始化速度慢
                        string com_name = this.ComPort.SelectedItem.ToString();
                        try
                        {
                            error = device1.ConnectWithVcp(com_name);
                        }
                        catch (Exception ex)
                        {
                            Debug.WriteLine("catch");
                            Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " " + ex.Message + Environment.NewLine);
                            Devmes.ScrollToCaret();
                            return;
                        }

                        if (error != 0)
                        {
                            Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Connect failed." + Environment.NewLine);
                            Devmes.ScrollToCaret();
                        }
                        else
                        {
                            Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Reconnect Success." + Environment.NewLine);
                            Devmes.ScrollToCaret();

                            isConnected = true;
                            this.ControlsEnabled();
                        }
                        Debug.WriteLine("重启");
                        _resume = false;
                    }
                }
                catch (Exception ex)
                {
                    Console.WriteLine($"Error reconnecting to COM port: {ex.Message}");
                }
            }
        }

        private void LongPress_LongPress(object sender, EventArgs e)
        {
            this.Invoke((Action)(() =>
            {
                passwordPopupWindow = new PasswordPopup();
                passwordPopupWindow.ClosePasswordWindow += PasswordPopupWindow_ClosePasswordWindow;
                passwordPopupWindow.StartPosition = FormStartPosition.CenterParent;
                passwordPopupWindow.ShowDialog();
            }));
        }

        private void PasswordPopupWindow_ClosePasswordWindow(object sender, bool e)
        {
            if (e)
            {
                isDebug = true;
            }
        }


        private void initForms()
        {
            SetCombolList();
            SetCombolList2();
            string[] vcpPort = GetPortList();
            int i = 0;
            //有限判断是否开通端口模式
            if (vcpPort.Length > 0)
            {
                for (i = 0; i < vcpPort.Length; i++)
                {
                    this.ComPort.Items.Add(vcpPort[i]);
                    this.ComPort2.Items.Add(vcpPort[i]);
                }
                if (i > 0)
                {
                    this.ComPort.SelectedIndex = 0;
                    this.ComPort2.SelectedIndex = 0;
                }
            }
        }

        /// <summary>
        /// VCP disconnect
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnVcpDisconnect_Click(object sender, EventArgs e)
        {
            if (m_bInventory) StopInventory();
            UInt32 error = 0;
            error = device1.DisConnect();

            if (error == 1)
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " DisConnect failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
            }
            if (error == 0)
            {
                this.ComPort.Enabled = true;
                //this.txtBaudRate.Enabled = false;
                this.Connect.Enabled = true;
                this.btnDisconnect.Enabled = false;
                _resume = false;
                isConnected = false;
            }
            this.ControlsEnabled();
        }

        /// <summary>
        /// VCP disconnect
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnVcpDisconnect_Click2(object sender, EventArgs e)
        {
            if (m_bInventory2) StopInventory2();
            UInt32 error = 0;
            error = device2.DisConnect();

            if (error == 1)
            {
                this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " DisConnect failed." + Environment.NewLine);
                this.Devmes2.ScrollToCaret();
            }
            if (error == 0)
            {
                this.ComPort2.Enabled = true;
                //this.txtBaudRate.Enabled = false;
                this.Connect2.Enabled = true;
                this.btnDisconnect2.Enabled = false;
                isConnected2 = false;
            }
            this.ControlsEnabled2();
        }

        /// <summary>
        /// VCP Connect
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnVcpConnect_Click(object sender, EventArgs e)
        {
            cmbBinFiles.DataSource = null;
            cmbRFIDBinFiles.DataSource = null;
            Cursor.Current = Cursors.WaitCursor;
            uint error = 0;
            isConnected = false;
            if (ComPort.Text.Length > 0)
            {
                string com_name = this.ComPort.SelectedItem.ToString();
                try
                {
                    error = device1.ConnectWithVcp(com_name);
                }
                catch (Exception ex)
                {
                    Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " " + ex.Message + Environment.NewLine);
                    Devmes.ScrollToCaret();
                    return;
                }

                if (error != 0)
                {
                    Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Connect failed." + Environment.NewLine);
                    Devmes.ScrollToCaret();
                }
            }
            else
            {
                Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " COM port is not exist,please check it." + Environment.NewLine);
                Devmes.ScrollToCaret();
                return;
            }

            Thread.Sleep(100);
            GetSdkVersion_load();
            Thread.Sleep(100);
            btnGetRegion_Click(btnGetRegion, e);
            Thread.Sleep(100);
            btnGetMask_Click(btnGetMask, e);
            Thread.Sleep(100);
            btnGetMaskEnable_Click(btnGetMaskEnable, null);
            Thread.Sleep(100);
            GetFWVersionBtn_Click(GetFWVersionBtn, e);
            Thread.Sleep(100);
            HIDGetBtn_Click(HIDgetBtn, e);
            Thread.Sleep(100);
            buzzerGetBtn_Click(buzzerGetBtn, e);
            Thread.Sleep(100);
            btnGetRSSIThreshold_Click(btnGetRSSIThreshold, e);
            Thread.Sleep(100);
            GetHWVersionBtn_Click(GetHWVersionBtn, e);
            Thread.Sleep(100);
            GetRFIDFWVerBtn_Click(GetRFIDFWVerBtn, e);
            Thread.Sleep(100);
            GetProductSN_load();
            Thread.Sleep(100);
            btnGetHIDInventorymode_Click(btnGetHIDInventorymode, e);

            if (error == 0 && getRegionErr && getSessionErr && getCollisionErr && getPowerErr && getReadTimeErr && getIdleTimeErr && getTargetErr && getFHErr)
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Connect failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
                if (error == 0) device1.DisConnect();
                return;
            }
            isConnected = true;
            _resume = false;

            connType = "VCP";
            this.ControlsEnabled();
        }

        /// <summary>
        /// VCP Connect
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnVcpConnect_Click2(object sender, EventArgs e)
        {
            cmbBinFiles2.DataSource = null;
            cmbRFIDBinFiles2.DataSource = null;
            Cursor.Current = Cursors.WaitCursor;
            uint error = 0;
            isConnected2 = false;
            if (ComPort2.Text.Length > 0)
            {
                string com_name = this.ComPort2.SelectedItem.ToString();
                try
                {
                    error = device2.ConnectWithVcp(com_name);
                }
                catch (Exception ex)
                {
                    Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " " + ex.Message + Environment.NewLine);
                    Devmes2.ScrollToCaret();
                    return;
                }

                if (error != 0)
                {
                    Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Connect failed." + Environment.NewLine);
                    Devmes2.ScrollToCaret();
                }
            }
            else
            {
                Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " COM port is not exist,please check it." + Environment.NewLine);
                Devmes2.ScrollToCaret();
                return;
            }

            Thread.Sleep(100);
            GetSdkVersion_load2();
            Thread.Sleep(100);
            btnGetRegion_Click2(btnGetRegion2, e);
            Thread.Sleep(100);
            btnGetMask_Click2(btnGetMask2, e);
            Thread.Sleep(100);
            btnGetMaskEnable_Click2(btnGetMaskEnable2, null);
            Thread.Sleep(100);
            GetFWVersionBtn_Click2(GetFWVersionBtn2, e);
            Thread.Sleep(100);
            HIDGetBtn_Click2(HIDgetBtn2, e);
            Thread.Sleep(100);
            buzzerGetBtn_Click2(buzzerGetBtn2, e);
            Thread.Sleep(100);
            btnGetRSSIThreshold_Click2(btnGetRSSIThreshold2, e);
            Thread.Sleep(100);
            GetHWVersionBtn_Click2(GetHWVersionBtn2, e);
            Thread.Sleep(100);
            GetRFIDFWVerBtn_Click2(GetRFIDFWVerBtn2, e);
            Thread.Sleep(100);
            GetProductSN_load2();
            Thread.Sleep(100);
            btnGetHIDInventorymode2_Click(btnGetHIDInventorymode2, e);

            if (error == 0 && getRegionErr2 && getSessionErr2 && getCollisionErr2 && getPowerErr2 && getReadTimeErr2 && getIdleTimeErr2 && getTargetErr2 && getFHErr2)
            {
                this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Connect failed." + Environment.NewLine);
                this.Devmes2.ScrollToCaret();
                if (error == 0) device2.DisConnect();
                return;
            }
            isConnected2 = true;
            connType = "VCP";
            this.ControlsEnabled2();
        }

        private void Write_Epc_Click(object sender, EventArgs e)
        {
            //input check
            string needMsg = "";
            if (txtEpc.Text == "") needMsg += DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " [WARNING]Please input EPC." + Environment.NewLine;
            if (text_off.Text == "") needMsg += DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " [WARNING]Please input start address." + Environment.NewLine;
            if (needMsg != "")
            {
                this.Devmes.AppendText(needMsg);
                this.Devmes.ScrollToCaret();
                return;
            }
            //handle
            UInt32 error = 0;
            string Epc_string = this.txtEpc.Text.Replace(" ", "").Replace("0x", "");

            if (Epc_string.Length % 2 != 0)
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Please input correct epc." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
                return;
            }

            //Epc_string1 选中的要被覆盖的标签的值
            string Epc_string1 = this.txtSelectedTag.Text;

            if (Epc_string1 != null)
            {
                Epc_string1 = Epc_string1.Replace(" ", "").Replace("0x", "");
                if (Epc_string1.Length % 2 != 0)
                {
                    this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Please input correct epc of selected." + Environment.NewLine);
                    this.Devmes.ScrollToCaret();
                    return;
                }
            }

            byte[] yu = { };
            if (Epc_string != null)
            {
                yu = HexStringToByteArray(Epc_string);
            }


            byte[] ren = { };
            if (Epc_string1 != null)
            {
                ren = HexStringToByteArray(Epc_string1);
            }

            error = device1.WriteMemory(
                SELSERVED.Checked ? Types.MemBankType.MEM_RESERVED : SELEPC.Checked ? Types.MemBankType.MEM_EPC : SELTID.Checked ? Types.MemBankType.MEM_TID : SELUSER.Checked ? Types.MemBankType.MEM_USER : 0,
                Convert.ToUInt32(text_off.Text),
                Convert.ToUInt32(ReadPassward.Text == "" ? "0" : ReadPassward.Text, 16), yu, ren);

            if (error == 1)
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Write Tag command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
            }
        }
        private void Write_Epc_Click2(object sender, EventArgs e)
        {
            //input check
            string needMsg = "";
            if (txtEpc2.Text == "") needMsg += DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " [WARNING]Please input EPC." + Environment.NewLine;
            if (text_off2.Text == "") needMsg += DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " [WARNING]Please input start address." + Environment.NewLine;
            if (needMsg != "")
            {
                this.Devmes2.AppendText(needMsg);
                this.Devmes2.ScrollToCaret();
                return;
            }
            //handle
            UInt32 error = 0;
            string Epc_string = this.txtEpc2.Text.Replace(" ", "").Replace("0x", "");

            if (Epc_string.Length % 2 != 0)
            {
                this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Please input correct epc." + Environment.NewLine);
                this.Devmes2.ScrollToCaret();
                return;
            }

            //Epc_string1 选中的要被覆盖的标签的值
            string Epc_string1 = this.txtSelectedTag2.Text;

            if (Epc_string1 != null)
            {
                Epc_string1 = Epc_string1.Replace(" ", "").Replace("0x", "");
                if (Epc_string1.Length % 2 != 0)
                {
                    this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Please input correct epc of selected." + Environment.NewLine);
                    this.Devmes2.ScrollToCaret();
                    return;
                }
            }

            byte[] yu = { };
            if (Epc_string != null)
            {
                yu = HexStringToByteArray(Epc_string);
            }


            byte[] ren = { };
            if (Epc_string1 != null)
            {
                ren = HexStringToByteArray(Epc_string1);
            }

            error = device2.WriteMemory(
                SELSERVED2.Checked ? Types.MemBankType.MEM_RESERVED : SELEPC2.Checked ? Types.MemBankType.MEM_EPC : SELTID2.Checked ? Types.MemBankType.MEM_TID : SELUSER2.Checked ? Types.MemBankType.MEM_USER : 0,
                Convert.ToUInt32(text_off2.Text),
                Convert.ToUInt32(ReadPassward2.Text == "" ? "0" : ReadPassward2.Text, 16), yu, ren);

            if (error == 1)
            {
                this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Write Tag command sent failed." + Environment.NewLine);
                this.Devmes2.ScrollToCaret();
            }
        }

        static byte[] HexStringToByteArray(string s)
        {
            s = s.Replace(" ", "").Replace("0x", "");
            byte[] buffer = new byte[s.Length / 2];
            for (int i = 0; i < s.Length; i += 2)
                buffer[i / 2] = (byte)Convert.ToByte(s.Substring(i, 2), 16);
            return buffer;
        }

        private void ReadTag_Click(object sender, EventArgs e)
        {
            UInt32 error = 0;
            Convert.ToUInt32(text_off.Text);
            //input value check
            StringBuilder sb = new StringBuilder();

            string Epc_string = this.txtSelectedTag.Text;

            if (Epc_string != null)
            {
                Epc_string = Epc_string.Replace(" ", "").Replace("0x", "");
                if (Epc_string.Length % 2 != 0) sb.AppendLine(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " [WARNING]Please input correct epc of selected.");
            }

            if (text_off.Text == "") sb.AppendLine(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " [WARNING]Please input start address.");
            if (ReadLenth.Text == "") sb.AppendLine(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " [WARNING]Please input length.");
            if (sb.ToString().Length > 0)
            {
                this.Devmes.AppendText(sb.ToString());
                this.Devmes.ScrollToCaret();
                return;
            }

            byte[] yu = { };
            if (Epc_string != null)
            {
                yu = HexStringToByteArray(Epc_string);
            }

            error = device1.ReadMemory(
                SELSERVED.Checked ? Types.MemBankType.MEM_RESERVED : SELEPC.Checked ? Types.MemBankType.MEM_EPC : SELTID.Checked ? Types.MemBankType.MEM_TID : SELUSER.Checked ? Types.MemBankType.MEM_USER : 0,
                Convert.ToUInt32(text_off.Text),
                Convert.ToUInt32(ReadLenth.Text),
                Convert.ToUInt32(ReadPassward.Text == "" ? "0" : ReadPassward.Text, 16), yu);

            if (error == 1)
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Read Tag command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
            }
        }

        private void ReadTag_Click2(object sender, EventArgs e)
        {
            UInt32 error = 0;
            Convert.ToUInt32(text_off2.Text);
            //input value check
            StringBuilder sb = new StringBuilder();

            string Epc_string = this.txtSelectedTag2.Text;

            if (Epc_string != null)
            {
                Epc_string = Epc_string.Replace(" ", "").Replace("0x", "");
                if (Epc_string.Length % 2 != 0) sb.AppendLine(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " [WARNING]Please input correct epc of selected.");
            }

            if (text_off2.Text == "") sb.AppendLine(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " [WARNING]Please input start address.");
            if (ReadLenth2.Text == "") sb.AppendLine(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " [WARNING]Please input length.");
            if (sb.ToString().Length > 0)
            {
                this.Devmes2.AppendText(sb.ToString());
                this.Devmes2.ScrollToCaret();
                return;
            }

            byte[] yu = { };
            if (Epc_string != null)
            {
                yu = HexStringToByteArray(Epc_string);
            }

            error = device2.ReadMemory(
                SELSERVED2.Checked ? Types.MemBankType.MEM_RESERVED : SELEPC2.Checked ? Types.MemBankType.MEM_EPC : SELTID2.Checked ? Types.MemBankType.MEM_TID : SELUSER2.Checked ? Types.MemBankType.MEM_USER : 0,
                Convert.ToUInt32(text_off2.Text),
                Convert.ToUInt32(ReadLenth2.Text),
                Convert.ToUInt32(ReadPassward2.Text == "" ? "0" : ReadPassward2.Text, 16), yu);

            if (error == 1)
            {
                this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Read Tag command sent failed." + Environment.NewLine);
                this.Devmes2.ScrollToCaret();
            }
        }

        private void btnSelectMask_Click(object sender, EventArgs e)
        {
            UInt32 error = 0;
            string Epc_string = this.txtSelectedTag.Text.Replace(" ", "").Replace("0x", "");
            byte[] mask = { };
            if (Epc_string.Length % 2 != 0)
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Please input correct epc of selected." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
                return;
            }
            mask = HexStringToByteArray(Epc_string);

            error = device1.SetSelectMask(
                SELSERVED.Checked ? Types.MemBankType.MEM_RESERVED : SELTID.Checked ? Types.MemBankType.MEM_TID : SELEPC.Checked ? Types.MemBankType.MEM_EPC : SELUSER.Checked ? Types.MemBankType.MEM_USER : 0,
                (Types.TargetType)cmbTarget.SelectedValue,
                (Types.ActionType)cmbAction.SelectedValue,
                Convert.ToUInt32(maskStartAddress.Text, 16),
                mask);

            if (error == 1)
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Select Tag command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
            }
            btnGetMaskEnable_Click(null, null);

        }

        private void btnSelectMask_Click2(object sender, EventArgs e)
        {
            UInt32 error = 0;
            string Epc_string = this.txtSelectedTag2.Text.Replace(" ", "").Replace("0x", "");
            byte[] mask = { };
            if (Epc_string.Length % 2 != 0)
            {
                this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Please input correct epc of selected." + Environment.NewLine);
                this.Devmes2.ScrollToCaret();
                return;
            }
            mask = HexStringToByteArray(Epc_string);

            error = device2.SetSelectMask(
                SELSERVED2.Checked ? Types.MemBankType.MEM_RESERVED : SELTID2.Checked ? Types.MemBankType.MEM_TID : SELEPC2.Checked ? Types.MemBankType.MEM_EPC : SELUSER2.Checked ? Types.MemBankType.MEM_USER : 0,
                (Types.TargetType)cmbTarget2.SelectedValue,
                (Types.ActionType)cmbAction2.SelectedValue,
                Convert.ToUInt32(maskStartAddress2.Text, 16),
                mask);

            if (error == 1)
            {
                this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Select Tag command sent failed." + Environment.NewLine);
                this.Devmes2.ScrollToCaret();
            }
            btnGetMaskEnable_Click2(null, null);
        }

        private void btnGetMask_Click(object sender, EventArgs e)
        {
            Types.MemBankType membank = 0;
            Types.TargetType target = 0;
            Types.ActionType action = 0;
            UInt32 startAddressWord = 0;
            string epc_string = null;
            UInt32 error = 0;
            error = device1.GetSelectMask(ref membank, ref target, ref action, ref startAddressWord, ref epc_string);
            if (error == 0)
            {
                this.txtSelectedTag.Text = epc_string;
                this.maskStartAddress.Text = startAddressWord.ToString();
                this.cmbTarget.SelectedValue = target;
                this.cmbAction.SelectedValue = action;
                if (membank == Types.MemBankType.MEM_TID)
                {
                    SELTID.Checked = true;
                }
                else if (membank == Types.MemBankType.MEM_EPC)
                {
                    SELEPC.Checked = true;
                }
                else if (membank == Types.MemBankType.MEM_USER)
                {
                    SELUSER.Checked = true;
                }
                else
                {
                    SELSERVED.Checked = true;
                }

            }

            if (error == 1)
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get Select Tag command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
            }
        }
        private void btnGetMask_Click2(object sender, EventArgs e)
        {
            Types.MemBankType membank = 0;
            Types.TargetType target = 0;
            Types.ActionType action = 0;
            UInt32 startAddressWord = 0;
            string epc_string = null;
            UInt32 error = 0;
            error = device2.GetSelectMask(ref membank, ref target, ref action, ref startAddressWord, ref epc_string);
            if (error == 0)
            {
                this.txtSelectedTag2.Text = epc_string;
                this.maskStartAddress2.Text = startAddressWord.ToString();
                this.cmbTarget2.SelectedValue = target;
                this.cmbAction2.SelectedValue = action;
                if (membank == Types.MemBankType.MEM_TID)
                {
                    SELTID2.Checked = true;
                }
                else if (membank == Types.MemBankType.MEM_EPC)
                {
                    SELEPC2.Checked = true;
                }
                else if (membank == Types.MemBankType.MEM_USER)
                {
                    SELUSER2.Checked = true;
                }
                else
                {
                    SELSERVED2.Checked = true;
                }

            }

            if (error == 1)
            {
                this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get Select Tag command sent failed." + Environment.NewLine);
                this.Devmes2.ScrollToCaret();
            }
        }

        private void btnSetMaskEnable_Click(object sender, EventArgs e)
        {
            UInt32 error = 0;
            error = device1.SetSelectionEnable((Types.SelectionEnable)cmbSelectionEnable.SelectedValue);
            if (error == 1)
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Set Selection Enable sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
            }
        }

        private void btnSetMaskEnable_Click2(object sender, EventArgs e)
        {
            UInt32 error = 0;
            error = device2.SetSelectionEnable((Types.SelectionEnable)cmbSelectionEnable2.SelectedValue);
            if (error == 1)
            {
                this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Set Selection Enable sent failed." + Environment.NewLine);
                this.Devmes2.ScrollToCaret();
            }
        }

        private void btnGetMaskEnable_Click(object sender, EventArgs e)
        {
            Types.SelectionEnable selection_enable = 0;
            UInt32 error = 0;
            error = device1.GetSelectionEnable(ref selection_enable);
            if (error == 0)
            {
                cmbSelectionEnable.SelectedValue = Convert.ToInt32(selection_enable);
            }

            if (error == 1)
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get Selection Enable command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
            }
        }

        private void btnGetMaskEnable_Click2(object sender, EventArgs e)
        {
            Types.SelectionEnable selection_enable = 0;
            UInt32 error = 0;
            error = device2.GetSelectionEnable(ref selection_enable);
            if (error == 0)
            {
                cmbSelectionEnable2.SelectedValue = Convert.ToInt32(selection_enable);
            }

            if (error == 1)
            {
                this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get Selection Enable command sent failed." + Environment.NewLine);
                this.Devmes2.ScrollToCaret();
            }
        }

        /// <summary>
        /// kill tag
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void button7_Click(object sender, EventArgs e)
        {
            string Epc_string = txtSelectedTag.Text.Replace(" ", "").Replace("0x", "");
            byte[] yu = { };

            if (Epc_string.Length % 2 != 0)
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Please input correct epc of selected." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
                return;
            }
            yu = HexStringToByteArray(Epc_string);
            UInt32 error = device1.Kill(Convert.ToUInt32(ReadPassward.Text == "" ? "0" : ReadPassward.Text, 16), yu);

            if (error == 1)
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Kill Tag command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
            }
        }

        private void button7_Click2(object sender, EventArgs e)
        {
            string Epc_string = txtSelectedTag2.Text.Replace(" ", "").Replace("0x", "");
            byte[] yu = { };

            if (Epc_string.Length % 2 != 0)
            {
                this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Please input correct epc of selected." + Environment.NewLine);
                this.Devmes2.ScrollToCaret();
                return;
            }
            yu = HexStringToByteArray(Epc_string);
            UInt32 error = device2.Kill(Convert.ToUInt32(ReadPassward2.Text == "" ? "0" : ReadPassward2.Text, 16), yu);

            if (error == 1)
            {
                this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Kill Tag command sent failed." + Environment.NewLine);
                this.Devmes2.ScrollToCaret();
            }
        }

        /// <summary>
        /// set ANT power
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnSetPowerWithANT_Click(object sender, EventArgs e)
        {
            UInt32 error = 0;
            if (!CheckPowersWithRegionType())
            {
                return;
            }
            error = device1.SetTxPower(
                txtPower1.Text == "" ? 0 : Convert.ToUInt32(txtPower1.Text)
                );
            if (error == 1)
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Set Power command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
            }
        }

        /// <summary>
        /// set ANT power
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnSetPowerWithANT_Click2(object sender, EventArgs e)
        {
            UInt32 error = 0;
            if (!CheckPowersWithRegionType2())
            {
                return;
            }
            error = device2.SetTxPower(
                txtPower2.Text == "" ? 0 : Convert.ToUInt32(txtPower2.Text)
                );
            if (error == 1)
            {
                this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Set Power command sent failed." + Environment.NewLine);
                this.Devmes2.ScrollToCaret();
            }
        }
        private bool CheckPowersWithRegionType()
        {
            if (Convert.ToUInt32(txtPower1.Text == "" ? "0" : txtPower1.Text) > defaultMaxPower)
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Please input correct antenna powers(" + CurrentRegionType + ":" + defaultMinPower + "~" + defaultMaxPower + "dbm)." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
                return false;
            }
            return true;
        }
        private bool CheckPowersWithRegionType2()
        {
            if (Convert.ToUInt32(txtPower2.Text == "" ? "0" : txtPower2.Text) > defaultMaxPower2)
            {
                this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Please input correct antenna powers(" + CurrentRegionType2 + ":" + defaultMinPower2 + "~" + defaultMaxPower2 + "dbm)." + Environment.NewLine);
                this.Devmes2.ScrollToCaret();
                return false;
            }
            return true;
        }
        bool getPowerErr = false;
        private void GetPower_Click(object sender, EventArgs e)
        {
            UInt32 power1 = 0;
            UInt32 minPower = 13;
            UInt32 maxPower = 23;
            if (CurrentRegionType != Types.RegionType.REGION_JAPAN)
            {
                maxPower = 27;
            }
            UInt32 error = 0;
            error = device1.GetTxPower(ref power1, ref minPower, ref maxPower);
            defaultMinPower = minPower;
            defaultMaxPower = maxPower;
            if (error == 0)
            {
                txtPower1.Text = (power1 > maxPower ? maxPower : power1).ToString();
                getPowerErr = false;
                if (power1 > maxPower)
                {
                    btnSetPowerWithANT_Click(null, null);
                }
            }
            if (error == 1)
            {
                txtPower1.Text = "";
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get Power command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
                getPowerErr = true;
            }
        }
        bool getPowerErr2 = false;
        private void GetPower_Click2(object sender, EventArgs e)
        {
            UInt32 power1 = 0;
            UInt32 minPower = 13;
            UInt32 maxPower = 23;
            if (CurrentRegionType2 != Types.RegionType.REGION_JAPAN)
            {
                maxPower = 27;
            }
            UInt32 error = 0;
            error = device2.GetTxPower(ref power1, ref minPower, ref maxPower);
            defaultMinPower2 = minPower;
            defaultMaxPower2 = maxPower;
            if (error == 0)
            {
                txtPower2.Text = (power1 > maxPower ? maxPower : power1).ToString();
                getPowerErr2 = false;
                if (power1 > maxPower)
                {
                    btnSetPowerWithANT_Click2(null, null);
                }
            }
            if (error == 1)
            {
                txtPower2.Text = "";
                this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get Power command sent failed." + Environment.NewLine);
                this.Devmes2.ScrollToCaret();
                getPowerErr2 = true;
            }
        }

        private void Clear_Click(object sender, EventArgs e)
        {
            total_time = System.Environment.TickCount;
            ClearTableData();
        }

        private void Clear_Click2(object sender, EventArgs e)
        {
            total_time2 = System.Environment.TickCount;
            ClearTableData2();
        }
        private void SetSession_Click(object sender, EventArgs e)
        {

            Types.SessionType sessionType = (Types.SessionType)cmbSession.SelectedValue;
            UInt32 error = 0;
            //session范围：0~3
            error = device1.SetSession(sessionType);

            if (error == 1)
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Set Session command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
            }
        }
        private void SetSession_Click2(object sender, EventArgs e)
        {
            Types.SessionType sessionType = (Types.SessionType)cmbSession2.SelectedValue;
            UInt32 error = 0;
            //session范围：0~3
            error = device2.SetSession(sessionType);

            if (error == 1)
            {
                this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Set Session command sent failed." + Environment.NewLine);
                this.Devmes2.ScrollToCaret();
            }
        }

        bool getSessionErr = false;
        private void GetSession_Click(object sender, EventArgs e)
        {
            Types.SessionType sessionType = 0;
            UInt32 error = 0;
            error = device1.GetSession(ref sessionType);
            if (error == 0)
            {
                getSessionErr = false;
                cmbSession.SelectedValue = Convert.ToInt32(sessionType);
            }

            if (error == 1)
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get Session command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
                getSessionErr = true;
            }
        }
        bool getSessionErr2 = false;
        private void GetSession_Click2(object sender, EventArgs e)
        {
            Types.SessionType sessionType = 0;
            UInt32 error = 0;
            error = device2.GetSession(ref sessionType);
            if (error == 0)
            {
                getSessionErr2 = false;
                cmbSession2.SelectedValue = Convert.ToInt32(sessionType);
            }

            if (error == 1)
            {
                this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get Session command sent failed." + Environment.NewLine);
                this.Devmes2.ScrollToCaret();
                getSessionErr2 = true;
            }
        }

        /// <summary>
        /// set region
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnSetRegion_Click(object sender, EventArgs e)
        {
            UInt32 error = 0;
            error = device1.SetRegion((Types.RegionType)cmbRegion.SelectedValue);

            if (error == 1)
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Set Region command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
            }
            else btnGetRegion_Click(null, null);
        }

        /// <summary>
        /// set region
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnSetRegion_Click2(object sender, EventArgs e)
        {
            UInt32 error = 0;
            error = device2.SetRegion((Types.RegionType)cmbRegion2.SelectedValue);

            if (error == 1)
            {
                this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Set Region command sent failed." + Environment.NewLine);
                this.Devmes2.ScrollToCaret();
            }
            else btnGetRegion_Click2(null, null);
        }

        bool getRegionErr = false;
        Types.RegionType CurrentRegionType;
        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnGetRegion_Click(object sender, EventArgs e)
        {
            CurrentRegionType = 0;
            Types.RegionType regionType = 0;
            UInt32 error = 0;
            error = device1.GetRegion(ref regionType);
            if (error == 0)
            {
                cmbRegion.SelectedValue = Convert.ToInt32(regionType);
                CurrentRegionType = regionType;

                switch (regionType)
                {
                    case Types.RegionType.REGION_CHINA2:
                        this.cmbChannel.DataSource = device1.getComboxList(typeof(Types.ChinaChannelType));
                        break;

                    case Types.RegionType.REGION_JAPAN:
                        this.cmbChannel.DataSource = device1.getComboxListByName(typeof(Types.JPChannelType), "diJPChannel");
                        break;


                    case Types.RegionType.REGION_BRAZIL:
                        this.cmbChannel.DataSource = device1.getComboxList(typeof(Types.BrazilChannelType));
                        break;

                    case Types.RegionType.REGION_EUROPE:
                        this.cmbChannel.DataSource = device1.getComboxList(typeof(Types.EuropeChannelType));
                        break;

                    case Types.RegionType.REGION_US:
                    case Types.RegionType.REGION_US_NARROW:
                        this.cmbChannel.DataSource = device1.getComboxList(typeof(Types.USChannelType));
                        break;
                }
                this.cmbChannel.DisplayMember = "name";
                this.cmbChannel.ValueMember = "value";

                Thread.Sleep(100);
                btnGetCollision_Click(btnGetCollision, e);
                Thread.Sleep(100);
                GetPower_Click(GetPower, e);
                Thread.Sleep(100);
                InitialGetFH_LBT();
                Thread.Sleep(100);
                btnGetChannel_Click(btnGetChannel, e);
                Thread.Sleep(100);
                InitialGetQuery();

                btn_getExportPath_Click(null, null);
                btn_GetAutoInventory_Click(null, null);



                getRegionErr = false;
            }

            if (error == 1)
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get Region command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
                getRegionErr = true;
            }
        }

        bool getRegionErr2 = false;
        Types.RegionType CurrentRegionType2;
        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnGetRegion_Click2(object sender, EventArgs e)
        {
            CurrentRegionType2 = 0;
            Types.RegionType regionType = 0;
            UInt32 error = 0;
            error = device2.GetRegion(ref regionType);
            if (error == 0)
            {
                cmbRegion2.SelectedValue = Convert.ToInt32(regionType);
                CurrentRegionType2 = regionType;

                switch (regionType)
                {
                    case Types.RegionType.REGION_CHINA2:
                        this.cmbChannel2.DataSource = device2.getComboxList(typeof(Types.ChinaChannelType));
                        break;

                    case Types.RegionType.REGION_JAPAN:
                        this.cmbChannel2.DataSource = device2.getComboxListByName(typeof(Types.JPChannelType), "diJPChannel");
                        break;


                    case Types.RegionType.REGION_BRAZIL:
                        this.cmbChannel2.DataSource = device2.getComboxList(typeof(Types.BrazilChannelType));
                        break;

                    case Types.RegionType.REGION_EUROPE:
                        this.cmbChannel2.DataSource = device2.getComboxList(typeof(Types.EuropeChannelType));
                        break;

                    case Types.RegionType.REGION_US:
                    case Types.RegionType.REGION_US_NARROW:
                        this.cmbChannel2.DataSource = device2.getComboxList(typeof(Types.USChannelType));
                        break;
                }
                this.cmbChannel2.DisplayMember = "name";
                this.cmbChannel2.ValueMember = "value";

                Thread.Sleep(100);
                btnGetCollision_Click2(btnGetCollision2, e);
                Thread.Sleep(100);
                GetPower_Click2(GetPower2, e);
                Thread.Sleep(100);
                InitialGetFH_LBT2();
                Thread.Sleep(100);
                btnGetChannel_Click2(btnGetChannel2, e);
                Thread.Sleep(100);
                InitialGetQuery2();

                btn_getExportPath_Click2(null, null);
                btn_GetAutoInventory_Click2(null, null);

                getRegionErr2 = false;
            }

            if (error == 1)
            {
                this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get Region command sent failed." + Environment.NewLine);
                this.Devmes2.ScrollToCaret();
                getRegionErr2 = true;
            }
        }

        private void InitialGetFH_LBT()
        {
            UInt32 error = 0;
            uint readTime = 10;
            uint idelTime = 0;
            uint cst = 1;
            uint rfl = 13;
            Types.FHType fh = 0;
            Types.LBTType lbt = 0;
            Types.CWType cw = 0;

            error = device1.GetFH_LBT(ref readTime, ref idelTime, ref cst, ref rfl, ref fh, ref lbt, ref cw);
            if (error == 0)
            {
                txtReadTime1.Text = readTime.ToString();
                getReadTimeErr = false;

                txtIdelTime.Text = idelTime.ToString();
                getIdleTimeErr = false;

                if (fh == Types.FHType.WITH_LBT && lbt == Types.LBTType.ENABLE)
                {
                    FHcheckBox.Checked = true;
                }
                else
                {
                    FHcheckBox.Checked = false;
                }
                getFHErr = false;
            }
            else
            {
                txtReadTime1.Text = "";
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get Read Time command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
                getReadTimeErr = true;

                txtIdelTime.Text = "";
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get Idel Time command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
                getIdleTimeErr = true;

                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get Frequency Automatic command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
                getFHErr = true;
            }
        }
        private void InitialGetFH_LBT2()
        {
            UInt32 error = 0;
            uint readTime = 10;
            uint idelTime = 0;
            uint cst = 1;
            uint rfl = 13;
            Types.FHType fh = 0;
            Types.LBTType lbt = 0;
            Types.CWType cw = 0;

            error = device2.GetFH_LBT(ref readTime, ref idelTime, ref cst, ref rfl, ref fh, ref lbt, ref cw);
            if (error == 0)
            {
                txtReadTime2.Text = readTime.ToString();
                getReadTimeErr2 = false;

                txtIdelTime2.Text = idelTime.ToString();
                getIdleTimeErr2 = false;

                if (fh == Types.FHType.WITH_LBT && lbt == Types.LBTType.ENABLE)
                {
                    FHcheckBox2.Checked = true;
                }
                else
                {
                    FHcheckBox2.Checked = false;
                }
                getFHErr2 = false;
            }
            else
            {
                txtReadTime2.Text = "";
                this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get Read Time command sent failed." + Environment.NewLine);
                this.Devmes2.ScrollToCaret();
                getReadTimeErr2 = true;

                txtIdelTime2.Text = "";
                this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get Idel Time command sent failed." + Environment.NewLine);
                this.Devmes2.ScrollToCaret();
                getIdleTimeErr2 = true;

                this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get Frequency Automatic command sent failed." + Environment.NewLine);
                this.Devmes2.ScrollToCaret();
                getFHErr2 = true;
            }
        }

        private void InitialGetQuery()
        {
            UInt32 error = 0;
            Types.DRType dr = 0;
            Types.MType m = 0;
            Types.TRextType trext = 0;
            Types.SelType sel = 0;
            Types.SessionType session = 0;
            Types.TargetABType target = 0;
            Types.QType q = 0;

            error = device1.GetQuery(ref dr, ref m, ref trext, ref sel, ref session, ref target, ref q);
            if (error == 0)
            {
                getSessionErr = false;
                cmbSession.SelectedValue = Convert.ToInt32(session);

                getTargetErr = false;
                cmbBasicTarget.SelectedValue = Convert.ToInt32(target);
            }
            else
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get Session command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
                getSessionErr = true;

                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get Target command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
                getTargetErr = true;
            }
        }
        private void InitialGetQuery2()
        {
            UInt32 error = 0;
            Types.DRType dr = 0;
            Types.MType m = 0;
            Types.TRextType trext = 0;
            Types.SelType sel = 0;
            Types.SessionType session = 0;
            Types.TargetABType target = 0;
            Types.QType q = 0;

            error = device2.GetQuery(ref dr, ref m, ref trext, ref sel, ref session, ref target, ref q);
            if (error == 0)
            {
                getSessionErr2 = false;
                cmbSession2.SelectedValue = Convert.ToInt32(session);

                getTargetErr2 = false;
                cmbBasicTarget2.SelectedValue = Convert.ToInt32(target);
            }
            else
            {
                this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get Session command sent failed." + Environment.NewLine);
                this.Devmes2.ScrollToCaret();
                getSessionErr2 = true;

                this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get Target command sent failed." + Environment.NewLine);
                this.Devmes2.ScrollToCaret();
                getTargetErr2 = true;
            }
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void cbAnt_CheckedChanged(object sender, EventArgs e)
        {
            //gbInventoryType.Enabled = !(cbAnt1.Checked || cbAnt2.Checked || cbAnt3.Checked || cbAnt4.Checked || cbAnt5.Checked || cbAnt6.Checked || cbAnt7.Checked || cbAnt8.Checked);
        }

        /// <summary>
        /// start inventory click
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void startInventory_Click(object sender, EventArgs e)
        {
            string path = this.TextExportPath.Text;
            if (!ExistsPath(path)) return;

            UInt32 error = 0;
            this.StartInventory.Enabled = false;
            if (m_bInventory)
            {
                error = device1.StopInventory();
                if (error != 0)
                {
                    this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Stop Inventory command sent failed." + Environment.NewLine);
                    this.Devmes.ScrollToCaret();
                    this.StartInventory.Enabled = true;
                    return;
                }
                m_bInventory = false;
                readTimer.Enabled = false;
                this.StartInventory.Text = "Start";


                this.grpOtherSetting.Enabled = true;
                this.grpAutoInventory.Enabled = true;

                //Task.Run(()=> {
                FileName += "_" + DateTime.Now.ToString("yyyyMMddHHmmssfff") + ".csv";
                Thread.Sleep(200);
                ExportCSV(FileName);
                //});
            }
            else
            {
                if (this.txtTagCount.Text == string.Empty) this.txtTagCount.Text = "0";
                if (this.txtInventoryRound.Text == string.Empty) this.txtInventoryRound.Text = "0";
                if (this.txtElapsedTime.Text == string.Empty) this.txtElapsedTime.Text = "0";



                error = StartInventoryByTypes();
                if (error != 0)
                {
                    this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Start Inventory By Types command sent failed." + Environment.NewLine);
                    this.Devmes.ScrollToCaret();
                    this.StartInventory.Enabled = true;
                    return;
                }

                total_time = System.Environment.TickCount;
                ClearTableData();

                this.StartInventory.Text = "Stop";
                m_bInventory = true;
                readTimer.Enabled = true;


                this.grpOtherSetting.Enabled = false;
                this.grpAutoInventory.Enabled = false;

                FileName = DateTime.Now.ToString("yyyyMMddHHmmssfff");
            }
            this.StartInventory.Enabled = true;
        }

        private void startInventory_Click2(object sender, EventArgs e)
        {
            string path = this.TextExportPath2.Text;
            if (!ExistsPath2(path)) return;

            UInt32 error = 0;
            this.StartInventory2.Enabled = false;
            if (m_bInventory2)
            {
                error = device2.StopInventory();
                if (error != 0)
                {
                    this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Stop Inventory command sent failed." + Environment.NewLine);
                    this.Devmes2.ScrollToCaret();
                    this.StartInventory2.Enabled = true;
                    return;
                }
                m_bInventory2 = false;
                readTimer2.Enabled = false;
                this.StartInventory2.Text = "Start";

                this.grpOtherSetting2.Enabled = true;
                this.grpAutoInventory2.Enabled = true;

                //Task.Run(()=> {
                FileName2 += "_" + DateTime.Now.ToString("yyyyMMddHHmmssfff") + "_D2.csv";
                Thread.Sleep(200);
                ExportCSV2(FileName2);
                //});
            }
            else
            {
                if (this.txtTagCount2.Text == string.Empty) this.txtTagCount2.Text = "0";
                if (this.txtInventoryRound2.Text == string.Empty) this.txtInventoryRound2.Text = "0";
                if (this.txtElapsedTime2.Text == string.Empty) this.txtElapsedTime2.Text = "0";

                error = StartInventoryByTypes2();
                if (error != 0)
                {
                    this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Start Inventory By Types command sent failed." + Environment.NewLine);
                    this.Devmes2.ScrollToCaret();
                    this.StartInventory2.Enabled = true;
                    return;
                }

                total_time2 = System.Environment.TickCount;
                ClearTableData2();

                this.StartInventory2.Text = "Stop";
                m_bInventory2 = true;
                readTimer2.Enabled = true;

                this.grpOtherSetting2.Enabled = false;
                this.grpAutoInventory2.Enabled = false;

                FileName2 = DateTime.Now.ToString("yyyyMMddHHmmssfff");
            }
            this.StartInventory2.Enabled = true;
        }

        /// <summary>
        /// 扫描列表行选中时，将当前的标签内容放置到access tag的tab控件中
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void DatalistView_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (this.DatalistView.SelectedItems.Count > 0)
            {
                ListViewItem row = this.DatalistView.SelectedItems[0];
                if (row != null && row.SubItems[2] != null && row.SubItems[2].Text != null)
                {
                    txtSelectedTag.Text = row.SubItems[2].Text;
                    selectedIndex = this.DatalistView.SelectedItems[0].Index;
                }
            }
        }
        /// <summary>
        /// 扫描列表行选中时，将当前的标签内容放置到access tag的tab控件中
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void DatalistView_SelectedIndexChanged2(object sender, EventArgs e)
        {
            if (this.DatalistView2.SelectedItems.Count > 0)
            {
                ListViewItem row = this.DatalistView2.SelectedItems[0];
                if (row != null && row.SubItems[2] != null && row.SubItems[2].Text != null)
                {
                    txtSelectedTag2.Text = row.SubItems[2].Text;
                    selectedIndex2 = this.DatalistView2.SelectedItems[0].Index;
                }
            }
        }

        private void MaskStartAddressWord_KeyPress(object sender, KeyPressEventArgs e)
        {
            e.Handled = ("0123456789ABCDEF".IndexOf(Char.ToUpper(e.KeyChar)) < 0);
        }

        private void ReadLenth_KeyPress(object sender, KeyPressEventArgs e)
        {
            e.Handled = ("0123456789ABCDEF".IndexOf(Char.ToUpper(e.KeyChar)) < 0);
        }

        private void password_text_KeyPress(object sender, KeyPressEventArgs e)
        {
            e.Handled = ("0123456789ABCDEF".IndexOf(Char.ToUpper(e.KeyChar)) < 0);
        }

        private void text_off_KeyPress(object sender, KeyPressEventArgs e)
        {
            e.Handled = ("0123456789ABCDEF".IndexOf(Char.ToUpper(e.KeyChar)) < 0);
        }

        private void txtEpc_KeyPress(object sender, KeyPressEventArgs e)
        {
            e.Handled = ("0123456789ABCDEF".IndexOf(Char.ToUpper(e.KeyChar)) < 0);
        }

        private void ReadPassward_KeyPress(object sender, KeyPressEventArgs e)
        {
            e.Handled = ("0123456789ABCDEF".IndexOf(Char.ToUpper(e.KeyChar)) < 0);
        }

        /// <summary>
        /// lock tag
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void buttonLock_Click(object sender, EventArgs e)
        {
            UInt32 error = 0;
            string Epc_string = this.txtSelectedTag.Text;
            if (Epc_string != null)
            {
                Epc_string = Epc_string.Replace(" ", "").Replace("0x", "");
                if (Epc_string.Length % 2 != 0)
                {
                    this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Please input correct epc." + Environment.NewLine);
                    this.Devmes.ScrollToCaret();
                    return;
                }
            }
            Epc_string = Epc_string.Replace(" ", "").Replace("0x", "");
            byte[] yu = { };
            if (Epc_string != null)
            {
                yu = HexStringToByteArray(Epc_string);
            }

            AsReader.TagMask tagMask = new AsReader.TagMask();
            tagMask.userMemoryBit1 = cbMaskUser1.Checked;
            tagMask.userMemoryBit2 = cbMaskUser2.Checked;
            tagMask.tidMemoryBit1 = cbMaskTID1.Checked;
            tagMask.tidMemoryBit2 = cbMaskTID2.Checked;
            tagMask.epcMemoryBit1 = cbMaskEPC1.Checked;
            tagMask.epcMemoryBit2 = cbMaskEPC2.Checked;
            tagMask.accessMemoryBit1 = cbMaskAccess1.Checked;
            tagMask.accessMemoryBit2 = cbMaskAccess2.Checked;
            tagMask.killPwdMemoryBit1 = cbMaskKill1.Checked;
            tagMask.killPwdMemoryBit2 = cbMaskKill2.Checked;

            AsReader.TagAction tagAction = new AsReader.TagAction();
            tagAction.userMemoryBit1 = cbActionUser1.Checked;
            tagAction.userMemoryBit2 = cbActionUser2.Checked;
            tagAction.tidMemoryBit1 = cbActionTID1.Checked;
            tagAction.tidMemoryBit2 = cbActionTID2.Checked;
            tagAction.epcMemoryBit1 = cbActionEPC1.Checked;
            tagAction.epcMemoryBit2 = cbActionEPC2.Checked;
            tagAction.accessMemoryBit1 = cbActionAccess1.Checked;
            tagAction.accessMemoryBit2 = cbActionAccess2.Checked;
            tagAction.killPwdMemoryBit1 = cbActionKill1.Checked;
            tagAction.killPwdMemoryBit2 = cbActionKill2.Checked;

            error = device1.LockMemory(tagMask, tagAction, Convert.ToUInt32(ReadPassward.Text == "" ? "0" : ReadPassward.Text, 16), yu);

            if (error == 1)
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Lock Tag command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
            }
        }

        private void buttonLock_Click2(object sender, EventArgs e)
        {
            UInt32 error = 0;
            string Epc_string = this.txtSelectedTag2.Text;
            if (Epc_string != null)
            {
                Epc_string = Epc_string.Replace(" ", "").Replace("0x", "");
                if (Epc_string.Length % 2 != 0)
                {
                    this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Please input correct epc." + Environment.NewLine);
                    this.Devmes2.ScrollToCaret();
                    return;
                }
            }
            Epc_string = Epc_string.Replace(" ", "").Replace("0x", "");
            byte[] yu = { };
            if (Epc_string != null)
            {
                yu = HexStringToByteArray(Epc_string);
            }

            AsReader.TagMask tagMask = new AsReader.TagMask();
            tagMask.userMemoryBit1 = cbMaskUser1_2.Checked;
            tagMask.userMemoryBit2 = cbMaskUser2_2.Checked;
            tagMask.tidMemoryBit1 = cbMaskTID1_2.Checked;
            tagMask.tidMemoryBit2 = cbMaskTID2_2.Checked;
            tagMask.epcMemoryBit1 = cbMaskEPC1_2.Checked;
            tagMask.epcMemoryBit2 = cbMaskEPC2_2.Checked;
            tagMask.accessMemoryBit1 = cbMaskAccess1_2.Checked;
            tagMask.accessMemoryBit2 = cbMaskAccess2_2.Checked;
            tagMask.killPwdMemoryBit1 = cbMaskKill1_2.Checked;
            tagMask.killPwdMemoryBit2 = cbMaskKill2_2.Checked;

            AsReader.TagAction tagAction = new AsReader.TagAction();
            tagAction.userMemoryBit1 = cbActionUser1_2.Checked;
            tagAction.userMemoryBit2 = cbActionUser2_2.Checked;
            tagAction.tidMemoryBit1 = cbActionTID1_2.Checked;
            tagAction.tidMemoryBit2 = cbActionTID2_2.Checked;
            tagAction.epcMemoryBit1 = cbActionEPC1_2.Checked;
            tagAction.epcMemoryBit2 = cbActionEPC2_2.Checked;
            tagAction.accessMemoryBit1 = cbActionAccess1_2.Checked;
            tagAction.accessMemoryBit2 = cbActionAccess2_2.Checked;
            tagAction.killPwdMemoryBit1 = cbActionKill1_2.Checked;
            tagAction.killPwdMemoryBit2 = cbActionKill2_2.Checked;

            error = device2.LockMemory(tagMask, tagAction, Convert.ToUInt32(ReadPassward2.Text == "" ? "0" : ReadPassward2.Text, 16), yu);

            if (error == 1)
            {
                this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Lock Tag command sent failed." + Environment.NewLine);
                this.Devmes2.ScrollToCaret();
            }
        }

        /// <summary>
        /// ANT power value
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void AntPowerOrReadTimeKeyPress(object sender, KeyPressEventArgs e)
        {
            e.Handled = ("0123456789".IndexOf(Char.ToUpper(e.KeyChar)) < 0);
        }

        /// <summary>
        /// set channel
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnSetChannel_Click(object sender, EventArgs e)
        {
            UInt32 error = device1.SetChannel((uint)Convert.ToInt32(cmbChannel.SelectedValue));

            if (error == 1)
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Set Channel command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
            }
        }
        /// <summary>
        /// set channel
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnSetChannel_Click2(object sender, EventArgs e)
        {
            UInt32 error = device2.SetChannel((uint)Convert.ToInt32(cmbChannel2.SelectedValue));

            if (error == 1)
            {
                this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Set Channel command sent failed." + Environment.NewLine);
                this.Devmes2.ScrollToCaret();
            }
        }

        /// <summary>
        /// get channel
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnGetChannel_Click(object sender, EventArgs e)
        {
            uint channel = 0;
            uint error = 0;
            error = device1.GetChannel(ref channel);
            if (error == 0) cmbChannel.SelectedValue = Convert.ToInt32(channel);

            if (error == 1)
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get Channel command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
            }
        }
        /// <summary>
        /// get channel
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnGetChannel_Click2(object sender, EventArgs e)
        {
            uint channel = 0;
            uint error = 0;
            error = device2.GetChannel(ref channel);
            if (error == 0) cmbChannel2.SelectedValue = Convert.ToInt32(channel);

            if (error == 1)
            {
                this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get Channel command sent failed." + Environment.NewLine);
                this.Devmes2.ScrollToCaret();
            }
        }

        private void cmbCollision_SelectedIndexChanged(object sender, EventArgs e)
        {
            Types.AntiCollisionMode anticollisionmode = (Types.AntiCollisionMode)cmbCollision.SelectedIndex;

            if (anticollisionmode == Types.AntiCollisionMode.FixedQ)
            {
                cmbMinQType.Enabled = false;
                cmbMaxQType.Enabled = false;
            }
            else
            {
                cmbMinQType.Enabled = true;
                cmbMaxQType.Enabled = true;
            }
        }

        private void cmbCollision_SelectedIndexChanged2(object sender, EventArgs e)
        {
            Types.AntiCollisionMode anticollisionmode = (Types.AntiCollisionMode)cmbCollision2.SelectedIndex;

            if (anticollisionmode == Types.AntiCollisionMode.FixedQ)
            {
                cmbMinQType2.Enabled = false;
                cmbMaxQType2.Enabled = false;
            }
            else
            {
                cmbMinQType2.Enabled = true;
                cmbMaxQType2.Enabled = true;
            }
        }

        /// <summary>
        /// set collision 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnSetCollision_Click(object sender, EventArgs e)
        {
            Types.AntiCollisionMode anticollisionmode = (Types.AntiCollisionMode)cmbCollision.SelectedValue;
            Types.QType startq = (Types.QType)cmbStartQType.SelectedValue;
            Types.QType minq = (Types.QType)cmbMinQType.SelectedValue;
            Types.QType maxq = (Types.QType)cmbMaxQType.SelectedValue;

            if (anticollisionmode == Types.AntiCollisionMode.DynamicQ)
            {
                if (startq < minq || startq > maxq)
                {
                    this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Set Q Start Value Error (Min <= Start <= Max)." + Environment.NewLine);
                    this.Devmes.ScrollToCaret();
                    MessageBox.Show("Set Q Start value is error (Min <= Start <= Max).", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    return;
                }
                if (minq > maxq)
                {
                    this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Set Q Min/Max value is error (Min <= Max)." + Environment.NewLine);
                    this.Devmes.ScrollToCaret();
                    MessageBox.Show("Set Q Min/Max value is error (Min <= Max).", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    return;
                }

            }

            UInt32 error = device1.SetAntiCollisionMode(anticollisionmode, startq, minq, maxq);

            if (error == 1)
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Set Collision command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
            }
        }
        /// <summary>
        /// set collision 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnSetCollision_Click2(object sender, EventArgs e)
        {
            Types.AntiCollisionMode anticollisionmode = (Types.AntiCollisionMode)cmbCollision2.SelectedValue;
            Types.QType startq = (Types.QType)cmbStartQType2.SelectedValue;
            Types.QType minq = (Types.QType)cmbMinQType2.SelectedValue;
            Types.QType maxq = (Types.QType)cmbMaxQType2.SelectedValue;

            if (anticollisionmode == Types.AntiCollisionMode.DynamicQ)
            {
                if (startq < minq || startq > maxq)
                {
                    this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Set Q Start Value Error (Min <= Start <= Max)." + Environment.NewLine);
                    this.Devmes2.ScrollToCaret();
                    MessageBox.Show("Set Q Start value is error (Min <= Start <= Max).", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    return;
                }
                if (minq > maxq)
                {
                    this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Set Q Min/Max value is error (Min <= Max)." + Environment.NewLine);
                    this.Devmes2.ScrollToCaret();
                    MessageBox.Show("Set Q Min/Max value is error (Min <= Max).", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    return;
                }
            }

            UInt32 error = device2.SetAntiCollisionMode(anticollisionmode, startq, minq, maxq);

            if (error == 1)
            {
                this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Set Collision command sent failed." + Environment.NewLine);
                this.Devmes2.ScrollToCaret();
            }
        }

        bool getCollisionErr = false;
        /// <summary>
        /// get collision
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnGetCollision_Click(object sender, EventArgs e)
        {
            Types.AntiCollisionMode anticollisionmode = 0;
            Types.QType startq = 0;
            Types.QType minq = 0;
            Types.QType maxq = 0;
            uint error = 0;

            error = device1.GetAntiCollisionMode(ref anticollisionmode, ref startq, ref minq, ref maxq);
            if (error == 0)
            {
                cmbCollision.SelectedValue = Convert.ToInt32(anticollisionmode);
                cmbStartQType.SelectedValue = Convert.ToInt32(startq);
                cmbMinQType.SelectedValue = Convert.ToInt32(minq);
                cmbMaxQType.SelectedValue = Convert.ToInt32(maxq);
                if (anticollisionmode == Types.AntiCollisionMode.FixedQ)
                {
                    cmbMinQType.Enabled = false;
                    cmbMaxQType.Enabled = false;
                }
                else
                {
                    cmbMinQType.Enabled = true;
                    cmbMaxQType.Enabled = true;
                }
                getCollisionErr = false;
            }
            if (error == 1)
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get Collision command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
                getCollisionErr = true;
            }
        }
        bool getCollisionErr2 = false;

        /// <summary>
        /// get collision
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnGetCollision_Click2(object sender, EventArgs e)
        {
            Types.AntiCollisionMode anticollisionmode = 0;
            Types.QType startq = 0;
            Types.QType minq = 0;
            Types.QType maxq = 0;
            uint error = 0;

            error = device2.GetAntiCollisionMode(ref anticollisionmode, ref startq, ref minq, ref maxq);
            if (error == 0)
            {
                cmbCollision2.SelectedValue = Convert.ToInt32(anticollisionmode);
                cmbStartQType2.SelectedValue = Convert.ToInt32(startq);
                cmbMinQType2.SelectedValue = Convert.ToInt32(minq);
                cmbMaxQType2.SelectedValue = Convert.ToInt32(maxq);
                if (anticollisionmode == Types.AntiCollisionMode.FixedQ)
                {
                    cmbMinQType2.Enabled = false;
                    cmbMaxQType2.Enabled = false;
                }
                else
                {
                    cmbMinQType2.Enabled = true;
                    cmbMaxQType2.Enabled = true;
                }
                getCollisionErr2 = false;
            }
            if (error == 1)
            {
                this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get Collision command sent failed." + Environment.NewLine);
                this.Devmes2.ScrollToCaret();
                getCollisionErr2 = true;
            }
        }
        /// <summary>
        /// set read time
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnSetReadTime_Click(object sender, EventArgs e)
        {
            UInt32 error = 0;
            if (checkReadTime(txtReadTime1.Text) == false)
            {
                string msg = DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Please input correct antenna read time(10~40000).";
                this.Devmes.AppendText(msg + Environment.NewLine);
                this.Devmes.ScrollToCaret();
                MessageBox.Show("Please input correct antenna read time(10~40000).", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                return;
            }
            error = device1.SetReadTime(Convert.ToUInt32(txtReadTime1.Text));

            if (error == 1)
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Set Read Time command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
            }
        }
        /// <summary>
        /// set read time
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnSetReadTime_Click2(object sender, EventArgs e)
        {
            UInt32 error = 0;
            if (checkReadTime(txtReadTime2.Text) == false)
            {
                string msg = DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Please input correct antenna read time(10~40000).";
                this.Devmes2.AppendText(msg + Environment.NewLine);
                this.Devmes2.ScrollToCaret();
                MessageBox.Show("Please input correct antenna read time(10~40000).", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                return;
            }
            error = device2.SetReadTime(Convert.ToUInt32(txtReadTime2.Text));

            if (error == 1)
            {
                this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Set Read Time command sent failed." + Environment.NewLine);
                this.Devmes2.ScrollToCaret();
            }
        }

        bool getReadTimeErr = false;
        private void btnGetReadTime_Click(object sender, EventArgs e)
        {
            UInt32 readTime1 = 0;
            UInt32 error = 0;

            error = device1.GetReadTime(ref readTime1);
            if (error == 0)
            {
                txtReadTime1.Text = readTime1.ToString();
                getReadTimeErr = false;
            }

            if (error == 1)
            {
                txtReadTime1.Text = "";
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get Read Time command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
                getReadTimeErr = true;
            }
        }

        bool getReadTimeErr2 = false;
        private void btnGetReadTime_Click2(object sender, EventArgs e)
        {
            UInt32 readTime1 = 0;
            UInt32 error = 0;

            error = device2.GetReadTime(ref readTime1);
            if (error == 0)
            {
                txtReadTime2.Text = readTime1.ToString();
                getReadTimeErr2 = false;
            }

            if (error == 1)
            {
                txtReadTime2.Text = "";
                this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get Read Time command sent failed." + Environment.NewLine);
                this.Devmes2.ScrollToCaret();
                getReadTimeErr2 = true;
            }
        }

        private void ClearTableData()
        {
            mTagHashTable.Clear();
            this.DatalistView.Items.Clear();
            //dt.Clear();
            selectedIndex = 0;
            selectedIndex2 = 0;
            this.Devmes.Text = "";

            singluationCount = 0;
            lblTotalDuration.Text = "0";
            lblTotalSingulation.Text = "0";
            lblTotalUnique.Text = "0";
            lblSingulationRate.Text = "0";
            lblAllTagCnt.Text = "0";
        }
        private void ClearTableData2()
        {
            mTagHashTable2.Clear();
            this.DatalistView2.Items.Clear();
            selectedIndex2 = 0;
            this.Devmes2.Text = "";

            singluationCount2 = 0;
            lblTotalDuration2.Text = "0";
            lblTotalSingulation2.Text = "0";
            lblTotalUnique2.Text = "0";
            lblSingulationRate2.Text = "0";
            lblAllTagCnt2.Text = "0";
        }

        /// <summary>
        /// 
        /// </summary>
        private void ControlsEnabled()
        {
            tabPageBasic.Enabled = isConnected;
            tabPageOpTag.Enabled = isConnected;
            tabPageHIDSetting.Enabled = isConnected;
            tabPageOtherSetting.Enabled = isConnected;
            tabPageInventory.Enabled = isConnected;
            Connect.Enabled = !isConnected;
            btnDisconnect.Enabled = isConnected && connType == "VCP";
            ComPort.Enabled = !isConnected;
            txtBaudRate.Enabled = !isConnected;
            grpFirmwareUpdate.Enabled = isConnected;
            SearchPortBtn.Enabled = !isConnected;

            cmbHIDInventrorymode.Enabled = isConnected;
        }
        /// <summary>
        /// 
        /// </summary>
        private void ControlsEnabled2()
        {
            tabPageBasic2.Enabled = isConnected2;
            tabPageOpTag2.Enabled = isConnected2;
            tabPageHIDSetting2.Enabled = isConnected2;
            tabPageOtherSetting2.Enabled = isConnected2;
            tabPageInventory2.Enabled = isConnected2;
            Connect2.Enabled = !isConnected2;
            btnDisconnect2.Enabled = isConnected2 && connType == "VCP";
            ComPort2.Enabled = !isConnected2;
            txtBaudRate2.Enabled = !isConnected2;
            grpFirmwareUpdate2.Enabled = isConnected2;
            SearchPortBtn2.Enabled = !isConnected2;

            cmbHIDInventrorymode2.Enabled = isConnected;
        }

        /// <summary>
        /// 
        /// </summary>
        private void SetCombolList()
        {
            this.cmbTarget.DataSource = device1.getComboxList(typeof(Types.TargetType));
            this.cmbTarget.DisplayMember = "name";
            this.cmbTarget.ValueMember = "value";
            this.cmbTarget.SelectedIndex = 0;

            this.cmbAction.DataSource = device1.getComboxList(typeof(Types.ActionType));
            this.cmbAction.DisplayMember = "name";
            this.cmbAction.ValueMember = "value";
            this.cmbAction.SelectedIndex = 0;

            this.cmbRegion.DataSource = device1.getComboxList(typeof(Types.RegionType));
            this.cmbRegion.DisplayMember = "name";
            this.cmbRegion.ValueMember = "value";
            this.cmbRegion.SelectedIndex = 0;

            this.cmbSession.DataSource = device1.getComboxList(typeof(Types.SessionType));
            this.cmbSession.DisplayMember = "name";
            this.cmbSession.ValueMember = "value";
            this.cmbSession.SelectedIndex = 0;

            this.cmbCollision.DataSource = device1.getComboxList(typeof(Types.AntiCollisionMode));
            this.cmbCollision.DisplayMember = "name";
            this.cmbCollision.ValueMember = "value";
            this.cmbCollision.SelectedIndex = 0;

            this.cmbStartQType.DataSource = device1.getComboxListByName(typeof(Types.QType), "dicQ");
            this.cmbStartQType.DisplayMember = "name";
            this.cmbStartQType.ValueMember = "value";
            this.cmbStartQType.SelectedIndex = 0;

            this.cmbMinQType.DataSource = device1.getComboxListByName(typeof(Types.QType), "dicQ");
            this.cmbMinQType.DisplayMember = "name";
            this.cmbMinQType.ValueMember = "value";
            this.cmbMinQType.SelectedIndex = 0;

            this.cmbMaxQType.DataSource = device1.getComboxListByName(typeof(Types.QType), "dicQ");
            this.cmbMaxQType.DisplayMember = "name";
            this.cmbMaxQType.ValueMember = "value";
            this.cmbMaxQType.SelectedIndex = 0;


            this.cmbBuzzer.DataSource = device1.getComboxList(typeof(Types.Buzzer));
            this.cmbBuzzer.DisplayMember = "name";
            this.cmbBuzzer.ValueMember = "value";
            this.cmbBuzzer.SelectedIndex = 0;

            this.cmbBasicTarget.DataSource = device1.getComboxListByName(typeof(Types.TargetABType), "dicQryTarget");
            this.cmbBasicTarget.DisplayMember = "name";
            this.cmbBasicTarget.ValueMember = "value";
            this.cmbBasicTarget.SelectedIndex = 0;

            this.cmbSelectionEnable.DataSource = device1.getComboxList(typeof(Types.SelectionEnable));
            this.cmbSelectionEnable.DisplayMember = "name";
            this.cmbSelectionEnable.ValueMember = "value";
            this.cmbSelectionEnable.SelectedIndex = 0;

            this.cmbHIDInventrorymode.DataSource = device1.getComboxList(typeof(Types.HIDInventoryMode));
            this.cmbHIDInventrorymode.DisplayMember = "name";
            this.cmbHIDInventrorymode.ValueMember = "value";
            this.cmbHIDInventrorymode.SelectedIndex = 0;

        }

        /// <summary>
        /// 
        /// </summary>
        private void SetCombolList2()
        {
            this.cmbTarget2.DataSource = device2.getComboxList(typeof(Types.TargetType));
            this.cmbTarget2.DisplayMember = "name";
            this.cmbTarget2.ValueMember = "value";
            this.cmbTarget2.SelectedIndex = 0;

            this.cmbAction2.DataSource = device2.getComboxList(typeof(Types.ActionType));
            this.cmbAction2.DisplayMember = "name";
            this.cmbAction2.ValueMember = "value";
            this.cmbAction2.SelectedIndex = 0;

            this.cmbRegion2.DataSource = device2.getComboxList(typeof(Types.RegionType));
            this.cmbRegion2.DisplayMember = "name";
            this.cmbRegion2.ValueMember = "value";
            this.cmbRegion2.SelectedIndex = 0;

            this.cmbSession2.DataSource = device2.getComboxList(typeof(Types.SessionType));
            this.cmbSession2.DisplayMember = "name";
            this.cmbSession2.ValueMember = "value";
            this.cmbSession2.SelectedIndex = 0;

            this.cmbCollision2.DataSource = device2.getComboxList(typeof(Types.AntiCollisionMode));
            this.cmbCollision2.DisplayMember = "name";
            this.cmbCollision2.ValueMember = "value";
            this.cmbCollision2.SelectedIndex = 0;

            this.cmbStartQType2.DataSource = device2.getComboxListByName(typeof(Types.QType), "dicQ");
            this.cmbStartQType2.DisplayMember = "name";
            this.cmbStartQType2.ValueMember = "value";
            this.cmbStartQType2.SelectedIndex = 0;

            this.cmbMinQType2.DataSource = device2.getComboxListByName(typeof(Types.QType), "dicQ");
            this.cmbMinQType2.DisplayMember = "name";
            this.cmbMinQType2.ValueMember = "value";
            this.cmbMinQType2.SelectedIndex = 0;

            this.cmbMaxQType2.DataSource = device2.getComboxListByName(typeof(Types.QType), "dicQ");
            this.cmbMaxQType2.DisplayMember = "name";
            this.cmbMaxQType2.ValueMember = "value";
            this.cmbMaxQType2.SelectedIndex = 0;


            this.cmbBuzzer2.DataSource = device2.getComboxList(typeof(Types.Buzzer));
            this.cmbBuzzer2.DisplayMember = "name";
            this.cmbBuzzer2.ValueMember = "value";
            this.cmbBuzzer2.SelectedIndex = 0;

            this.cmbBasicTarget2.DataSource = device2.getComboxListByName(typeof(Types.TargetABType), "dicQryTarget");
            this.cmbBasicTarget2.DisplayMember = "name";
            this.cmbBasicTarget2.ValueMember = "value";
            this.cmbBasicTarget2.SelectedIndex = 0;

            this.cmbSelectionEnable2.DataSource = device2.getComboxList(typeof(Types.SelectionEnable));
            this.cmbSelectionEnable2.DisplayMember = "name";
            this.cmbSelectionEnable2.ValueMember = "value";
            this.cmbSelectionEnable2.SelectedIndex = 0;

            this.cmbHIDInventrorymode2.DataSource = device2.getComboxList(typeof(Types.HIDInventoryMode));
            this.cmbHIDInventrorymode2.DisplayMember = "name";
            this.cmbHIDInventrorymode2.ValueMember = "value";
            this.cmbHIDInventrorymode2.SelectedIndex = 0;
        }

        private void StopInventory()
        {
            StartInventory.Text = "Start";
            StartInventory.Enabled = false;
            readTimer.Enabled = false;
            //if (m_bInventory) while (device1.StopInventory() != 0) ;
            if (m_bInventory)
            {
                device1.StopInventory();
            }
            m_bInventory = false;
            StartInventory.Enabled = true;
            ClearTableData();
        }

        private void StopInventory2()
        {
            StartInventory2.Text = "Start";
            StartInventory2.Enabled = false;
            readTimer2.Enabled = false;
            if (m_bInventory2)
            {
                device2.StopInventory();
            }
            m_bInventory2 = false;
            StartInventory2.Enabled = true;
            ClearTableData2();
        }
        public static string[] GetPortList()
        {
            return SerialPort.GetPortNames();
        }

        void SetReaderTagDataList(AsReader.InventoryResult tagcallbackdata)
        {
            singluationCount++;

            mReadTag = tagcallbackdata;
            string epc = tagcallbackdata.tagdata.epc;
            string pc = tagcallbackdata.tagdata.pc;
            string tid = tagcallbackdata.tagdata.tid;
            string tagdata = tagcallbackdata.tagdata.data;

            if (epc != null)
            {
                if (!mTagHashTable.ContainsKey(epc))
                {
                    mTagHashTable.Add(epc, this.DatalistView.Items.Count);

                    ListViewItem item = new ListViewItem();
                    item.Text = (this.DatalistView.Items.Count + 1).ToString();
                    item.SubItems.Add(Convert.ToString(tagcallbackdata.tagdata.pc));
                    item.SubItems.Add(Convert.ToString(tagcallbackdata.tagdata.epc));
                    //item.SubItems.Add(Convert.ToString(tagcallbackdata.tagdata.tid));
                    item.SubItems.Add(Convert.ToString(tagcallbackdata.rssi));
                    item.SubItems.Add(Convert.ToString(tagcallbackdata.tagdata.data));
                    //item.SubItems.Add(Convert.ToString(tagcallbackdata.antenna));
                    item.SubItems.Add(DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss"));
                    item.SubItems.Add("1");


                    this.DatalistView.Items.Add(item);
                }
                else
                {
                    int count = (int)mTagHashTable[epc];
                    ListViewItem item = this.DatalistView.Items[count];
                    item.SubItems[3].Text = Convert.ToString(tagcallbackdata.rssi);
                    item.SubItems[4].Text = Convert.ToString(tagcallbackdata.tagdata.data);
                    //item.SubItems[5].Text = Convert.ToString(tagcallbackdata.antenna);
                    item.SubItems[5].Text = DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss");
                    item.SubItems[6].Text = (Convert.ToInt32(item.SubItems[6].Text) + 1).ToString();

                }

            }
            if (epc == null && tid != null)
            {
                if (!mTagHashTable.ContainsKey(tid))
                {
                    mTagHashTable.Add(tid, this.DatalistView.Items.Count);

                    ListViewItem item = new ListViewItem();
                    item.Text = (this.DatalistView.Items.Count + 1).ToString();
                    item.SubItems.Add(Convert.ToString(tagcallbackdata.tagdata.pc));
                    item.SubItems.Add(Convert.ToString(tagcallbackdata.tagdata.epc));
                    //item.SubItems.Add(Convert.ToString(tagcallbackdata.tagdata.tid));
                    item.SubItems.Add(Convert.ToString(tagcallbackdata.rssi));
                    item.SubItems.Add(Convert.ToString(tagcallbackdata.tagdata.data));
                    //item.SubItems.Add(Convert.ToString(tagcallbackdata.antenna));
                    item.SubItems.Add(DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss"));
                    item.SubItems.Add("1");


                    this.DatalistView.Items.Add(item);
                }
                else
                {
                    int count = (int)mTagHashTable[tid];

                    ListViewItem item = this.DatalistView.Items[count];
                    item.SubItems[3].Text = Convert.ToString(tagcallbackdata.rssi);
                    item.SubItems[4].Text = Convert.ToString(tagcallbackdata.tagdata.data);

                    item.SubItems[5].Text = DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss");
                    item.SubItems[6].Text = (Convert.ToInt32(item.SubItems[6].Text) + 1).ToString();

                }
            }
            if (epc == null && tid == null && tagdata != null)
            {
                if (!mTagHashTable.ContainsKey(tagdata))
                {
                    mTagHashTable.Add(tagdata, this.DatalistView.Items.Count);

                    ListViewItem item = new ListViewItem();
                    item.Text = (this.DatalistView.Items.Count + 1).ToString();
                    item.SubItems.Add(Convert.ToString(tagcallbackdata.tagdata.pc));
                    item.SubItems.Add(Convert.ToString(tagcallbackdata.tagdata.epc));
                    //item.SubItems.Add(Convert.ToString(tagcallbackdata.tagdata.tid));
                    item.SubItems.Add(Convert.ToString(tagcallbackdata.rssi));
                    item.SubItems.Add(Convert.ToString(tagcallbackdata.tagdata.data));
                    //item.SubItems.Add(Convert.ToString(tagcallbackdata.antenna));
                    item.SubItems.Add(DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss"));
                    item.SubItems.Add("1");


                    this.DatalistView.Items.Add(item);
                }
                else
                {
                    int count = (int)mTagHashTable[tagdata];

                    ListViewItem item = this.DatalistView.Items[count];
                    item.SubItems[3].Text = Convert.ToString(tagcallbackdata.rssi);
                    item.SubItems[4].Text = Convert.ToString(tagcallbackdata.tagdata.data);

                    item.SubItems[5].Text = DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss");
                    item.SubItems[6].Text = (Convert.ToInt32(item.SubItems[6].Text) + 1).ToString();

                }
            }

            lblTotalSingulation.Text = singluationCount.ToString();
            lblTotalUnique.Text = DatalistView.Items.Count.ToString();
            lblAllTagCnt.Text = DatalistView.Items.Count.ToString();
        }

        void SetReaderTagDataList2(AsReader.InventoryResult tagcallbackdata)
        {
            singluationCount2++;
            mReadTag2 = tagcallbackdata;
            string epc = tagcallbackdata.tagdata.epc;
            string pc = tagcallbackdata.tagdata.pc;
            string tid = tagcallbackdata.tagdata.tid;
            string tagdata = tagcallbackdata.tagdata.data;
            if (epc != null)
            {
                if (!mTagHashTable2.ContainsKey(epc))
                {
                    mTagHashTable2.Add(epc, this.DatalistView2.Items.Count);
                    ListViewItem item = new ListViewItem();
                    item.Text = (this.DatalistView2.Items.Count + 1).ToString();
                    item.SubItems.Add(Convert.ToString(tagcallbackdata.tagdata.pc));
                    item.SubItems.Add(Convert.ToString(tagcallbackdata.tagdata.epc));
                    //item.SubItems.Add(Convert.ToString(tagcallbackdata.tagdata.tid));
                    item.SubItems.Add(Convert.ToString(tagcallbackdata.rssi));
                    item.SubItems.Add(Convert.ToString(tagcallbackdata.tagdata.data));
                    //item.SubItems.Add(Convert.ToString(tagcallbackdata.antenna));
                    item.SubItems.Add(DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss"));
                    item.SubItems.Add("1");
                    this.DatalistView2.Items.Add(item);
                }
                else
                {
                    int count = (int)mTagHashTable2[epc];
                    ListViewItem item = this.DatalistView2.Items[count];
                    item.SubItems[3].Text = Convert.ToString(tagcallbackdata.rssi);
                    item.SubItems[4].Text = Convert.ToString(tagcallbackdata.tagdata.data);
                    //item.SubItems[5].Text = Convert.ToString(tagcallbackdata.antenna);
                    item.SubItems[5].Text = DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss");
                    item.SubItems[6].Text = (Convert.ToInt32(item.SubItems[6].Text) + 1).ToString();
                }
            }
            if (epc == null && tid != null)
            {
                if (!mTagHashTable2.ContainsKey(tid))
                {
                    mTagHashTable2.Add(tid, this.DatalistView2.Items.Count);
                    ListViewItem item = new ListViewItem();
                    item.Text = (this.DatalistView2.Items.Count + 1).ToString();
                    item.SubItems.Add(Convert.ToString(tagcallbackdata.tagdata.pc));
                    item.SubItems.Add(Convert.ToString(tagcallbackdata.tagdata.epc));
                    //item.SubItems.Add(Convert.ToString(tagcallbackdata.tagdata.tid));
                    item.SubItems.Add(Convert.ToString(tagcallbackdata.rssi));
                    item.SubItems.Add(Convert.ToString(tagcallbackdata.tagdata.data));
                    //item.SubItems.Add(Convert.ToString(tagcallbackdata.antenna));
                    item.SubItems.Add(DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss"));
                    item.SubItems.Add("1");
                    this.DatalistView2.Items.Add(item);
                }
                else
                {
                    int count = (int)mTagHashTable2[tid];
                    ListViewItem item = this.DatalistView2.Items[count];
                    item.SubItems[3].Text = Convert.ToString(tagcallbackdata.rssi);
                    item.SubItems[4].Text = Convert.ToString(tagcallbackdata.tagdata.data);
                    item.SubItems[5].Text = DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss");
                    item.SubItems[6].Text = (Convert.ToInt32(item.SubItems[6].Text) + 1).ToString();
                }
            }
            if (epc == null && tid == null && tagdata != null)
            {
                if (!mTagHashTable2.ContainsKey(tagdata))
                {
                    mTagHashTable2.Add(tagdata, this.DatalistView2.Items.Count);
                    ListViewItem item = new ListViewItem();
                    item.Text = (this.DatalistView2.Items.Count + 1).ToString();
                    item.SubItems.Add(Convert.ToString(tagcallbackdata.tagdata.pc));
                    item.SubItems.Add(Convert.ToString(tagcallbackdata.tagdata.epc));
                    //item.SubItems.Add(Convert.ToString(tagcallbackdata.tagdata.tid));
                    item.SubItems.Add(Convert.ToString(tagcallbackdata.rssi));
                    item.SubItems.Add(Convert.ToString(tagcallbackdata.tagdata.data));
                    //item.SubItems.Add(Convert.ToString(tagcallbackdata.antenna));
                    item.SubItems.Add(DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss"));
                    item.SubItems.Add("1");
                    this.DatalistView2.Items.Add(item);
                }
                else
                {
                    int count = (int)mTagHashTable2[tagdata];
                    ListViewItem item = this.DatalistView2.Items[count];
                    item.SubItems[3].Text = Convert.ToString(tagcallbackdata.rssi);
                    item.SubItems[4].Text = Convert.ToString(tagcallbackdata.tagdata.data);

                    item.SubItems[5].Text = DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss");
                    item.SubItems[6].Text = (Convert.ToInt32(item.SubItems[6].Text) + 1).ToString();
                }
            }
            lblTotalSingulation2.Text = singluationCount2.ToString();
            lblTotalUnique2.Text = DatalistView2.Items.Count.ToString();
            lblAllTagCnt2.Text = DatalistView2.Items.Count.ToString();
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="rdtag"></param>
        private void ShowTagData(AsReader.InventoryResult rdtag)
        {
            ProcessDelegate mainProcess = delegate ()
            {
                SetReaderTagDataList(rdtag);

                if (this.DatalistView.Items.Count > 0)
                {
                    //this.DatalistView.Items[selectedIndex].Selected = true;
                    this.DatalistView.Items[selectedIndex].EnsureVisible();
                }
            };
            this.Invoke(mainProcess);
        }
        private void ShowTagData2(AsReader.InventoryResult rdtag)
        {
            ProcessDelegate mainProcess = delegate ()
            {
                SetReaderTagDataList2(rdtag);

                if (this.DatalistView2.Items.Count > 0)
                {
                    this.DatalistView2.Items[selectedIndex2].EnsureVisible();
                }
            };
            this.Invoke(mainProcess);
        }
        private void WhenReadComplete(bool completeStatus)
        {
            ProcessDelegate mainProcess = delegate ()
            {
                UInt32 error = 0;
                this.StartInventory.Enabled = false;
                if (m_bInventory && completeStatus)
                {
                    error = device1.StopInventory();
                    if (error != 0)
                    {
                        this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Stop Inventory command sent failed." + Environment.NewLine);
                        this.Devmes.ScrollToCaret();
                        this.StartInventory.Enabled = true;
                        return;
                    }
                    m_bInventory = false;
                    readTimer.Enabled = false;
                    this.StartInventory.Text = "Start";

                    this.grpOtherSetting.Enabled = true;
                    this.grpAutoInventory.Enabled = true;

                    FileName += "_" + DateTime.Now.ToString("yyyyMMddHHmmssfff") + ".csv";
                    Thread.Sleep(200);
                    ExportCSV(FileName);
                }

                this.StartInventory.Enabled = true;
            };

            this.Invoke(mainProcess);

        }
        private void WhenReadComplete2(bool completeStatus)
        {
            ProcessDelegate mainProcess = delegate ()
            {
                UInt32 error = 0;
                this.StartInventory2.Enabled = false;
                if (m_bInventory2 && completeStatus)
                {
                    error = device2.StopInventory();
                    if (error != 0)
                    {
                        this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Stop Inventory command sent failed." + Environment.NewLine);
                        this.Devmes2.ScrollToCaret();
                        this.StartInventory2.Enabled = true;
                        return;
                    }
                    m_bInventory2 = false;
                    readTimer2.Enabled = false;
                    this.StartInventory2.Text = "Start";

                    this.grpOtherSetting2.Enabled = true;
                    this.grpAutoInventory2.Enabled = true;

                    FileName2 += "_" + DateTime.Now.ToString("yyyyMMddHHmmssfff") + "_D2.csv";
                    Thread.Sleep(200);
                    ExportCSV2(FileName2);
                }
                this.StartInventory2.Enabled = true;
            };
            this.Invoke(mainProcess);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        private UInt32 StartInventoryByTypes()
        {
            UInt32 error = 0;
            bool parseRet = false;
            byte outTagCount = 0;
            parseRet = byte.TryParse(txtTagCount.Text, out outTagCount);

            if (parseRet == false)
            {
                string msg = DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Parameter error: Tag Count.";
                this.Devmes.AppendText(msg + Environment.NewLine);
                this.Devmes.ScrollToCaret();
                return 999;
            }
            byte outElapsedTime = 0;
            parseRet = byte.TryParse(txtElapsedTime.Text, out outElapsedTime);

            if (parseRet == false)
            {
                string msg = DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Parameter error: Elapsed Time.";
                this.Devmes.AppendText(msg + Environment.NewLine);
                this.Devmes.ScrollToCaret();
                return 999;
            }

            ushort inventoryRound = 0;
            parseRet = ushort.TryParse(this.txtInventoryRound.Text, out inventoryRound);

            if (parseRet == false)
            {
                string msg = DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Parameter error: Inventory Round.";
                this.Devmes.AppendText(msg + Environment.NewLine);
                this.Devmes.ScrollToCaret();
                return 999;
            }
            error = device1.StartInventory(
                rbRssiOn.Checked ? true : false,
                outTagCount,
                outElapsedTime,
                inventoryRound,
                cbAnt1.Checked);
            return error;
        }
        private UInt32 StartInventoryByTypes2()
        {
            UInt32 error = 0;
            bool parseRet = false;
            byte outTagCount = 0;
            parseRet = byte.TryParse(txtTagCount2.Text, out outTagCount);

            if (parseRet == false)
            {
                string msg = DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Parameter error: Tag Count.";
                this.Devmes2.AppendText(msg + Environment.NewLine);
                this.Devmes2.ScrollToCaret();
                return 999;
            }
            byte outElapsedTime = 0;
            parseRet = byte.TryParse(txtElapsedTime2.Text, out outElapsedTime);

            if (parseRet == false)
            {
                string msg = DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Parameter error: Elapsed Time.";
                this.Devmes2.AppendText(msg + Environment.NewLine);
                this.Devmes2.ScrollToCaret();
                return 999;
            }

            ushort inventoryRound = 0;
            parseRet = ushort.TryParse(this.txtInventoryRound2.Text, out inventoryRound);

            if (parseRet == false)
            {
                string msg = DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Parameter error: Inventory Round.";
                this.Devmes2.AppendText(msg + Environment.NewLine);
                this.Devmes2.ScrollToCaret();
                return 999;
            }
            error = device2.StartInventory(
                rbRssiOn2.Checked ? true : false,
                outTagCount,
                outElapsedTime,
                inventoryRound,
                cbAnt1_2.Checked);
            return error;
        }

        private bool checkReadTime(string readTime)
        {
            if (readTime == "")
            {
                return false;
            }
            else if (Convert.ToUInt32(readTime) < 10 || Convert.ToUInt32(readTime) > 40000)
            {
                return false;
            }
            return true;
        }

        private void ShowErrorMsg(uint error)
        {
            ProcessDelegate mainProcess = delegate ()
            {
                ShowErrorMessage(error);
            };

            this.Invoke(mainProcess);

        }
        private void ShowErrorMsg2(uint error)
        {
            ProcessDelegate mainProcess = delegate ()
            {
                ShowErrorMessage2(error);
            };

            this.Invoke(mainProcess);
        }

        private void ShowErrorMessage(uint error)
        {
            if (Enum.IsDefined(typeof(Types.ErrorCode), Convert.ToInt32(error)))
            {
                string message = Enum.Parse(typeof(Types.ErrorCode), Convert.ToString(error)).ToString();
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " 0x" + Convert.ToString(error, 16) + ":" + message + Environment.NewLine);
            }
            else
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " 0x" + Convert.ToString(error, 16) + ":" + " Unkown error." + Environment.NewLine);
            }
            this.Devmes.ScrollToCaret();
        }
        private void ShowErrorMessage2(uint error)
        {
            if (Enum.IsDefined(typeof(Types.ErrorCode), Convert.ToInt32(error)))
            {
                string message = Enum.Parse(typeof(Types.ErrorCode), Convert.ToString(error)).ToString();
                this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " 0x" + Convert.ToString(error, 16) + ":" + message + Environment.NewLine);
            }
            else
            {
                this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " 0x" + Convert.ToString(error, 16) + ":" + " Unkown error." + Environment.NewLine);
            }
            this.Devmes2.ScrollToCaret();
        }

        private void ShowSuccessMsg(uint success)
        {
            ProcessDelegate mainProcess = delegate ()
            {
                ShowSuccessMessage(success);
            };

            this.Invoke(mainProcess);
        }
        private void ShowSuccessMsg2(uint success)
        {
            ProcessDelegate mainProcess = delegate ()
            {
                ShowSuccessMessage2(success);
            };

            this.Invoke(mainProcess);
        }

        private void ShowSuccessMessage(uint success)
        {
            if (Enum.IsDefined(typeof(Types.SuccessCode), Convert.ToInt32(success)))
            {
                string message = Enum.Parse(typeof(Types.SuccessCode), Convert.ToString(success)).ToString();
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " 0x" + Convert.ToString(success, 16) + ":" + message + Environment.NewLine);
            }
            else
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " 0x" + Convert.ToString(success, 16) + ":" + " Unkown success code." + Environment.NewLine);
            }
            this.Devmes.ScrollToCaret();
        }

        private void ShowSuccessMessage2(uint success)
        {
            if (Enum.IsDefined(typeof(Types.SuccessCode), Convert.ToInt32(success)))
            {
                string message = Enum.Parse(typeof(Types.SuccessCode), Convert.ToString(success)).ToString();
                this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " 0x" + Convert.ToString(success, 16) + ":" + message + Environment.NewLine);
            }
            else
            {
                this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " 0x" + Convert.ToString(success, 16) + ":" + " Unkown success code." + Environment.NewLine);
            }
            this.Devmes2.ScrollToCaret();
        }

        private void GetSdkVersion_load()
        {
            string sdkVersion = "";
            this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get SDK Version " + Environment.NewLine);
            device1.GetSdkVersion(ref sdkVersion);
            tx_sdkversion.Text = sdkVersion;
        }

        private void GetSdkVersion_load2()
        {
            string sdkVersion = "";
            this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get SDK Version " + Environment.NewLine);
            device2.GetSdkVersion(ref sdkVersion);
            tx_sdkversion2.Text = sdkVersion;
        }

        private void GetProductSN_load()
        {
            uint error = 0;
            string productSN = "";
            error = device1.GetProductSN(ref productSN);
            if (error == 0)
            {
                tx_productSN.Text = productSN;
            }
            else
            {
                tx_productSN.Text = "";
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get S/N command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
            }
        }
        private void GetProductSN_load2()
        {
            uint error = 0;
            string productSN = "";
            error = device2.GetProductSN(ref productSN);
            if (error == 0)
            {
                tx_productSN2.Text = productSN;
            }
            else
            {
                tx_productSN2.Text = "";
                this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get S/N command sent failed." + Environment.NewLine);
                this.Devmes2.ScrollToCaret();
            }
        }

        private void btnDefaultSetting_Click(object sender, EventArgs e)
        {
            bool successed = device1.DefaultSetting();
            if (!successed)
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + "Default Setting command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
            }
            else
            {
                btnGetRegion_Click(btnGetRegion, e);
                Thread.Sleep(100);
                btnGetMask_Click(btnGetMask, e);
                Thread.Sleep(100);
                btnGetMaskEnable_Click(btnGetMaskEnable, null);
                Thread.Sleep(100);
                HIDGetBtn_Click(HIDgetBtn, e);
                Thread.Sleep(100);
                buzzerGetBtn_Click(buzzerGetBtn, e);
                Thread.Sleep(100);
                btnGetRSSIThreshold_Click(btnGetRSSIThreshold, e);
                Thread.Sleep(100);
                btnGetHIDInventorymode_Click(btnGetHIDInventorymode, e);
            }
        }

        private void btnDefaultSetting_Click2(object sender, EventArgs e)
        {
            bool successed = device2.DefaultSetting();
            if (!successed)
            {
                this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + "Default Setting command sent failed." + Environment.NewLine);
                this.Devmes2.ScrollToCaret();
            }
            else
            {
                btnGetRegion_Click2(btnGetRegion2, e);
                Thread.Sleep(100);
                btnGetMask_Click2(btnGetMask2, e);
                Thread.Sleep(100);
                btnGetMaskEnable_Click2(btnGetMaskEnable2, null);
                Thread.Sleep(100);
                HIDGetBtn_Click2(HIDgetBtn2, e);
                Thread.Sleep(100);
                buzzerGetBtn_Click2(buzzerGetBtn2, e);
                Thread.Sleep(100);
                btnGetRSSIThreshold_Click2(btnGetRSSIThreshold2, e);
                Thread.Sleep(100);
                btnGetHIDInventorymode2_Click(btnGetHIDInventorymode2, e);
            }
        }
        private bool checkIdleTime(string idelTime)
        {
            if (idelTime == "")
            {
                return false;
            }
            else if (Convert.ToUInt32(idelTime) < 0 || Convert.ToUInt32(idelTime) > 40000)
            {
                return false;
            }
            return true;
        }


        private void btnSetIdleTime_Click(object sender, EventArgs e)
        {
            uint error = 0;
            uint idelTime = 0;
            if (checkIdleTime(txtIdelTime.Text) == false)
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Please input correct antenna idle time(0~40000)." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
                MessageBox.Show("Please input correct antenna idle time(0~40000).", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                return;
            }
            if (uint.TryParse(txtIdelTime.Text, out idelTime) == false)
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Please input correct antenna idle time(0~40000)." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
                MessageBox.Show("Please input correct antenna idle time(0~40000).", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                return;
            }
            error = device1.SetIdelTime(idelTime);

            if (error == 1)
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Set Idel Time command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
            }
        }

        private void btnSetIdleTime_Click2(object sender, EventArgs e)
        {
            uint error = 0;
            uint idelTime = 0;
            if (checkIdleTime(txtIdelTime2.Text) == false)
            {
                this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Please input correct antenna idle time(0~40000)." + Environment.NewLine);
                this.Devmes2.ScrollToCaret();
                MessageBox.Show("Please input correct antenna idle time(0~40000).", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                return;
            }
            if (uint.TryParse(txtIdelTime2.Text, out idelTime) == false)
            {
                this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Please input correct antenna idle time(0~40000)." + Environment.NewLine);
                this.Devmes2.ScrollToCaret();
                MessageBox.Show("Please input correct antenna idle time(0~40000).", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                return;
            }
            error = device2.SetIdelTime(idelTime);

            if (error == 1)
            {
                this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Set Idel Time command sent failed." + Environment.NewLine);
                this.Devmes2.ScrollToCaret();
            }
        }

        bool getIdleTimeErr = false;
        private void btnGetIdleTime_Click(object sender, EventArgs e)
        {
            uint idelTime = 0;
            uint error = 0;
            error = device1.GetIdelTime(ref idelTime);
            if (error == 0)
            {
                txtIdelTime.Text = idelTime.ToString();
                getIdleTimeErr = false;
            }
            else
            {
                txtIdelTime.Text = "";
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get Idel Time command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
                getIdleTimeErr = true;
            }

        }
        bool getIdleTimeErr2 = false;

        private void btnGetIdleTime_Click2(object sender, EventArgs e)
        {
            uint idelTime = 0;
            uint error = 0;
            error = device2.GetIdelTime(ref idelTime);
            if (error == 0)
            {
                txtIdelTime2.Text = idelTime.ToString();
                getIdleTimeErr2 = false;
            }
            else
            {
                txtIdelTime2.Text = "";
                this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get Idel Time command sent failed." + Environment.NewLine);
                this.Devmes2.ScrollToCaret();
                getIdleTimeErr2 = true;
            }

        }
        private void readTimer_Tick(object sender, EventArgs e)
        {
            int duration = (System.Environment.TickCount - total_time);
            lblTotalDuration.Text = duration.ToString();
            lblSingulationRate.Text = (((float)singluationCount * 1000) / (float)duration).ToString("F01");
        }
        private void readTimer_Tick2(object sender, EventArgs e)
        {
            int duration = (System.Environment.TickCount - total_time2);
            lblTotalDuration2.Text = duration.ToString();
            lblSingulationRate2.Text = (((float)singluationCount2 * 1000) / (float)duration).ToString("F01");
        }

        private void commonCheckBoxCheckedChanged(object sender)
        {
            if ((sender as CheckBox).Checked == true)
            {
                foreach (CheckBox isCheckbox in (sender as CheckBox).Parent.Controls)
                {
                    if (isCheckbox != sender)
                    {
                        isCheckbox.Checked = false;
                    }
                }
            }
        }
        private void enterCheckBox_CheckedChanged(object sender, EventArgs e)
        {
            commonCheckBoxCheckedChanged(sender);
        }

        private void tabControl1_SelectedIndexChanged(object sender, EventArgs e)
        {
            try
            {
                if (tcLeft.SelectedTab.Name == "SettingPage")
                {
                    SettingComboBoxStatus();
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine("StartAddress_KeyUp: " + ex.Message);
            }
        }
        private void tcLeft_SelectedIndexChanged2(object sender, EventArgs e)
        {
            try
            {
                if (tcLeft2.SelectedTab.Name == "SettingPage")
                {
                    SettingComboBoxStatus2();
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine("StartAddress_KeyUp: " + ex.Message);
            }
        }

        private void HIDStartAddress_KeyUp(object sender, KeyEventArgs e)
        {
            try
            {
                SettingComboBoxStatus();
            }
            catch (Exception ex)
            {
                Console.WriteLine("StartAddress_KeyUp: " + ex.Message);
            }
        }
        private void HIDStartAddress_KeyUp2(object sender, KeyEventArgs e)
        {
            try
            {
                SettingComboBoxStatus2();
            }
            catch (Exception ex)
            {
                Console.WriteLine("StartAddress_KeyUp: " + ex.Message);
            }
        }

        private void SettingComboBoxStatus()
        {
            if (epcCheckBox.Checked || tidCheckBox.Checked)
            {
                HIDfilterTime.SelectedIndex = 0;
                HIDfilterTime.Enabled = false;
            }
            else
            {
                if (HIDstartAddress.Text == "0" && HIDreadLength.Text == "0")
                {
                    HIDfilterTime.SelectedIndex = 0;
                    HIDfilterTime.Enabled = false;
                }
                else
                {
                    HIDfilterTime.Enabled = true;
                }
            }

            if (HIDstartAddress.Text == "0" && HIDreadLength.Text == "0" && epcRadioBtn.Checked)
            {
                HIDinventoryInterval.Enabled = true;
            }
            else
            {
                HIDinventoryInterval.SelectedIndex = 0;
                HIDinventoryInterval.Enabled = false;
            }

            if (HIDstartAddress.Text == "0" && HIDreadLength.Text == "0")
            {
                epcCheckBox.Checked = false;
                epcCheckBox.Enabled = false;
                tidCheckBox.Checked = false;
                tidCheckBox.Enabled = false;
            }
            else
            {
                epcCheckBox.Enabled = true;
                tidCheckBox.Enabled = true;
            }

        }

        private void SettingComboBoxStatus2()
        {
            if (epcCheckBox2.Checked || tidCheckBox2.Checked)
            {
                HIDfilterTime2.SelectedIndex = 0;
                HIDfilterTime2.Enabled = false;
            }
            else
            {
                if (HIDstartAddress2.Text == "0" && HIDreadLength2.Text == "0")
                {
                    HIDfilterTime2.SelectedIndex = 0;
                    HIDfilterTime2.Enabled = false;
                }
                else
                {
                    HIDfilterTime2.Enabled = true;
                }
            }

            if (HIDstartAddress2.Text == "0" && HIDreadLength2.Text == "0" && epcRadioBtn2.Checked)
            {
                HIDinventoryInterval2.Enabled = true;
            }
            else
            {
                HIDinventoryInterval2.SelectedIndex = 0;
                HIDinventoryInterval2.Enabled = false;
            }

            if (HIDstartAddress2.Text == "0" && HIDreadLength2.Text == "0")
            {
                epcCheckBox2.Checked = false;
                epcCheckBox2.Enabled = false;
                tidCheckBox2.Checked = false;
                tidCheckBox2.Enabled = false;
            }
            else
            {
                epcCheckBox2.Enabled = true;
                tidCheckBox2.Enabled = true;
            }
        }

        private void AsReaderP3xU_Demo_FormClosing(object sender, FormClosingEventArgs e)
        {
            UInt32 error = 0;
            this.StartInventory.Enabled = false;
            this.StartInventory2.Enabled = false;
            if (m_bInventory)
            {
                error = device1.StopInventory();
                FileName += "_" + DateTime.Now.ToString("yyyyMMddHHmmssfff") + ".csv";
                ExportCSV(FileName);
            }
            if (isConnected)
            {
                device1.DisConnect();
            }
            if (m_bInventory2)
            {
                error = device2.StopInventory();
                FileName2 += DateTime.Now.ToString("yyyyMMddHHmmssfff") + "_D2.csv";
                ExportCSV2(FileName2);
            }
            if (isConnected2)
            {
                device2.DisConnect();
            }

        }

        private void HIDsetBtn_Click(object sender, EventArgs e)
        {
            try
            {
                int hid_adr = 0;
                int hid_len = 0;
                int hid_filter_time = 0;
                byte repeat_epc_tid = 0;
                int hid_inventory = 0;
                byte epc_tid_user = 0;
                byte output_suffix = 0;
                byte output_without = 0;
                uint error = 0;

                if ((HIDstartAddress.Text.Trim() == "") || (HIDreadLength.Text.Trim() == "") || Convert.ToInt32(HIDstartAddress.Text.Trim()) > 65535 || Convert.ToInt32(HIDstartAddress.Text.Trim()) < 0)
                {
                    MessageBox.Show("Set failed: Start Address Parameter Error");
                    return;
                }
                if ((HIDreadLength.Text.Trim() == "") || (HIDreadLength.Text.Trim() == "") || Convert.ToInt32(HIDreadLength.Text.Trim()) > 128 || Convert.ToInt32(HIDreadLength.Text.Trim()) < 0)
                {
                    MessageBox.Show("Set failed: Read Length Parameter Error");
                    return;
                }

                hid_adr = Convert.ToInt32(HIDstartAddress.Text.Trim());
                hid_len = Convert.ToInt32(HIDreadLength.Text.Trim());

                if (HIDinventoryInterval.Items.Count > 0)
                {
                    hid_inventory = HIDinventoryInterval.SelectedIndex;
                }

                if (HIDfilterTime.Items.Count > 0)
                {
                    hid_filter_time = HIDfilterTime.SelectedIndex;
                }

                if (repeatEpcRadioBtn.Checked)
                {
                    repeat_epc_tid = (byte)Types.HidRepeatEpcTid.IS_CHECKED_EPC;
                }
                else
                {
                    repeat_epc_tid = (byte)Types.HidRepeatEpcTid.IS_CHECKED_TID;
                }

                if (epcRadioBtn.Checked)
                {
                    epc_tid_user = (byte)Types.HidEpcTidUser.EPC;
                }
                else if (tidRadioBtn.Checked)
                {
                    epc_tid_user = (byte)Types.HidEpcTidUser.TID;
                }
                else
                {
                    epc_tid_user = (byte)Types.HidEpcTidUser.USER;
                }

                if (enterCheckBox.Checked)
                {
                    output_suffix = (byte)Types.HidOutputSuffix.ENTER;
                }
                else if (tabCheckBox.Checked)
                {
                    output_suffix = (byte)Types.HidOutputSuffix.TAB;
                }
                else if (backspaceCheckBox.Checked)
                {
                    output_suffix = (byte)Types.HidOutputSuffix.BACKSPACE;
                }
                else if (commaCheckBox.Checked)
                {
                    output_suffix = (byte)Types.HidOutputSuffix.COMMA;
                }
                else
                {
                    output_suffix = (byte)Types.HidOutputSuffix.NO_CHECKED;
                }
                if (epcCheckBox.Checked)
                {
                    output_without = (byte)Types.HidOutputWithout.IS_CHECKED;
                }
                else if (tidCheckBox.Checked)
                {
                    output_without = (byte)Types.HidOutputWithout.IS_TID_CHECKED;
                }
                else
                {
                    output_without = (byte)Types.HidOutputWithout.NO_CHECKED;
                }

                error = device1.SetHIDWorkParams(hid_adr, hid_len, hid_inventory, hid_filter_time, repeat_epc_tid, epc_tid_user, output_suffix, output_without);

                if (error == 1)
                {
                    this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Set HID work parameter sent failed." + Environment.NewLine);
                    this.Devmes.ScrollToCaret();
                }

            }
            catch (Exception ex)
            {
                MessageBox.Show("Set failed: " + ex.Message);
            }
        }
        private void HIDsetBtn_Click2(object sender, EventArgs e)
        {
            try
            {
                int hid_adr = 0;
                int hid_len = 0;
                int hid_filter_time = 0;
                byte repeat_epc_tid = 0;
                int hid_inventory = 0;
                byte epc_tid_user = 0;
                byte output_suffix = 0;
                byte output_without = 0;
                uint error = 0;

                if ((HIDstartAddress2.Text.Trim() == "") || (HIDreadLength2.Text.Trim() == "") || Convert.ToInt32(HIDstartAddress2.Text.Trim()) > 65535 || Convert.ToInt32(HIDstartAddress2.Text.Trim()) < 0)
                {
                    MessageBox.Show("Set failed: Start Address Parameter Error");
                    return;
                }
                if ((HIDreadLength2.Text.Trim() == "") || (HIDreadLength2.Text.Trim() == "") || Convert.ToInt32(HIDreadLength2.Text.Trim()) > 128 || Convert.ToInt32(HIDreadLength2.Text.Trim()) < 0)
                {
                    MessageBox.Show("Set failed: Read Length Parameter Error");
                    return;
                }

                hid_adr = Convert.ToInt32(HIDstartAddress2.Text.Trim());
                hid_len = Convert.ToInt32(HIDreadLength2.Text.Trim());

                if (HIDinventoryInterval2.Items.Count > 0)
                {
                    hid_inventory = HIDinventoryInterval2.SelectedIndex;
                }

                if (HIDfilterTime2.Items.Count > 0)
                {
                    hid_filter_time = HIDfilterTime2.SelectedIndex;
                }

                if (repeatEpcRadioBtn2.Checked)
                {
                    repeat_epc_tid = (byte)Types.HidRepeatEpcTid.IS_CHECKED_EPC;
                }
                else
                {
                    repeat_epc_tid = (byte)Types.HidRepeatEpcTid.IS_CHECKED_TID;
                }

                if (epcRadioBtn2.Checked)
                {
                    epc_tid_user = (byte)Types.HidEpcTidUser.EPC;
                }
                else if (tidRadioBtn2.Checked)
                {
                    epc_tid_user = (byte)Types.HidEpcTidUser.TID;
                }
                else
                {
                    epc_tid_user = (byte)Types.HidEpcTidUser.USER;
                }

                if (enterCheckBox2.Checked)
                {
                    output_suffix = (byte)Types.HidOutputSuffix.ENTER;
                }
                else if (tabCheckBox2.Checked)
                {
                    output_suffix = (byte)Types.HidOutputSuffix.TAB;
                }
                else if (backspaceCheckBox2.Checked)
                {
                    output_suffix = (byte)Types.HidOutputSuffix.BACKSPACE;
                }
                else if (commaCheckBox2.Checked)
                {
                    output_suffix = (byte)Types.HidOutputSuffix.COMMA;
                }
                else
                {
                    output_suffix = (byte)Types.HidOutputSuffix.NO_CHECKED;
                }
                if (epcCheckBox2.Checked)
                {
                    output_without = (byte)Types.HidOutputWithout.IS_CHECKED;
                }
                else if (tidCheckBox2.Checked)
                {
                    output_without = (byte)Types.HidOutputWithout.IS_TID_CHECKED;
                }
                else
                {
                    output_without = (byte)Types.HidOutputWithout.NO_CHECKED;
                }

                error = device2.SetHIDWorkParams(hid_adr, hid_len, hid_inventory, hid_filter_time, repeat_epc_tid, epc_tid_user, output_suffix, output_without);

                if (error == 1)
                {
                    this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Set HID work parameter sent failed." + Environment.NewLine);
                    this.Devmes2.ScrollToCaret();
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show("Set failed: " + ex.Message);
            }
        }

        private void HIDGetBtn_Click(object sender, EventArgs e)
        {
            try
            {
                int hid_adr = 0;
                int hid_len = 0;
                int hid_filter_time = 0;
                int hid_inventory = 0;
                Types.HidRepeatEpcTid repeat_epc_tid = 0;
                Types.HidEpcTidUser epc_tid_user = 0;
                Types.HidOutputSuffix output_suffix = 0;
                Types.HidOutputWithout output_without = 0;
                uint error = 0;

                error = device1.GetHIDWorkParams(ref hid_adr, ref hid_len, ref hid_inventory, ref repeat_epc_tid, ref hid_filter_time, ref epc_tid_user, ref output_suffix, ref output_without);
                if (error == 0)
                {
                    if (epc_tid_user == Types.HidEpcTidUser.EPC)
                    {
                        epcRadioBtn.Checked = true;
                    }
                    else if (epc_tid_user == Types.HidEpcTidUser.TID)
                    {
                        tidRadioBtn.Checked = true;
                    }
                    else
                    {
                        userRadioBtn.Checked = true;
                    }

                    HIDstartAddress.Text = hid_adr.ToString();
                    HIDreadLength.Text = hid_len.ToString();
                    SettingComboBoxStatus();

                    if (repeat_epc_tid == Types.HidRepeatEpcTid.IS_CHECKED_EPC)
                    {
                        repeatEpcRadioBtn.Checked = true;
                    }
                    else
                    {
                        repeatTidRadioBtn.Checked = true;
                    }

                    if (output_suffix == Types.HidOutputSuffix.ENTER)
                    {
                        enterCheckBox.Checked = true;
                    }
                    else if (output_suffix == Types.HidOutputSuffix.TAB)
                    {
                        tabCheckBox.Checked = true;
                    }
                    else if (output_suffix == Types.HidOutputSuffix.BACKSPACE)
                    {
                        backspaceCheckBox.Checked = true;
                    }
                    else if (output_suffix == Types.HidOutputSuffix.COMMA)
                    {
                        commaCheckBox.Checked = true;
                    }
                    else
                    {
                        enterCheckBox.Checked = false;
                        tabCheckBox.Checked = false;
                        backspaceCheckBox.Checked = false;
                        commaCheckBox.Checked = false;
                    }

                    if (output_without == Types.HidOutputWithout.IS_CHECKED)
                    {
                        epcCheckBox.Checked = true;
                    }
                    else if (output_without == Types.HidOutputWithout.IS_TID_CHECKED)
                    {
                        tidCheckBox.Checked = true;
                    }
                    else
                    {
                        epcCheckBox.Checked = false;
                        epcCheckBox.Checked = false;
                    }

                    if (HIDinventoryInterval.Items.Count > hid_inventory)
                    {
                        HIDinventoryInterval.SelectedIndex = hid_inventory;
                    }

                    if (HIDfilterTime.Items.Count > hid_filter_time)
                    {
                        HIDfilterTime.SelectedIndex = hid_filter_time;
                    }

                }
                else
                {
                    this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get HID work parameter sent failed." + Environment.NewLine);
                    this.Devmes.ScrollToCaret();
                }

            }
            catch (Exception ex)
            {
                MessageBox.Show("Get failed: " + ex.Message);
            }
        }

        private void HIDGetBtn_Click2(object sender, EventArgs e)
        {
            try
            {
                int hid_adr = 0;
                int hid_len = 0;
                int hid_filter_time = 0;
                int hid_inventory = 0;
                Types.HidRepeatEpcTid repeat_epc_tid = 0;
                Types.HidEpcTidUser epc_tid_user = 0;
                Types.HidOutputSuffix output_suffix = 0;
                Types.HidOutputWithout output_without = 0;
                uint error = 0;

                error = device2.GetHIDWorkParams(ref hid_adr, ref hid_len, ref hid_inventory, ref repeat_epc_tid, ref hid_filter_time, ref epc_tid_user, ref output_suffix, ref output_without);
                if (error == 0)
                {
                    if (epc_tid_user == Types.HidEpcTidUser.EPC)
                    {
                        epcRadioBtn2.Checked = true;
                    }
                    else if (epc_tid_user == Types.HidEpcTidUser.TID)
                    {
                        tidRadioBtn2.Checked = true;
                    }
                    else
                    {
                        userRadioBtn2.Checked = true;
                    }

                    HIDstartAddress2.Text = hid_adr.ToString();
                    HIDreadLength2.Text = hid_len.ToString();
                    SettingComboBoxStatus2();

                    if (repeat_epc_tid == Types.HidRepeatEpcTid.IS_CHECKED_EPC)
                    {
                        repeatEpcRadioBtn2.Checked = true;
                    }
                    else
                    {
                        repeatTidRadioBtn2.Checked = true;
                    }

                    if (output_suffix == Types.HidOutputSuffix.ENTER)
                    {
                        enterCheckBox2.Checked = true;
                    }
                    else if (output_suffix == Types.HidOutputSuffix.TAB)
                    {
                        tabCheckBox2.Checked = true;
                    }
                    else if (output_suffix == Types.HidOutputSuffix.BACKSPACE)
                    {
                        backspaceCheckBox2.Checked = true;
                    }
                    else if (output_suffix == Types.HidOutputSuffix.COMMA)
                    {
                        commaCheckBox2.Checked = true;
                    }
                    else
                    {
                        enterCheckBox2.Checked = false;
                        tabCheckBox2.Checked = false;
                        backspaceCheckBox2.Checked = false;
                        commaCheckBox2.Checked = false;
                    }

                    if (output_without == Types.HidOutputWithout.IS_CHECKED)
                    {
                        epcCheckBox2.Checked = true;
                    }
                    else if (output_without == Types.HidOutputWithout.IS_TID_CHECKED)
                    {
                        tidCheckBox2.Checked = true;
                    }
                    else
                    {
                        epcCheckBox2.Checked = false;
                        epcCheckBox2.Checked = false;
                    }

                    if (HIDinventoryInterval2.Items.Count > hid_inventory)
                    {
                        HIDinventoryInterval2.SelectedIndex = hid_inventory;
                    }

                    if (HIDfilterTime2.Items.Count > hid_filter_time)
                    {
                        HIDfilterTime2.SelectedIndex = hid_filter_time;
                    }

                }
                else
                {
                    this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get HID work parameter sent failed." + Environment.NewLine);
                    this.Devmes2.ScrollToCaret();
                }

            }
            catch (Exception ex)
            {
                MessageBox.Show("Get failed: " + ex.Message);
            }
        }

        private void buzzerSetBtn_Click(object sender, EventArgs e)
        {
            try
            {
                uint error = 0;
                error = device1.SetBuzzer((Types.Buzzer)cmbBuzzer.SelectedValue);

                if (error == 1)
                {
                    this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Set HID Buzzer sent failed." + Environment.NewLine);
                    this.Devmes.ScrollToCaret();
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show("Set failed: " + ex.Message);
            }
        }
        private void buzzerSetBtn_Click2(object sender, EventArgs e)
        {
            try
            {
                uint error = 0;
                error = device2.SetBuzzer((Types.Buzzer)cmbBuzzer2.SelectedValue);

                if (error == 1)
                {
                    this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Set HID Buzzer sent failed." + Environment.NewLine);
                    this.Devmes2.ScrollToCaret();
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show("Set failed: " + ex.Message);
            }
        }

        private void buzzerGetBtn_Click(object sender, EventArgs e)
        {
            try
            {
                Types.Buzzer buzzer = 0;
                uint error = 0;

                error = device1.GetBuzzer(ref buzzer);
                if (error == 0)
                {
                    cmbBuzzer.SelectedValue = Convert.ToInt32(buzzer);
                }
                else
                {
                    this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get HID Buzzer sent failed." + Environment.NewLine);
                    this.Devmes.ScrollToCaret();
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show("Get failed: " + ex.Message);
            }
        }
        private void buzzerGetBtn_Click2(object sender, EventArgs e)
        {
            try
            {
                Types.Buzzer buzzer = 0;
                uint error = 0;

                error = device2.GetBuzzer(ref buzzer);
                if (error == 0)
                {
                    cmbBuzzer2.SelectedValue = Convert.ToInt32(buzzer);
                }
                else
                {
                    this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get HID Buzzer sent failed." + Environment.NewLine);
                    this.Devmes2.ScrollToCaret();
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show("Get failed: " + ex.Message);
            }
        }

        private void GetFWVersionBtn_Click(object sender, EventArgs e)
        {
            uint error = 0;
            string fwVersion = "";
            error = device1.GetFwVersion(ref fwVersion);
            if (error == 0)
            {
                txtFirmwareVer.Text = fwVersion;
            }
            else
            {
                txtFirmwareVer.Text = "";
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get Fw Version command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
            }
        }
        private void GetFWVersionBtn_Click2(object sender, EventArgs e)
        {
            uint error = 0;
            string fwVersion = "";
            error = device2.GetFwVersion(ref fwVersion);
            if (error == 0)
            {
                txtFirmwareVer2.Text = fwVersion;
            }
            else
            {
                txtFirmwareVer2.Text = "";
                this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get Fw Version command sent failed." + Environment.NewLine);
                this.Devmes2.ScrollToCaret();
            }
        }

        [Obsolete]
        private void btnGetBins_Click(object sender, EventArgs e)
        {
            try
            {
                string hwVer = device1.hwVer;
                if (hwVer == null || hwVer == "")
                {
                    hwVer = "HW1.0.1";
                }
                if (((Button)sender).Text == "Cancel")
                {
                    ((Button)sender).Text = "Get Files";
                    return;
                }
                else
                {
                    if (hwVer == null)
                    {
                        MessageBox.Show("Please get HW Version.", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                        return;
                    }

                    ((Button)sender).Text = "Cancel";
                }
                string fwXmlURL = device1.fwURL + device1.fwXmlName;
                XmlDataDocument xmlDoc = new XmlDataDocument();
                DataSet myDataSet = xmlDoc.DataSet;
                myDataSet.ReadXml(fwXmlURL);
                int strIndex = hwVer.LastIndexOf(".") + 1;
                string value = hwVer.Substring(strIndex);
                if (value == "0")
                {
                    value = "1";
                }
                string vx = "V" + value;
                for (int i = 0; i < myDataSet.Tables[0].Rows.Count; i++)
                {
                    string FwFileNameStr = myDataSet.Tables[0].Rows[i]["FwFileName"].ToString();
                    string status = myDataSet.Tables[0].Rows[i]["status"].ToString().ToLower();
                    int strIndex1 = FwFileNameStr.LastIndexOf("_") + 1;
                    string Version = FwFileNameStr.Substring(strIndex1);
                    if (!Version.Contains(vx) || (!isDebug && status == "debug"))
                    {
                        myDataSet.Tables[0].Rows[i].Delete();
                        i--;
                    }
                }

                cmbBinFiles.DataSource = myDataSet.Tables[0];
                cmbBinFiles.DisplayMember = "FwFileName";
                ((Button)sender).Text = "Get Files";
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
                MessageBox.Show("Get bin files failed.", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get bin files failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
            }
        }
        private void btnGetBins_Click2(object sender, EventArgs e)
        {
            try
            {
                string hwVer = device2.hwVer;
                if (hwVer == null || hwVer == "")
                {
                    hwVer = "HW1.0.1";
                }
                if (((Button)sender).Text == "Cancel")
                {
                    ((Button)sender).Text = "Get Files";
                    return;
                }
                else
                {
                    if (hwVer == null)
                    {
                        MessageBox.Show("Please get HW Version.", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                        return;
                    }

                    ((Button)sender).Text = "Cancel";
                }
                string fwXmlURL = device2.fwURL + device2.fwXmlName;
                XmlDataDocument xmlDoc = new XmlDataDocument();
                DataSet myDataSet = xmlDoc.DataSet;
                myDataSet.ReadXml(fwXmlURL);
                int strIndex = hwVer.LastIndexOf(".") + 1;
                string value = hwVer.Substring(strIndex);
                if (value == "0")
                {
                    value = "1";
                }
                string vx = "V" + value;
                for (int i = 0; i < myDataSet.Tables[0].Rows.Count; i++)
                {
                    string FwFileNameStr = myDataSet.Tables[0].Rows[i]["FwFileName"].ToString();
                    string status = myDataSet.Tables[0].Rows[i]["status"].ToString().ToLower();
                    int strIndex1 = FwFileNameStr.LastIndexOf("_") + 1;
                    string Version = FwFileNameStr.Substring(strIndex1);
                    if (!Version.Contains(vx) || (!isDebug && status == "debug"))
                    {
                        myDataSet.Tables[0].Rows[i].Delete();
                        i--;
                    }
                }

                cmbBinFiles2.DataSource = myDataSet.Tables[0];
                cmbBinFiles2.DisplayMember = "FwFileName";
                ((Button)sender).Text = "Get Files";
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
                MessageBox.Show("Get bin files failed.", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get bin files failed." + Environment.NewLine);
                this.Devmes2.ScrollToCaret();
            }
        }

        private void btnFirmwareUpdate_Click(object sender, EventArgs e)
        {
            try
            {
                if (MessageBox.Show("Do you want to update now?", "Update Firmware", MessageBoxButtons.YesNo, MessageBoxIcon.Information) == DialogResult.No)
                {
                    return;
                }
                if (((Button)sender).Text == "Updating")
                {
                    MessageBox.Show("Firmware is updating...", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    return;
                }
                if (cmbBinFiles.DropDownStyle == ComboBoxStyle.DropDownList && cmbBinFiles.Items.Count == 0)
                {
                    MessageBox.Show("Please get bin files!", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    return;
                }
                if (cmbBinFiles.DropDownStyle == ComboBoxStyle.DropDownList && cmbBinFiles.SelectedIndex < 0)
                {
                    MessageBox.Show("Please select a file!", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    return;
                }
                if (btnFirmwareUpdate.Text == "Update")
                {
                    btnFirmwareUpdate.Text = "Updating";
                }

                string filename = cmbBinFiles.Text.ToString().Trim();

                this.updateWord.Visible = true;
                progressBar2.Visible = true;
                progressBar2.Value = 0;
                progressBar2.Style = ProgressBarStyle.Blocks;
                progressBar2.Maximum = 3;
                progressBar2.Minimum = 0;
                progressBar2.MarqueeAnimationSpeed = 100;
                progressBar2.Step = 1;

                UpdateControlsEnabled(false);

                bool status = device1.DownloadFirmwareFile("FW", filename);
                progressBar2.PerformStep();
                progressBar2.Visible = false;
                Thread.Sleep(500);
                string filePath = device1.firmwareFolderNmae + @"\" + filename;
                //return;
                if (status && File.Exists(filePath))
                {

                    FileStream myStream = new FileStream(filePath, FileMode.Open, FileAccess.Read);
                    int bytes = (int)myStream.Length;
                    myStream.Close();
                    int countPicket = (int)Math.Ceiling((decimal)(bytes / 2) / 50);

                    progressBar1.Visible = true;
                    progressBar1.Value = 0;
                    progressBar1.Style = ProgressBarStyle.Blocks;
                    progressBar1.Maximum = countPicket + 2;
                    progressBar1.Minimum = 0;
                    progressBar1.MarqueeAnimationSpeed = 100;
                    progressBar1.Step = 1;

                    bool updateStatus = device1.FirmwareUpdate(filePath);
                    if (updateStatus)
                    {
                        if (MessageBox.Show("Update Firmware Success! Do you want to reboot now?", "Update Firmware Information", MessageBoxButtons.YesNo, MessageBoxIcon.Information) == DialogResult.Yes)
                        {
                            RebootDevice();
                        }
                    }
                    else
                    {
                        MessageBox.Show("Update Firmware failed!", "Update Firmware", MessageBoxButtons.OK);
                    }
                }
                else
                {
                    string msgTitle = "Warning";
                    string msg = "Demo App: Download firmware file failed. No available firmware for update. ";
                    MessageBox.Show(msg, msgTitle, MessageBoxButtons.OK);
                }
                btnFirmwareUpdate.Text = "Update";

                progressBar1.PerformStep();
                progressBar1.Visible = false;
                this.updateWord.Visible = false;
                UpdateControlsEnabled(true);
                ControlsEnabled();
            }
            catch (Exception ex)
            {
                UpdateControlsEnabled(true);
                progressBar1.Visible = false;
                progressBar2.Visible = false;
                this.updateWord.Visible = false;
                Console.WriteLine(ex.Message);
                MessageBox.Show(ex.Message, "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
            }
        }
        private void btnFirmwareUpdate_Click2(object sender, EventArgs e)
        {
            try
            {
                if (MessageBox.Show("Do you want to update now?", "Update Firmware", MessageBoxButtons.YesNo, MessageBoxIcon.Information) == DialogResult.No)
                {
                    return;
                }
                if (((Button)sender).Text == "Updating")
                {
                    MessageBox.Show("Firmware is updating...", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    return;
                }
                if (cmbBinFiles2.DropDownStyle == ComboBoxStyle.DropDownList && cmbBinFiles2.Items.Count == 0)
                {
                    MessageBox.Show("Please get bin files!", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    return;
                }
                if (cmbBinFiles2.DropDownStyle == ComboBoxStyle.DropDownList && cmbBinFiles2.SelectedIndex < 0)
                {
                    MessageBox.Show("Please select a file!", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    return;
                }
                if (btnFirmwareUpdate2.Text == "Update")
                {
                    btnFirmwareUpdate2.Text = "Updating";
                }

                string filename = cmbBinFiles2.Text.ToString().Trim();

                this.updateWord2.Visible = true;
                progressBar2_2.Visible = true;
                progressBar2_2.Value = 0;
                progressBar2_2.Style = ProgressBarStyle.Blocks;
                progressBar2_2.Maximum = 3;
                progressBar2_2.Minimum = 0;
                progressBar2_2.MarqueeAnimationSpeed = 100;
                progressBar2_2.Step = 1;

                UpdateControlsEnabled2(false);

                bool status = device2.DownloadFirmwareFile("FW", filename);
                progressBar2_2.PerformStep();
                progressBar2_2.Visible = false;
                Thread.Sleep(500);
                string filePath = device2.firmwareFolderNmae + @"\" + filename;
                //return;
                if (status && File.Exists(filePath))
                {

                    FileStream myStream = new FileStream(filePath, FileMode.Open, FileAccess.Read);
                    int bytes = (int)myStream.Length;
                    myStream.Close();
                    int countPicket = (int)Math.Ceiling((decimal)(bytes / 2) / 50);

                    progressBar1_2.Visible = true;
                    progressBar1_2.Value = 0;
                    progressBar1_2.Style = ProgressBarStyle.Blocks;
                    progressBar1_2.Maximum = countPicket + 2;
                    progressBar1_2.Minimum = 0;
                    progressBar1_2.MarqueeAnimationSpeed = 100;
                    progressBar1_2.Step = 1;

                    bool updateStatus = device2.FirmwareUpdate(filePath);
                    if (updateStatus)
                    {
                        if (MessageBox.Show("Update Firmware Success! Do you want to reboot now?", "Update Firmware Information", MessageBoxButtons.YesNo, MessageBoxIcon.Information) == DialogResult.Yes)
                        {
                            RebootDevice2();
                        }
                    }
                    else
                    {
                        MessageBox.Show("Update Firmware failed!", "Update Firmware", MessageBoxButtons.OK);
                    }
                }
                else
                {
                    string msgTitle = "Warning";
                    string msg = "Demo App: Download firmware file failed. No available firmware for update. ";
                    MessageBox.Show(msg, msgTitle, MessageBoxButtons.OK);
                }
                btnFirmwareUpdate2.Text = "Update";

                progressBar1_2.PerformStep();
                progressBar1_2.Visible = false;
                this.updateWord2.Visible = false;
                UpdateControlsEnabled2(true);
                ControlsEnabled2();
            }
            catch (Exception ex)
            {
                UpdateControlsEnabled2(true);
                progressBar1_2.Visible = false;
                progressBar2_2.Visible = false;
                this.updateWord2.Visible = false;
                Console.WriteLine(ex.Message);
                MessageBox.Show(ex.Message, "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
            }
        }

        private void UpdateControlsEnabled(bool status)
        {
            this.grpConnect.Enabled = status;
            this.grpFirmwareUpdate.Enabled = status;
            this.tcLeft.Enabled = status;
            this.tcRight.Enabled = status;
        }

        private void UpdateControlsEnabled2(bool status)
        {
            this.grpConnect2.Enabled = status;
            this.grpFirmwareUpdate2.Enabled = status;
            this.tcLeft2.Enabled = status;
            this.tcRight2.Enabled = status;
        }

        private void RebootDevice()
        {
            try
            {

                bool status = device1.RebootDevice();
                if (status)
                {
                    Thread.Sleep(1000);
                    btnVcpDisconnect_Click(btnDisconnect, null);
                    MessageBox.Show("Device must be reconnected for normal use!", "Warning");
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show("Reboot Device: " + ex.Message);
            }
        }
        private void RebootDevice2()
        {
            try
            {

                bool status = device2.RebootDevice();
                if (status)
                {
                    Thread.Sleep(1000);
                    btnVcpDisconnect_Click2(btnDisconnect2, null);
                    MessageBox.Show("Device must be reconnected for normal use!", "Warning");
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show("Reboot Device: " + ex.Message);
            }
        }

        private void WhenReceivedRebootDevice(byte[] packetRx, string strPacket)
        {
            try
            {
                if (strPacket.Trim() != "BB 01 5B 00 01 00 7E 1A 14")
                {
                    this.Invoke((EventHandler)delegate
                    {
                        this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + "Reboot device failed." + Environment.NewLine);
                        this.Devmes.ScrollToCaret();
                    });
                }
                else
                {
                    this.Invoke((EventHandler)delegate
                    {
                        this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + "Reboot device succeeded." + Environment.NewLine);
                        this.Devmes.ScrollToCaret();
                    });
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show("Receive Reboot Device Message failed: " + ex.Message);
            }
        }
        private void WhenReceivedRebootDevice2(byte[] packetRx, string strPacket)
        {
            try
            {
                if (strPacket.Trim() != "BB 01 5B 00 01 00 7E 1A 14")
                {
                    this.Invoke((EventHandler)delegate
                    {
                        this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + "Reboot device failed." + Environment.NewLine);
                        this.Devmes2.ScrollToCaret();
                    });
                }
                else
                {
                    this.Invoke((EventHandler)delegate
                    {
                        this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + "Reboot device succeeded." + Environment.NewLine);
                        this.Devmes2.ScrollToCaret();
                    });
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show("Receive Reboot Device Message failed: " + ex.Message);
            }
        }

        private void WhenShowReceiveMsg(string strLog)
        {
            try
            {
                this.Invoke((EventHandler)delegate
                {
                    this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " " + strLog + Environment.NewLine);
                    this.Devmes.ScrollToCaret();
                });
            }
            catch (Exception ex)
            {
                MessageBox.Show("Receive Msg failed: " + ex.Message);
            }
        }
        private void WhenShowReceiveMsg2(string strLog)
        {
            try
            {
                this.Invoke((EventHandler)delegate
                {
                    this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " " + strLog + Environment.NewLine);
                    this.Devmes2.ScrollToCaret();
                });
            }
            catch (Exception ex)
            {
                MessageBox.Show("Receive Msg failed: " + ex.Message);
            }
        }

        private void SearchPortBtn_Click(object sender, EventArgs e)
        {
            string[] vcpPort = GetPortList();
            int i = 0;
            ComPort.Items.Clear();
            //有限判断是否开通端口模式
            if (vcpPort.Length > 0)
            {
                for (i = 0; i < vcpPort.Length; i++)
                {
                    this.ComPort.Items.Add(vcpPort[i]);
                }
                if (i > 0)
                    this.ComPort.SelectedIndex = 0;
            }
        }

        private void SearchPortBtn_Click2(object sender, EventArgs e)
        {
            string[] vcpPort = GetPortList();
            int i = 0;
            ComPort2.Items.Clear();
            //有限判断是否开通端口模式
            if (vcpPort.Length > 0)
            {
                for (i = 0; i < vcpPort.Length; i++)
                {
                    this.ComPort2.Items.Add(vcpPort[i]);
                }
                if (i > 0)
                    this.ComPort2.SelectedIndex = 0;
            }
        }

        private void btnSetTarget_Click(object sender, EventArgs e)
        {
            Types.TargetABType target = (Types.TargetABType)cmbBasicTarget.SelectedValue;
            UInt32 error = 0;
            //session范围：0~3
            error = device1.SetBasicTarget(target);

            if (error == 1)
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Set Session command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
            }
        }

        private void btnSetTarget_Click2(object sender, EventArgs e)
        {
            Types.TargetABType target = (Types.TargetABType)cmbBasicTarget2.SelectedValue;
            UInt32 error = 0;
            //session范围：0~3
            error = device2.SetBasicTarget(target);

            if (error == 1)
            {
                this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Set Session command sent failed." + Environment.NewLine);
                this.Devmes2.ScrollToCaret();
            }
        }

        bool getTargetErr = false;
        private void btnGetTarget_Click(object sender, EventArgs e)
        {
            Types.TargetABType target = 0;
            UInt32 error = 0;
            error = device1.GetBasicTarget(ref target);
            if (error == 0)
            {
                getTargetErr = false;
                cmbBasicTarget.SelectedValue = Convert.ToInt32(target);
            }

            if (error == 1)
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get Target command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
                getTargetErr = true;
            }
        }
        bool getTargetErr2 = false;
        private void btnGetTarget_Click2(object sender, EventArgs e)
        {
            Types.TargetABType target = 0;
            UInt32 error = 0;
            error = device2.GetBasicTarget(ref target);
            if (error == 0)
            {
                getTargetErr2 = false;
                cmbBasicTarget2.SelectedValue = Convert.ToInt32(target);
            }

            if (error == 1)
            {
                this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get Target command sent failed." + Environment.NewLine);
                this.Devmes2.ScrollToCaret();
                getTargetErr2 = true;
            }
        }

        private void epcCheckBox_CheckedChanged(object sender, EventArgs e)
        {
            commonCheckBoxCheckedChanged(sender);
            try
            {
                SettingComboBoxStatus();
            }
            catch (Exception ex)
            {
                Console.WriteLine("StartAddress_KeyUp: " + ex.Message);
            }
        }

        private void epcCheckBox_CheckedChanged2(object sender, EventArgs e)
        {
            commonCheckBoxCheckedChanged(sender);
            try
            {
                SettingComboBoxStatus2();
            }
            catch (Exception ex)
            {
                Console.WriteLine("StartAddress_KeyUp: " + ex.Message);
            }
        }

        private void whenReceivedFirmwareUpdateProgress()
        {
            this.Invoke(
                new Action(
                    delegate
                    {
                        progressBar1.PerformStep();
                    }));
        }
        private void whenReceivedFirmwareUpdateProgress2()
        {
            this.Invoke(
                new Action(
                    delegate
                    {
                        progressBar1_2.PerformStep();
                    }));
        }

        private void whenReceivedDownloadFirmwareProgress()
        {
            this.Invoke(
                new Action(
                    delegate
                    {
                        progressBar2.PerformStep();
                    }));
        }

        private void whenReceivedDownloadFirmwareProgress2()
        {
            this.Invoke(
                new Action(
                    delegate
                    {
                        progressBar2_2.PerformStep();
                    }));
        }

        private void SetFHbtn_Click(object sender, EventArgs e)
        {
            UInt32 error = 0;
            bool status = FHcheckBox.Checked;
            error = device1.SetFrequencyAutomatic(status);

            if (error == 1)
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Set Frequency Automatic command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
            }
            else
            {
                btnGetChannel_Click(null, null);
            }

        }
        private void SetFHbtn_Click2(object sender, EventArgs e)
        {
            UInt32 error = 0;
            bool status = FHcheckBox2.Checked;
            error = device2.SetFrequencyAutomatic(status);

            if (error == 1)
            {
                this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Set Frequency Automatic command sent failed." + Environment.NewLine);
                this.Devmes2.ScrollToCaret();
            }
            else
            {
                btnGetChannel_Click2(null, null);
            }
        }

        bool getFHErr = false;
        private void GetFHbtn_Click(object sender, EventArgs e)
        {
            UInt32 error = 0;
            bool status = false;

            error = device1.GetFrequencyAutomatic(ref status);
            if (error == 0)
            {
                FHcheckBox.Checked = status;
                getFHErr = false;
                btnGetChannel_Click(null, null);
            }

            if (error == 1)
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get Frequency Automatic command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
                getFHErr = true;
            }
        }
        bool getFHErr2 = false;
        private void GetFHbtn_Click2(object sender, EventArgs e)
        {
            UInt32 error = 0;
            bool status = false;

            error = device2.GetFrequencyAutomatic(ref status);
            if (error == 0)
            {
                FHcheckBox2.Checked = status;
                getFHErr2 = false;
                btnGetChannel_Click2(null, null);
            }

            if (error == 1)
            {
                this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get Frequency Automatic command sent failed." + Environment.NewLine);
                this.Devmes2.ScrollToCaret();
                getFHErr2 = true;
            }
        }

        private void FHcheckBox_CheckedChanged(object sender, EventArgs e)
        {
            if (FHcheckBox.Checked)
            {
                cmbChannel.Enabled = false;
            }
            else
            {
                cmbChannel.Enabled = true;
            }
        }

        private void FHcheckBox_CheckedChanged2(object sender, EventArgs e)
        {
            if (FHcheckBox2.Checked)
            {
                cmbChannel2.Enabled = false;
            }
            else
            {
                cmbChannel2.Enabled = true;
            }
        }

        private void whenReceivedTriggerHandler(int triggerHandler)
        {
            ProcessDelegate mainProcess = delegate ()
            {
                if (triggerHandler == 0x01)
                {
                    KeyPressNum = KeyPressNum + 1;
                }
                if (triggerHandler == 0x00)
                {
                    KeyFreeNum = KeyFreeNum + 1;
                }
                if (KeyPressNum == 1 && KeyFreeNum == 1)
                {
                    startInventory_Click(null, null);
                }
                if (KeyPressNum == 2 && KeyFreeNum == 2)
                {
                    KeyPressNum = 0;
                    KeyFreeNum = 0;
                    startInventory_Click(null, null);
                }

            };

            this.Invoke(mainProcess);
        }
        private void whenReceivedTriggerHandler2(int triggerHandler)
        {
            ProcessDelegate mainProcess = delegate ()
            {
                if (triggerHandler == 0x01)
                {
                    KeyPressNum2 = KeyPressNum2 + 1;
                }
                if (triggerHandler == 0x00)
                {
                    KeyFreeNum2 = KeyFreeNum2 + 1;
                }
                if (KeyPressNum2 == 1 && KeyFreeNum2 == 1)
                {
                    startInventory_Click2(null, null);
                }
                if (KeyPressNum2 == 2 && KeyFreeNum2 == 2)
                {
                    KeyPressNum2 = 0;
                    KeyFreeNum2 = 0;
                    startInventory_Click2(null, null);
                }
            };
            this.Invoke(mainProcess);
        }

        private void btnSetRSSIThreshold_Click(object sender, EventArgs e)
        {
            string rssiMax = txtRssiMaxVal.Text;

            UInt32 error = 0;
            if (checkRssiMax(rssiMax) == false)
            {
                string msg = DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Please input correct RSSI Threshold(-99~0).";
                this.Devmes.AppendText(msg + Environment.NewLine);
                this.Devmes.ScrollToCaret();
                MessageBox.Show("Please input correct RSSI Threshold(-99~0).", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                return;
            }
            error = device1.SetRSSIThreshold(Convert.ToInt32(rssiMax));

            if (error == 1)
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Set RSSI Threshold command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
            }

        }
        private void btnSetRSSIThreshold_Click2(object sender, EventArgs e)
        {
            string rssiMax = txtRssiMaxVal2.Text;

            UInt32 error = 0;
            if (checkRssiMax(rssiMax) == false)
            {
                string msg = DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Please input correct RSSI Threshold(-99~0).";
                this.Devmes2.AppendText(msg + Environment.NewLine);
                this.Devmes2.ScrollToCaret();
                MessageBox.Show("Please input correct RSSI Threshold(-99~0).", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                return;
            }
            error = device2.SetRSSIThreshold(Convert.ToInt32(rssiMax));

            if (error == 1)
            {
                this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Set RSSI Threshold command sent failed." + Environment.NewLine);
                this.Devmes2.ScrollToCaret();
            }
        }

        bool geRssiMaxErr = false;
        private void btnGetRSSIThreshold_Click(object sender, EventArgs e)
        {
            int rssiMax = 0;
            UInt32 error = 0;

            error = device1.GetRSSIThreshold(ref rssiMax);
            if (error == 0)
            {
                txtRssiMaxVal.Text = rssiMax.ToString();
                geRssiMaxErr = false;
            }

            if (error == 1)
            {
                txtRssiMaxVal.Text = "0";
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get Rssi Max command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
                geRssiMaxErr = true;
            }
        }
        bool geRssiMaxErr2 = false;
        private void btnGetRSSIThreshold_Click2(object sender, EventArgs e)
        {
            int rssiMax = 0;
            UInt32 error = 0;

            error = device2.GetRSSIThreshold(ref rssiMax);
            if (error == 0)
            {
                txtRssiMaxVal2.Text = rssiMax.ToString();
                geRssiMaxErr2 = false;
            }

            if (error == 1)
            {
                txtRssiMaxVal2.Text = "0";
                this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get Rssi Max command sent failed." + Environment.NewLine);
                this.Devmes2.ScrollToCaret();
                geRssiMaxErr2 = true;
            }
        }

        private bool checkRssiMax(string rssiMaxval)
        {
            if (rssiMaxval == "")
            {
                return false;
            }
            else if (Convert.ToUInt32(rssiMaxval) < 0 || Convert.ToUInt32(rssiMaxval) > 99)
            {
                return false;
            }
            return true;
        }


        private void Weekdayones_CheckedChanged(object sender, EventArgs e)
        {
            if (!this.checkBox1.Checked || !this.checkBox2.Checked || !this.checkBox3.Checked || !this.checkBox4.Checked || !this.checkBox5.Checked)
            {
                this.cbWeekday.Checked = false;
            }

            if (this.checkBox1.Checked && this.checkBox2.Checked && this.checkBox3.Checked && this.checkBox4.Checked && this.checkBox5.Checked)
            {
                this.cbWeekday.Checked = true;
            }
        }

        private void Weekdayones_CheckedChanged2(object sender, EventArgs e)
        {
            if (!this.checkBox1_2.Checked || !this.checkBox2_2.Checked || !this.checkBox3_2.Checked || !this.checkBox4_2.Checked || !this.checkBox5_2.Checked)
            {
                this.cbWeekday2.Checked = false;
            }

            if (this.checkBox1_2.Checked && this.checkBox2_2.Checked && this.checkBox3_2.Checked && this.checkBox4_2.Checked && this.checkBox5_2.Checked)
            {
                this.cbWeekday2.Checked = true;
            }
        }

        private void Weekday_Click(object sender, EventArgs e)
        {
            if (this.cbWeekday.Checked)
            {
                this.checkBox1.Checked = true;
                this.checkBox2.Checked = true;
                this.checkBox3.Checked = true;
                this.checkBox4.Checked = true;
                this.checkBox5.Checked = true;
            }
            else
            {
                this.checkBox1.Checked = false;
                this.checkBox2.Checked = false;
                this.checkBox3.Checked = false;
                this.checkBox4.Checked = false;
                this.checkBox5.Checked = false;
            }
        }

        private void Weekday_Click2(object sender, EventArgs e)
        {
            if (this.cbWeekday2.Checked)
            {
                this.checkBox1_2.Checked = true;
                this.checkBox2_2.Checked = true;
                this.checkBox3_2.Checked = true;
                this.checkBox4_2.Checked = true;
                this.checkBox5_2.Checked = true;
            }
            else
            {
                this.checkBox1_2.Checked = false;
                this.checkBox2_2.Checked = false;
                this.checkBox3_2.Checked = false;
                this.checkBox4_2.Checked = false;
                this.checkBox5_2.Checked = false;
            }
        }

        private void Weekend_Click(object sender, EventArgs e)
        {
            if (this.cbWeekend.Checked)
            {
                this.checkBox6.Checked = true;
                this.checkBox7.Checked = true;
            }
            else
            {
                this.checkBox6.Checked = false;
                this.checkBox7.Checked = false;
            }
        }

        private void Weekend_Click2(object sender, EventArgs e)
        {
            if (this.cbWeekend2.Checked)
            {
                this.checkBox6_2.Checked = true;
                this.checkBox7_2.Checked = true;
            }
            else
            {
                this.checkBox6_2.Checked = false;
                this.checkBox7_2.Checked = false;
            }
        }

        private void Weekendones_CheckedChanged(object sender, EventArgs e)
        {
            if (!this.checkBox6.Checked || !this.checkBox7.Checked)
            {
                this.cbWeekend.Checked = false;
            }

            if (this.checkBox6.Checked && this.checkBox7.Checked)
            {
                this.cbWeekend.Checked = true;
            }
        }
        private void Weekendones_CheckedChanged2(object sender, EventArgs e)
        {
            if (!this.checkBox6_2.Checked || !this.checkBox7_2.Checked)
            {
                this.cbWeekend2.Checked = false;
            }

            if (this.checkBox6_2.Checked && this.checkBox7_2.Checked)
            {
                this.cbWeekend2.Checked = true;
            }
        }

        private void btn_Export_Click(object sender, EventArgs e)
        {
            FolderBrowserDialog dialog = new FolderBrowserDialog();
            dialog.Description = "请选择文件路径";

            if (dialog.ShowDialog() == DialogResult.OK)
            {
                string foldPath = dialog.SelectedPath;
                this.TextExportPath.Text = foldPath;

                btn_setExportPath_Click(null, null);
            }
        }

        private void btn_Export_Click2(object sender, EventArgs e)
        {
            FolderBrowserDialog dialog = new FolderBrowserDialog();
            dialog.Description = "请选择文件路径";

            if (dialog.ShowDialog() == DialogResult.OK)
            {
                string foldPath = dialog.SelectedPath;
                this.TextExportPath2.Text = foldPath;

                btn_setExportPath_Click2(null, null);
            }
        }

        void ExportCSV(object obj)
        {
            this.Invoke((new Action(() =>
            {
                FileName = "";

                int count = DatalistView.Items.Count;
                if (count == 0)
                {
                    MessageBox.Show("There is no data to export!");
                }
                else if (count != Convert.ToInt32(lblAllTagCnt.Text))
                {
                    MessageBox.Show("Export data error!");
                }
                else
                {
                    if (string.IsNullOrEmpty(this.TextExportPath.Text)) return;


                    string csvFileName = this.TextExportPath.Text + "\\" + obj.ToString();

                    DataTable dt = new DataTable();
                    DataRow dr;
                    for (int t = 0; t < DatalistView.Columns.Count; t++)
                    {
                        if (t == 3 || t == 4)
                        {
                            continue;
                        }
                        dt.Columns.Add(DatalistView.Columns[t].Text.Trim(), typeof(string));
                    }
                    for (int i = 0; i < DatalistView.Items.Count; i++)
                    {
                        int col = 0;
                        dr = dt.NewRow();
                        for (int j = 0; j < DatalistView.Columns.Count; j++)
                        {
                            if (j == 3 || j == 4)
                            {
                                continue;
                            }
                            dr[col] = DatalistView.Items[i].SubItems[j].Text.Trim();
                            col++;
                        }
                        dt.Rows.Add(dr);
                    }

                    DataTable2CSV(dt, csvFileName);
                }
            })));
        }

        void ExportCSV2(object obj)
        {
            this.Invoke((new Action(() =>
            {
                FileName2 = "";

                int count = DatalistView2.Items.Count;
                if (count == 0)
                {
                    MessageBox.Show("There is no data to export!");
                }
                else if (count != Convert.ToInt32(lblAllTagCnt2.Text))
                {
                    MessageBox.Show("Export data error!");
                }
                else
                {
                    if (string.IsNullOrEmpty(this.TextExportPath2.Text)) return;
                    string csvFileName = this.TextExportPath2.Text + "\\" + obj.ToString();

                    DataTable dt = new DataTable();
                    DataRow dr;
                    for (int t = 0; t < DatalistView2.Columns.Count; t++)
                    {
                        if (t == 3 || t == 4)
                        {
                            continue;
                        }
                        dt.Columns.Add(DatalistView2.Columns[t].Text.Trim(), typeof(string));
                    }
                    for (int i = 0; i < DatalistView2.Items.Count; i++)
                    {
                        int col = 0;
                        dr = dt.NewRow();
                        for (int j = 0; j < DatalistView2.Columns.Count; j++)
                        {
                            if (j == 3 || j == 4)
                            {
                                continue;
                            }
                            dr[col] = DatalistView2.Items[i].SubItems[j].Text.Trim();
                            col++;
                        }
                        dt.Rows.Add(dr);
                    }
                    DataTable2CSV(dt, csvFileName);
                }
            })));
        }

        public static void DataTable2CSV(System.Data.DataTable dt, string AbosultedFilePath)
        {
            System.IO.FileStream fs = new FileStream(AbosultedFilePath, System.IO.FileMode.Create, System.IO.FileAccess.Write);
            StreamWriter sw = new StreamWriter(fs, new System.Text.UnicodeEncoding());
            //Tabel header
            for (int i = 0; i < dt.Columns.Count; i++)
            {
                sw.Write(dt.Columns[i].ColumnName);
                sw.Write("\t");
            }
            sw.WriteLine("");
            //Table body
            for (int i = 0; i < dt.Rows.Count; i++)
            {
                for (int j = 0; j < dt.Columns.Count; j++)
                {
                    sw.Write(DelQuota(dt.Rows[i][j].ToString()));
                    sw.Write("\t");
                }
                sw.WriteLine("");
            }
            sw.Flush();
            sw.Close();
        }

        public static string DelQuota(string str)
        {
            string result = str;
            //string[] strQuota = { "~", "!", "@", "#", "$", "%", "^", "&", "*", "(", ")", "`", ";", "'", ",", ".", "/", ":", "/,", "<", ">", "?" };
            string[] strQuota = { "~", "!", "@", "#", "$", "%", "^", "&", "*", "(", ")", "`", ";", "'", ",", ".", "/", "/,", "<", ">", "?" };
            for (int i = 0; i < strQuota.Length; i++)
            {
                if (result.IndexOf(strQuota[i]) > -1)
                    result = result.Replace(strQuota[i], "");
            }
            return result;
        }

        private void TimerAuto_Tick(object sender, EventArgs e)
        {
            var nowTime = DateTime.Now;
            this.lblCurrentTime.Text = nowTime.ToString();

            if (this.lab_Inventory.Text == "0")
            {

                int booltype = 0;

                switch (Convert.ToInt32(nowTime.DayOfWeek))
                {
                    case 1: if (this.chb_1.Checked) booltype++; break;
                    case 2: if (this.chb_2.Checked) booltype++; break;
                    case 3: if (this.chb_3.Checked) booltype++; break;
                    case 4: if (this.chb_4.Checked) booltype++; break;
                    case 5: if (this.chb_5.Checked) booltype++; break;
                    case 6: if (this.chb_6.Checked) booltype++; break;
                    case 0: if (this.chb_7.Checked) booltype++; break;
                }
                if (booltype < 1)
                {
                    return;
                }

                DateTime dateS = new DateTime(nowTime.Year, nowTime.Month, nowTime.Day, tb_s.Value.Hour, tb_s.Value.Minute, nowTime.Second);
                DateTime dateE = new DateTime(nowTime.Year, nowTime.Month, nowTime.Day, tb_e.Value.Hour, tb_e.Value.Minute, nowTime.Second);

                if (nowTime >= dateS && nowTime < dateE)
                {
                    if (m_bInventory)
                    {
                        this.labletest.Text = "已经触发了";
                        TodatAutoStart = true;
                        AutoStart++;
                    }

                    if (!TodatAutoStart)
                    {
                        TodatAutoStart = true;
                        //MessageBox.Show("触发start");
                        startInventory_Click(null, null);
                        this.labletest.Text = "已经触发了";
                        AutoStart++;
                    }
                }
                else if (nowTime >= dateE)
                {
                    if (m_bInventory && AutoStart > 0)
                    {
                        startInventory_Click(null, null);
                        //MessageBox.Show("中止");
                        AutoStart = 0;
                    }
                }
                else
                {
                    this.labletest.Text = "不满足触发";
                }

                int h = nowTime.Hour;
                int m = nowTime.Minute;
                int s = nowTime.Second;

                if (h + m + s == 0)
                {
                    TodatAutoStart = false;
                    //MessageBox.Show("重置！");
                }
            }
        }
        private void TimerAuto_Tick2(object sender, EventArgs e)
        {
            var nowTime = DateTime.Now;
            this.lblCurrentTime2.Text = nowTime.ToString();

            if (this.lab_Inventory2.Text == "0")
            {
                int booltype = 0;
                switch (Convert.ToInt32(nowTime.DayOfWeek))
                {
                    case 1: if (this.chb_1_2.Checked) booltype++; break;
                    case 2: if (this.chb_2_2.Checked) booltype++; break;
                    case 3: if (this.chb_3_2.Checked) booltype++; break;
                    case 4: if (this.chb_4_2.Checked) booltype++; break;
                    case 5: if (this.chb_5_2.Checked) booltype++; break;
                    case 6: if (this.chb_6_2.Checked) booltype++; break;
                    case 0: if (this.chb_7_2.Checked) booltype++; break;
                }
                if (booltype < 1)
                {
                    return;
                }

                DateTime dateS = new DateTime(nowTime.Year, nowTime.Month, nowTime.Day, tb_s2.Value.Hour, tb_s2.Value.Minute, nowTime.Second);
                DateTime dateE = new DateTime(nowTime.Year, nowTime.Month, nowTime.Day, tb_e2.Value.Hour, tb_e2.Value.Minute, nowTime.Second);

                if (nowTime >= dateS && nowTime < dateE)
                {
                    if (m_bInventory2)
                    {
                        this.labletest2.Text = "已经触发了";
                        TodatAutoStart2 = true;
                        AutoStart2++;
                    }

                    if (!TodatAutoStart2)
                    {
                        TodatAutoStart2 = true;
                        //MessageBox.Show("触发start");
                        startInventory_Click2(null, null);
                        this.labletest2.Text = "已经触发了";
                        AutoStart2++;
                    }
                }
                else if (nowTime >= dateE)
                {
                    if (m_bInventory2 && AutoStart2 > 0)
                    {
                        startInventory_Click2(null, null);
                        //MessageBox.Show("中止");
                        AutoStart2 = 0;
                    }
                }
                else
                {
                    this.labletest2.Text = "不满足触发";
                }

                int h = nowTime.Hour;
                int m = nowTime.Minute;
                int s = nowTime.Second;

                if (h + m + s == 0)
                {
                    TodatAutoStart2 = false;
                    //MessageBox.Show("重置！");
                }
            }
        }

        private void DatePickerS_ValueChanged(object sender, EventArgs e)
        {
            int hE = this.DatePickerE.Value.Hour;
            int mE = this.DatePickerE.Value.Minute;

            int hS = this.DatePickerS.Value.Hour;
            int mS = this.DatePickerS.Value.Minute;

            if (hE + mE == 0)
            {
                this.DatePickerE.Text = "23:59";
                //不允许跨天
            }

            if (hS == 23 && mS == 59)
            {
                this.DatePickerS.Text = "00:00";
            }
        }

        private void DatePickerS_ValueChanged2(object sender, EventArgs e)
        {
            int hE = this.DatePickerE2.Value.Hour;
            int mE = this.DatePickerE2.Value.Minute;

            int hS = this.DatePickerS2.Value.Hour;
            int mS = this.DatePickerS2.Value.Minute;

            if (hE + mE == 0)
            {
                this.DatePickerE2.Text = "23:59";
                //不允许跨天
            }

            if (hS == 23 && mS == 59)
            {
                this.DatePickerS2.Text = "00:00";
            }
        }

        private bool ExistsPath(string path)
        {
            if (string.IsNullOrEmpty(path))
            {
                //MessageBox.Show("Please specify a path to save the tag data first.");
                //this.tabControl1.SelectedTab = this.tabPage4;
                //this.TextExportPath.Focus();
                //btn_Export_Click(null, null);
                //return false;

                return true;
            }
            else
            {
                if (!Directory.Exists(path))
                {
                    //this.TextExportPath.Text = string.Empty;
                    MessageBox.Show("The path does not exist. Please specify a new one.");
                    this.tcLeft.SelectedTab = this.tabPageOtherSetting;
                    this.TextExportPath.Focus();
                    btn_Export_Click(null, null);
                    return false;
                }
            }
            this.TextExportPath.Text = Path.GetFullPath(path);

            return true;
        }

        private bool ExistsPath2(string path)
        {
            if (string.IsNullOrEmpty(path))
            {
                //MessageBox.Show("Please specify a path to save the tag data first.");
                //this.tabControl1.SelectedTab = this.tabPage4;
                //this.TextExportPath.Focus();
                //btn_Export_Click(null, null);
                //return false;

                return true;
            }
            else
            {
                if (!Directory.Exists(path))
                {
                    //this.TextExportPath.Text = string.Empty;
                    MessageBox.Show("The path does not exist. Please specify a new one.");
                    this.tcLeft2.SelectedTab = this.tabPageOtherSetting2;
                    this.TextExportPath2.Focus();
                    btn_Export_Click2(null, null);
                    return false;
                }
            }
            this.TextExportPath2.Text = Path.GetFullPath(path);

            return true;
        }

        private void btn_setExportPath_Click(object sender, EventArgs e)
        {
            string path = this.TextExportPath.Text;

            if (!ExistsPath(path)) return;

            UInt32 error = 0;
            error = device1.SetExportPath(path);
            this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Set Export Path.\r\n");
            this.Devmes.ScrollToCaret();
        }
        private void btn_setExportPath_Click2(object sender, EventArgs e)
        {
            string path = this.TextExportPath2.Text;

            if (!ExistsPath2(path)) return;

            UInt32 error = 0;
            error = device2.SetExportPath(path);
            this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Set Export Path.\r\n");
            this.Devmes2.ScrollToCaret();
        }

        private void btn_getExportPath_Click(object sender, EventArgs e)
        {
            string path = "";

            UInt32 error = 0;
            error = device1.GetExportPath(ref path);

            this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get Export Path.\r\n");
            this.Devmes.ScrollToCaret();

            this.TextExportPath.Text = path;
        }
        private void btn_getExportPath_Click2(object sender, EventArgs e)
        {
            string path = "";

            UInt32 error = 0;
            error = device2.GetExportPath(ref path);

            this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get Export Path.\r\n");
            this.Devmes2.ScrollToCaret();

            this.TextExportPath2.Text = path;
        }

        private void btn_SetAutoInventory_Click(object sender, EventArgs e)
        {
            if (this.DatePickerS.Value >= this.DatePickerE.Value)
            {
                MessageBox.Show("The end time cannot be earlier than the start time.");
                this.DatePickerS.Focus();
            }

            Auto_Inventory auto_Inventory;
            auto_Inventory.Enable = this.cob_Inventory.SelectedIndex;
            auto_Inventory.Mon = Convert.ToInt32(this.checkBox1.Checked);
            auto_Inventory.Tues = Convert.ToInt32(this.checkBox2.Checked);
            auto_Inventory.Wed = Convert.ToInt32(this.checkBox3.Checked);
            auto_Inventory.Thurs = Convert.ToInt32(this.checkBox4.Checked);
            auto_Inventory.Fri = Convert.ToInt32(this.checkBox5.Checked);
            auto_Inventory.Sat = Convert.ToInt32(this.checkBox6.Checked);
            auto_Inventory.Sun = Convert.ToInt32(this.checkBox7.Checked);
            auto_Inventory.StartTime = this.DatePickerS.Text;
            auto_Inventory.EndTime = this.DatePickerE.Text;

            UInt32 error = 0;
            error = device1.SetAutoInventory(auto_Inventory);

            TodatAutoStart = false;

            btn_GetAutoInventory_Click(null, null);

            this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Set Auto Inventory Info.\r\n");
            this.Devmes.ScrollToCaret();
        }
        private void btn_SetAutoInventory_Click2(object sender, EventArgs e)
        {
            if (this.DatePickerS2.Value >= this.DatePickerE2.Value)
            {
                MessageBox.Show("The end time cannot be earlier than the start time.");
                this.DatePickerS2.Focus();
            }

            Auto_Inventory auto_Inventory;
            auto_Inventory.Enable = this.cob_Inventory2.SelectedIndex;
            auto_Inventory.Mon = Convert.ToInt32(this.checkBox1_2.Checked);
            auto_Inventory.Tues = Convert.ToInt32(this.checkBox2_2.Checked);
            auto_Inventory.Wed = Convert.ToInt32(this.checkBox3_2.Checked);
            auto_Inventory.Thurs = Convert.ToInt32(this.checkBox4_2.Checked);
            auto_Inventory.Fri = Convert.ToInt32(this.checkBox5_2.Checked);
            auto_Inventory.Sat = Convert.ToInt32(this.checkBox6_2.Checked);
            auto_Inventory.Sun = Convert.ToInt32(this.checkBox7_2.Checked);
            auto_Inventory.StartTime = this.DatePickerS2.Text;
            auto_Inventory.EndTime = this.DatePickerE2.Text;

            UInt32 error = 0;
            error = device2.SetAutoInventory(auto_Inventory);

            TodatAutoStart2 = false;

            btn_GetAutoInventory_Click2(null, null);

            this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Set Auto Inventory Info.\r\n");
            this.Devmes2.ScrollToCaret();
        }

        private void btn_GetAutoInventory_Click(object sender, EventArgs e)
        {
            Auto_Inventory auto_Inventory = new Auto_Inventory();

            UInt32 error = 0;
            error = device1.GetAutoInventory(ref auto_Inventory);

            this.cob_Inventory.SelectedIndex = auto_Inventory.Enable;
            this.checkBox1.Checked = Convert.ToBoolean(auto_Inventory.Mon);
            this.checkBox2.Checked = Convert.ToBoolean(auto_Inventory.Tues);
            this.checkBox3.Checked = Convert.ToBoolean(auto_Inventory.Wed);
            this.checkBox4.Checked = Convert.ToBoolean(auto_Inventory.Thurs);
            this.checkBox5.Checked = Convert.ToBoolean(auto_Inventory.Fri);
            this.checkBox6.Checked = Convert.ToBoolean(auto_Inventory.Sat);
            this.checkBox7.Checked = Convert.ToBoolean(auto_Inventory.Sun);
            this.DatePickerS.Text = auto_Inventory.StartTime;
            this.DatePickerE.Text = auto_Inventory.EndTime;

            this.lab_Inventory.Text = auto_Inventory.Enable.ToString();
            this.chb_1.Checked = this.checkBox1.Checked;
            this.chb_2.Checked = this.checkBox2.Checked;
            this.chb_3.Checked = this.checkBox3.Checked;
            this.chb_4.Checked = this.checkBox4.Checked;
            this.chb_5.Checked = this.checkBox5.Checked;
            this.chb_6.Checked = this.checkBox6.Checked;
            this.chb_7.Checked = this.checkBox7.Checked;
            this.tb_s.Text = auto_Inventory.StartTime;
            this.tb_e.Text = auto_Inventory.EndTime;

            this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get Auto Inventory Info.\r\n");
            this.Devmes.ScrollToCaret();
        }

        private void btn_GetAutoInventory_Click2(object sender, EventArgs e)
        {
            Auto_Inventory auto_Inventory = new Auto_Inventory();

            UInt32 error = 0;
            error = device2.GetAutoInventory(ref auto_Inventory);

            this.cob_Inventory2.SelectedIndex = auto_Inventory.Enable;
            this.checkBox1_2.Checked = Convert.ToBoolean(auto_Inventory.Mon);
            this.checkBox2_2.Checked = Convert.ToBoolean(auto_Inventory.Tues);
            this.checkBox3_2.Checked = Convert.ToBoolean(auto_Inventory.Wed);
            this.checkBox4_2.Checked = Convert.ToBoolean(auto_Inventory.Thurs);
            this.checkBox5_2.Checked = Convert.ToBoolean(auto_Inventory.Fri);
            this.checkBox6_2.Checked = Convert.ToBoolean(auto_Inventory.Sat);
            this.checkBox7_2.Checked = Convert.ToBoolean(auto_Inventory.Sun);
            this.DatePickerS2.Text = auto_Inventory.StartTime;
            this.DatePickerE2.Text = auto_Inventory.EndTime;

            this.lab_Inventory2.Text = auto_Inventory.Enable.ToString();
            this.chb_1_2.Checked = this.checkBox1_2.Checked;
            this.chb_2_2.Checked = this.checkBox2_2.Checked;
            this.chb_3_2.Checked = this.checkBox3_2.Checked;
            this.chb_4_2.Checked = this.checkBox4_2.Checked;
            this.chb_5_2.Checked = this.checkBox5_2.Checked;
            this.chb_6_2.Checked = this.checkBox6_2.Checked;
            this.chb_7_2.Checked = this.checkBox7_2.Checked;
            this.tb_s2.Text = auto_Inventory.StartTime;
            this.tb_e2.Text = auto_Inventory.EndTime;

            this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get Auto Inventory Info.\r\n");
            this.Devmes2.ScrollToCaret();
        }

        private void GetHWVersionBtn_Click(object sender, EventArgs e)
        {
            uint error = 0;
            string hwVersion = "";
            error = device1.GetHwVersion(ref hwVersion);
            if (error == 0)
            {
                txtHardwareVer.Text = hwVersion;
            }
            else
            {
                txtHardwareVer.Text = "";
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get Hw Version command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
            }
        }
        private void GetHWVersionBtn_Click2(object sender, EventArgs e)
        {
            uint error = 0;
            string hwVersion = "";
            error = device2.GetHwVersion(ref hwVersion);
            if (error == 0)
            {
                txtHardwareVer2.Text = hwVersion;
            }
            else
            {
                txtHardwareVer2.Text = "";
                this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get Hw Version command sent failed." + Environment.NewLine);
                this.Devmes2.ScrollToCaret();
            }
        }

        private void GetRFIDFWVerBtn_Click(object sender, EventArgs e)
        {
            uint error = 0;
            string rfidFwVersion = "";
            error = device1.GetRFIDFwVersion(ref rfidFwVersion);
            if (error == 0)
            {
                txtRFIDFWVer.Text = rfidFwVersion;
            }
            else
            {
                txtRFIDFWVer.Text = "";
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get RFID Fw Version command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
            }
        }
        private void GetRFIDFWVerBtn_Click2(object sender, EventArgs e)
        {
            uint error = 0;
            string rfidFwVersion = "";
            error = device2.GetRFIDFwVersion(ref rfidFwVersion);
            if (error == 0)
            {
                txtRFIDFWVer2.Text = rfidFwVersion;
            }
            else
            {
                txtRFIDFWVer2.Text = "";
                this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get RFID Fw Version command sent failed." + Environment.NewLine);
                this.Devmes2.ScrollToCaret();
            }
        }

        [Obsolete]
        private void btnGetRFIDBins_Click(object sender, EventArgs e)
        {
            try
            {
                if (((Button)sender).Text == "Cancel")
                {
                    ((Button)sender).Text = "Get Files";
                    return;
                }
                else
                {
                    ((Button)sender).Text = "Cancel";
                }
                string fwXmlURL = device1.rfidFwURL + device1.rfidFwXmlName;
                XmlDataDocument xmlDoc = new XmlDataDocument();
                DataSet myDataSet = xmlDoc.DataSet;
                myDataSet.ReadXml(fwXmlURL);
                if (!isDebug && myDataSet != null && myDataSet.Tables != null && myDataSet.Tables.Count > 0)
                {
                    DataView filter = new DataView(myDataSet.Tables[0]);
                    filter.RowFilter = "status <> 'debug'";
                    DataTable dt = filter.ToTable();
                    cmbRFIDBinFiles.DataSource = dt;
                }
                else
                {
                    cmbRFIDBinFiles.DataSource = myDataSet.Tables[0];
                }
                cmbRFIDBinFiles.DisplayMember = "FwFileName";
                ((Button)sender).Text = "Get Files";
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
                MessageBox.Show("Get bin files failed.", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get bin files failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
            }
        }

        [Obsolete]
        private void btnGetRFIDBins_Click2(object sender, EventArgs e)
        {
            try
            {
                if (((Button)sender).Text == "Cancel")
                {
                    ((Button)sender).Text = "Get Files";
                    return;
                }
                else
                {
                    ((Button)sender).Text = "Cancel";
                }
                string fwXmlURL = device2.rfidFwURL + device2.rfidFwXmlName;
                XmlDataDocument xmlDoc = new XmlDataDocument();
                DataSet myDataSet = xmlDoc.DataSet;
                myDataSet.ReadXml(fwXmlURL);
                if (!isDebug && myDataSet != null && myDataSet.Tables != null && myDataSet.Tables.Count > 0)
                {
                    DataView filter = new DataView(myDataSet.Tables[0]);
                    filter.RowFilter = "status <> 'debug'";
                    DataTable dt = filter.ToTable();
                    cmbRFIDBinFiles2.DataSource = dt;
                }
                else
                {
                    cmbRFIDBinFiles2.DataSource = myDataSet.Tables[0];
                }
                cmbRFIDBinFiles2.DisplayMember = "FwFileName";
                ((Button)sender).Text = "Get Files";
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
                MessageBox.Show("Get bin files failed.", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get bin files failed." + Environment.NewLine);
                this.Devmes2.ScrollToCaret();
            }
        }

        private void btnRFIDFWUpdate_Click(object sender, EventArgs e)
        {
            try
            {
                if (MessageBox.Show("Do you want to update now?", "Update RFID Firmware", MessageBoxButtons.YesNo, MessageBoxIcon.Information) == DialogResult.No)
                {
                    return;
                }
                if (((Button)sender).Text == "Updating")
                {
                    MessageBox.Show("PFID Firmware is updating...", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    return;
                }
                if (cmbRFIDBinFiles.DropDownStyle == ComboBoxStyle.DropDownList && cmbRFIDBinFiles.Items.Count == 0)
                {
                    MessageBox.Show("Please get bin files!", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    return;
                }
                if (cmbRFIDBinFiles.DropDownStyle == ComboBoxStyle.DropDownList && cmbRFIDBinFiles.SelectedIndex < 0)
                {
                    MessageBox.Show("Please select a file!", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    return;
                }
                if (btnRFIDFWUpdate.Text == "Update")
                {
                    btnRFIDFWUpdate.Text = "Updating";
                }

                string filename = cmbRFIDBinFiles.Text.ToString().Trim();

                this.updateWord.Visible = true;
                progressBar2.Visible = true;
                progressBar2.Value = 0;
                progressBar2.Style = ProgressBarStyle.Blocks;
                progressBar2.Maximum = 3;
                progressBar2.Minimum = 0;
                progressBar2.MarqueeAnimationSpeed = 100;
                progressBar2.Step = 1;

                UpdateControlsEnabled(false);

                bool status = device1.DownloadFirmwareFile("RFIDFW", filename);
                progressBar2.PerformStep();
                progressBar2.Visible = false;
                Thread.Sleep(500);
                string filePath = device1.firmwareFolderNmae + @"\" + filename;
                //return;
                if (status && File.Exists(filePath))
                {

                    FileStream myStream = new FileStream(filePath, FileMode.Open, FileAccess.Read);
                    BinaryReader myReader = new BinaryReader(myStream);
                    int bytes = (int)myStream.Length;
                    string fileDataStr = Encoding.ASCII.GetString(myReader.ReadBytes(bytes));
                    myReader.Close();
                    myStream.Close();

                    string[] separator = { "\r\n" };
                    string[] rfidRowArr = fileDataStr.Split(separator, StringSplitOptions.RemoveEmptyEntries);

                    int countPicket = (int)Math.Ceiling((decimal)((int)rfidRowArr.Length / (1024 / 16)));

                    progressBar1.Visible = true;
                    progressBar1.Value = 0;
                    progressBar1.Style = ProgressBarStyle.Blocks;
                    progressBar1.Maximum = countPicket + 2;
                    progressBar1.Minimum = 0;
                    progressBar1.MarqueeAnimationSpeed = 100;
                    progressBar1.Step = 1;

                    bool updateStatus = device1.RFIDFirmwareUpdate(filePath);
                    if (updateStatus)
                    {
                        if (MessageBox.Show("Update RFID firmware success! To use the device, please unplug it from the PC and plug it again.", "Update RFID Firmware Information", MessageBoxButtons.OK, MessageBoxIcon.Information) == DialogResult.OK)
                        {
                            btnVcpDisconnect_Click(btnDisconnect, null);
                        }
                    }
                    else
                    {
                        MessageBox.Show("Update RFID Firmware failed!", "Update RFID Firmware", MessageBoxButtons.OK);
                    }
                }
                else
                {
                    string msgTitle = "Warning";
                    string msg = "Demo App: Download RFID firmware file failed. No available firmware for update. ";
                    MessageBox.Show(msg, msgTitle, MessageBoxButtons.OK);
                }
                btnRFIDFWUpdate.Text = "Update";

                progressBar1.PerformStep();
                progressBar1.Visible = false;
                this.updateWord.Visible = false;
                UpdateControlsEnabled(true);
                ControlsEnabled();
            }
            catch (Exception ex)
            {
                UpdateControlsEnabled(true);
                progressBar1.Visible = false;
                progressBar2.Visible = false;
                this.updateWord.Visible = false;
                Console.WriteLine(ex.Message);
                MessageBox.Show(ex.Message, "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
            }
        }

        private void btnRFIDFWUpdate_Click2(object sender, EventArgs e)
        {
            try
            {
                if (MessageBox.Show("Do you want to update now?", "Update RFID Firmware", MessageBoxButtons.YesNo, MessageBoxIcon.Information) == DialogResult.No)
                {
                    return;
                }
                if (((Button)sender).Text == "Updating")
                {
                    MessageBox.Show("PFID Firmware is updating...", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    return;
                }
                if (cmbRFIDBinFiles2.DropDownStyle == ComboBoxStyle.DropDownList && cmbRFIDBinFiles2.Items.Count == 0)
                {
                    MessageBox.Show("Please get bin files!", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    return;
                }
                if (cmbRFIDBinFiles2.DropDownStyle == ComboBoxStyle.DropDownList && cmbRFIDBinFiles2.SelectedIndex < 0)
                {
                    MessageBox.Show("Please select a file!", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    return;
                }
                if (btnRFIDFWUpdate2.Text == "Update")
                {
                    btnRFIDFWUpdate2.Text = "Updating";
                }

                string filename = cmbRFIDBinFiles2.Text.ToString().Trim();

                this.updateWord2.Visible = true;
                progressBar2_2.Visible = true;
                progressBar2_2.Value = 0;
                progressBar2_2.Style = ProgressBarStyle.Blocks;
                progressBar2_2.Maximum = 3;
                progressBar2_2.Minimum = 0;
                progressBar2_2.MarqueeAnimationSpeed = 100;
                progressBar2_2.Step = 1;

                UpdateControlsEnabled2(false);

                bool status = device2.DownloadFirmwareFile("RFIDFW", filename);
                progressBar2_2.PerformStep();
                progressBar2_2.Visible = false;
                Thread.Sleep(500);
                string filePath = device2.firmwareFolderNmae + @"\" + filename;
                //return;
                if (status && File.Exists(filePath))
                {
                    FileStream myStream = new FileStream(filePath, FileMode.Open, FileAccess.Read);
                    BinaryReader myReader = new BinaryReader(myStream);
                    int bytes = (int)myStream.Length;
                    string fileDataStr = Encoding.ASCII.GetString(myReader.ReadBytes(bytes));
                    myReader.Close();
                    myStream.Close();

                    string[] separator = { "\r\n" };
                    string[] rfidRowArr = fileDataStr.Split(separator, StringSplitOptions.RemoveEmptyEntries);
                    int countPicket = (int)Math.Ceiling((decimal)((int)rfidRowArr.Length / (1024 / 16)));
                    progressBar1_2.Visible = true;
                    progressBar1_2.Value = 0;
                    progressBar1_2.Style = ProgressBarStyle.Blocks;
                    progressBar1_2.Maximum = countPicket + 2;
                    progressBar1_2.Minimum = 0;
                    progressBar1_2.MarqueeAnimationSpeed = 100;
                    progressBar1_2.Step = 1;
                    bool updateStatus = device2.RFIDFirmwareUpdate(filePath);
                    if (updateStatus)
                    {
                        if (MessageBox.Show("Update RFID firmware success! To use the device, please unplug it from the PC and plug it again.", "Update RFID Firmware Information", MessageBoxButtons.OK, MessageBoxIcon.Information) == DialogResult.OK)
                        {
                            btnVcpDisconnect_Click2(btnDisconnect2, null);
                        }
                    }
                    else
                    {
                        MessageBox.Show("Update RFID Firmware failed!", "Update RFID Firmware", MessageBoxButtons.OK);
                    }
                }
                else
                {
                    string msgTitle = "Warning";
                    string msg = "Demo App: Download RFID firmware file failed. No available firmware for update. ";
                    MessageBox.Show(msg, msgTitle, MessageBoxButtons.OK);
                }
                btnRFIDFWUpdate2.Text = "Update";

                progressBar1_2.PerformStep();
                progressBar1_2.Visible = false;
                this.updateWord2.Visible = false;
                UpdateControlsEnabled2(true);
                ControlsEnabled2();
            }
            catch (Exception ex)
            {
                UpdateControlsEnabled2(true);
                progressBar1_2.Visible = false;
                progressBar2_2.Visible = false;
                this.updateWord2.Visible = false;
                Console.WriteLine(ex.Message);
                MessageBox.Show(ex.Message, "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
            }
        }

        private void epcRadioBtn_CheckedChanged(object sender, EventArgs e)
        {
            try
            {
                SettingComboBoxStatus();
            }
            catch (Exception ex)
            {
                Console.WriteLine("epcRadioBtn_CheckedChanged: " + ex.Message);
            }
        }

        private void epcRadioBtn_CheckedChanged2(object sender, EventArgs e)
        {
            try
            {
                SettingComboBoxStatus2();
            }
            catch (Exception ex)
            {
                Console.WriteLine("epcRadioBtn_CheckedChanged: " + ex.Message);
            }
        }

        private void tidRadioBtn_CheckedChanged(object sender, EventArgs e)
        {
            try
            {
                SettingComboBoxStatus();
            }
            catch (Exception ex)
            {
                Console.WriteLine("epcRadioBtn_CheckedChanged: " + ex.Message);
            }
        }
        private void tidRadioBtn_CheckedChanged2(object sender, EventArgs e)
        {
            try
            {
                SettingComboBoxStatus2();
            }
            catch (Exception ex)
            {
                Console.WriteLine("epcRadioBtn_CheckedChanged: " + ex.Message);
            }
        }

        private void userRadioBtn_CheckedChanged(object sender, EventArgs e)
        {
            try
            {
                SettingComboBoxStatus();
            }
            catch (Exception ex)
            {
                Console.WriteLine("epcRadioBtn_CheckedChanged: " + ex.Message);
            }
        }

        private void userRadioBtn_CheckedChanged2(object sender, EventArgs e)
        {
            try
            {
                SettingComboBoxStatus2();
            }
            catch (Exception ex)
            {
                Console.WriteLine("epcRadioBtn_CheckedChanged: " + ex.Message);
            }
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            this.initForms();
            this.ControlsEnabled();
            this.ControlsEnabled2();
            device1.callBackResultTagData = ShowTagData;
            device1.callBackResultError = ShowErrorMsg;
            device1.callBackResultSuccess = ShowSuccessMsg;
            device1.whenShowReceiveMsg += WhenShowReceiveMsg;
            device1.whenReceivedRebootDevice += WhenReceivedRebootDevice;
            device1.callBackResultReadComplete = WhenReadComplete;
            device1.whenReceivedFirmwareUpdateProgress += whenReceivedFirmwareUpdateProgress;
            device1.whenReceivedDownloadFirmwareProgress += whenReceivedDownloadFirmwareProgress;
            device1.callBackTriggerHandler += whenReceivedTriggerHandler;

            device2.callBackResultTagData = ShowTagData2;
            device2.callBackResultError = ShowErrorMsg2;
            device2.callBackResultSuccess = ShowSuccessMsg2;
            device2.whenShowReceiveMsg += WhenShowReceiveMsg2;
            device2.whenReceivedRebootDevice += WhenReceivedRebootDevice2;
            device2.callBackResultReadComplete = WhenReadComplete2;
            device2.whenReceivedFirmwareUpdateProgress += whenReceivedFirmwareUpdateProgress2;
            device2.whenReceivedDownloadFirmwareProgress += whenReceivedDownloadFirmwareProgress2;
            device2.callBackTriggerHandler += whenReceivedTriggerHandler2;

            int i = 0;
            for (i = 0; i < 100; i++)
            {
                HIDfilterTime.Items.Add(i.ToString() + "*1s");
                HIDfilterTime2.Items.Add(i.ToString() + "*1s");
            }
            HIDfilterTime.SelectedIndex = 0;
            HIDfilterTime2.SelectedIndex = 0;

            for (int j = 0; j < 11; j++)
            {
                HIDinventoryInterval.Items.Add(j.ToString() + "*0.1s");
                HIDinventoryInterval2.Items.Add(j.ToString() + "*0.1s");
            }
            HIDinventoryInterval.SelectedIndex = 0;
            HIDinventoryInterval2.SelectedIndex = 0;

            bool isDebug = ConfigurationManager.AppSettings["isDebug"].ToLower() == "true";
            if (isDebug)
            {
                cmbBinFiles.DropDownStyle = ComboBoxStyle.DropDown;
                cmbRFIDBinFiles.DropDownStyle = ComboBoxStyle.DropDown;
            }
        }

        private void btnSetHIDInventorymode_Click(object sender, EventArgs e)
        {
            UInt32 error = 0;
            HIDInventoryMode mode = (HIDInventoryMode)Enum.Parse(typeof(HIDInventoryMode), this.cmbHIDInventrorymode.Text);
            error = device1.SetHIDInventoryMode(mode);
            if (error == 1)
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Set HID Inventory mode sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
            }
        }

        private void btnGetHIDInventorymode_Click(object sender, EventArgs e)
        {
            UInt32 error = 0;
            HIDInventoryMode mode = HIDInventoryMode.Manual;
            error = device1.GetHIDInventoryMode(ref mode);
            if (error == 1)
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get HID Inventory mode sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
            }
            else
            {
                if ((int)mode > 2)
                {
                    this.cmbHIDInventrorymode.SelectedIndex = 0;
                }
                else
                {
                    this.cmbHIDInventrorymode.SelectedIndex = (int)mode;
                }
            }

        }

        private void btnSetHIDInventorymode2_Click(object sender, EventArgs e)
        {
            UInt32 error = 0;
            HIDInventoryMode mode = (HIDInventoryMode)Enum.Parse(typeof(HIDInventoryMode), this.cmbHIDInventrorymode2.Text);
            error = device2.SetHIDInventoryMode(mode);
            if (error == 1)
            {
                this.Devmes2.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Set HID Inventory mode sent failed." + Environment.NewLine);
                this.Devmes2.ScrollToCaret();
            }
        }

        private void btnGetHIDInventorymode2_Click(object sender, EventArgs e)
        {
            UInt32 error = 0;
            HIDInventoryMode mode = HIDInventoryMode.Manual;

            error = device2.GetHIDInventoryMode(ref mode);
            if (error == 1)
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get HID Inventory mode sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
            }
            else
            {
                if ((int)mode > 2)
                {
                    this.cmbHIDInventrorymode.SelectedIndex = 0;
                }
                else
                {
                    this.cmbHIDInventrorymode.SelectedIndex = (int)mode;
                }
            }
        }

        private void btnGetTagStatus_Click(object sender, EventArgs e)
        {
            string Epc_string = this.txtSelectedTag.Text;
            if (Epc_string != null)
            {
                Epc_string = Epc_string.Replace(" ", "").Replace("0x", "");
                if (Epc_string.Length % 2 != 0)
                {
                    this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " [WARNING]Please input correct epc of selected.");
                    this.Devmes.ScrollToCaret();
                    return;
                }
            }
            else
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " [WARNING]No tag selected." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
                return;
            }

            byte[] yu = { };
            if (Epc_string != null)
            {
                yu = HexStringToByteArray(Epc_string);
            }

            Types.TagStatus status = device1.CheckTagStatus(yu);

            this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Tag status: " + status.ToString() + Environment.NewLine);
            this.Devmes.ScrollToCaret();
            //for (int i = 0; i < 10; i++)
            //{
            //    Types.TagStatus status = device1.CheckTagStatus(yu);

            //    this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Tag status: " + status.ToString() + Environment.NewLine);
            //    this.Devmes.ScrollToCaret();
            //}
        }

        private void SELEPC_CheckedChanged(object sender, EventArgs e)
        {
            btnGetTagStatus.Enabled = true;
        }

        private void SELSERVED_CheckedChanged(object sender, EventArgs e)
        {
            btnGetTagStatus.Enabled = false;
        }

        private void SELUSER_CheckedChanged(object sender, EventArgs e)
        {
            btnGetTagStatus.Enabled = false;
        }

        private void SELTID_CheckedChanged(object sender, EventArgs e)
        {
            btnGetTagStatus.Enabled = false;
        }

        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            //Properties.Settings.Default.isDebug = false;
            //Properties.Settings.Default.Save();
            Configuration config = ConfigurationManager.OpenExeConfiguration(ConfigurationUserLevel.None);
            config.AppSettings.Settings["isDebug"].Value = "false";
            config.Save(ConfigurationSaveMode.Modified);
            ConfigurationManager.RefreshSection("appSettings");
        }
    }
}
 