﻿using AsReaderP3xU;
using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Configuration;
using System.Data;
using System.Drawing;
using System.IO;
using System.IO.Ports;
using System.Linq;
using System.Net;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Xml;

namespace AsReaderP3xU_Demo
{
    public partial class AsReaderP3xU : Form
    {
        private int total_time = 0;//The total time.
        int singluationCount = 0;
        volatile bool m_bInventory = false;
        bool isConnected = false;
        int selectedIndex = 0;
        string connType = "";

        uint defaultMinPower = 13;
        uint defaultMaxPower = 23;

        private Hashtable mTagHashTable = new Hashtable();
        private AsReader.InventoryResult mReadTag;
        private delegate void ProcessDelegate();

        public int KeyPressNum = 0;
        public int KeyFreeNum = 0;

        string FileName;

        bool TodatAutoStart = false;
        int AutoStart = 0;

        //DataTable dt = new DataTable();



        public AsReaderP3xU()
        {
            InitializeComponent();

            //dt.Columns.Add("Index", typeof(string));
            //dt.Columns.Add("PC", typeof(string));
            //dt.Columns.Add("EPC", typeof(string));
            //dt.Columns.Add("Time", typeof(string));
        }

        private void initForms()
        {
            SetCombolList();
            string[] vcpPort = GetPortList();
            int i = 0;
            //有限判断是否开通端口模式
            if (vcpPort.Length > 0)
            {
                for (i = 0; i < vcpPort.Length; i++)
                {
                    this.ComPort.Items.Add(vcpPort[i]);
                }
                if (i > 0)
                    this.ComPort.SelectedIndex = 0;
            }
        }

        /// <summary>
        /// VCP disconnect
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnVcpDisconnect_Click(object sender, EventArgs e)
        {
            if (m_bInventory) StopInventory();
            UInt32 error = 0;
            error = Device.DisConnect();

            if (error == 1)
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " DisConnect failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
            }
            if (error == 0)
            {
                this.ComPort.Enabled = true;
                //this.txtBaudRate.Enabled = false;
                this.Connect.Enabled = true;
                this.button2.Enabled = false;
                isConnected = false;
            }
            this.ControlsEnabled();
        }

        /// <summary>
        /// VCP Connect
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnVcpConnect_Click(object sender, EventArgs e)
        {
            cmbBinFiles.DataSource = null;
            cmbRFIDBinFiles.DataSource = null;
            Cursor.Current = Cursors.WaitCursor;
            uint error = 0;
            isConnected = false;
            if (ComPort.Text.Length > 0)
            {
                string com_name = this.ComPort.SelectedItem.ToString();
                try
                {
                    error = Device.ConnectWithVcp(com_name);
                }
                catch (Exception ex)
                {
                    Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " " + ex.Message + Environment.NewLine);
                    Devmes.ScrollToCaret();
                    return;
                }

                if (error != 0)
                {
                    Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Connect failed." + Environment.NewLine);
                    Devmes.ScrollToCaret();
                }
            }
            else
            {
                Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " COM port is not exist,please check it." + Environment.NewLine);
                Devmes.ScrollToCaret();
                return;
            }

            Thread.Sleep(100);
            GetSdkVersion_load();
            Thread.Sleep(100);
            btnGetRegion_Click(btnGetRegion, e);
            Thread.Sleep(100);
            btnGetMask_Click(btnGetMask, e);
            Thread.Sleep(100);
            btnGetMaskEnable_Click(btnGetMaskEnable, null);
            Thread.Sleep(100);
            GetFWVersionBtn_Click(GetFWVersionBtn, e);
            Thread.Sleep(100);
            HIDGetBtn_Click(HIDgetBtn, e);
            Thread.Sleep(100);
            buzzerGetBtn_Click(buzzerGetBtn, e);
            Thread.Sleep(100);
            btnGetRSSIThreshold_Click(btnGetRSSIThreshold, e);
            Thread.Sleep(100);
            GetHWVersionBtn_Click(GetHWVersionBtn, e);
            Thread.Sleep(100);
            GetRFIDFWVerBtn_Click(GetRFIDFWVerBtn, e);
            Thread.Sleep(100);
            GetProductSN_load();

            if (error == 0 && getRegionErr && getSessionErr && getCollisionErr && getPowerErr && getReadTimeErr && getIdleTimeErr && getTargetErr && getFHErr)
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Connect failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
                if (error == 0) Device.DisConnect();
                return;
            }
            isConnected = true;
            connType = "VCP";
            this.ControlsEnabled();
        }

        private void Write_Epc_Click(object sender, EventArgs e)
        {
            //input check
            string needMsg = "";
            if (txtEpc.Text == "") needMsg += DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " [WARNING]Please input EPC." + Environment.NewLine;
            if (text_off.Text == "") needMsg += DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " [WARNING]Please input start address." + Environment.NewLine;
            if (needMsg != "")
            {
                this.Devmes.AppendText(needMsg);
                this.Devmes.ScrollToCaret();
                return;
            }
            //handle
            UInt32 error = 0;
            string Epc_string = this.txtEpc.Text.Replace(" ", "").Replace("0x", "");

            if (Epc_string.Length % 2 != 0)
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Please input correct epc." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
                return;
            }

            //Epc_string1 选中的要被覆盖的标签的值
            string Epc_string1 = this.txtSelectedTag.Text;

            if (Epc_string1 != null)
            {
                Epc_string1 = Epc_string1.Replace(" ", "").Replace("0x", "");
                if (Epc_string1.Length % 2 != 0)
                {
                    this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Please input correct epc of selected." + Environment.NewLine);
                    this.Devmes.ScrollToCaret();
                    return;
                }
            }

            byte[] yu = { };
            if (Epc_string != null)
            {
                yu = HexStringToByteArray(Epc_string);
            }


            byte[] ren = { };
            if (Epc_string1 != null)
            {
                ren = HexStringToByteArray(Epc_string1);
            }

            error = Device.WriteMemory(
                SELSERVED.Checked ? Types.MemBankType.MEM_RESERVED : SELEPC.Checked ? Types.MemBankType.MEM_EPC : SELTID.Checked ? Types.MemBankType.MEM_TID : SELUSER.Checked ? Types.MemBankType.MEM_USER : 0,
                Convert.ToUInt32(text_off.Text),
                Convert.ToUInt32(ReadPassward.Text == "" ? "0" : ReadPassward.Text, 16), yu, ren);

            if (error == 1)
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Write Tag command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
            }
        }

        static byte[] HexStringToByteArray(string s)
        {
            s = s.Replace(" ", "").Replace("0x", "");
            byte[] buffer = new byte[s.Length / 2];
            for (int i = 0; i < s.Length; i += 2)
                buffer[i / 2] = (byte)Convert.ToByte(s.Substring(i, 2), 16);
            return buffer;
        }

        private void ReadTag_Click(object sender, EventArgs e)
        {
            UInt32 error = 0;
            Convert.ToUInt32(text_off.Text);
            //input value check
            StringBuilder sb = new StringBuilder();

            string Epc_string = this.txtSelectedTag.Text;

            if (Epc_string != null)
            {
                Epc_string = Epc_string.Replace(" ", "").Replace("0x", "");
                if (Epc_string.Length % 2 != 0) sb.AppendLine(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " [WARNING]Please input correct epc of selected.");
            }

            if (text_off.Text == "") sb.AppendLine(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " [WARNING]Please input start address.");
            if (ReadLenth.Text == "") sb.AppendLine(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " [WARNING]Please input length.");
            if (sb.ToString().Length > 0)
            {
                this.Devmes.AppendText(sb.ToString());
                this.Devmes.ScrollToCaret();
                return;
            }

            byte[] yu = { };
            if (Epc_string != null)
            {
                yu = HexStringToByteArray(Epc_string);
            }

            error = Device.ReadMemory(
                SELSERVED.Checked ? Types.MemBankType.MEM_RESERVED : SELEPC.Checked ? Types.MemBankType.MEM_EPC : SELTID.Checked ? Types.MemBankType.MEM_TID : SELUSER.Checked ? Types.MemBankType.MEM_USER : 0,
                Convert.ToUInt32(text_off.Text),
                Convert.ToUInt32(ReadLenth.Text),
                Convert.ToUInt32(ReadPassward.Text == "" ? "0" : ReadPassward.Text, 16), yu);

            if (error == 1)
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Read Tag command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
            }
        }

        private void btnSelectMask_Click(object sender, EventArgs e)
        {
            UInt32 error = 0;
            string Epc_string = this.txtSelectedTag.Text.Replace(" ", "").Replace("0x", "");
            byte[] mask = { };
            if (Epc_string.Length % 2 != 0)
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Please input correct epc of selected." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
                return;
            }
            mask = HexStringToByteArray(Epc_string);

            error = Device.SetSelectMask(
                SELSERVED.Checked ? Types.MemBankType.MEM_RESERVED : SELTID.Checked ? Types.MemBankType.MEM_TID : SELEPC.Checked ? Types.MemBankType.MEM_EPC : SELUSER.Checked ? Types.MemBankType.MEM_USER : 0,
                (Types.TargetType)cmbTarget.SelectedValue,
                (Types.ActionType)cmbAction.SelectedValue,
                Convert.ToUInt32(maskStartAddress.Text, 16),
                mask);

            if (error == 1)
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Select Tag command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
            }
            btnGetMaskEnable_Click(null, null);

        }

        private void btnGetMask_Click(object sender, EventArgs e)
        {
            Types.MemBankType membank = 0;
            Types.TargetType target = 0;
            Types.ActionType action = 0;
            UInt32 startAddressWord = 0;
            string epc_string = null;
            UInt32 error = 0;
            error = Device.GetSelectMask(ref membank, ref target, ref action, ref startAddressWord, ref epc_string);
            if (error == 0)
            {
                this.txtSelectedTag.Text = epc_string;
                this.maskStartAddress.Text = startAddressWord.ToString();
                this.cmbTarget.SelectedValue = target;
                this.cmbAction.SelectedValue = action;
                if (membank == Types.MemBankType.MEM_TID)
                {
                    SELTID.Checked = true;
                }
                else if (membank == Types.MemBankType.MEM_EPC)
                {
                    SELEPC.Checked = true;
                }
                else if (membank == Types.MemBankType.MEM_USER)
                {
                    SELUSER.Checked = true;
                }
                else
                {
                    SELSERVED.Checked = true;
                }

            }

            if (error == 1)
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get Select Tag command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
            }
        }

        private void btnSetMaskEnable_Click(object sender, EventArgs e)
        {
            UInt32 error = 0;
            error = Device.SetSelectionEnable((Types.SelectionEnable)cmbSelectionEnable.SelectedValue);
            if (error == 1)
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Set Selection Enable sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
            }
        }

        private void btnGetMaskEnable_Click(object sender, EventArgs e)
        {
            Types.SelectionEnable selection_enable = 0;
            UInt32 error = 0;
            error = Device.GetSelectionEnable(ref selection_enable);
            if (error == 0)
            {
                cmbSelectionEnable.SelectedValue = Convert.ToInt32(selection_enable);
            }

            if (error == 1)
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get Selection Enable command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
            }
        }

        /// <summary>
        /// kill tag
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void button7_Click(object sender, EventArgs e)
        {
            string Epc_string = txtSelectedTag.Text.Replace(" ", "").Replace("0x", "");
            byte[] yu = { };

            if (Epc_string.Length % 2 != 0)
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Please input correct epc of selected." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
                return;
            }
            yu = HexStringToByteArray(Epc_string);
            UInt32 error = Device.Kill(Convert.ToUInt32(ReadPassward.Text == "" ? "0" : ReadPassward.Text, 16), yu);

            if (error == 1)
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Kill Tag command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
            }
        }

        /// <summary>
        /// set ANT power
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnSetPowerWithANT_Click(object sender, EventArgs e)
        {
            UInt32 error = 0;
            if (!CheckPowersWithRegionType())
            {
                return;
            }
            error = Device.SetTxPower(
                txtPower1.Text == "" ? 0 : Convert.ToUInt32(txtPower1.Text)
                );
            if (error == 1)
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Set Power command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
            }
        }
        private bool CheckPowersWithRegionType()
        {
            if (Convert.ToUInt32(txtPower1.Text == "" ? "0" : txtPower1.Text) > defaultMaxPower)
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Please input correct antenna powers(" + CurrentRegionType + ":" + defaultMinPower + "~" + defaultMaxPower + "dbm)." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
                return false;
            }
            return true;
        }
        bool getPowerErr = false;
        private void GetPower_Click(object sender, EventArgs e)
        {
            UInt32 power1 = 0;
            UInt32 minPower = 13;
            UInt32 maxPower = 23;
            if (CurrentRegionType != Types.RegionType.REGION_JAPAN)
            {
                maxPower = 27;
            }
            UInt32 error = 0;
            error = Device.GetTxPower(ref power1, ref minPower, ref maxPower);
            defaultMinPower = minPower;
            defaultMaxPower = maxPower;
            if (error == 0)
            {
                txtPower1.Text = (power1 > maxPower ? maxPower : power1).ToString();
                getPowerErr = false;
                if (power1 > maxPower)
                {
                    btnSetPowerWithANT_Click(null, null);
                }
            }
            if (error == 1)
            {
                txtPower1.Text = "";
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get Power command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
                getPowerErr = true;
            }
        }

        private void Clear_Click(object sender, EventArgs e)
        {
            total_time = System.Environment.TickCount;
            ClearTableData();
        }

        private void SetSession_Click(object sender, EventArgs e)
        {

            Types.SessionType sessionType = (Types.SessionType)cmbSession.SelectedValue;
            UInt32 error = 0;
            //session范围：0~3
            error = Device.SetSession(sessionType);

            if (error == 1)
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Set Session command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
            }
        }

        bool getSessionErr = false;
        private void GetSession_Click(object sender, EventArgs e)
        {
            Types.SessionType sessionType = 0;
            UInt32 error = 0;
            error = Device.GetSession(ref sessionType);
            if (error == 0)
            {
                getSessionErr = false;
                cmbSession.SelectedValue = Convert.ToInt32(sessionType);
            }

            if (error == 1)
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get Session command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
                getSessionErr = true;
            }
        }

        /// <summary>
        /// set region
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnSetRegion_Click(object sender, EventArgs e)
        {
            UInt32 error = 0;
            error = Device.SetRegion((Types.RegionType)cmbRegion.SelectedValue);

            if (error == 1)
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Set Region command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
            }
            else btnGetRegion_Click(null, null);
        }

        bool getRegionErr = false;
        Types.RegionType CurrentRegionType;
        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnGetRegion_Click(object sender, EventArgs e)
        {
            CurrentRegionType = 0;
            Types.RegionType regionType = 0;
            UInt32 error = 0;
            error = Device.GetRegion(ref regionType);
            if (error == 0)
            {
                cmbRegion.SelectedValue = Convert.ToInt32(regionType);
                CurrentRegionType = regionType;

                switch (regionType)
                {
                    case Types.RegionType.REGION_CHINA2:
                        this.cmbChannel.DataSource = Device.getComboxList(typeof(Types.ChinaChannelType));
                        break;

                    case Types.RegionType.REGION_JAPAN:
                        this.cmbChannel.DataSource = Device.getComboxListByName(typeof(Types.JPChannelType), "diJPChannel");
                        break;


                    case Types.RegionType.REGION_BRAZIL:
                        this.cmbChannel.DataSource = Device.getComboxList(typeof(Types.BrazilChannelType));
                        break;

                    case Types.RegionType.REGION_EUROPE:
                        this.cmbChannel.DataSource = Device.getComboxList(typeof(Types.EuropeChannelType));
                        break;

                    case Types.RegionType.REGION_US:
                    case Types.RegionType.REGION_US_NARROW:
                        this.cmbChannel.DataSource = Device.getComboxList(typeof(Types.USChannelType));
                        break;
                }
                this.cmbChannel.DisplayMember = "name";
                this.cmbChannel.ValueMember = "value";

                Thread.Sleep(100);
                btnGetCollision_Click(btnGetCollision, e);
                Thread.Sleep(100);
                GetPower_Click(GetPower, e);
                Thread.Sleep(100);
                InitialGetFH_LBT();
                Thread.Sleep(100);
                btnGetChannel_Click(btnGetChannel, e);
                Thread.Sleep(100);
                InitialGetQuery();

                btn_getExportPath_Click(null, null);
                btn_GetAutoInventory_Click(null, null);

                getRegionErr = false;
            }

            if (error == 1)
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get Region command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
                getRegionErr = true;
            }
        }

        private void InitialGetFH_LBT()
        {
            UInt32 error = 0;
            uint readTime = 10;
            uint idelTime = 0;
            uint cst = 1;
            uint rfl = 13;
            Types.FHType fh = 0;
            Types.LBTType lbt = 0;
            Types.CWType cw = 0;

            error = Device.GetFH_LBT(ref readTime, ref idelTime, ref cst, ref rfl, ref fh, ref lbt, ref cw);
            if (error == 0)
            {
                txtReadTime1.Text = readTime.ToString();
                getReadTimeErr = false;

                txtIdelTime.Text = idelTime.ToString();
                getIdleTimeErr = false;

                if (fh == Types.FHType.WITH_LBT && lbt == Types.LBTType.ENABLE)
                {
                    FHcheckBox.Checked = true;
                }
                else
                {
                    FHcheckBox.Checked = false;
                }
                getFHErr = false;
            }
            else
            {
                txtReadTime1.Text = "";
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get Read Time command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
                getReadTimeErr = true;

                txtIdelTime.Text = "";
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get Idel Time command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
                getIdleTimeErr = true;

                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get Frequency Automatic command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
                getFHErr = true;
            }
        }

        private void InitialGetQuery()
        {
            UInt32 error = 0;
            Types.DRType dr = 0;
            Types.MType m = 0;
            Types.TRextType trext = 0;
            Types.SelType sel = 0;
            Types.SessionType session = 0;
            Types.TargetABType target = 0;
            Types.QType q = 0;

            error = Device.GetQuery(ref dr, ref m, ref trext, ref sel, ref session, ref target, ref q);
            if (error == 0)
            {
                getSessionErr = false;
                cmbSession.SelectedValue = Convert.ToInt32(session);

                getTargetErr = false;
                cmbBasicTarget.SelectedValue = Convert.ToInt32(target);
            }
            else
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get Session command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
                getSessionErr = true;

                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get Target command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
                getTargetErr = true;
            }

        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void cbAnt_CheckedChanged(object sender, EventArgs e)
        {
            //gbInventoryType.Enabled = !(cbAnt1.Checked || cbAnt2.Checked || cbAnt3.Checked || cbAnt4.Checked || cbAnt5.Checked || cbAnt6.Checked || cbAnt7.Checked || cbAnt8.Checked);
        }

        /// <summary>
        /// start inventory click
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void startInventory_Click(object sender, EventArgs e)
        {
            string path = this.TextExportPath.Text;
            if (!ExistsPath(path)) return;

            UInt32 error = 0;
            this.StartInventory.Enabled = false;
            if (m_bInventory)
            {
                error = Device.StopInventory();
                if (error != 0)
                {
                    this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Stop Inventory command sent failed." + Environment.NewLine);
                    this.Devmes.ScrollToCaret();
                    this.StartInventory.Enabled = true;
                    return;
                }
                m_bInventory = false;
                readTimer.Enabled = false;
                this.StartInventory.Text = "Start";


                this.groupBox6.Enabled = true;
                this.groupBox5.Enabled = true;

                //Task.Run(()=> {
                FileName += "_" + DateTime.Now.ToString("yyyyMMddHHmmssfff") + ".csv";
                Thread.Sleep(200);
                ExportCSV(FileName);
                //});
            }
            else
            {
                if (this.txtTagCount.Text == string.Empty) this.txtTagCount.Text = "0";
                if (this.txtInventoryRound.Text == string.Empty) this.txtInventoryRound.Text = "0";
                if (this.txtElapsedTime.Text == string.Empty) this.txtElapsedTime.Text = "0";



                error = StartInventoryByTypes();
                if (error != 0)
                {
                    this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Start Inventory By Types command sent failed." + Environment.NewLine);
                    this.Devmes.ScrollToCaret();
                    this.StartInventory.Enabled = true;
                    return;
                }

                total_time = System.Environment.TickCount;
                ClearTableData();

                this.StartInventory.Text = "Stop";
                m_bInventory = true;
                readTimer.Enabled = true;


                this.groupBox6.Enabled = false;
                this.groupBox5.Enabled = false;

                FileName = DateTime.Now.ToString("yyyyMMddHHmmssfff");
            }
            this.StartInventory.Enabled = true;

        }

        private void AsReaderBoxP3xU_Demo_Load(object sender, EventArgs e)
        {
            this.initForms();
            this.ControlsEnabled();
            Device.callBackResultTagData = ShowTagData;
            Device.callBackResultError = ShowErrorMsg;
            Device.callBackResultSuccess = ShowSuccessMsg;

            Device.whenShowReceiveMsg += WhenShowReceiveMsg;
            Device.whenReceivedRebootDevice += WhenReceivedRebootDevice;
            Device.callBackResultReadComplete = WhenReadComplete;
            Device.whenReceivedFirmwareUpdateProgress += whenReceivedFirmwareUpdateProgress;
            Device.whenReceivedDownloadFirmwareProgress += whenReceivedDownloadFirmwareProgress;

            Device.callBackTriggerHandler += whenReceivedTriggerHandler;

            int i = 0;
            for (i = 0; i < 100; i++)
            {
                HIDfilterTime.Items.Add(i.ToString() + "*1s");
            }
            HIDfilterTime.SelectedIndex = 0;

            for (int j = 0; j < 11; j++)
            {
                HIDinventoryInterval.Items.Add(j.ToString() + "*0.1s");
            }
            HIDinventoryInterval.SelectedIndex = 0;

        }
        /// <summary>
        /// 扫描列表行选中时，将当前的标签内容放置到access tag的tab控件中
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void DatalistView_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (this.DatalistView.SelectedItems.Count > 0)
            {
                ListViewItem row = this.DatalistView.SelectedItems[0];
                if (row != null && row.SubItems[2] != null && row.SubItems[2].Text != null)
                {
                    txtSelectedTag.Text = row.SubItems[2].Text;
                    selectedIndex = this.DatalistView.SelectedItems[0].Index;
                }
            }
        }

        private void MaskStartAddressWord_KeyPress(object sender, KeyPressEventArgs e)
        {
            e.Handled = ("0123456789ABCDEF".IndexOf(Char.ToUpper(e.KeyChar)) < 0);
        }

        private void ReadLenth_KeyPress(object sender, KeyPressEventArgs e)
        {
            e.Handled = ("0123456789ABCDEF".IndexOf(Char.ToUpper(e.KeyChar)) < 0);
        }

        private void password_text_KeyPress(object sender, KeyPressEventArgs e)
        {
            e.Handled = ("0123456789ABCDEF".IndexOf(Char.ToUpper(e.KeyChar)) < 0);
        }

        private void text_off_KeyPress(object sender, KeyPressEventArgs e)
        {
            e.Handled = ("0123456789ABCDEF".IndexOf(Char.ToUpper(e.KeyChar)) < 0);
        }

        private void txtEpc_KeyPress(object sender, KeyPressEventArgs e)
        {
            e.Handled = ("0123456789ABCDEF".IndexOf(Char.ToUpper(e.KeyChar)) < 0);
        }

        private void ReadPassward_KeyPress(object sender, KeyPressEventArgs e)
        {
            e.Handled = ("0123456789ABCDEF".IndexOf(Char.ToUpper(e.KeyChar)) < 0);
        }

        /// <summary>
        /// lock tag
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void buttonLock_Click(object sender, EventArgs e)
        {
            UInt32 error = 0;
            string Epc_string = this.txtSelectedTag.Text;
            if (Epc_string != null)
            {
                Epc_string = Epc_string.Replace(" ", "").Replace("0x", "");
                if (Epc_string.Length % 2 != 0)
                {
                    this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Please input correct epc." + Environment.NewLine);
                    this.Devmes.ScrollToCaret();
                    return;
                }
            }
            Epc_string = Epc_string.Replace(" ", "").Replace("0x", "");
            byte[] yu = { };
            if (Epc_string != null)
            {
                yu = HexStringToByteArray(Epc_string);
            }

            AsReader.TagMask tagMask = new AsReader.TagMask();
            tagMask.userMemoryBit1 = cbMaskUser1.Checked;
            tagMask.userMemoryBit2 = cbMaskUser2.Checked;
            tagMask.tidMemoryBit1 = cbMaskTID1.Checked;
            tagMask.tidMemoryBit2 = cbMaskTID2.Checked;
            tagMask.epcMemoryBit1 = cbMaskEPC1.Checked;
            tagMask.epcMemoryBit2 = cbMaskEPC2.Checked;
            tagMask.accessMemoryBit1 = cbMaskAccess1.Checked;
            tagMask.accessMemoryBit2 = cbMaskAccess2.Checked;
            tagMask.killPwdMemoryBit1 = cbMaskKill1.Checked;
            tagMask.killPwdMemoryBit2 = cbMaskKill2.Checked;

            AsReader.TagAction tagAction = new AsReader.TagAction();
            tagAction.userMemoryBit1 = cbActionUser1.Checked;
            tagAction.userMemoryBit2 = cbActionUser2.Checked;
            tagAction.tidMemoryBit1 = cbActionTID1.Checked;
            tagAction.tidMemoryBit2 = cbActionTID2.Checked;
            tagAction.epcMemoryBit1 = cbActionEPC1.Checked;
            tagAction.epcMemoryBit2 = cbActionEPC2.Checked;
            tagAction.accessMemoryBit1 = cbActionAccess1.Checked;
            tagAction.accessMemoryBit2 = cbActionAccess2.Checked;
            tagAction.killPwdMemoryBit1 = cbActionKill1.Checked;
            tagAction.killPwdMemoryBit2 = cbActionKill2.Checked;

            error = Device.LockMemory(tagMask, tagAction, Convert.ToUInt32(ReadPassward.Text == "" ? "0" : ReadPassward.Text, 16), yu);

            if (error == 1)
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Lock Tag command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
            }
        }

        /// <summary>
        /// ANT power value
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void AntPowerOrReadTimeKeyPress(object sender, KeyPressEventArgs e)
        {
            e.Handled = ("0123456789".IndexOf(Char.ToUpper(e.KeyChar)) < 0);
        }

        /// <summary>
        /// set channel
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnSetChannel_Click(object sender, EventArgs e)
        {
            UInt32 error = Device.SetChannel((uint)Convert.ToInt32(cmbChannel.SelectedValue));

            if (error == 1)
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Set Channel command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
            }
        }

        /// <summary>
        /// get channel
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnGetChannel_Click(object sender, EventArgs e)
        {
            uint channel = 0;
            uint error = 0;
            error = Device.GetChannel(ref channel);
            if (error == 0) cmbChannel.SelectedValue = Convert.ToInt32(channel);

            if (error == 1)
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get Channel command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
            }
        }

        private void cmbCollision_SelectedIndexChanged(object sender, EventArgs e)
        {
            Types.AntiCollisionMode anticollisionmode = (Types.AntiCollisionMode)cmbCollision.SelectedIndex;

            if (anticollisionmode == Types.AntiCollisionMode.FixedQ)
            {
                cmbMinQType.Enabled = false;
                cmbMaxQType.Enabled = false;
            }
            else
            {
                cmbMinQType.Enabled = true;
                cmbMaxQType.Enabled = true;
            }
        }

        /// <summary>
        /// set collision 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnSetCollision_Click(object sender, EventArgs e)
        {
            Types.AntiCollisionMode anticollisionmode = (Types.AntiCollisionMode)cmbCollision.SelectedValue;
            Types.QType startq = (Types.QType)cmbStartQType.SelectedValue;
            Types.QType minq = (Types.QType)cmbMinQType.SelectedValue;
            Types.QType maxq = (Types.QType)cmbMaxQType.SelectedValue;

            if (anticollisionmode == Types.AntiCollisionMode.DynamicQ)
            {
                if (startq < minq || startq > maxq)
                {
                    this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Set Q Start Value Error (Min <= Start <= Max)." + Environment.NewLine);
                    this.Devmes.ScrollToCaret();
                    MessageBox.Show("Set Q Start value is error (Min <= Start <= Max).", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    return;
                }
                if (minq > maxq)
                {
                    this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Set Q Min/Max value is error (Min <= Max)." + Environment.NewLine);
                    this.Devmes.ScrollToCaret();
                    MessageBox.Show("Set Q Min/Max value is error (Min <= Max).", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    return;
                }

            }

            UInt32 error = Device.SetAntiCollisionMode(anticollisionmode, startq, minq, maxq);

            if (error == 1)
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Set Collision command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
            }
        }

        bool getCollisionErr = false;
        /// <summary>
        /// get collision
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnGetCollision_Click(object sender, EventArgs e)
        {
            Types.AntiCollisionMode anticollisionmode = 0;
            Types.QType startq = 0;
            Types.QType minq = 0;
            Types.QType maxq = 0;
            uint error = 0;

            error = Device.GetAntiCollisionMode(ref anticollisionmode, ref startq, ref minq, ref maxq);
            if (error == 0)
            {
                cmbCollision.SelectedValue = Convert.ToInt32(anticollisionmode);
                cmbStartQType.SelectedValue = Convert.ToInt32(startq);
                cmbMinQType.SelectedValue = Convert.ToInt32(minq);
                cmbMaxQType.SelectedValue = Convert.ToInt32(maxq);
                if (anticollisionmode == Types.AntiCollisionMode.FixedQ)
                {
                    cmbMinQType.Enabled = false;
                    cmbMaxQType.Enabled = false;
                }
                else
                {
                    cmbMinQType.Enabled = true;
                    cmbMaxQType.Enabled = true;
                }
                getCollisionErr = false;
            }
            if (error == 1)
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get Collision command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
                getCollisionErr = true;
            }
        }

        /// <summary>
        /// set read time
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnSetReadTime_Click(object sender, EventArgs e)
        {
            UInt32 error = 0;
            if (checkReadTime(txtReadTime1.Text) == false)
            {
                string msg = DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Please input correct antenna read time(10~40000).";
                this.Devmes.AppendText(msg + Environment.NewLine);
                this.Devmes.ScrollToCaret();
                MessageBox.Show("Please input correct antenna read time(10~40000).", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                return;
            }
            error = Device.SetReadTime(Convert.ToUInt32(txtReadTime1.Text));

            if (error == 1)
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Set Read Time command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
            }
        }

        bool getReadTimeErr = false;
        private void btnGetReadTime_Click(object sender, EventArgs e)
        {
            UInt32 readTime1 = 0;
            UInt32 error = 0;

            error = Device.GetReadTime(ref readTime1);
            if (error == 0)
            {
                txtReadTime1.Text = readTime1.ToString();
                getReadTimeErr = false;
            }

            if (error == 1)
            {
                txtReadTime1.Text = "";
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get Read Time command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
                getReadTimeErr = true;
            }
        }

        private void ClearTableData()
        {
            mTagHashTable.Clear();
            this.DatalistView.Items.Clear();
            //dt.Clear();
            selectedIndex = 0;
            this.Devmes.Text = "";

            singluationCount = 0;
            lblTotalDuration.Text = "0";
            lblTotalSingulation.Text = "0";
            lblTotalUnique.Text = "0";
            lblSingulationRate.Text = "0";
            lblAllTagCnt.Text = "0";
        }

        /// <summary>
        /// 
        /// </summary>
        private void ControlsEnabled()
        {
            //isConnected:true => connect succeed
            this.InventorySet.Enabled = isConnected;
            this.tabControl2.Enabled = isConnected;
            this.SelectTag.Enabled = isConnected;
            this.groupBox4.Enabled = isConnected;
            this.LockTag.Enabled = isConnected;
            this.Connect.Enabled = !isConnected;
            this.button2.Enabled = isConnected && connType == "VCP";
            this.ComPort.Enabled = !isConnected;
            //this.txtBaudRate.Enabled = !isConnected;
            this.gbCW.Enabled = isConnected;
            this.StartInventory.Enabled = isConnected;
            this.gbTypes.Enabled = isConnected;
            this.HIDWorkCon.Enabled = isConnected;
            this.grpFirmwareUpdate.Enabled = isConnected;
            this.SearchPortBtn.Enabled = !isConnected;

            this.groupBox5.Enabled = isConnected;
            this.groupBox6.Enabled = isConnected;
            this.BasicInfo.Enabled = isConnected;

            //this.GetFWVersionBtn.Enabled = isConnected;
        }

        /// <summary>
        /// 
        /// </summary>
        private void SetCombolList()
        {
            this.cmbTarget.DataSource = Device.getComboxList(typeof(Types.TargetType));
            this.cmbTarget.DisplayMember = "name";
            this.cmbTarget.ValueMember = "value";
            this.cmbTarget.SelectedIndex = 0;

            this.cmbAction.DataSource = Device.getComboxList(typeof(Types.ActionType));
            this.cmbAction.DisplayMember = "name";
            this.cmbAction.ValueMember = "value";
            this.cmbAction.SelectedIndex = 0;

            this.cmbRegion.DataSource = Device.getComboxList(typeof(Types.RegionType));
            this.cmbRegion.DisplayMember = "name";
            this.cmbRegion.ValueMember = "value";
            this.cmbRegion.SelectedIndex = 0;

            this.cmbSession.DataSource = Device.getComboxList(typeof(Types.SessionType));
            this.cmbSession.DisplayMember = "name";
            this.cmbSession.ValueMember = "value";
            this.cmbSession.SelectedIndex = 0;

            this.cmbCollision.DataSource = Device.getComboxList(typeof(Types.AntiCollisionMode));
            this.cmbCollision.DisplayMember = "name";
            this.cmbCollision.ValueMember = "value";
            this.cmbCollision.SelectedIndex = 0;

            this.cmbStartQType.DataSource = Device.getComboxListByName(typeof(Types.QType), "dicQ");
            this.cmbStartQType.DisplayMember = "name";
            this.cmbStartQType.ValueMember = "value";
            this.cmbStartQType.SelectedIndex = 0;

            this.cmbMinQType.DataSource = Device.getComboxListByName(typeof(Types.QType), "dicQ");
            this.cmbMinQType.DisplayMember = "name";
            this.cmbMinQType.ValueMember = "value";
            this.cmbMinQType.SelectedIndex = 0;

            this.cmbMaxQType.DataSource = Device.getComboxListByName(typeof(Types.QType), "dicQ");
            this.cmbMaxQType.DisplayMember = "name";
            this.cmbMaxQType.ValueMember = "value";
            this.cmbMaxQType.SelectedIndex = 0;


            this.cmbBuzzer.DataSource = Device.getComboxList(typeof(Types.Buzzer));
            this.cmbBuzzer.DisplayMember = "name";
            this.cmbBuzzer.ValueMember = "value";
            this.cmbBuzzer.SelectedIndex = 0;

            this.cmbBasicTarget.DataSource = Device.getComboxListByName(typeof(Types.TargetABType), "dicQryTarget");
            this.cmbBasicTarget.DisplayMember = "name";
            this.cmbBasicTarget.ValueMember = "value";
            this.cmbBasicTarget.SelectedIndex = 0;

            this.cmbSelectionEnable.DataSource = Device.getComboxList(typeof(Types.SelectionEnable));
            this.cmbSelectionEnable.DisplayMember = "name";
            this.cmbSelectionEnable.ValueMember = "value";
            this.cmbSelectionEnable.SelectedIndex = 0;

        }

        private void StopInventory()
        {
            StartInventory.Text = "Start";
            StartInventory.Enabled = false;
            readTimer.Enabled = false;
            //if (m_bInventory) while (Device.StopInventory() != 0) ;
            if (m_bInventory)
            {
                Device.StopInventory();
            }
            m_bInventory = false;
            StartInventory.Enabled = true;
            ClearTableData();
        }

        public static string[] GetPortList()
        {
            return SerialPort.GetPortNames();
        }

        void SetReaderTagDataList(AsReader.InventoryResult tagcallbackdata)
        {
            singluationCount++;

            mReadTag = tagcallbackdata;
            string epc = tagcallbackdata.tagdata.epc;
            string pc = tagcallbackdata.tagdata.pc;
            string tid = tagcallbackdata.tagdata.tid;
            string tagdata = tagcallbackdata.tagdata.data;

            //DataRow dr;
            //dr = dt.NewRow();
            //dr["Index"] = singluationCount.ToString();
            //dr["PC"] = pc;
            //dr["EPC"] = epc;
            //dr["Time"] = DateTime.Now.ToString("yyyy-MM-dd HH_mm_ss fff");
            //dt.Rows.Add(dr);


            if (epc != null)
            {
                if (!mTagHashTable.ContainsKey(epc))
                {
                    mTagHashTable.Add(epc, this.DatalistView.Items.Count);

                    ListViewItem item = new ListViewItem();
                    item.Text = (this.DatalistView.Items.Count + 1).ToString();
                    item.SubItems.Add(Convert.ToString(tagcallbackdata.tagdata.pc));
                    item.SubItems.Add(Convert.ToString(tagcallbackdata.tagdata.epc));
                    //item.SubItems.Add(Convert.ToString(tagcallbackdata.tagdata.tid));
                    item.SubItems.Add(Convert.ToString(tagcallbackdata.rssi));
                    item.SubItems.Add(Convert.ToString(tagcallbackdata.tagdata.data));
                    //item.SubItems.Add(Convert.ToString(tagcallbackdata.antenna));
                    item.SubItems.Add(DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss"));
                    item.SubItems.Add("1");


                    this.DatalistView.Items.Add(item);
                }
                else
                {
                    int count = (int)mTagHashTable[epc];
                    ListViewItem item = this.DatalistView.Items[count];
                    item.SubItems[3].Text = Convert.ToString(tagcallbackdata.rssi);
                    item.SubItems[4].Text = Convert.ToString(tagcallbackdata.tagdata.data);
                    //item.SubItems[5].Text = Convert.ToString(tagcallbackdata.antenna);
                    item.SubItems[5].Text = DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss");
                    item.SubItems[6].Text = (Convert.ToInt32(item.SubItems[6].Text) + 1).ToString();

                }

            }
            if (epc == null && tid != null)
            {
                if (!mTagHashTable.ContainsKey(tid))
                {
                    mTagHashTable.Add(tid, this.DatalistView.Items.Count);

                    ListViewItem item = new ListViewItem();
                    item.Text = (this.DatalistView.Items.Count + 1).ToString();
                    item.SubItems.Add(Convert.ToString(tagcallbackdata.tagdata.pc));
                    item.SubItems.Add(Convert.ToString(tagcallbackdata.tagdata.epc));
                    //item.SubItems.Add(Convert.ToString(tagcallbackdata.tagdata.tid));
                    item.SubItems.Add(Convert.ToString(tagcallbackdata.rssi));
                    item.SubItems.Add(Convert.ToString(tagcallbackdata.tagdata.data));
                    //item.SubItems.Add(Convert.ToString(tagcallbackdata.antenna));
                    item.SubItems.Add(DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss"));
                    item.SubItems.Add("1");


                    this.DatalistView.Items.Add(item);
                }
                else
                {
                    int count = (int)mTagHashTable[tid];

                    ListViewItem item = this.DatalistView.Items[count];
                    item.SubItems[3].Text = Convert.ToString(tagcallbackdata.rssi);
                    item.SubItems[4].Text = Convert.ToString(tagcallbackdata.tagdata.data);

                    item.SubItems[5].Text = DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss");
                    item.SubItems[6].Text = (Convert.ToInt32(item.SubItems[6].Text) + 1).ToString();

                }
            }
            if (epc == null && tid == null && tagdata != null)
            {
                if (!mTagHashTable.ContainsKey(tagdata))
                {
                    mTagHashTable.Add(tagdata, this.DatalistView.Items.Count);

                    ListViewItem item = new ListViewItem();
                    item.Text = (this.DatalistView.Items.Count + 1).ToString();
                    item.SubItems.Add(Convert.ToString(tagcallbackdata.tagdata.pc));
                    item.SubItems.Add(Convert.ToString(tagcallbackdata.tagdata.epc));
                    //item.SubItems.Add(Convert.ToString(tagcallbackdata.tagdata.tid));
                    item.SubItems.Add(Convert.ToString(tagcallbackdata.rssi));
                    item.SubItems.Add(Convert.ToString(tagcallbackdata.tagdata.data));
                    //item.SubItems.Add(Convert.ToString(tagcallbackdata.antenna));
                    item.SubItems.Add(DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss"));
                    item.SubItems.Add("1");


                    this.DatalistView.Items.Add(item);
                }
                else
                {
                    int count = (int)mTagHashTable[tagdata];

                    ListViewItem item = this.DatalistView.Items[count];
                    item.SubItems[3].Text = Convert.ToString(tagcallbackdata.rssi);
                    item.SubItems[4].Text = Convert.ToString(tagcallbackdata.tagdata.data);

                    item.SubItems[5].Text = DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss");
                    item.SubItems[6].Text = (Convert.ToInt32(item.SubItems[6].Text) + 1).ToString();

                }
            }

            lblTotalSingulation.Text = singluationCount.ToString();
            lblTotalUnique.Text = DatalistView.Items.Count.ToString();
            lblAllTagCnt.Text = DatalistView.Items.Count.ToString();
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="rdtag"></param>
        private void ShowTagData(AsReader.InventoryResult rdtag)
        {
            ProcessDelegate mainProcess = delegate ()
            {
                SetReaderTagDataList(rdtag);

                if (this.DatalistView.Items.Count > 0)
                {
                    //this.DatalistView.Items[selectedIndex].Selected = true;
                    this.DatalistView.Items[selectedIndex].EnsureVisible();
                }

            };

            this.Invoke(mainProcess);

        }
        private void WhenReadComplete(bool completeStatus)
        {
            ProcessDelegate mainProcess = delegate ()
            {
                UInt32 error = 0;
                this.StartInventory.Enabled = false;
                if (m_bInventory && completeStatus)
                {
                    error = Device.StopInventory();
                    if (error != 0)
                    {
                        this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Stop Inventory command sent failed." + Environment.NewLine);
                        this.Devmes.ScrollToCaret();
                        this.StartInventory.Enabled = true;
                        return;
                    }
                    m_bInventory = false;
                    readTimer.Enabled = false;
                    this.StartInventory.Text = "Start";

                    this.groupBox6.Enabled = true;
                    this.groupBox5.Enabled = true;

                    FileName += "_" + DateTime.Now.ToString("yyyyMMddHHmmssfff") + ".csv";
                    Thread.Sleep(200);
                    ExportCSV(FileName);
                }

                this.StartInventory.Enabled = true;
            };

            this.Invoke(mainProcess);

        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        private UInt32 StartInventoryByTypes()
        {
            UInt32 error = 0;
            bool parseRet = false;
            byte outTagCount = 0;
            parseRet = byte.TryParse(txtTagCount.Text, out outTagCount);

            if (parseRet == false)
            {
                string msg = DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Parameter error: Tag Count.";
                this.Devmes.AppendText(msg + Environment.NewLine);
                this.Devmes.ScrollToCaret();
                return 999;
            }
            byte outElapsedTime = 0;
            parseRet = byte.TryParse(txtElapsedTime.Text, out outElapsedTime);

            if (parseRet == false)
            {
                string msg = DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Parameter error: Elapsed Time.";
                this.Devmes.AppendText(msg + Environment.NewLine);
                this.Devmes.ScrollToCaret();
                return 999;
            }

            ushort inventoryRound = 0;
            parseRet = ushort.TryParse(this.txtInventoryRound.Text, out inventoryRound);

            if (parseRet == false)
            {
                string msg = DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Parameter error: Inventory Round.";
                this.Devmes.AppendText(msg + Environment.NewLine);
                this.Devmes.ScrollToCaret();
                return 999;
            }
            error = Device.StartInventory(
                rbRssiOn.Checked ? true : false,
                outTagCount,
                outElapsedTime,
                inventoryRound,
                cbAnt1.Checked);
            return error;
        }

        private bool checkReadTime(string readTime)
        {
            if (readTime == "")
            {
                return false;
            }
            else if (Convert.ToUInt32(readTime) < 10 || Convert.ToUInt32(readTime) > 40000)
            {
                return false;
            }
            return true;
        }

        private void ShowErrorMsg(uint error)
        {
            ProcessDelegate mainProcess = delegate ()
            {
                ShowErrorMessage(error);
            };

            this.Invoke(mainProcess);

        }

        private void ShowErrorMessage(uint error)
        {
            if (Enum.IsDefined(typeof(Types.ErrorCode), Convert.ToInt32(error)))
            {
                string message = Enum.Parse(typeof(Types.ErrorCode), Convert.ToString(error)).ToString();
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " 0x" + Convert.ToString(error, 16) + ":" + message + Environment.NewLine);
            }
            else
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " 0x" + Convert.ToString(error, 16) + ":" + " Unkown error." + Environment.NewLine);
            }
            this.Devmes.ScrollToCaret();
        }

        private void ShowSuccessMsg(uint success)
        {
            ProcessDelegate mainProcess = delegate ()
            {
                ShowSuccessMessage(success);
            };

            this.Invoke(mainProcess);
        }

        private void ShowSuccessMessage(uint success)
        {
            if (Enum.IsDefined(typeof(Types.SuccessCode), Convert.ToInt32(success)))
            {
                string message = Enum.Parse(typeof(Types.SuccessCode), Convert.ToString(success)).ToString();
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " 0x" + Convert.ToString(success, 16) + ":" + message + Environment.NewLine);
            }
            else
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " 0x" + Convert.ToString(success, 16) + ":" + " Unkown success code." + Environment.NewLine);
            }
            this.Devmes.ScrollToCaret();
        }

        private void GetSdkVersion_load()
        {
            string sdkVersion = "";
            this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get SDK Version " + Environment.NewLine);
            Device.GetSdkVersion(ref sdkVersion);
            tx_sdkversion.Text = sdkVersion;
        }

        private void GetProductSN_load()
        {
            uint error = 0;
            string productSN = "";
            error = Device.GetProductSN(ref productSN);
            if (error == 0)
            {
                tx_productSN.Text = productSN;
            }
            else
            {
                tx_productSN.Text = "";
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get S/N command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
            }
        }

        private void btnDefaultSetting_Click(object sender, EventArgs e)
        {
            bool successed = Device.DefaultSetting();
            if (!successed)
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + "Default Setting command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
            }
            else
            {
                btnGetRegion_Click(btnGetRegion, e);
                Thread.Sleep(100);
                btnGetMask_Click(btnGetMask, e);
                Thread.Sleep(100);
                btnGetMaskEnable_Click(btnGetMaskEnable, null);
                Thread.Sleep(100);
                HIDGetBtn_Click(HIDgetBtn, e);
                Thread.Sleep(100);
                buzzerGetBtn_Click(buzzerGetBtn, e);
                Thread.Sleep(100);
                btnGetRSSIThreshold_Click(btnGetRSSIThreshold, e);
            }
        }
        private bool checkIdleTime(string idelTime)
        {
            if (idelTime == "")
            {
                return false;
            }
            else if (Convert.ToUInt32(idelTime) < 0 || Convert.ToUInt32(idelTime) > 40000)
            {
                return false;
            }
            return true;
        }


        private void btnSetIdleTime_Click(object sender, EventArgs e)
        {
            uint error = 0;
            uint idelTime = 0;
            if (checkIdleTime(txtIdelTime.Text) == false)
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Please input correct antenna idle time(0~40000)." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
                MessageBox.Show("Please input correct antenna idle time(0~40000).", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                return;
            }
            if (uint.TryParse(txtIdelTime.Text, out idelTime) == false)
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Please input correct antenna idle time(0~40000)." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
                MessageBox.Show("Please input correct antenna idle time(0~40000).", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                return;
            }
            error = Device.SetIdelTime(idelTime);

            if (error == 1)
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Set Idel Time command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
            }
        }

        bool getIdleTimeErr = false;
        private void btnGetIdleTime_Click(object sender, EventArgs e)
        {
            uint idelTime = 0;
            uint error = 0;
            error = Device.GetIdelTime(ref idelTime);
            if (error == 0)
            {
                txtIdelTime.Text = idelTime.ToString();
                getIdleTimeErr = false;
            }
            else
            {
                txtIdelTime.Text = "";
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get Idel Time command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
                getIdleTimeErr = true;
            }

        }
        private void readTimer_Tick(object sender, EventArgs e)
        {
            int duration = (System.Environment.TickCount - total_time);
            lblTotalDuration.Text = duration.ToString();
            lblSingulationRate.Text = (((float)singluationCount * 1000) / (float)duration).ToString("F01");
        }

        private void txtPower1_TextChanged(object sender, EventArgs e)
        {

        }

        private void commonCheckBoxCheckedChanged(object sender)
        {
            if ((sender as CheckBox).Checked == true)
            {
                foreach (CheckBox isCheckbox in (sender as CheckBox).Parent.Controls)
                {
                    if (isCheckbox != sender)
                    {
                        isCheckbox.Checked = false;
                    }
                }
            }
        }
        private void enterCheckBox_CheckedChanged(object sender, EventArgs e)
        {
            commonCheckBoxCheckedChanged(sender);
        }

        private void tabCheckBox_CheckedChanged(object sender, EventArgs e)
        {
            commonCheckBoxCheckedChanged(sender);
        }

        private void backspaceCheckBox_CheckedChanged(object sender, EventArgs e)
        {
            commonCheckBoxCheckedChanged(sender);
        }

        private void commaCheckBox_CheckedChanged(object sender, EventArgs e)
        {
            commonCheckBoxCheckedChanged(sender);
        }


        private void tabControl1_SelectedIndexChanged(object sender, EventArgs e)
        {
            try
            {
                if (tabControl1.SelectedTab.Name == "SettingPage")
                {
                    SettingComboBoxStatus();
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine("StartAddress_KeyUp: " + ex.Message);
            }
        }

        private void HIDStartAddress_KeyUp(object sender, KeyEventArgs e)
        {
            try
            {
                SettingComboBoxStatus();
            }
            catch (Exception ex)
            {
                Console.WriteLine("StartAddress_KeyUp: " + ex.Message);
            }

        }
        private void HIDReadLength_KeyUp(object sender, KeyEventArgs e)
        {
            try
            {
                SettingComboBoxStatus();
            }
            catch (Exception ex)
            {
                Console.WriteLine("ReadLength_KeyUp: " + ex.Message);
            }
        }

        private void SettingComboBoxStatus()
        {
            if (epcCheckBox.Checked || tidCheckBox.Checked)
            {
                HIDfilterTime.SelectedIndex = 0;
                HIDfilterTime.Enabled = false;
            }
            else
            {
                if (HIDstartAddress.Text == "0" && HIDreadLength.Text == "0")
                {
                    HIDfilterTime.SelectedIndex = 0;
                    HIDfilterTime.Enabled = false;
                }
                else
                {
                    HIDfilterTime.Enabled = true;
                }
            }

            if (HIDstartAddress.Text == "0" && HIDreadLength.Text == "0" && epcRadioBtn.Checked)
            {
                HIDinventoryInterval.Enabled = true;
            }
            else
            {
                HIDinventoryInterval.SelectedIndex = 0;
                HIDinventoryInterval.Enabled = false;
            }

            if (HIDstartAddress.Text == "0" && HIDreadLength.Text == "0")
            {
                epcCheckBox.Checked = false;
                epcCheckBox.Enabled = false;
                tidCheckBox.Checked = false;
                tidCheckBox.Enabled = false;
            }
            else
            {
                epcCheckBox.Enabled = true;
                tidCheckBox.Enabled = true;
            }

        }

        private void AsReaderP3xU_Demo_FormClosing(object sender, FormClosingEventArgs e)
        {
            UInt32 error = 0;
            this.StartInventory.Enabled = false;
            if (m_bInventory)
            {

                error = Device.StopInventory();


                FileName += "_" + DateTime.Now.ToString("yyyyMMddHHmmssfff") + ".csv";
                ExportCSV(FileName);
            }
            if (isConnected)
            {
                Device.DisConnect();
            }
        }

        private void HIDsetBtn_Click(object sender, EventArgs e)
        {
            try
            {
                int hid_adr = 0;
                int hid_len = 0;
                int hid_filter_time = 0;
                byte repeat_epc_tid = 0;
                int hid_inventory = 0;
                byte epc_tid_user = 0;
                byte output_suffix = 0;
                byte output_without = 0;
                uint error = 0;

                if ((HIDstartAddress.Text.Trim() == "") || (HIDreadLength.Text.Trim() == "") || Convert.ToInt32(HIDstartAddress.Text.Trim()) > 255 || Convert.ToInt32(HIDstartAddress.Text.Trim()) < 0)
                {
                    MessageBox.Show("Set failed: Start Address Parameter Error");
                    return;
                }
                if ((HIDreadLength.Text.Trim() == "") || (HIDreadLength.Text.Trim() == "") || Convert.ToInt32(HIDreadLength.Text.Trim()) > 15 || Convert.ToInt32(HIDreadLength.Text.Trim()) < 0)
                {
                    MessageBox.Show("Set failed: Read Length Parameter Error");
                    return;
                }

                hid_adr = Convert.ToInt32(HIDstartAddress.Text.Trim());
                hid_len = Convert.ToInt32(HIDreadLength.Text.Trim());

                if (HIDinventoryInterval.Items.Count > 0)
                {
                    hid_inventory = HIDinventoryInterval.SelectedIndex;
                }

                if (HIDfilterTime.Items.Count > 0)
                {
                    hid_filter_time = HIDfilterTime.SelectedIndex;
                }

                if (repeatEpcRadioBtn.Checked)
                {
                    repeat_epc_tid = (byte)Types.HidRepeatEpcTid.IS_CHECKED_EPC;
                }
                else
                {
                    repeat_epc_tid = (byte)Types.HidRepeatEpcTid.IS_CHECKED_TID;
                }

                if (epcRadioBtn.Checked)
                {
                    epc_tid_user = (byte)Types.HidEpcTidUser.EPC;
                }
                else if (tidRadioBtn.Checked)
                {
                    epc_tid_user = (byte)Types.HidEpcTidUser.TID;
                }
                else
                {
                    epc_tid_user = (byte)Types.HidEpcTidUser.USER;
                }

                if (enterCheckBox.Checked)
                {
                    output_suffix = (byte)Types.HidOutputSuffix.ENTER;
                }
                else if (tabCheckBox.Checked)
                {
                    output_suffix = (byte)Types.HidOutputSuffix.TAB;
                }
                else if (backspaceCheckBox.Checked)
                {
                    output_suffix = (byte)Types.HidOutputSuffix.BACKSPACE;
                }
                else if (commaCheckBox.Checked)
                {
                    output_suffix = (byte)Types.HidOutputSuffix.COMMA;
                }
                else
                {
                    output_suffix = (byte)Types.HidOutputSuffix.NO_CHECKED;
                }
                if (epcCheckBox.Checked)
                {
                    output_without = (byte)Types.HidOutputWithout.IS_CHECKED;
                }
                else if (tidCheckBox.Checked)
                {
                    output_without = (byte)Types.HidOutputWithout.IS_TID_CHECKED;
                }
                else
                {
                    output_without = (byte)Types.HidOutputWithout.NO_CHECKED;
                }

                error = Device.SetHIDWorkParams(hid_adr, hid_len, hid_inventory, hid_filter_time, repeat_epc_tid, epc_tid_user, output_suffix, output_without);

                if (error == 1)
                {
                    this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Set HID work parameter sent failed." + Environment.NewLine);
                    this.Devmes.ScrollToCaret();
                }

            }
            catch (Exception ex)
            {
                MessageBox.Show("Set failed: " + ex.Message);
            }
        }

        private void HIDGetBtn_Click(object sender, EventArgs e)
        {
            try
            {
                int hid_adr = 0;
                int hid_len = 0;
                int hid_filter_time = 0;
                int hid_inventory = 0;
                Types.HidRepeatEpcTid repeat_epc_tid = 0;
                Types.HidEpcTidUser epc_tid_user = 0;
                Types.HidOutputSuffix output_suffix = 0;
                Types.HidOutputWithout output_without = 0;
                uint error = 0;

                error = Device.GetHIDWorkParams(ref hid_adr, ref hid_len, ref hid_inventory, ref repeat_epc_tid, ref hid_filter_time, ref epc_tid_user, ref output_suffix, ref output_without);
                if (error == 0)
                {
                    if (epc_tid_user == Types.HidEpcTidUser.EPC)
                    {
                        epcRadioBtn.Checked = true;
                    }
                    else if (epc_tid_user == Types.HidEpcTidUser.TID)
                    {
                        tidRadioBtn.Checked = true;
                    }
                    else
                    {
                        userRadioBtn.Checked = true;
                    }

                    HIDstartAddress.Text = hid_adr.ToString();
                    HIDreadLength.Text = hid_len.ToString();
                    SettingComboBoxStatus();

                    if (repeat_epc_tid == Types.HidRepeatEpcTid.IS_CHECKED_EPC)
                    {
                        repeatEpcRadioBtn.Checked = true;
                    }
                    else
                    {
                        repeatTidRadioBtn.Checked = true;
                    }

                    if (output_suffix == Types.HidOutputSuffix.ENTER)
                    {
                        enterCheckBox.Checked = true;
                    }
                    else if (output_suffix == Types.HidOutputSuffix.TAB)
                    {
                        tabCheckBox.Checked = true;
                    }
                    else if (output_suffix == Types.HidOutputSuffix.BACKSPACE)
                    {
                        backspaceCheckBox.Checked = true;
                    }
                    else if (output_suffix == Types.HidOutputSuffix.COMMA)
                    {
                        commaCheckBox.Checked = true;
                    }
                    else
                    {
                        enterCheckBox.Checked = false;
                        tabCheckBox.Checked = false;
                        backspaceCheckBox.Checked = false;
                        commaCheckBox.Checked = false;
                    }

                    if (output_without == Types.HidOutputWithout.IS_CHECKED)
                    {
                        epcCheckBox.Checked = true;
                    }
                    else if (output_without == Types.HidOutputWithout.IS_TID_CHECKED)
                    {
                        tidCheckBox.Checked = true;
                    }
                    else
                    {
                        epcCheckBox.Checked = false;
                        epcCheckBox.Checked = false;
                    }

                    if (HIDinventoryInterval.Items.Count > hid_inventory)
                    {
                        HIDinventoryInterval.SelectedIndex = hid_inventory;
                    }

                    if (HIDfilterTime.Items.Count > hid_filter_time)
                    {
                        HIDfilterTime.SelectedIndex = hid_filter_time;
                    }

                }
                else
                {
                    this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get HID work parameter sent failed." + Environment.NewLine);
                    this.Devmes.ScrollToCaret();
                }

            }
            catch (Exception ex)
            {
                MessageBox.Show("Get failed: " + ex.Message);
            }
        }

        private void buzzerSetBtn_Click(object sender, EventArgs e)
        {
            try
            {
                uint error = 0;
                error = Device.SetBuzzer((Types.Buzzer)cmbBuzzer.SelectedValue);

                if (error == 1)
                {
                    this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Set HID Buzzer sent failed." + Environment.NewLine);
                    this.Devmes.ScrollToCaret();
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show("Set failed: " + ex.Message);
            }
        }

        private void buzzerGetBtn_Click(object sender, EventArgs e)
        {
            try
            {
                Types.Buzzer buzzer = 0;
                uint error = 0;

                error = Device.GetBuzzer(ref buzzer);
                if (error == 0)
                {
                    cmbBuzzer.SelectedValue = Convert.ToInt32(buzzer);
                }
                else
                {
                    this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get HID Buzzer sent failed." + Environment.NewLine);
                    this.Devmes.ScrollToCaret();
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show("Get failed: " + ex.Message);
            }
        }

        private void GetFWVersionBtn_Click(object sender, EventArgs e)
        {
            uint error = 0;
            string fwVersion = "";
            error = Device.GetFwVersion(ref fwVersion);
            if (error == 0)
            {
                txtFirmwareVer.Text = fwVersion;
            }
            else
            {
                txtFirmwareVer.Text = "";
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get Fw Version command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
            }
        }

        [Obsolete]
        private void btnGetBins_Click(object sender, EventArgs e)
        {
            try
            {
                string hwVer = Device.hwVer;
                if (hwVer == null || hwVer == "") {
                    hwVer = "HW1.0.1";
                }
                if (((Button)sender).Text == "Cancel")
                {
                    ((Button)sender).Text = "Get Files";
                    return;
                }
                else
                {
                    if (hwVer == null)
                    {
                        MessageBox.Show("Please get HW Version.", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                        return;
                    }

                    ((Button)sender).Text = "Cancel";  
                }
                string fwXmlURL = Device.fwURL + Device.fwXmlName;
                XmlDataDocument xmlDoc = new XmlDataDocument();
                DataSet myDataSet = xmlDoc.DataSet;
                myDataSet.ReadXml(fwXmlURL);
                int strIndex = hwVer.LastIndexOf(".") + 1;
                string value = hwVer.Substring(strIndex);
                if (value == "0") {
                    value = "1";
                }
                string vx = "V" + value;
                for (int i = 0; i < myDataSet.Tables[0].Rows.Count; i++) {
                    string FwFileNameStr = myDataSet.Tables[0].Rows[i]["FwFileName"].ToString();
                    int strIndex1 = FwFileNameStr.LastIndexOf("_") + 1;
                    string Version = FwFileNameStr.Substring(strIndex1);
                    if (!Version.Contains(vx)) {
                        myDataSet.Tables[0].Rows[i].Delete();
                        i--;
                    }
                }

                cmbBinFiles.DataSource = myDataSet.Tables[0];
                cmbBinFiles.DisplayMember = "FwFileName";
                ((Button)sender).Text = "Get Files";
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
                MessageBox.Show("Get bin files failed.", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get bin files failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
            }
        }

        private void btnFirmwareUpdate_Click(object sender, EventArgs e)
        {
            try
            {
                if (MessageBox.Show("Do you want to update now?", "Update Firmware", MessageBoxButtons.YesNo, MessageBoxIcon.Information) == DialogResult.No)
                {
                    return;
                }
                if (((Button)sender).Text == "Updating")
                {
                    MessageBox.Show("Firmware is updating...", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    return;
                }
                if (cmbBinFiles.Items.Count == 0)
                {
                    MessageBox.Show("Please get bin files!", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    return;
                }
                if (cmbBinFiles.SelectedIndex < 0)
                {
                    MessageBox.Show("Please select a file!", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    return;
                }
                if (btnFirmwareUpdate.Text == "Update")
                {
                    btnFirmwareUpdate.Text = "Updating";
                }

                string filename = cmbBinFiles.Text.ToString().Trim();

                this.updateWord.Visible = true;
                progressBar2.Visible = true;
                progressBar2.Value = 0;
                progressBar2.Style = ProgressBarStyle.Blocks;
                progressBar2.Maximum = 3;
                progressBar2.Minimum = 0;
                progressBar2.MarqueeAnimationSpeed = 100;
                progressBar2.Step = 1;

                UpdateControlsEnabled(false);

                bool status = Device.DownloadFirmwareFile("FW",filename);
                progressBar2.PerformStep();
                progressBar2.Visible = false;
                Thread.Sleep(500);
                string filePath = Device.firmwareFolderNmae + @"\" + filename;
                //return;
                if (status && File.Exists(filePath))
                {

                    FileStream myStream = new FileStream(filePath, FileMode.Open, FileAccess.Read);
                    int bytes = (int)myStream.Length;
                    myStream.Close();
                    int countPicket = (int)Math.Ceiling((decimal)(bytes / 2) / 50);

                    progressBar1.Visible = true;
                    progressBar1.Value = 0;
                    progressBar1.Style = ProgressBarStyle.Blocks;
                    progressBar1.Maximum = countPicket + 2;
                    progressBar1.Minimum = 0;
                    progressBar1.MarqueeAnimationSpeed = 100;
                    progressBar1.Step = 1;

                    bool updateStatus = Device.FirmwareUpdate(filePath);
                    if (updateStatus)
                    {
                        if (MessageBox.Show("Update Firmware Success! Do you want to reboot now?", "Update Firmware Information", MessageBoxButtons.YesNo, MessageBoxIcon.Information) == DialogResult.Yes)
                        {
                            RebootDevice();
                        }
                    }
                    else
                    {
                        MessageBox.Show("Update Firmware failed!", "Update Firmware", MessageBoxButtons.OK);
                    }
                }
                else
                {
                    string msgTitle = "Warning";
                    string msg = "Demo App: Download firmware file failed. No available firmware for update. ";
                    MessageBox.Show(msg, msgTitle, MessageBoxButtons.OK);
                }
                btnFirmwareUpdate.Text = "Update";

                progressBar1.PerformStep();
                progressBar1.Visible = false;
                this.updateWord.Visible = false;
                UpdateControlsEnabled(true);
                ControlsEnabled();
            }
            catch (Exception ex)
            {
                UpdateControlsEnabled(true);
                progressBar1.Visible = false;
                progressBar2.Visible = false;
                this.updateWord.Visible = false;
                Console.WriteLine(ex.Message);
                MessageBox.Show(ex.Message, "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
            }
        }

        private void UpdateControlsEnabled(bool status)
        {
            this.groupBox1.Enabled = status;
            this.grpFirmwareUpdate.Enabled = status;
            this.tabControl1.Enabled = status;
            this.tabControl2.Enabled = status;

        }

        private void RebootDevice()
        {
            try
            {

                bool status = Device.RebootDevice();
                if (status)
                {
                    Thread.Sleep(1000);
                    btnVcpDisconnect_Click(button2, null);
                    MessageBox.Show("Device must be reconnected for normal use!", "Warning");
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show("Reboot Device: " + ex.Message);
            }
        }

        private void WhenReceivedRebootDevice(byte[] packetRx, string strPacket)
        {
            try
            {
                if (strPacket.Trim() != "BB 01 5B 00 01 00 7E 1A 14")
                {
                    this.Invoke((EventHandler)delegate
                    {
                        this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + "Reboot device failed." + Environment.NewLine);
                        this.Devmes.ScrollToCaret();
                    });
                }
                else
                {
                    this.Invoke((EventHandler)delegate
                    {
                        this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + "Reboot device succeeded." + Environment.NewLine);
                        this.Devmes.ScrollToCaret();
                    });
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show("Receive Reboot Device Message failed: " + ex.Message);
            }
        }

        private void WhenShowReceiveMsg(string strLog)
        {
            try
            {
                this.Invoke((EventHandler)delegate
                {
                    this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " " + strLog + Environment.NewLine);
                    this.Devmes.ScrollToCaret();
                });
            }
            catch (Exception ex)
            {
                MessageBox.Show("Receive Msg failed: " + ex.Message);
            }
        }

        private void SearchPortBtn_Click(object sender, EventArgs e)
        {
            string[] vcpPort = GetPortList();
            int i = 0;
            ComPort.Items.Clear();
            //有限判断是否开通端口模式
            if (vcpPort.Length > 0)
            {
                for (i = 0; i < vcpPort.Length; i++)
                {
                    this.ComPort.Items.Add(vcpPort[i]);
                }
                if (i > 0)
                    this.ComPort.SelectedIndex = 0;
            }
        }

        private void btnSetTarget_Click(object sender, EventArgs e)
        {
            Types.TargetABType target = (Types.TargetABType)cmbBasicTarget.SelectedValue;
            UInt32 error = 0;
            //session范围：0~3
            error = Device.SetBasicTarget(target);

            if (error == 1)
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Set Session command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
            }
        }

        bool getTargetErr = false;
        private void btnGetTarget_Click(object sender, EventArgs e)
        {
            Types.TargetABType target = 0;
            UInt32 error = 0;
            error = Device.GetBasicTarget(ref target);
            if (error == 0)
            {
                getTargetErr = false;
                cmbBasicTarget.SelectedValue = Convert.ToInt32(target);
            }

            if (error == 1)
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get Target command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
                getTargetErr = true;
            }
        }

        private void epcCheckBox_CheckedChanged(object sender, EventArgs e)
        {
            commonCheckBoxCheckedChanged(sender);
            try
            {
                SettingComboBoxStatus();
            }
            catch (Exception ex)
            {
                Console.WriteLine("StartAddress_KeyUp: " + ex.Message);
            }


        }

        private void tidCheckBox_CheckedChanged(object sender, EventArgs e)
        {
            commonCheckBoxCheckedChanged(sender);
            try
            {
                SettingComboBoxStatus();
            }
            catch (Exception ex)
            {
                Console.WriteLine("StartAddress_KeyUp: " + ex.Message);
            }
        }

        private void whenReceivedFirmwareUpdateProgress()
        {
            this.Invoke(
                new Action(
                    delegate {
                        progressBar1.PerformStep();
                    }));
        }

        private void whenReceivedDownloadFirmwareProgress()
        {
            this.Invoke(
                new Action(
                    delegate {
                        progressBar2.PerformStep();
                    }));
        }

        private void SetFHbtn_Click(object sender, EventArgs e)
        {
            UInt32 error = 0;
            bool status = FHcheckBox.Checked;
            error = Device.SetFrequencyAutomatic(status);

            if (error == 1)
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Set Frequency Automatic command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
            }
            else
            {
                btnGetChannel_Click(null, null);
            }

        }

        bool getFHErr = false;
        private void GetFHbtn_Click(object sender, EventArgs e)
        {
            UInt32 error = 0;
            bool status = false;

            error = Device.GetFrequencyAutomatic(ref status);
            if (error == 0)
            {
                FHcheckBox.Checked = status;
                getFHErr = false;
                btnGetChannel_Click(null, null);
            }

            if (error == 1)
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get Frequency Automatic command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
                getFHErr = true;
            }
        }

        private void FHcheckBox_CheckedChanged(object sender, EventArgs e)
        {
            if (FHcheckBox.Checked)
            {
                cmbChannel.Enabled = false;
            }
            else
            {
                cmbChannel.Enabled = true;
            }
        }

        private void whenReceivedTriggerHandler(int triggerHandler)
        {
            ProcessDelegate mainProcess = delegate ()
            {
                if (triggerHandler == 0x01)
                {
                    KeyPressNum = KeyPressNum + 1;
                }
                if (triggerHandler == 0x00)
                {
                    KeyFreeNum = KeyFreeNum + 1;
                }
                if (KeyPressNum == 1 && KeyFreeNum == 1)
                {
                    startInventory_Click(null, null);
                }
                if (KeyPressNum == 2 && KeyFreeNum == 2)
                {
                    KeyPressNum = 0;
                    KeyFreeNum = 0;
                    startInventory_Click(null, null);
                }

            };

            this.Invoke(mainProcess);
        }

        private void btnSetRSSIThreshold_Click(object sender, EventArgs e)
        {
            string rssiMax = txtRssiMaxVal.Text;

            UInt32 error = 0;
            if (checkRssiMax(rssiMax) == false)
            {
                string msg = DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Please input correct RSSI Threshold(-99~0).";
                this.Devmes.AppendText(msg + Environment.NewLine);
                this.Devmes.ScrollToCaret();
                MessageBox.Show("Please input correct RSSI Threshold(-99~0).", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                return;
            }
            error = Device.SetRSSIThreshold(Convert.ToInt32(rssiMax));

            if (error == 1)
            {
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Set RSSI Threshold command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
            }

        }

        bool geRssiMaxErr = false;
        private void btnGetRSSIThreshold_Click(object sender, EventArgs e)
        {
            int rssiMax = 0;
            UInt32 error = 0;

            error = Device.GetRSSIThreshold(ref rssiMax);
            if (error == 0)
            {
                txtRssiMaxVal.Text = rssiMax.ToString();
                geRssiMaxErr = false;
            }

            if (error == 1)
            {
                txtRssiMaxVal.Text = "0";
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get Rssi Max command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
                geRssiMaxErr = true;
            }
        }


        private bool checkRssiMax(string rssiMaxval)
        {
            if (rssiMaxval == "")
            {
                return false;
            }
            else if (Convert.ToUInt32(rssiMaxval) < 0 || Convert.ToUInt32(rssiMaxval) > 99)
            {
                return false;
            }
            return true;
        }


        private void Weekdayones_CheckedChanged(object sender, EventArgs e)
        {
            if (!this.checkBox1.Checked || !this.checkBox2.Checked || !this.checkBox3.Checked || !this.checkBox4.Checked || !this.checkBox5.Checked)
            {
                this.checkBox9.Checked = false;
            }

            if (this.checkBox1.Checked && this.checkBox2.Checked && this.checkBox3.Checked && this.checkBox4.Checked && this.checkBox5.Checked)
            {
                this.checkBox9.Checked = true;
            }
        }


        private void Weekday_Click(object sender, EventArgs e)
        {
            if (this.checkBox9.Checked)
            {
                this.checkBox1.Checked = true;
                this.checkBox2.Checked = true;
                this.checkBox3.Checked = true;
                this.checkBox4.Checked = true;
                this.checkBox5.Checked = true;
            }
            else
            {
                this.checkBox1.Checked = false;
                this.checkBox2.Checked = false;
                this.checkBox3.Checked = false;
                this.checkBox4.Checked = false;
                this.checkBox5.Checked = false;
            }
        }


        private void Weekend_Click(object sender, EventArgs e)
        {
            if (this.checkBox10.Checked)
            {
                this.checkBox6.Checked = true;
                this.checkBox7.Checked = true;
            }
            else
            {
                this.checkBox6.Checked = false;
                this.checkBox7.Checked = false;
            }
        }

        private void Weekendones_CheckedChanged(object sender, EventArgs e)
        {
            if (!this.checkBox6.Checked || !this.checkBox7.Checked)
            {
                this.checkBox10.Checked = false;
            }

            if (this.checkBox6.Checked && this.checkBox7.Checked)
            {
                this.checkBox10.Checked = true;
            }

        }

        private void btn_Export_Click(object sender, EventArgs e)
        {
            FolderBrowserDialog dialog = new FolderBrowserDialog();
            dialog.Description = "请选择文件路径";

            if (dialog.ShowDialog() == DialogResult.OK)
            {
                string foldPath = dialog.SelectedPath;
                this.TextExportPath.Text = foldPath;

                btn_setExportPath_Click(null, null);
            }
        }


        void ExportCSV(object obj)
        {
            this.Invoke((new Action(() =>
            {

                FileName = "";

                int count = DatalistView.Items.Count;
                if (count == 0)
                {
                    MessageBox.Show("There is no data to export!");
                }
                else if (count != Convert.ToInt32(lblAllTagCnt.Text))
                {
                    MessageBox.Show("Export data error!");
                }
                else
                {
                    if (string.IsNullOrEmpty(this.TextExportPath.Text)) return;


                    string csvFileName = this.TextExportPath.Text + "\\" + obj.ToString();

                    DataTable dt = new DataTable();
                    DataRow dr;
                    for (int t = 0; t < DatalistView.Columns.Count; t++)
                    {
                        if (t == 3 || t == 4)
                        {
                            continue;
                        }
                        dt.Columns.Add(DatalistView.Columns[t].Text.Trim(), typeof(string));
                    }
                    for (int i = 0; i < DatalistView.Items.Count; i++)
                    {
                        int col = 0;
                        dr = dt.NewRow();
                        for (int j = 0; j < DatalistView.Columns.Count; j++)
                        {
                            if (j == 3 || j == 4)
                            {
                                continue;
                            }
                            dr[col] = DatalistView.Items[i].SubItems[j].Text.Trim();
                            col++;
                        }
                        dt.Rows.Add(dr);
                    }

                    DataTable2CSV(dt, csvFileName);
                }
            })));
        }

        public static void DataTable2CSV(System.Data.DataTable dt, string AbosultedFilePath)
        {
            System.IO.FileStream fs = new FileStream(AbosultedFilePath, System.IO.FileMode.Create, System.IO.FileAccess.Write);
            StreamWriter sw = new StreamWriter(fs, new System.Text.UnicodeEncoding());
            //Tabel header
            for (int i = 0; i < dt.Columns.Count; i++)
            {
                sw.Write(dt.Columns[i].ColumnName);
                sw.Write("\t");
            }
            sw.WriteLine("");
            //Table body
            for (int i = 0; i < dt.Rows.Count; i++)
            {
                for (int j = 0; j < dt.Columns.Count; j++)
                {
                    sw.Write(DelQuota(dt.Rows[i][j].ToString()));
                    sw.Write("\t");
                }
                sw.WriteLine("");
            }
            sw.Flush();
            sw.Close();
        }

        public static string DelQuota(string str)
        {
            string result = str;
            //string[] strQuota = { "~", "!", "@", "#", "$", "%", "^", "&", "*", "(", ")", "`", ";", "'", ",", ".", "/", ":", "/,", "<", ">", "?" };
            string[] strQuota = { "~", "!", "@", "#", "$", "%", "^", "&", "*", "(", ")", "`", ";", "'", ",", ".", "/","/,", "<", ">", "?" };
            for (int i = 0; i < strQuota.Length; i++)
            {
                if (result.IndexOf(strQuota[i]) > -1)
                    result = result.Replace(strQuota[i], "");
            }
            return result;
        }



        private void TimerAuto_Tick(object sender, EventArgs e)
        {
            var nowTime = DateTime.Now;
            this.label33.Text = nowTime.ToString();

            if (this.lab_Inventory.Text == "0")
            {

                int booltype = 0;

                switch (Convert.ToInt32(nowTime.DayOfWeek))
                {
                    case 1: if (this.chb_1.Checked) booltype++; break;
                    case 2: if (this.chb_2.Checked) booltype++; break;
                    case 3: if (this.chb_3.Checked) booltype++; break;
                    case 4: if (this.chb_4.Checked) booltype++; break;
                    case 5: if (this.chb_5.Checked) booltype++; break;
                    case 6: if (this.chb_6.Checked) booltype++; break;
                    case 0: if (this.chb_7.Checked) booltype++; break;
                }
                if (booltype < 1)
                {
                    return;
                }

                DateTime dateS = new DateTime(nowTime.Year, nowTime.Month, nowTime.Day, tb_s.Value.Hour, tb_s.Value.Minute, nowTime.Second);
                DateTime dateE = new DateTime(nowTime.Year, nowTime.Month, nowTime.Day, tb_e.Value.Hour, tb_e.Value.Minute, nowTime.Second);

                if (nowTime >= dateS && nowTime < dateE)
                {
                    if (m_bInventory)
                    {
                        this.labletest.Text = "已经触发了";
                        TodatAutoStart = true;
                        AutoStart++;
                    }

                    if (!TodatAutoStart)
                    {
                        TodatAutoStart = true;
                        //MessageBox.Show("触发start");
                        startInventory_Click(null, null);
                        this.labletest.Text = "已经触发了";
                        AutoStart++;
                    }
                }
                else if (nowTime >= dateE)
                {
                    if (m_bInventory && AutoStart > 0)
                    {
                        startInventory_Click(null, null);
                        //MessageBox.Show("中止");
                        AutoStart = 0;
                    }
                }
                else
                {
                    this.labletest.Text = "不满足触发";
                }

                int h = nowTime.Hour;
                int m = nowTime.Minute;
                int s = nowTime.Second;

                if (h + m + s == 0)
                {
                    TodatAutoStart = false;
                    //MessageBox.Show("重置！");
                }
            }
        }

        private void DatePickerS_ValueChanged(object sender, EventArgs e)
        {
            int hE = this.DatePickerE.Value.Hour;
            int mE = this.DatePickerE.Value.Minute;

            int hS = this.DatePickerS.Value.Hour;
            int mS = this.DatePickerS.Value.Minute;

            if (hE + mE == 0)
            {
                this.DatePickerE.Text = "23:59";
                //不允许跨天
            }

            if (hS == 23 && mS == 59)
            {
                this.DatePickerS.Text = "00:00";
            }

        }


        private bool ExistsPath(string path)
        {
            if (string.IsNullOrEmpty(path))
            {
                //MessageBox.Show("Please specify a path to save the tag data first.");
                //this.tabControl1.SelectedTab = this.tabPage4;
                //this.TextExportPath.Focus();
                //btn_Export_Click(null, null);
                //return false;

                return true;
            }
            else
            {
                if (!Directory.Exists(path))
                {
                    //this.TextExportPath.Text = string.Empty;
                    MessageBox.Show("The path does not exist. Please specify a new one.");
                    this.tabControl1.SelectedTab = this.tabPage4;
                    this.TextExportPath.Focus();
                    btn_Export_Click(null, null);
                    return false;
                }
            }
            this.TextExportPath.Text = Path.GetFullPath(path);

            return true;
        }

        private void btn_setExportPath_Click(object sender, EventArgs e)
        {
            string path = this.TextExportPath.Text;

            if (!ExistsPath(path)) return;

            UInt32 error = 0;
            error = Device.SetExportPath(path);
            this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Set Export Path.\r\n");
            this.Devmes.ScrollToCaret();
        }

        private void btn_getExportPath_Click(object sender, EventArgs e)
        {
            string path = "";

            UInt32 error = 0;
            error = Device.GetExportPath(ref path);

            this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get Export Path.\r\n");
            this.Devmes.ScrollToCaret();

            this.TextExportPath.Text = path;
        }


        private void btn_SetAutoInventory_Click(object sender, EventArgs e)
        {
            if (this.DatePickerS.Value >= this.DatePickerE.Value)
            {
                MessageBox.Show("The end time cannot be earlier than the start time.");
                this.DatePickerS.Focus();
            }

            Device.Auto_Inventory auto_Inventory;
            auto_Inventory.Enable = this.cob_Inventory.SelectedIndex;
            auto_Inventory.Mon = Convert.ToInt32(this.checkBox1.Checked);
            auto_Inventory.Tues = Convert.ToInt32(this.checkBox2.Checked);
            auto_Inventory.Wed = Convert.ToInt32(this.checkBox3.Checked);
            auto_Inventory.Thurs = Convert.ToInt32(this.checkBox4.Checked);
            auto_Inventory.Fri = Convert.ToInt32(this.checkBox5.Checked);
            auto_Inventory.Sat = Convert.ToInt32(this.checkBox6.Checked);
            auto_Inventory.Sun = Convert.ToInt32(this.checkBox7.Checked);
            auto_Inventory.StartTime = this.DatePickerS.Text;
            auto_Inventory.EndTime = this.DatePickerE.Text;

            UInt32 error = 0;
            error = Device.SetAutoInventory(auto_Inventory);

            TodatAutoStart = false;

            btn_GetAutoInventory_Click(null, null);

            this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Set Auto Inventory Info.\r\n");
            this.Devmes.ScrollToCaret();
        }

        private void btn_GetAutoInventory_Click(object sender, EventArgs e)
        {
            Device.Auto_Inventory auto_Inventory = new Device.Auto_Inventory();
            
            UInt32 error = 0;
            error = Device.GetAutoInventory(ref auto_Inventory);

            this.cob_Inventory.SelectedIndex = auto_Inventory.Enable;
            this.checkBox1.Checked = Convert.ToBoolean(auto_Inventory.Mon);
            this.checkBox2.Checked = Convert.ToBoolean(auto_Inventory.Tues);
            this.checkBox3.Checked = Convert.ToBoolean(auto_Inventory.Wed);
            this.checkBox4.Checked = Convert.ToBoolean(auto_Inventory.Thurs);
            this.checkBox5.Checked = Convert.ToBoolean(auto_Inventory.Fri);
            this.checkBox6.Checked = Convert.ToBoolean(auto_Inventory.Sat);
            this.checkBox7.Checked = Convert.ToBoolean(auto_Inventory.Sun);
            this.DatePickerS.Text = auto_Inventory.StartTime;
            this.DatePickerE.Text = auto_Inventory.EndTime;

            this.lab_Inventory.Text = auto_Inventory.Enable.ToString();
            this.chb_1.Checked = this.checkBox1.Checked;
            this.chb_2.Checked = this.checkBox2.Checked;
            this.chb_3.Checked = this.checkBox3.Checked;
            this.chb_4.Checked = this.checkBox4.Checked;
            this.chb_5.Checked = this.checkBox5.Checked;
            this.chb_6.Checked = this.checkBox6.Checked;
            this.chb_7.Checked = this.checkBox7.Checked;
            this.tb_s.Text = auto_Inventory.StartTime;
            this.tb_e.Text = auto_Inventory.EndTime;

            this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get Auto Inventory Info.\r\n");
            this.Devmes.ScrollToCaret();
        }

        private void GetHWVersionBtn_Click(object sender, EventArgs e)
        {
            uint error = 0;
            string hwVersion = "";
            error = Device.GetHwVersion(ref hwVersion);
            if (error == 0)
            {
                txtHardwareVer.Text = hwVersion;
            }
            else
            {
                txtHardwareVer.Text = "";
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get Hw Version command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
            }
        }

        private void GetRFIDFWVerBtn_Click(object sender, EventArgs e)
        {
            uint error = 0;
            string rfidFwVersion = "";
            error = Device.GetRFIDFwVersion(ref rfidFwVersion);
            if (error == 0)
            {
                txtRFIDFWVer.Text = rfidFwVersion;
            }
            else
            {
                txtRFIDFWVer.Text = "";
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get RFID Fw Version command sent failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
            }
        }

        [Obsolete]
        private void btnGetRFIDBins_Click(object sender, EventArgs e)
        {
            try
            {
                if (((Button)sender).Text == "Cancel")
                {
                    ((Button)sender).Text = "Get Files";
                    return;
                }
                else
                {
                    ((Button)sender).Text = "Cancel";  
                }
                string fwXmlURL = Device.rfidFwURL + Device.rfidFwXmlName;
                XmlDataDocument xmlDoc = new XmlDataDocument();
                DataSet myDataSet = xmlDoc.DataSet;
                myDataSet.ReadXml(fwXmlURL);
                cmbRFIDBinFiles.DataSource = myDataSet.Tables[0];
                cmbRFIDBinFiles.DisplayMember = "FwFileName";
                ((Button)sender).Text = "Get Files";
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
                MessageBox.Show("Get bin files failed.", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                this.Devmes.AppendText(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + " Get bin files failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
            }
        }

        private void btnRFIDFWUpdate_Click(object sender, EventArgs e)
        {
            try
            {
                if (MessageBox.Show("Do you want to update now?", "Update RFID Firmware", MessageBoxButtons.YesNo, MessageBoxIcon.Information) == DialogResult.No)
                {
                    return;
                }
                if (((Button)sender).Text == "Updating")
                {
                    MessageBox.Show("PFID Firmware is updating...", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    return;
                }
                if (cmbRFIDBinFiles.Items.Count == 0)
                {
                    MessageBox.Show("Please get bin files!", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    return;
                }
                if (cmbRFIDBinFiles.SelectedIndex < 0)
                {
                    MessageBox.Show("Please select a file!", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    return;
                }
                if (btnRFIDFWUpdate.Text == "Update")
                {
                    btnRFIDFWUpdate.Text = "Updating";
                }

                string filename = cmbRFIDBinFiles.Text.ToString().Trim();

                this.updateWord.Visible = true;
                progressBar2.Visible = true;
                progressBar2.Value = 0;
                progressBar2.Style = ProgressBarStyle.Blocks;
                progressBar2.Maximum = 3;
                progressBar2.Minimum = 0;
                progressBar2.MarqueeAnimationSpeed = 100;
                progressBar2.Step = 1;

                UpdateControlsEnabled(false);

                bool status = Device.DownloadFirmwareFile("RFIDFW",filename);
                progressBar2.PerformStep();
                progressBar2.Visible = false;
                Thread.Sleep(500);
                string filePath = Device.firmwareFolderNmae + @"\" + filename;
                //return;
                if (status && File.Exists(filePath))
                {

                    FileStream myStream = new FileStream(filePath, FileMode.Open, FileAccess.Read);
                    BinaryReader myReader = new BinaryReader(myStream);
                    int bytes = (int)myStream.Length;
                    string fileDataStr = Encoding.ASCII.GetString(myReader.ReadBytes(bytes));
                    myReader.Close();
                    myStream.Close();

                    string[] separator = { "\r\n" };
                    string[] rfidRowArr = fileDataStr.Split(separator, StringSplitOptions.RemoveEmptyEntries);

                    int countPicket = (int)Math.Ceiling((decimal)((int)rfidRowArr.Length / (1024 / 16)));

                    progressBar1.Visible = true;
                    progressBar1.Value = 0;
                    progressBar1.Style = ProgressBarStyle.Blocks;
                    progressBar1.Maximum = countPicket + 2;
                    progressBar1.Minimum = 0;
                    progressBar1.MarqueeAnimationSpeed = 100;
                    progressBar1.Step = 1;

                    bool updateStatus = Device.RFIDFirmwareUpdate(filePath);
                    if (updateStatus)
                    {
                        if (MessageBox.Show("Update RFID firmware success! To use the device, please unplug it from the PC and plug it again.", "Update RFID Firmware Information", MessageBoxButtons.OK, MessageBoxIcon.Information) == DialogResult.OK)
                        {
                            btnVcpDisconnect_Click(button2, null);
                        }
                    }
                    else
                    {
                        MessageBox.Show("Update RFID Firmware failed!", "Update RFID Firmware", MessageBoxButtons.OK);
                    }
                }
                else
                {
                    string msgTitle = "Warning";
                    string msg = "Demo App: Download RFID firmware file failed. No available firmware for update. ";
                    MessageBox.Show(msg, msgTitle, MessageBoxButtons.OK);
                }
                btnRFIDFWUpdate.Text = "Update";

                progressBar1.PerformStep();
                progressBar1.Visible = false;
                this.updateWord.Visible = false;
                UpdateControlsEnabled(true);
                ControlsEnabled();
            }
            catch (Exception ex)
            {
                UpdateControlsEnabled(true);
                progressBar1.Visible = false;
                progressBar2.Visible = false;
                this.updateWord.Visible = false;
                Console.WriteLine(ex.Message);
                MessageBox.Show(ex.Message, "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
            }
        }

        private void epcRadioBtn_CheckedChanged(object sender, EventArgs e)
        {
            try
            {
                SettingComboBoxStatus();
            }
            catch (Exception ex)
            {
                Console.WriteLine("epcRadioBtn_CheckedChanged: " + ex.Message);
            }
        }

        private void tidRadioBtn_CheckedChanged(object sender, EventArgs e)
        {
            try
            {
                SettingComboBoxStatus();
            }
            catch (Exception ex)
            {
                Console.WriteLine("epcRadioBtn_CheckedChanged: " + ex.Message);
            }
        }

        private void userRadioBtn_CheckedChanged(object sender, EventArgs e)
        {
            try
            {
                SettingComboBoxStatus();
            }
            catch (Exception ex)
            {
                Console.WriteLine("epcRadioBtn_CheckedChanged: " + ex.Message);
            }
        }
    }
}
