﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace AsReaderP3xU_Demo
{
    class ResultData
    {
        public int waitPacket;
        public int maxWaitPacket = 100;
        public string waitString;
        public byte[] waitBytes;
        public bool isWaitSuccess;
        public AsPacket.AsReaderP3xURcpType asReaderP3xURcpType;

        public ResultData(AsPacket.AsReaderP3xURcpType type)
        {
            waitPacket = 0;
            maxWaitPacket = 200;//升级的时候最后一包的指令可能超过一秒【最后一包是确认是否更新完毕的】，所以1000->2000毫秒
            waitString = null;
            waitBytes = null;
            asReaderP3xURcpType = type;
        }
        public bool StartWait()
        {
            try
            {
                waitPacket = 0;
                waitString = null;
                waitBytes = null;
                int waitNumber = 0;
                isWaitSuccess = false;
                while (true)
                {
                    waitNumber++;
                    if (waitPacket != 0)
                    {
                        isWaitSuccess = true;
                        break;
                    }
                    if (waitNumber >= maxWaitPacket)
                    {
                        isWaitSuccess = false;
                        break;
                    }
                    Thread.Sleep(10);
                }
                return isWaitSuccess;
            }
            catch (Exception ex)
            {
                Console.WriteLine("Error: StartWait() - " + ex.ToString());
                return false;
            }
        }
        public void EndWait()
        {
            try
            {
                waitPacket = 1;
            }
            catch (Exception ex)
            {
                Console.WriteLine("Error: EndWait() - " + ex.ToString());
            }
        }
    }
}
