package support.andro.app.rfid.view.base;

import android.content.Intent;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import support.andro.app.rfid.dialog.WaitDialog;
import support.andro.app.rfid.util.ResUtil;
import support.andro.app.rfid.view.sub.EpcMaskActivity;

import com.asreader.app.rfid.MainActivity;
import com.asreader.p252b.diagnostics.AsReaderP252BLog;
import com.asreader.app.rfid.R;
import com.asreader.p252b.rfid.exception.AsReaderP252BException;

public abstract class RfidMaskActivity extends RfidPowerGainActivity implements OnClickListener {

	private static final String TAG = RfidMaskActivity.class.getSimpleName();

	public static final String KEY_MASK_TYPE = "mask_type";
	public static final String KEY_MASK = "mask_value";
	protected static final int DEFAULT_MASK_TYPE = 1;

	@SuppressWarnings("unused")
	protected static final String DEFAULT_MASK = "";

	private static final int EPC_OFFSET = 32;
	private static final int MAX_MASK = 8;

	protected Button btnMask;
	private String mMaskValue;


	public RfidMaskActivity() {
		mMaskValue = "";
	}

	@Override 
	public void onClick(View v) {
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. onClick(%s)", ResUtil.getId(v.getId()));

		Intent intent;
		switch (v.getId()) {
		case R.id.mask:
			intent = new Intent(this, EpcMaskActivity.class);
			startActivityForResult(intent, VIEW_MASK);
			break;
		}
		super.onClick(v);
	}

	@Override
	protected void initWidgets() {
		super.initWidgets();

		btnMask = (Button) findViewById(R.id.mask);
		btnMask.setOnClickListener(this);
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. initWidgets()");
	}

	@Override
	protected void enableActionWidgets(boolean enabled) {
		super.enableActionWidgets(enabled);

		btnMask.setEnabled(isEnabledWidget(enabled) && mMaskValue.equals(""));

		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. enableActionWidgets(%s)", enabled);
	}

	protected void  initMask() {
		Intent intent = getIntent();
		int code = intent.getIntExtra(KEY_MASK_TYPE, DEFAULT_MASK_TYPE);
		if ((mMaskValue = intent.getStringExtra(KEY_MASK)) == null)
			mMaskValue = "";

		if (mMaskValue.equals("")) {
			WaitDialog.hide();
			return;
		}


		
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. initMask() - [%s]", mMaskValue);
	}

	protected void exitMask() {

		if (mMaskValue.equals(""))
			return;
		try {
			getReader().clearEpcMask();
			for (int i = 0; i < MainActivity.mUserConfigs.getEpcMaskCount(); i++) {
				getReader().addEpcMask(MainActivity.mUserConfigs.getEpcMask(i));
			}
		} catch (AsReaderP252BException e) {
			AsReaderP252BLog.e(TAG, e, "ERROR. exitMask() - Failed to rollback use epc mask");
		}
	}

	protected String getMask() {
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. getMask() - [%s]", mMaskValue);
		return mMaskValue;
	}
}
