package support.andro.app.rfid.adapter;

import java.util.ArrayList;
import java.util.HashMap;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;

public class LbtAdapter extends BaseAdapter {

    private LayoutInflater inflater;
    private ArrayList<StringValueItem> lstItems;
    private HashMap<Integer, StringValueItem> mapItems;
    private int res;
    private int dropDownRes;

    // ------------------------------------------------------------------------
    // Constructor
    // ------------------------------------------------------------------------
    public LbtAdapter(Context context, int res) {
        super();
        this.inflater = (LayoutInflater) context
                .getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        lstItems = new ArrayList<>();
        mapItems = new HashMap<>();
        this.res = this.dropDownRes = res;
    }

    public void addItem(int slot, String name, boolean isUsed) {
        StringValueItem item = new StringValueItem(slot, name, isUsed);

        lstItems.add(item);
        mapItems.put(slot, item);
    }

    public void clear() {
        lstItems.clear();
        mapItems.clear();
    }

    public int getValue(int position) {
        return this.lstItems.get(position).getValue();
    }

    public int getPosition(int value) {
        for (int i = 0; i < lstItems.size(); i++) {
            if (lstItems.get(i).getValue() == value)
                return i;
        }
        return -1;
    }
    @Override
    public int getCount() {
        return this.lstItems.size();
    }

    @Override
    public Integer getItem(int position) {
        return this.lstItems.get(position).value;
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        StringValueViewHolder holder;

        if (null == convertView) {
            convertView = inflater.inflate(this.res, parent, false);
            holder = new StringValueViewHolder(convertView);
        } else {
            holder = (StringValueViewHolder) convertView.getTag();
        }
        holder.setItem(this.lstItems.get(position));

        return convertView;
    }

    @Override
    public View getDropDownView(int position, View convertView, ViewGroup parent) {
        StringValueViewHolder holder;

        if (null == convertView) {
            convertView = inflater.inflate(this.dropDownRes, parent, false);
            holder = new StringValueViewHolder(convertView);
        } else {
            holder = (StringValueViewHolder) convertView.getTag();
        }
        holder.setItem(this.lstItems.get(position));

        return convertView;
    }

    // ------------------------------------------------------------------------
    // Internal Class StringValueItem
    // ------------------------------------------------------------------------

    private class StringValueItem {

        private int value;
        private String name;
        private boolean isUsed;

        private StringValueItem(int value, String name, boolean isUsed) {
            this.value = value;
            this.name = name;
            this.isUsed = isUsed;
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            return this.name;
        }


        public void setUsed(boolean used) {
            this.isUsed = used;
        }
    }

    // ------------------------------------------------------------------------
    // Internal Class StringValueViewHolder
    // ------------------------------------------------------------------------

    private class StringValueViewHolder {

        private TextView text;

        private StringValueViewHolder(View parent) {
            this.text = (TextView) parent.findViewById(android.R.id.text1);
            parent.setTag(this);
        }

        public void setItem(StringValueItem item) {
            this.text.setText(item.toString());
        }
    }
}
