package com.asreader.app.rfid.view;

import android.app.ActionBar;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.util.Xml;
import android.view.KeyEvent;
import android.view.MenuItem;
import android.view.View;
import android.widget.Button;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;

import com.asreader.app.rfid.MainActivity;
import com.asreader.app.rfid.R;
import com.asreader.p252b.AsReaderP252B;
import com.asreader.p252b.barcode.AsReaderP252BBarcodeType;
import com.asreader.p252b.device.type.AsReaderP252BConnectionState;
import com.asreader.p252b.device.type.AsReaderP252BKeyState;
import com.asreader.p252b.diagnostics.AsReaderP252BLog;
import com.asreader.p252b.rfid.exception.AsReaderP252BException;
import com.asreader.p252b.rfid.type.AsReaderP252BActionState;
import com.asreader.p252b.rfid.type.AsReaderP252BResultCode;
import com.dinuscxj.progressbar.CircleProgressBar;

import org.xmlpull.v1.XmlPullParser;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.concurrent.Executors;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

import support.andro.app.rfid.view.base.RfidActivity;

class MyX509TrustManager implements X509TrustManager {

    @Override
    public void checkClientTrusted(X509Certificate certificates[], String authType) throws CertificateException {
    }

    @Override
    public void checkServerTrusted(X509Certificate[] ax509certificate, String s) throws CertificateException {
        if (ax509certificate == null){
            throw new IllegalArgumentException("X509Certificate array is null");
        }
        if (!(ax509certificate.length > 0)){
            throw new IllegalArgumentException("X509Certificate is empty");
        }
        if (!(null != s && s.toLowerCase().contains("RSA".toLowerCase()))) {
            throw new CertificateException("AuthType is not RSA");
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        // TODO Auto-generated method stub
        return null;
    }
}

class FirmwareInfo extends Object {
    public String firmwareVersion;
    public String firmwareName;
    public String firmwareMode;

    public FirmwareInfo() {
    }

    public FirmwareInfo(String firmwareName) {
        this.firmwareName = firmwareName;
    }

    public FirmwareInfo(String firmwareVersion, String firmwareName, String firmwareMode) {
        this.firmwareVersion = firmwareVersion;
        this.firmwareName = firmwareName;
        this.firmwareMode = firmwareMode;
    }

    public String getFirmwareVersion() {
        return firmwareVersion;
    }

    public void setFirmwareVersion(String firmwareVersion) {
        this.firmwareVersion = firmwareVersion;
    }

    public String getFirmwareName() {
        return firmwareName;
    }

    public void setFirmwareName(String firmwareName) {
        this.firmwareName = firmwareName;
    }

    public String getFirmwareMode() {
        return firmwareMode;
    }

    public void setFirmwareMode(String firmwareMode) {
        this.firmwareMode = firmwareMode;
    }
}

public class UpdateFirmwareActivity extends RfidActivity {

    private static final String TAG = MainActivity.class.getSimpleName();

    protected static final String PATH = "https://camera.asreaderapps.com/mrxapp/W3/fw/";
    protected static final String XML = "W3.xml";

    protected static final int TIME_OUT = 3000;
    private ListView lv_news;
    private boolean clearStatus;
    private Button btnUpdate;
    private CircleProgressBar line_progress;
    private Button btnRefresh;
    //    private TextView textView;
    private UpdateFirmwareListViewAdapter lvAdapter;
    private String filePath;

    private static final String commandEnd = "\r\n";
    private static final String firmwareAddressCommand = "~r<" + commandEnd;
    private static final String firmwareWriteCommand = "~w=W3" + commandEnd;
    private static final String firmwareSetData = "~w>";
    private static final String firmwareSetEND = "~w?" + commandEnd;

    private static com.asreader.app.rfid.view.FirmwareInfo currentUpdateInfo;

    private final int PACKET = 256;

    private static UpdateFirmwareTask updateFirmwareTask;

    private AlertDialog.Builder warningDialog;

    @Override
    public void onStateChanged(AsReaderP252B reader, AsReaderP252BConnectionState state) {
        super.onStateChanged(reader, state);
    }

    @Override
    public void onReadBarcode(AsReaderP252B reader, AsReaderP252BBarcodeType type, String barcode) {
        AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "EVENT. onReadBarcode (%s, [%s])", type, barcode);
    }

    @Override
    public void onReadBarcode(AsReaderP252B reader, AsReaderP252BBarcodeType type, byte[] barcodeData) {
        AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "EVENT. onReadBarcode (%s, [%s])", type, barcodeData);
    }

    @Override
    public void onActionChanged(AsReaderP252B reader, AsReaderP252BActionState action) {
        super.onActionChanged(reader, action);
    }

    @Override
    public void onReadTag(AsReaderP252B reader, AsReaderP252BActionState action, String tag, float rssi, float phase, float frequency) {

    }

    @Override
    public void onAccessResult(AsReaderP252B reader, AsReaderP252BResultCode code, AsReaderP252BActionState action, String epc, String data, float rssi, float phase, float frequency) {

    }

    @Override
    public void onReadTemperatureTag(AsReaderP252B reader, AsReaderP252BActionState action, String tag, float rssi, float phase, float frequency, float temperature) {

    }

    @Override
    public void onReadHumidityTag(AsReaderP252B reader, AsReaderP252BActionState action, String tag, float rssi, float phase, float frequency, float humidity) {

    }

    @Override
    public boolean onModeKeyEvent(AsReaderP252B reader, AsReaderP252BKeyState state) {
        AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "EVENT. onModeKeyEvent [%s]", state);
        return false;
    }

    @Override
    public boolean onKeyEvent(AsReaderP252B reader, AsReaderP252BKeyState state) {
        return super.onKeyEvent(reader, state);
    }

    @Override
    public void onReceivedData(byte[] data) {

    }

    Handler progressHandler = new Handler() {
        public void handleMessage(Message msg) {
            line_progress.setProgress(msg.what);
        }

        ;
    };

    private Handler xmlHandler = new Handler() {
        @Override
        public void handleMessage(Message msg) {
            enableOrDisableComponent(true);
            switch (msg.what) {
                case RESULT_OK:
                    List<FirmwareInfo> list = (List<FirmwareInfo>) msg.obj;
                    lvAdapter.setList(list);
                    break;
                case RESULT_CANCELED:
                    Log.d("tag", "RESULT_CANCELED");
                    break;
                default:
                    break;
            }
        }
    };

    private Handler downloadHandler = new Handler() {
        @Override
        public void handleMessage(Message msg) {
            enableOrDisableComponent(true);
            switch (msg.what) {
                case RESULT_OK:
                    if (updateFirmwareTask != null) {
                        updateFirmwareTask.cancel(true);
                        updateFirmwareTask = null;
                        try {
                            Thread.sleep(500);
                        } catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    updateFirmwareTask = new UpdateFirmwareTask();
                    updateFirmwareTask.execute(currentUpdateInfo.firmwareName);
                    break;
                case RESULT_CANCELED:
                    Toast.makeText(com.asreader.app.rfid.view.UpdateFirmwareActivity.this, msg.obj.toString(), Toast.LENGTH_SHORT).show();
                    break;
                default:
                    break;
            }
        }
    };

    private Handler updateHandler = new Handler() {
        @Override
        public void handleMessage(Message msg) {
            enableOrDisableComponent(true);
            line_progress.setVisibility(View.GONE);
            switch (msg.what) {
                case RESULT_OK:
                    Toast.makeText(com.asreader.app.rfid.view.UpdateFirmwareActivity.this, msg.obj.toString(), Toast.LENGTH_SHORT).show();
                    break;
                case RESULT_CANCELED:
                    Toast.makeText(com.asreader.app.rfid.view.UpdateFirmwareActivity.this, msg.obj.toString(), Toast.LENGTH_SHORT).show();
                    if(lvAdapter != null && lvAdapter.getCount() > 0 && lvAdapter.getCurrentCheckBoxState()) {
                        enableOrDisableUpdateButton(true);
                    }
                    break;
                default:
                    break;
            }
        }
    };

    private Handler clearHandler = new Handler() {
        @Override
        public void handleMessage(Message msg) {
            ActionBar actionBar = getActionBar();
            switch (msg.what) {
                case RESULT_OK:
                    clearStatus = true;
                    if(actionBar != null) {
                        actionBar.setHomeButtonEnabled(false);
                    }
                    break;
                case RESULT_CANCELED:
                    clearStatus = false;
                    if(actionBar != null) {
                        actionBar.setHomeButtonEnabled(true);
                    }
                    break;
                default:
                    break;
            }
        }
    };

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        clearStatus = false;
        ActionBar actionBar = getActionBar();
        if(actionBar != null) {
            actionBar.setDisplayOptions(ActionBar.DISPLAY_SHOW_CUSTOM);
            actionBar.setCustomView(R.layout.activity_title);
            actionBar.setDisplayHomeAsUpEnabled(true);
            actionBar.setDisplayShowHomeEnabled(true);
            actionBar.setHomeButtonEnabled(true);
        }
        TextView titleText = (TextView)findViewById(R.id.title_text);
        titleText.setText(R.string.update_firmware);
        titleText.setTextColor(getColor(getApplicationContext(), R.color.black));

        lvAdapter = new UpdateFirmwareListViewAdapter(this);
        filePath = getApplicationContext().getFilesDir().getAbsolutePath() + "/UpdateFile/";
        setContentView(R.layout.activity_update_firmware);
        lv_news = (ListView) findViewById(R.id.lv_news);
        lv_news.setAdapter(lvAdapter);

        btnUpdate = (Button) findViewById(R.id.btn_update_firmware);
        btnUpdate.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (currentUpdateInfo == null) return;
                DownloadFile(PATH + currentUpdateInfo.firmwareName, filePath + currentUpdateInfo.firmwareName);
            }
        });
        line_progress = (CircleProgressBar) findViewById(R.id.custom_progress);
        btnRefresh = (Button) findViewById(R.id.btn_refresh);
        btnRefresh.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if(lvAdapter != null && lvAdapter.getCount() > 0) {
                    lvAdapter.clearCurrentCheckBoxChecked();
                }
                readNews();
            }
        });
        this.createReader();
        readNews();
    }

    @Override
    protected void onDestroy() {
        AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. onDestroy()");
        // Destroy Reader
        destroyReader();
        super.onDestroy();
    }

    private void enableOrDisableComponent(boolean flag) {
        lvAdapter.setEnableFlag(flag);
        btnRefresh.setEnabled(flag);
    }

    private void enableOrDisableUpdateButton(boolean flag) {
        btnUpdate.setEnabled(flag);
        btnUpdate.setClickable(flag);
        btnUpdate.setFocusable(flag);
    }

    @Override
    protected void initReader() {

    }

    private void initDialog() {
        warningDialog = new AlertDialog.Builder(UpdateFirmwareActivity.this);
        warningDialog.setTitle("Tip");
        warningDialog.setMessage(getResources().getString(R.string.dialog_update_firmware_version_warning));
        warningDialog.setPositiveButton("OK", new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                finish();
            }
        });
        warningDialog.setCancelable(false);
        warningDialog.create();
        warningDialog.show();
    }
    public void readNews() {
        ///
        enableOrDisableComponent(false);
        new Thread(new Runnable() {
            @Override
            public void run() {
                try {
                    URL url = new URL(PATH + XML);
                    SSLContext sslcontext = SSLContext.getInstance("SSL");
                    sslcontext.init(null, new TrustManager[]{new com.asreader.app.rfid.view.MyX509TrustManager()}, new java.security.SecureRandom());
                    HostnameVerifier ignoreHostnameVerifier = new HostnameVerifier() {
                        public boolean verify(String s, SSLSession sslsession) {
                            if (s.equals("camera.asreaderapps.com")) {
                                return true;
                            } else {
                                return false;
                            }
                        }
                    };
                    HttpsURLConnection.setDefaultHostnameVerifier(ignoreHostnameVerifier);
                    HttpsURLConnection.setDefaultSSLSocketFactory(sslcontext.getSocketFactory());

                    HttpURLConnection conn = (HttpURLConnection) url.openConnection();
                    conn.setRequestMethod("GET");
                    conn.setReadTimeout(TIME_OUT);
                    conn.connect();
                    int responseCode = conn.getResponseCode();
                    if (responseCode == 200) {
                        InputStream is = conn.getInputStream();
                        List<FirmwareInfo> items = parserXML(is);

                        xmlHandler.obtainMessage(RESULT_OK, items).sendToTarget();
                    } else {
                        xmlHandler.obtainMessage(RESULT_CANCELED, "List download failed").sendToTarget();
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                    xmlHandler.obtainMessage(RESULT_CANCELED, "List download failed").sendToTarget();
                }
            }
        }).start();
    }

    protected List<FirmwareInfo> parserXML(InputStream is) throws Exception {

        XmlPullParser parser = Xml.newPullParser();
        parser.setInput(is, "utf-8");
        List<FirmwareInfo> list = null;
        com.asreader.app.rfid.view.FirmwareInfo item = null;
        int event = -1;
        while ((event = parser.next()) != XmlPullParser.END_DOCUMENT) {
            String tagName = parser.getName();
            if (event == XmlPullParser.START_TAG) {
                if ("W3_Fw".equals(tagName)) {
                    list = new ArrayList<FirmwareInfo>();
                } else if ("Fw".equals(tagName)) {
                    item = new com.asreader.app.rfid.view.FirmwareInfo();
                    item.firmwareMode = parser.getAttributeValue(null, "status").trim();
                } else if ("FwFileName".equals(tagName)) {
                    item.firmwareName = parser.nextText().trim();
                } else if ("Version".equals(tagName)) {
                } else if ("Version".equals(tagName)) {
                    item.firmwareVersion = parser.nextText().trim();
                }

            } else if (event == XmlPullParser.END_TAG) {
                if ("Fw".equals(tagName)) {
                    list.add(item);
                }
            }
        }
        return list;
    }
    private static int currentCount;

    private class UpdateFirmwareTask extends AsyncTask<String, Integer, String> {

        // 方法1：onPreExecute（）
        // 作用：执行 线程任务前的操作
        @Override
        protected void onPreExecute() {
            enableOrDisableComponent(false);
            enableOrDisableUpdateButton(false);
            line_progress.setVisibility(View.VISIBLE);
            // 执行前显示提示
        }


        // 方法2：doInBackground（）
        // 作用：接收输入参数、执行任务中的耗时操作、返回 线程任务执行的结果
        // 此处通过计算从而模拟“加载进度”的情况
        @Override
        protected String doInBackground(String... fileName) {
            try {
                if (fileName[0] == null || fileName[0].equals("")) {
                    updateHandler.obtainMessage(RESULT_CANCELED, "update failed").sendToTarget();
                    return null;
                }
                byte[] ad = getReader().sendData(firmwareAddressCommand.getBytes("ASCII"));

                String address = new String(ad, "ASCII");

                byte[] buffer;
                File file = new File(filePath + fileName[0]);
                FileInputStream inStream = new FileInputStream(file);

                buffer = new byte[inStream.available()];
                inStream.read(buffer);

                byte[] sendData = new byte[buffer.length / 2];
                if ("00008040000".equals(address)) {
                    System.arraycopy(buffer, buffer.length / 2, sendData, 0, buffer.length / 2);

                } else if ("00008060000".equals(address)) {
                    System.arraycopy(buffer, 0, sendData, 0, buffer.length / 2);

                } else {
                    updateHandler.obtainMessage(RESULT_CANCELED, "update failed").sendToTarget();
                    return null;
                }

                double countPicket = Math.ceil((float) sendData.length / PACKET);

                byte[] sendFileData = firmwareWriteCommand.getBytes("ASCII");
                currentCount = 0;
                byte[] fd = getReader().sendData(sendFileData);

                String result = new String(fd, "ASCII");

                if (!result.equals("0000")) {
                    updateHandler.obtainMessage(RESULT_CANCELED, "update failed").sendToTarget();
                    return null;
                }

                int retryTimes = 0;

                clearHandler.obtainMessage(RESULT_OK, "").sendToTarget();
                publishProgress(0);

                for (int i = 0; i < countPicket; i++) {
                    byte blockNumber = (byte) (currentCount % 256);
                    int copyLength = sendData.length - PACKET * (1 + currentCount) < 0 ? sendData.length - PACKET * currentCount : PACKET;
                    if (copyLength <= 0) {
                        updateHandler.obtainMessage(RESULT_CANCELED, "update failed").sendToTarget();
                        clearHandler.obtainMessage(RESULT_CANCELED, "").sendToTarget();
                        return null;
                    }
                    byte[] itemData = new byte[copyLength];
                    System.arraycopy(sendData, currentCount * PACKET, itemData, 0, copyLength);

                    byte[] itemHeader = firmwareSetData.getBytes("ASCII");

                    byte[] itemEnd = commandEnd.getBytes("ASCII");

                    final byte[] sendItemData = new byte[itemHeader.length + 2 + 1 + itemData.length + 2 + itemEnd.length];

                    System.arraycopy(itemHeader, 0, sendItemData, 0, itemHeader.length);

                    int length = 1 + itemData.length + 2 + itemEnd.length;

                    convertIntToByteArray(length, sendItemData, itemHeader.length, 2);

                    sendItemData[itemHeader.length + 2] = blockNumber;

                    System.arraycopy(itemData, 0, sendItemData, itemHeader.length + 2 + 1, itemData.length);

                    byte[] crcData = new byte[2 + 1 + itemData.length];

                    System.arraycopy(sendItemData, 3, crcData, 0, crcData.length);

                    convertIntToByteArray(calculateCRC(crcData), sendItemData, itemHeader.length + 2 + 1 + itemData.length, 2);

                    System.arraycopy(itemEnd, 0, sendItemData, itemHeader.length + 2 + 1 + itemData.length + 2, itemEnd.length);

                    publishProgress((int) (currentCount / countPicket * 100));
                    byte[] resultByte = getReader().sendData(sendItemData);
                    String resultState = new String(resultByte, "ASCII");
                    if (!resultState.equals("0000")) {
                        retryTimes++;
                        if (retryTimes > 4) {
                            updateHandler.obtainMessage(RESULT_CANCELED, "update failed").sendToTarget();
                            clearHandler.obtainMessage(RESULT_CANCELED, "").sendToTarget();
                            return null;
                        }
                    } else {
                        Log.i("Update", "Success" + i);
                        retryTimes = 0;
                        currentCount++;
                    }
                }
                publishProgress(100);
                byte[] resultEND = getReader().sendData(firmwareSetEND.getBytes("ASCII"));

                String ENDStr = new String(resultEND, "ASCII");

                if (!ENDStr.equals("0000")) {
                    updateHandler.obtainMessage(RESULT_CANCELED, "update failed").sendToTarget();
                    clearHandler.obtainMessage(RESULT_CANCELED, "").sendToTarget();
                    return null;
                }

                updateHandler.obtainMessage(RESULT_OK, "update success").sendToTarget();
                clearHandler.obtainMessage(RESULT_CANCELED, "").sendToTarget();
            } catch (AsReaderP252BException | UnsupportedEncodingException | FileNotFoundException e) {
                e.printStackTrace();
                updateHandler.obtainMessage(RESULT_CANCELED, "update failed").sendToTarget();
                clearHandler.obtainMessage(RESULT_CANCELED, "").sendToTarget();
            } catch (IOException e) {
                e.printStackTrace();
                updateHandler.obtainMessage(RESULT_CANCELED, "update failed").sendToTarget();
                clearHandler.obtainMessage(RESULT_CANCELED, "").sendToTarget();
            }

            return null;
        }

        // 方法3：onProgressUpdate（）
        // 作用：在主线程 显示线程任务执行的进度
        @Override
        protected void onProgressUpdate(Integer... progresses) {
            line_progress.setProgress(progresses[0]);
        }

        // 方法4：onPostExecute（）
        // 作用：接收线程任务执行结果、将执行结果显示到UI组件
        @Override
        protected void onPostExecute(String result) {
            // 执行完毕后，则更新UI
        }

        // 方法5：onCancelled()
        // 作用：将异步任务设置为：取消状态
        @Override
        protected void onCancelled() {
            line_progress.setProgress(0);
        }
    }

    public void onClickList(com.asreader.app.rfid.view.FirmwareInfo info) {
        currentUpdateInfo = info;
        if (info != null) btnUpdate.setEnabled(true);
        else enableOrDisableUpdateButton(false);
    }

    private void DownloadFile(final String url, final String filePath) {
        ///////
        enableOrDisableComponent(false);
        enableOrDisableUpdateButton(false);
        if (ConfirmFile(filePath)) {
            downloadHandler.obtainMessage(RESULT_OK, "download data success").sendToTarget();
            return;
        }

        Executors.newCachedThreadPool().execute(new Runnable() {
            @Override
            public void run() {
                try {
                    URL webUrl = new URL(url);
                    URLConnection con = webUrl.openConnection();    // 打开连接
                    int fileSize = con.getContentLength();//根据响应获取文件大小
                    if (fileSize <= 0) throw new RuntimeException("无法获知文件大小 ");

                    InputStream in = con.getInputStream();            // 获取InputStream
                    if (in == null) throw new RuntimeException("stream is null");

                    File f = new File(filePath);                    // 创建文件输出流
                    FileOutputStream fo = new FileOutputStream(f);

                    byte[] buffer = new byte[1024];
                    int len = 0;
                    int downLoadFileSize = 0;
                    while ((len = in.read(buffer)) > 0)        // 读取文件
                    {
                        fo.write(buffer, 0, len);            // 写入文件
                        downLoadFileSize += len;
                    }

                    in.close();

                    fo.flush();
                    fo.close();

                    downloadHandler.obtainMessage(RESULT_OK, "download data success").sendToTarget();
                } catch (Exception e) {
                    e.printStackTrace();
                    downloadHandler.obtainMessage(RESULT_CANCELED, "download data failed").sendToTarget();
                    File f = new File(filePath);

                    if (f.exists() && f.isFile()) {
                        if (!f.delete()) {
                            downloadHandler.obtainMessage(RESULT_CANCELED, "delete file failed").sendToTarget();
                        }
                    }
                }
            }
        });
    }

    /**
     * 创建目录和文件
     */
    private boolean ConfirmFile(String filePath) {
        boolean success = false;

        try {
            File f = new File(filePath);
            File parent = f.getParentFile();

            if (!parent.exists()) {
                parent.mkdirs();
                success = false;
            } else {
                success = true;
            }

            if (!f.exists()) {
                f.createNewFile();
                success = false;
            }

        } catch (Exception ex) {
            ex.printStackTrace();
        }
        return success;
    }

    //转十六进制
    public static String bytesToHexString(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (src == null || src.length <= 0) {
            return null;
        }
        for (int i = 0; i < src.length; i++) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }

    /**
     * This converts int value to byte array.
     *
     * @param number : int value
     * @param array  : destination byte array
     * @param index  : starting index
     * @param count  : count to convert
     */
    private static void convertIntToByteArray(int number, byte[] array, int index, int count) {
        int i;
        byte num;

        for (i = count - 1; i >= 0; i--) {
            num = (byte) (number & 0xFF);
            array[index + i] = num;
            number = number >> 8;
        }
    }


    /**
     * This calculates CRC16 from the RCP packet
     *
     * @return CRC16
     */
    private static int calculateCRC(byte[] packet) {

        int i;
        int crc = 0xFFFF;

        for (i = 0; i < packet.length; i++) {
            crc = ((crc << 8) ^ crc16tab[((crc >> 8) ^ packet[i]) & 0x00FF]) & 0xFFFF;
        }

        return crc;
    }

    private static int[] crc16tab = {
            0x0000, 0x1021, 0x2042, 0x3063, 0x4084, 0x50a5, 0x60c6, 0x70e7,
            0x8108, 0x9129, 0xa14a, 0xb16b, 0xc18c, 0xd1ad, 0xe1ce, 0xf1ef,
            0x1231, 0x0210, 0x3273, 0x2252, 0x52b5, 0x4294, 0x72f7, 0x62d6,
            0x9339, 0x8318, 0xb37b, 0xa35a, 0xd3bd, 0xc39c, 0xf3ff, 0xe3de,
            0x2462, 0x3443, 0x0420, 0x1401, 0x64e6, 0x74c7, 0x44a4, 0x5485,
            0xa56a, 0xb54b, 0x8528, 0x9509, 0xe5ee, 0xf5cf, 0xc5ac, 0xd58d,
            0x3653, 0x2672, 0x1611, 0x0630, 0x76d7, 0x66f6, 0x5695, 0x46b4,
            0xb75b, 0xa77a, 0x9719, 0x8738, 0xf7df, 0xe7fe, 0xd79d, 0xc7bc,
            0x48c4, 0x58e5, 0x6886, 0x78a7, 0x0840, 0x1861, 0x2802, 0x3823,
            0xc9cc, 0xd9ed, 0xe98e, 0xf9af, 0x8948, 0x9969, 0xa90a, 0xb92b,
            0x5af5, 0x4ad4, 0x7ab7, 0x6a96, 0x1a71, 0x0a50, 0x3a33, 0x2a12,
            0xdbfd, 0xcbdc, 0xfbbf, 0xeb9e, 0x9b79, 0x8b58, 0xbb3b, 0xab1a,
            0x6ca6, 0x7c87, 0x4ce4, 0x5cc5, 0x2c22, 0x3c03, 0x0c60, 0x1c41,
            0xedae, 0xfd8f, 0xcdec, 0xddcd, 0xad2a, 0xbd0b, 0x8d68, 0x9d49,
            0x7e97, 0x6eb6, 0x5ed5, 0x4ef4, 0x3e13, 0x2e32, 0x1e51, 0x0e70,
            0xff9f, 0xefbe, 0xdfdd, 0xcffc, 0xbf1b, 0xaf3a, 0x9f59, 0x8f78,
            0x9188, 0x81a9, 0xb1ca, 0xa1eb, 0xd10c, 0xc12d, 0xf14e, 0xe16f,
            0x1080, 0x00a1, 0x30c2, 0x20e3, 0x5004, 0x4025, 0x7046, 0x6067,
            0x83b9, 0x9398, 0xa3fb, 0xb3da, 0xc33d, 0xd31c, 0xe37f, 0xf35e,
            0x02b1, 0x1290, 0x22f3, 0x32d2, 0x4235, 0x5214, 0x6277, 0x7256,
            0xb5ea, 0xa5cb, 0x95a8, 0x8589, 0xf56e, 0xe54f, 0xd52c, 0xc50d,
            0x34e2, 0x24c3, 0x14a0, 0x0481, 0x7466, 0x6447, 0x5424, 0x4405,
            0xa7db, 0xb7fa, 0x8799, 0x97b8, 0xe75f, 0xf77e, 0xc71d, 0xd73c,
            0x26d3, 0x36f2, 0x0691, 0x16b0, 0x6657, 0x7676, 0x4615, 0x5634,
            0xd94c, 0xc96d, 0xf90e, 0xe92f, 0x99c8, 0x89e9, 0xb98a, 0xa9ab,
            0x5844, 0x4865, 0x7806, 0x6827, 0x18c0, 0x08e1, 0x3882, 0x28a3,
            0xcb7d, 0xdb5c, 0xeb3f, 0xfb1e, 0x8bf9, 0x9bd8, 0xabbb, 0xbb9a,
            0x4a75, 0x5a54, 0x6a37, 0x7a16, 0x0af1, 0x1ad0, 0x2ab3, 0x3a92,
            0xfd2e, 0xed0f, 0xdd6c, 0xcd4d, 0xbdaa, 0xad8b, 0x9de8, 0x8dc9,
            0x7c26, 0x6c07, 0x5c64, 0x4c45, 0x3ca2, 0x2c83, 0x1ce0, 0x0cc1,
            0xef1f, 0xff3e, 0xcf5d, 0xdf7c, 0xaf9b, 0xbfba, 0x8fd9, 0x9ff8,
            0x6e17, 0x7e36, 0x4e55, 0x5e74, 0x2e93, 0x3eb2, 0x0ed1, 0x1ef0
    };

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {

        switch (item.getItemId()) {
            case android.R.id.home:
                this.finish();
                return true;
        }
        return super.onOptionsItemSelected(item);
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == KeyEvent.KEYCODE_BACK) {
            if (!clearStatus) {
                finish();
            }
            return false;
        }
        return false;

    }
}
