package com.asreader.app.rfid.view;

import java.lang.ref.WeakReference;
import java.util.Locale;

import support.andro.app.rfid.adapter.MemoryListAdapter;
import support.andro.app.rfid.adapter.SpinnerAdapter;
import support.andro.app.rfid.dialog.WaitDialog;
import support.andro.app.rfid.util.ResUtil;
import support.andro.app.rfid.view.base.MemoryActivity;

import com.asreader.p252b.barcode.AsReaderP252BBarcodeType;
import com.asreader.p252b.device.type.AsReaderP252BConnectionState;
import com.asreader.p252b.rfid.exception.AsReaderP252BException;
import com.asreader.p252b.rfid.type.AsReaderP252BActionState;
import com.asreader.p252b.rfid.type.AsReaderP252BMemoryBank;
import com.asreader.p252b.rfid.type.AsReaderP252BResultCode;
import com.asreader.app.rfid.R;
import com.asreader.p252b.AsReaderP252B;
import com.asreader.p252b.device.type.AsReaderP252BKeyState;
import com.asreader.p252b.diagnostics.AsReaderP252BLog;

import android.app.ActionBar;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.view.View;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.ScrollView;
import android.widget.TextView;
import android.widget.Toast;

public class ReadMemoryActivity extends MemoryActivity {

	private static final String TAG = ReadMemoryActivity.class.getSimpleName();

	private static final int DEFAULT_MEM_LENGTH = 2;

	private ListView lstValue;
	private TextView txtLength;
	private Button btnRead;


	private MemoryListAdapter adpValue;

	private int mLength;
	private Handler mHandler;
	private AlertDialog readDialog;
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_read_memory);
		ActionBar actionBar = getActionBar();
		if(actionBar != null) {
			actionBar.setDisplayOptions(ActionBar.DISPLAY_SHOW_CUSTOM);
			actionBar.setCustomView(R.layout.activity_title);
			actionBar.setDisplayHomeAsUpEnabled(true);
			actionBar.setDisplayShowHomeEnabled(true);
		}
		TextView titleText = (TextView)findViewById(R.id.title_text);
		titleText.setText(R.string.read_memory_name);
		final int version = Build.VERSION.SDK_INT;
		if(version >= Build.VERSION_CODES.M)
			titleText.setTextColor(getColor(getApplicationContext(), R.color.black));

		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. onCreate()");

		mHandler = new Handler();

		// Initialize Widget
		initWidgets();

//		// Initialize Mask
//		initMask();
//		//mMaskType = MaskType.Selection;
//
//		resetActionResult();
//
//		setMask(getMask());
//
//		// Enable action widget
//		enableActionWidgets(true);
//
//		outputMessage(R.string.read_memory_intro_message);
		
		InitTask task = new InitTask(this);
		task.execute();
		
	}

	@Override
	protected void onDestroy() {

		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. onDestroy()");

		// Destroy Reader
		destroyReader();

		super.onDestroy();
	}

	@Override
	protected void onStart() {
		super.onStart();
		new Thread(mLoadOptionOnStart).start();
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. onStart()");
	}

	@Override
	protected void onStop() {



		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. onStop()");
		super.onStop();
	}
	private Runnable mLoadOptionOnStart = new Runnable() {
		@Override
		public void run() {
			createReader();
			initReader();
			mHandler.post(new Runnable() {
				@Override
				public void run() {
					enableActionWidgets(true);
				}
			});
		}
	};
	@Override
	protected void onResume() {
		super.onResume();
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. onResume()");
	}

	@Override
	protected void onPause() {
		if(getReader().getAction() == AsReaderP252BActionState.ReadMemory)
			getReader().stop();

		// Rollback Mask
		exitMask();
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. onPause()");
		super.onPause();
	}

	@Override
	public void onClick(View v) {

		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. onClick(%s)", ResUtil.getId(v.getId()));

		switch (v.getId()) {
		case R.id.length:
			showMemLengthDialog();
			break;
		case R.id.action_read:
			if (getReader().getAction() == AsReaderP252BActionState.Stop) {
				readMemory();
			} else {
				stopAction();
			}
			break;
		}
		super.onClick(v);
	}
	
	@Override
	public boolean onKeyEvent(AsReaderP252B reader, AsReaderP252BKeyState state) {
		if (state == AsReaderP252BKeyState.KeyDown) {
			if (getReader().getAction() == AsReaderP252BActionState.Stop) {
				readMemory();
			} else {
				stopAction();
			}
		}
		return false;
	}

	@Override
	public boolean onModeKeyEvent(AsReaderP252B reader, AsReaderP252BKeyState state) {
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "EVENT. onModeKeyEvent [%s]", state);
		return false;
	}

	@Override
	public void onReadBarcode(AsReaderP252B reader, AsReaderP252BBarcodeType type, String barcode) {
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "EVENT. onReadBarcode (%s, [%s])", type, barcode);
	}

	@Override
	public void onReadBarcode(AsReaderP252B reader, AsReaderP252BBarcodeType type, byte[] barcodeData) {
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "EVENT. onReadBarcode (%s, [%s])", type, barcodeData);
	}

	@Override
	public void onReceivedData(byte[] data) {

	}

	@Override
	public void onActionChanged(AsReaderP252B reader, AsReaderP252BActionState action) {

		AsReaderP252BLog.d(TAG, AsReaderP252BLog.DEBUG, "EVENT. onActionChanged(%s)", action);

		enableActionWidgets(true);

		if (action == AsReaderP252BActionState.Stop) {
			dialogDismiss();
			if (!isActionResult()) {
				outputMessage(R.string.read_memory_intro_message);
			}
		}
	}

	@Override
	public void onAccessResult(AsReaderP252B reader, AsReaderP252BResultCode code, AsReaderP252BActionState action, String epc, String data,
							   float rssi, float phase, float frequency) {
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "EVENT. onAccessResult(%s, %s, [%s], [%s], %.2f, %.2f)", code, action, epc == null ? "" : epc,
				data == null ? "" : data, rssi, phase);

		setActionResult();

		if (code != AsReaderP252BResultCode.NoError) {
			outputFailMessage(code.toString());
			return;
		}

		if(epc != null)
			outputSelection(epc.length() > 4 ? epc.substring(4) : epc);

		outputSuccessMessage(R.string.access_success);
		int offset = getMemOffset();
		adpValue.setValue(offset, data);
		setRssi(rssi, phase, frequency);
	}

	@Override
	public void onReadTemperatureTag(AsReaderP252B reader, AsReaderP252BActionState action, String tag, float rssi, float phase, float frequency, float temperature) {

	}

	@Override
	public void onReadHumidityTag(AsReaderP252B reader, AsReaderP252BActionState action, String tag, float rssi, float phase, float frequency, float humidity) {

	}

	// Read Memroy
	private void readMemory() {
		
		clearWidgets();
		enableActionWidgets(false);
		outputSelection("");
		outputMessage(R.string.read_memory_read_message);

		resetActionResult();

		AsReaderP252BMemoryBank bank = getMemBank();
		int offset = getMemOffset();
		int length = getMemLength();
		int time = getOperationTime();

		String password = getAccessPassword();
		try {
			getReader().setAccessPassword(password);
		} catch (AsReaderP252BException e) {
			AsReaderP252BLog.e(TAG, e, "ERROR. readMemory() - Failed to set password [%s]", password);
		}

		try {
			getReader().setOperationTime(time);
		} catch (AsReaderP252BException e) {
			AsReaderP252BLog.e(TAG, e, "ERROR. readMemory() - Failed to set operation time(%d)", time);
		}

		AsReaderP252BResultCode res;
		dialogDismiss();
		dialogShow();
		if ((res = getReader().readMemory(bank, offset, length)) != AsReaderP252BResultCode.NoError) {
			dialogDismiss();
			AsReaderP252BLog.e(TAG, "ERROR. readMemory() - Failed to start read memory(%s, %d, %d)", bank, offset, length);
			String msg = String.format(Locale.US, "%s : 0x%04X", res.toString(), res.getCode());
			Toast.makeText(this, msg, Toast.LENGTH_SHORT).show();
			enableActionWidgets(true);
			outputFailMessage(R.string.read_memory_fail_read_message);
			return;
		}
		
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. readMemory()");
	}

	// Initialize Reader
	@Override
	protected void initReader() {
		super.initReader();
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. initReader()");
	}

	// Initialize Widgets
	@Override
	protected void initWidgets() {
		super.initWidgets();

		// Value ListView
		lstValue = (ListView) findViewById(R.id.read_memory);
		adpValue = new MemoryListAdapter(this);
		lstValue.setAdapter(adpValue);
		lstValue.setBackgroundColor(getColor(getApplicationContext(), R.color.message_background));
		//adpValue.setValue(0, "00000000000000000000000000000000");

		ScrollView scrlParams = (ScrollView) findViewById(R.id.read_params);
		scrlParams.setBackgroundColor(getColor(getApplicationContext(), R.color.message_background));
		
		// Length Spinner
		txtLength = (TextView) findViewById(R.id.length);
		txtLength.setOnClickListener(this);

		// Read Button
		btnRead = (Button) findViewById(R.id.action_read);
		btnRead.setOnClickListener(this);
		
		setMemLength(DEFAULT_MEM_LENGTH);

		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. initWidgets()");
	}

	// Enable/Disable Action Widgets
	@Override
	protected void enableActionWidgets(boolean enabled) {
		super.enableActionWidgets(enabled);

		lstValue.setEnabled(isEnabledWidget(enabled));
		btnRead.setEnabled(isEnabledWidget(enabled, AsReaderP252BActionState.Inventory));

		if (enabled) {
			switch (getReader().getAction()) {
			case Inventory:
				btnRead.setText(R.string.action_stop);
				break;
			case Stop:
				btnRead.setText(R.string.action_read_memory);
				break;
			default:
				break;
			}
		}
		
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. enableActionWidgets(%s)", enabled);
	}

	@Override
	protected void clearWidgets() {
		super.clearWidgets();

		resetActionResult();
		adpValue.clear();

		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. clearWidgets()");
	}

	protected void setMemLength(int length) {
		mLength = length;
		txtLength.setText(String.format(Locale.US, "%d WORD", mLength));
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. setMemLength(%d)", length);
	}

	protected int getMemLength() {
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. getMemLength() - [%d]", mLength);
		return mLength;
	}

	private void showMemLengthDialog() {
		if (!mIsEnabled)
			return;

		LinearLayout root = (LinearLayout) LinearLayout.inflate(this, R.layout.dialog_list_view, null);
		final ListView value = (ListView) root.findViewById(R.id.list);
		final SpinnerAdapter adapter = new SpinnerAdapter(this, android.R.layout.simple_list_item_single_choice);

		for(int n=0; n<=15; n++) {
			adapter.addItem(n, String.format(Locale.US, "%d WORD", n));
		}
		value.setAdapter(adapter);
		value.setChoiceMode(ListView.CHOICE_MODE_SINGLE);

		AlertDialog.Builder builder = new AlertDialog.Builder(this);
		builder.setTitle(R.string.length);
		builder.setView(root);
		builder.setPositiveButton(R.string.action_ok, new DialogInterface.OnClickListener() {

			@Override
			public void onClick(DialogInterface dialog, int which) {
				int position;
				try {
					position = value.getCheckedItemPosition();
				} catch (Exception e) {
					position = DEFAULT_MEM_OFFSET;
				}
				setMemLength(position);
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showMemLengthDialog().$PositiveButton.onClick()");
			}
		});
		builder.setNegativeButton(R.string.action_cancel, new DialogInterface.OnClickListener() {

			@Override
			public void onClick(DialogInterface dialog, int which) {
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showMemLengthDialog().$NegativeButton.onClick()");
			}
		});
		builder.setCancelable(true);
		builder.setOnCancelListener(new DialogInterface.OnCancelListener() {

			@Override
			public void onCancel(DialogInterface dialog) {
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showMemLengthDialog().onCancel()");
			}
		});
		AlertDialog dialog = builder.create();
		dialog.setOnShowListener(new DialogInterface.OnShowListener() {

			@Override
			public void onShow(DialogInterface dialog) {
				int position = adapter.getPosition(mLength);
				value.setItemChecked(position, true);
				value.setSelectionFromTop(position, 0);
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showMemLengthDialog().onShow()");
			}
		});
		dialog.show();
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showMemLengthDialog()");
	}
	private void dialogShow() {
		AlertDialog.Builder builder = new AlertDialog.Builder(this);
		builder.setTitle("Please wait...");
		builder.setMessage(R.string.reading_tag_memory);
		builder.setNegativeButton(R.string.action_stop, new DialogInterface.OnClickListener() {
			@Override
			public void onClick(DialogInterface dialog, int which) {
				getReader().stop();
			}
		});
		builder.setCancelable(true);
		builder.setOnCancelListener(new DialogInterface.OnCancelListener() {

			@Override
			public void onCancel(DialogInterface dialog) {
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showPowerGinaDialog().onCancel()");
			}
		});
		readDialog = builder.create();
		readDialog.show();
	}
	private void dialogDismiss () {
		if (readDialog != null && readDialog.isShowing()) {
			readDialog.dismiss();
			readDialog = null;
		}
	}
	private static class InitTask extends AsyncTask<Void, Void, Boolean> {

		private final WeakReference<ReadMemoryActivity> mActivity;

		InitTask(ReadMemoryActivity activity) {
			mActivity = new WeakReference<>(activity);
		}

		@Override
		protected void onPreExecute() {
			ReadMemoryActivity activity = mActivity.get();
			WaitDialog.show(activity, R.string.init_mask);
			super.onPreExecute();
		}

		@Override
		protected Boolean doInBackground(Void... params) {
			// Initialize Mask
			ReadMemoryActivity activity = mActivity.get();
			activity.initMask();
			return true;
		}
		
		@Override
		protected void onPostExecute(Boolean result) {
			ReadMemoryActivity activity = mActivity.get();

			activity.resetActionResult();
			activity.setMask(activity.getMask());
			// Enable action widget
			activity.enableActionWidgets(true);
			activity.outputMessage(R.string.read_memory_intro_message);
			WaitDialog.hide();
			super.onPostExecute(result);
		}
	}
}
