package com.asreader.app.rfid.view;

import java.util.ArrayList;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;

import support.andro.app.rfid.adapter.PowerRangeAdapter;
import support.andro.app.rfid.adapter.SpinnerAdapter;
import support.andro.app.rfid.data.SaveAsCSV;
import support.andro.app.rfid.dialog.WaitDialog;
import support.andro.app.rfid.filter.InputFilterMinMax;
import support.andro.app.rfid.util.ResUtil;
import support.andro.app.rfid.view.base.AccessActivity;
import support.andro.app.rfid.view.base.BaseInventoryActivity;
import support.andro.app.rfid.view.base.RfidActivity;

import com.asreader.p252b.barcode.AsReaderP252BBarcodeType;
import com.asreader.p252b.device.type.AsReaderP252BConnectionState;
import com.asreader.p252b.rfid.exception.AsReaderP252BException;
import com.asreader.p252b.rfid.params.AsReaderP252BPowerRange;
import com.asreader.p252b.rfid.type.AsReaderP252BActionState;
import com.asreader.p252b.rfid.type.AsReaderP252BBuzzerState;
import com.asreader.p252b.rfid.type.AsReaderP252BScanMode;
import com.asreader.p252b.rfid.type.AsReaderP252BQuerySession;
import com.asreader.p252b.rfid.type.AsReaderP252BSessionFlag;
import com.asreader.p252b.rfid.type.AsReaderP252BResultCode;
import com.asreader.p252b.device.type.AsReaderP252BKeyState;
import com.asreader.app.rfid.MainActivity;
import com.asreader.app.rfid.R;
import com.asreader.p252b.AsReaderP252B;
import com.asreader.p252b.diagnostics.AsReaderP252BLog;

import android.app.ActionBar;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.PowerManager;
import android.text.InputFilter;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.TextView;

public class InventoryActivity extends BaseInventoryActivity {

	private static final String TAG = InventoryActivity.class.getSimpleName();

	private TextView txtTotalCount;
	private TextView txtSpeed;
	private LinearLayout layoutOption;
	private TextView txtPowerGain;
	private TextView txtDisplayPC;
	private TextView txtContinuousMode;
	private TextView txtReportRssi;
	private TextView txtOperationTime;
	private TextView txtQuerySession;
	private TextView txtQueryTarget;

	
	private AsReaderP252BPowerRange mAsReaderP252BPowerRange;
	private int mCurrentPowerGain;
	private boolean mDisplayPC;
	private boolean mContinuousMode;
	private boolean mReportRssi;
	private int mOperationTime;
	private AsReaderP252BQuerySession mAsReaderP252BQuerySession;
	private AsReaderP252BSessionFlag mAsReaderP252BQueryTarget;

//	private long mTotalTagCount;
	private long mLastTime;
	private double mTagSpeed;
	
	private static final String KEY_LAST_CONTINUOUS_MODE = "last_continuous_mode";
	 
	private long mSpeedTagCount;  

	private int mRestartTime;
	private boolean mIsRunRestart;
	private Handler mHandler;

	private Timer inventoryTimer;
	private ArrayList<String> tagArray;
	private long mTotalTagCounts;
	private boolean isRunning;
	PowerManager powerManager;
	PowerManager.WakeLock wakeLock;
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_inventory);
		powerManager = (PowerManager) getSystemService(POWER_SERVICE);
		wakeLock = powerManager.newWakeLock(PowerManager.FULL_WAKE_LOCK, "InventoryScan:WakeLock");
		ActionBar actionBar = getActionBar();
		if(actionBar != null) {
			actionBar.setDisplayOptions(ActionBar.DISPLAY_SHOW_CUSTOM);
			actionBar.setCustomView(R.layout.activity_title);
			actionBar.setDisplayHomeAsUpEnabled(true);
			actionBar.setDisplayShowHomeEnabled(true);
		}
		TextView titleText = (TextView)findViewById(R.id.title_text);
		titleText.setText(R.string.inventory_name);
		final int version = Build.VERSION.SDK_INT;
		if(version >= Build.VERSION_CODES.M)
			titleText.setTextColor(getColor(getApplicationContext(), R.color.black));
		
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. onCreate()");
		
		mHandler = new Handler();
		


		// Initialize Mask
		initMask();

		// Initialize Widget
		initWidgets();



		mTotalTagCounts = 0;
		mLastTime = 0;
		mTagSpeed = 0.0;
		mRestartTime = 0;
		mIsRunRestart = false;
		

		
		mSpeedTagCount = 0;
		mCurrentPowerGain = 0;
		mDisplayPC = MainActivity.mUserConfigs.getDisplayPc();

		tagArray = new ArrayList();
	}

	@Override
	protected void onDestroy() {

		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. onDestroy()");

		// Destroy Reader
		destroyReader();

		adpTags.shutDown();

		super.onDestroy();
	}
	
	@Override
	public void onBackPressed() {
		super.onBackPressed();
	}

	@Override
	protected void onStart() {
		super.onStart();
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. onStart()");
	}

	@Override
	protected void onResume() {
		WaitDialog.show(this, R.string.load);
		new Thread(mLoadOptionOnStart).start();
		super.onResume();
	}

	@Override
	protected void onStop() {
		if(getReader().getAction() == AsReaderP252BActionState.Inventory) {
			getReader().stop();
		}
		isRunning = false;
		super.onStop();
	}
	private Runnable mLoadOptionOnStart = new Runnable() {
		@Override
		public void run() {
			createReader();
			initReader();
			if(getReader().getState() == AsReaderP252BConnectionState.Connected) {
				// Load Option
//				WaitDialog.show(this, R.string.load_option);
				getReader().stop();
				try {
					mContinuousMode = getReader().getContinuousMode();
				} catch (AsReaderP252BException e) {
				}
				try {
					mReportRssi = getReader().getReportRSSI();
				} catch (AsReaderP252BException e) {
				}
				try {
					mOperationTime = getReader().getOperationTime();
				} catch (AsReaderP252BException e) {
				}
				try {
					mAsReaderP252BQuerySession = getReader().getQuerySession();
				} catch (AsReaderP252BException e) {
				}
				try {
					mAsReaderP252BQueryTarget = getReader().getSessionFlag();
				} catch (AsReaderP252BException e) {
				}
				try {
					mAsReaderP252BPowerRange = getReader().getPowerGainRange();
					mCurrentPowerGain = getReader().getPowerGain();
					mDisplayPC = MainActivity.mUserConfigs.getDisplayPc();
				} catch (AsReaderP252BException e) {
				}
			}
			mHandler.post(new Runnable() {
				@Override
				public void run() {
					// Enable action widget
					enableActionWidgets(true);
					if(getReader().getState() == AsReaderP252BConnectionState.Connected) {
						setDisplayPC(mDisplayPC);
						displayPowerGain();
						displayDisplayPC();
						displayContinuousMode();
						displayReportRSSI();
						displayOperationTime();
						displayQuerySession();
						displayQueryTarget();
					}
					WaitDialog.hide();
				}
			});
		}
	};
	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. onCreateOptionsMenu()");
		getMenuInflater().inflate(R.menu.save_file, menu);
		return true;
	}

	@Override
	public boolean onPrepareOptionsMenu(Menu menu) {
		MenuItem mnuSaveFile;

		mnuSaveFile = menu.findItem(R.id.save_csv);
		mnuSaveFile.setEnabled(getReader().getAction() == AsReaderP252BActionState.Stop);
		
		return super.onPrepareOptionsMenu(menu);
	}
	
	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		int id = item.getItemId();

		switch (id) {
		case R.id.save_csv:
			if(adpTags.getCount() < 1)
				return true;
			
			SaveAsCSV task = new SaveAsCSV(InventoryActivity.this, SaveAsCSV.DATA_TYPE_RFID, adpTags, mDisplayPC);
			task.execute();
			return true;
		}
		return super.onOptionsItemSelected(item);
	}
	
	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data) {
		super.onActivityResult(requestCode, resultCode, data);
		
		switch (requestCode) {
		case AccessActivity.VIEW_READ_MEMORY:
		case AccessActivity.VIEW_WRITE_MEMORY:
		case AccessActivity.VIEW_TAG_ACCESS:
		case RfidActivity.VIEW_MASK:
			if(getReader().getState() == AsReaderP252BConnectionState.Connected) {
				// Load Option
//				WaitDialog.show(this, R.string.load_option);
				new Thread(mLoadOption).start();
			}
			break;
		}
	}

	private void displayPowerGain() {
		txtPowerGain.setText(String.format(Locale.US, "%.1f dBm", (double) mCurrentPowerGain / 10.0));
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. displayPowerGain(%d)", mCurrentPowerGain);
	}
	
	private void displayDisplayPC() {
		txtDisplayPC.setText(mDisplayPC ? "On" : "Off");
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. displayDisplayPC(%s)", mDisplayPC);
	}

	private void displayContinuousMode() {
		txtContinuousMode.setText(mContinuousMode ? "On" : "Off");
	}
	
	private void displayReportRSSI() {
		txtReportRssi.setText(mReportRssi ? "On" : "Off");
	}
	
	private void displayOperationTime() {
		txtOperationTime.setText(String.format(Locale.US, "%d s", mOperationTime));
	}
	
	private void displayQuerySession() {
		if (mAsReaderP252BQuerySession != null) {
			txtQuerySession.setText(mAsReaderP252BQuerySession.toString());
		}
	}
	
	private void displayQueryTarget() {
		if (mAsReaderP252BQueryTarget != null) {
			txtQueryTarget.setText(mAsReaderP252BQueryTarget.toString());
		}
	}

	private Runnable mLoadOption = new Runnable() {

		@Override
		public void run() {
			
			try {
				mAsReaderP252BPowerRange = getReader().getPowerGainRange();
				mCurrentPowerGain = getReader().getPowerGain();
			} catch (AsReaderP252BException e) {
				AsReaderP252BLog.e(TAG, e, "ERROR. initReader() - Failed to get power gain");
			}
			try {
				mContinuousMode = getReader().getContinuousMode();
			} catch (AsReaderP252BException e) {
				AsReaderP252BLog.e(TAG, e, "ERROR. initReader() - Failed to get continuous mode");
			}
			try {
				mReportRssi = getReader().getReportRSSI();
			} catch (AsReaderP252BException e) {
				AsReaderP252BLog.e(TAG, e, "ERROR. initReader() - Failed to get report rssi");
			}
			try {
				mOperationTime = getReader().getOperationTime();
			} catch (AsReaderP252BException e) {
				AsReaderP252BLog.e(TAG, e, "ERROR. initReader() - Failed to get operation time");
			}
			try {
				mAsReaderP252BQuerySession = getReader().getQuerySession();
			} catch (AsReaderP252BException e) {
				AsReaderP252BLog.e(TAG, e, "ERROR. initReader() - Failed to get query session");
			}
			try {
				mAsReaderP252BQueryTarget = getReader().getSessionFlag();
			} catch (AsReaderP252BException e) {
				AsReaderP252BLog.e(TAG, e, "ERROR. initReader() - Failed to get query target");
			}

			mDisplayPC = MainActivity.mUserConfigs.getDisplayPc();

			mHandler.post(new Runnable() {

				@Override
				public void run() {
					setDisplayPC(mDisplayPC);
					displayPowerGain();
					displayDisplayPC();
					displayContinuousMode();
					displayReportRSSI();
					displayOperationTime();
					displayQuerySession();
					displayQueryTarget();
//					WaitDialog.hide();
					enableActionWidgets(true);
				}

			});
		}
		
	};

	private void showPowerGainDialog() {

		if (!mIsEnabled)
			return;

		LinearLayout root = (LinearLayout) LinearLayout.inflate(this, R.layout.dialog_list_view, null);
		final ListView power = (ListView) root.findViewById(R.id.list);
		final PowerRangeAdapter adapter = new PowerRangeAdapter(this, mAsReaderP252BPowerRange,
				android.R.layout.simple_list_item_single_choice);
		power.setAdapter(adapter);
		power.setChoiceMode(ListView.CHOICE_MODE_SINGLE);

		AlertDialog.Builder builder = new AlertDialog.Builder(this);
		builder.setTitle(R.string.power_gain);
		builder.setView(root);
		builder.setPositiveButton(R.string.action_ok, new DialogInterface.OnClickListener() {

			@Override
			public void onClick(DialogInterface dialog, int which) {
				int position = power.getCheckedItemPosition();
				int power = adapter.getItemValue(position);
				
				try {
					getReader().setPowerGain(power);
					mCurrentPowerGain = power;
					MainActivity.mUserConfigs.setPowerGain(power);
					MainActivity.mUserConfigs.Save();
				} catch (AsReaderP252BException e) {
					AsReaderP252BLog.e(TAG, e, "ERROR. $showPowerGainDialog() - Failed to set power gain (%d)", power);
				}
				
				displayPowerGain();
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showPowerGinaDialog().$PositiveButton.onClick()");
			}
		});
		builder.setNegativeButton(R.string.action_cancel, new DialogInterface.OnClickListener() {
			
			@Override
			public void onClick(DialogInterface dialog, int which) {
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showPowerGinaDialog().$NegativeButton.onClick()");
			}
		});
		builder.setCancelable(true);
		builder.setOnCancelListener(new DialogInterface.OnCancelListener() {
			
			@Override
			public void onCancel(DialogInterface dialog) {
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showPowerGinaDialog().onCancel()");
			}
		});
		AlertDialog dialog = builder.create();
		dialog.setOnShowListener(new DialogInterface.OnShowListener() {

			@Override
			public void onShow(DialogInterface dialog) {
				int position = adapter.getItemPosition(mCurrentPowerGain);
				power.setItemChecked(position, true);
				power.setSelectionFromTop(position, 0);
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showPowerGinaDialog().onShow()");
			}
		});
		dialog.show();

		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showPowerGinaDialog()");
	}
	
	private void showDisplayPcDialog() {
		if (!mIsEnabled)
			return;

		LinearLayout root = (LinearLayout) LinearLayout.inflate(this, R.layout.dialog_list_view, null);
		final ListView value = (ListView) root.findViewById(R.id.list);
		final SpinnerAdapter adapter = new SpinnerAdapter(this, android.R.layout.simple_list_item_single_choice);
		adapter.addItem(0, "Off");
		adapter.addItem(1, "On");
		value.setAdapter(adapter);
		value.setChoiceMode(ListView.CHOICE_MODE_SINGLE);

		AlertDialog.Builder builder = new AlertDialog.Builder(this);
		builder.setTitle(R.string.display_pc);
		builder.setView(root);
		builder.setPositiveButton(R.string.action_ok, new DialogInterface.OnClickListener() {

			@Override
			public void onClick(DialogInterface dialog, int which) {
				try {
					int position = value.getCheckedItemPosition();
					mDisplayPC = adapter.getValue(position) > 0;
					setDisplayPC(mDisplayPC);
					MainActivity.mUserConfigs.setDisplayPc(mDisplayPC);
					MainActivity.mUserConfigs.Save();
				} catch (Exception e) {
					AsReaderP252BLog.e(TAG, "ERROR.  showDisplayPcDialog().$PositiveButton.onClick() - [%s]"
								, e.getMessage());
				}
				displayDisplayPC();
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showDisplayPcDialog().$PositiveButton.onClick()");
			}
		});
		builder.setNegativeButton(R.string.action_cancel, new DialogInterface.OnClickListener() {

			@Override
			public void onClick(DialogInterface dialog, int which) {
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showDisplayPcDialog().$NegativeButton.onClick()");
			}
		});
		builder.setCancelable(true);
		builder.setOnCancelListener(new DialogInterface.OnCancelListener() {

			@Override
			public void onCancel(DialogInterface dialog) {
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showDisplayPcDialog().onCancel()");
			}
		});
		AlertDialog dialog = builder.create();
		dialog.setOnShowListener(new DialogInterface.OnShowListener() {

			@Override
			public void onShow(DialogInterface dialog) {
				int position = adapter.getPosition(mDisplayPC ? 1 : 0);
				value.setItemChecked(position, true);
				value.setSelectionFromTop(position, 0);
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showDisplayPcDialog().onShow()");
			}
		});
		dialog.show();
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showDisplayPcDialog()");
	}
	
	private void showContinuousModeDialog() {
		if (!mIsEnabled)
			return;

		LinearLayout root = (LinearLayout) LinearLayout.inflate(this, R.layout.dialog_list_view, null);
		final ListView value = (ListView) root.findViewById(R.id.list);
		final SpinnerAdapter adapter = new SpinnerAdapter(this, android.R.layout.simple_list_item_single_choice);
		adapter.addItem(0, "Off");
		adapter.addItem(1, "On");
		value.setAdapter(adapter);
		value.setChoiceMode(ListView.CHOICE_MODE_SINGLE);

		AlertDialog.Builder builder = new AlertDialog.Builder(this);
		builder.setTitle(R.string.continuous_mode);
		builder.setView(root);
		builder.setPositiveButton(R.string.action_ok, new DialogInterface.OnClickListener() {

			@Override
			public void onClick(DialogInterface dialog, int which) {
				try {
					int position = value.getCheckedItemPosition();
					mContinuousMode = adapter.getValue(position) > 0;
					getReader().setContinuousMode(mContinuousMode);
					MainActivity.mUserConfigs.setIsContinuousMode(mContinuousMode);
					MainActivity.mUserConfigs.Save();
					saveConinuousMode();
				} catch (Exception e) {
					AsReaderP252BLog.e(TAG, "ERROR.  showContinuousModeDialog().$PositiveButton.onClick() - [%s]"
							, e.getMessage());
				}
				displayContinuousMode();
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showContinuousModeDialog().$PositiveButton.onClick()");
			}
		});
		builder.setNegativeButton(R.string.action_cancel, new DialogInterface.OnClickListener() {

			@Override
			public void onClick(DialogInterface dialog, int which) {
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showContinuousModeDialog().$NegativeButton.onClick()");
			}
		});
		builder.setCancelable(true);
		builder.setOnCancelListener(new DialogInterface.OnCancelListener() {

			@Override
			public void onCancel(DialogInterface dialog) {
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showContinuousModeDialog().onCancel()");
			}
		});
		AlertDialog dialog = builder.create();
		dialog.setOnShowListener(new DialogInterface.OnShowListener() {

			@Override
			public void onShow(DialogInterface dialog) {
				int position = adapter.getPosition(mContinuousMode ? 1 : 0);
				value.setItemChecked(position, true);
				value.setSelectionFromTop(position, 0);
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showContinuousModeDialog().onShow()");
			}
		});
		dialog.show();
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showContinuousModeDialog()");
	}
	
	private void showReportRssiDialog() {
		if (!mIsEnabled)
			return;

		LinearLayout root = (LinearLayout) LinearLayout.inflate(this, R.layout.dialog_list_view, null);
		final ListView value = (ListView) root.findViewById(R.id.list);
		final SpinnerAdapter adapter = new SpinnerAdapter(this, android.R.layout.simple_list_item_single_choice);
		adapter.addItem(0, "Off");
		adapter.addItem(1, "On");
		value.setAdapter(adapter);
		value.setChoiceMode(ListView.CHOICE_MODE_SINGLE);

		AlertDialog.Builder builder = new AlertDialog.Builder(this);
		builder.setTitle(R.string.report_rssi);
		builder.setView(root);
		builder.setPositiveButton(R.string.action_ok, new DialogInterface.OnClickListener() {

			@Override
			public void onClick(DialogInterface dialog, int which) {
				try {
					int position = value.getCheckedItemPosition();
					mReportRssi = adapter.getValue(position) > 0;
					getReader().setReportRSSI(mReportRssi);
					MainActivity.mUserConfigs.setReportRssi(mReportRssi);
					MainActivity.mUserConfigs.Save();
					setReportRssiMode(mReportRssi);
					mTotalTagCounts = 0;
					tagArray = new ArrayList();
				} catch (Exception e) {
					AsReaderP252BLog.e(TAG, "ERROR.  showReportRssiDialog().$PositiveButton.onClick() - [%s]"
							, e.getMessage());
				}
				displayReportRSSI();
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showReportRssiDialog().$PositiveButton.onClick()");
			}
		});
		builder.setNegativeButton(R.string.action_cancel, new DialogInterface.OnClickListener() {

			@Override
			public void onClick(DialogInterface dialog, int which) {
				mTotalTagCounts = 0;
				tagArray = new ArrayList();
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showReportRssiDialog().$NegativeButton.onClick()");
			}
		});
		builder.setCancelable(true);
		builder.setOnCancelListener(new DialogInterface.OnCancelListener() {

			@Override
			public void onCancel(DialogInterface dialog) {
				mTotalTagCounts = 0;
				tagArray = new ArrayList();
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showReportRssiDialog().onCancel()");
			}
		});
		AlertDialog dialog = builder.create();
		dialog.setOnShowListener(new DialogInterface.OnShowListener() {

			@Override
			public void onShow(DialogInterface dialog) {
				int position = adapter.getPosition(mReportRssi ? 1 : 0);
				value.setItemChecked(position, true);
				value.setSelectionFromTop(position, 0);
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showReportRssiDialog().onShow()");
			}
		});
		dialog.show();
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showReportRssiDialog()");
	}
	
	private void showOperationTimeDialog() {

		if (!mIsEnabled)
			return;

		LinearLayout root = (LinearLayout) LinearLayout.inflate(this, R.layout.dialog_input_unit, null);
		final TextView unit = (TextView) root.findViewById(R.id.unit);
		unit.setText(R.string.unit_sec);
		final EditText value = (EditText) root.findViewById(R.id.value);
		InputFilter[] filters = new InputFilter[] { new InputFilterMinMax(0, 1800) };
		value.setFilters(filters);

		AlertDialog.Builder builder = new AlertDialog.Builder(this);
		builder.setTitle(R.string.operation_time);
		builder.setView(root);
		builder.setPositiveButton(R.string.action_ok, new DialogInterface.OnClickListener() {

			@Override
			public void onClick(DialogInterface dialog, int which) {
				
				try {
					mOperationTime = Integer.parseInt(value.getText().toString());
				} catch (Exception e) {
					mOperationTime = 0;
				}
				try {
					getReader().setOperationTime(mOperationTime);
					MainActivity.mUserConfigs.setOperationTime(mOperationTime);
					MainActivity.mUserConfigs.Save();
				} catch (Exception e) {
					AsReaderP252BLog.e(TAG, "ERROR.  showOperationTimeDialog().$PositiveButton.onClick() - [%s]"
							, e.getMessage());
				}
				displayOperationTime();
				InputMethodManager imm = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
				if(imm != null)
					imm.hideSoftInputFromWindow(value.getWindowToken(), 0);
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showOperationTimeDialog().$PositiveButton.onClick()");
			}
		});
		builder.setNegativeButton(R.string.action_cancel, new DialogInterface.OnClickListener() {

			@Override
			public void onClick(DialogInterface dialog, int which) {
				InputMethodManager imm = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
				if(imm != null)
					imm.hideSoftInputFromWindow(value.getWindowToken(), 0);
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showOperationTimeDialog().$NegativeButton.onClick()");
			}
		});
		builder.setCancelable(true);
		builder.setOnCancelListener(new DialogInterface.OnCancelListener() {

			@Override
			public void onCancel(DialogInterface dialog) {
				InputMethodManager imm = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
				if(imm != null)
					imm.hideSoftInputFromWindow(value.getWindowToken(), 0);
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showOperationTimeDialog().onCancel()");
			}
		});
		AlertDialog dialog = builder.create();
		dialog.setOnShowListener(new DialogInterface.OnShowListener() {

			@Override
			public void onShow(DialogInterface dialog) {
				value.setText(String.format(Locale.US, "%d", mOperationTime));
				value.selectAll();
				value.requestFocus();
				InputMethodManager imm = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
				if(imm != null)
					imm.showSoftInput(value, InputMethodManager.SHOW_FORCED);
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showOperationTimeDialog().onShow()");
			}
		});
		dialog.show();

		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showOperationTimeDialog()");
	}
	
	private void showQuerySessionDialog() {
		if (!mIsEnabled)
			return;

		LinearLayout root = (LinearLayout) LinearLayout.inflate(this, R.layout.dialog_list_view, null);
		final ListView value = (ListView) root.findViewById(R.id.list);
		final SpinnerAdapter adapter = new SpinnerAdapter(this, android.R.layout.simple_list_item_single_choice);
		for (AsReaderP252BQuerySession item : AsReaderP252BQuerySession.values()) {
			adapter.addItem(item.getValue(), item.toString());
		}
		value.setAdapter(adapter);
		value.setChoiceMode(ListView.CHOICE_MODE_SINGLE);

		AlertDialog.Builder builder = new AlertDialog.Builder(this);
		builder.setTitle(R.string.inventory_session);
		builder.setView(root);
		builder.setPositiveButton(R.string.action_ok, new DialogInterface.OnClickListener() {

			@Override
			public void onClick(DialogInterface dialog, int which) {
				try {
					int position = value.getCheckedItemPosition();
					mAsReaderP252BQuerySession = AsReaderP252BQuerySession.valueOf(adapter.getValue(position));
					getReader().setQuerySession(mAsReaderP252BQuerySession);
					MainActivity.mUserConfigs.setSession(mAsReaderP252BQuerySession);
					MainActivity.mUserConfigs.Save();
				} catch (Exception e) {
					AsReaderP252BLog.e(TAG, "ERROR.  showQuerySessionDialog().$PositiveButton.onClick() - [%s]"
							, e.getMessage());
				}
				displayQuerySession();
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showQuerySessionDialog().$PositiveButton.onClick()");
			}
		});
		builder.setNegativeButton(R.string.action_cancel, new DialogInterface.OnClickListener() {

			@Override
			public void onClick(DialogInterface dialog, int which) {
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showQuerySessionDialog().$NegativeButton.onClick()");
			}
		});
		builder.setCancelable(true);
		builder.setOnCancelListener(new DialogInterface.OnCancelListener() {

			@Override
			public void onCancel(DialogInterface dialog) {
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showQuerySessionDialog().onCancel()");
			}
		});
		AlertDialog dialog = builder.create();
		dialog.setOnShowListener(new DialogInterface.OnShowListener() {

			@Override
			public void onShow(DialogInterface dialog) {
				int position = adapter.getPosition(mAsReaderP252BQuerySession.getValue());
				value.setItemChecked(position, true);
				value.setSelectionFromTop(position, 0);
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showQuerySessionDialog().onShow()");
			}
		});
		dialog.show();
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showQuerySessionDialog()");
	}
	
	private void showQueryTargetDialog() {
		if (!mIsEnabled)
			return;

		LinearLayout root = (LinearLayout) LinearLayout.inflate(this, R.layout.dialog_list_view, null);
		final ListView value = (ListView) root.findViewById(R.id.list);
		final SpinnerAdapter adapter = new SpinnerAdapter(this, android.R.layout.simple_list_item_single_choice);
		for (AsReaderP252BSessionFlag item : AsReaderP252BSessionFlag.values()) {
			adapter.addItem(item.getValue(), item.toString());
		}
		value.setAdapter(adapter);
		value.setChoiceMode(ListView.CHOICE_MODE_SINGLE);

		AlertDialog.Builder builder = new AlertDialog.Builder(this);
		builder.setTitle(R.string.target);
		builder.setView(root);
		builder.setPositiveButton(R.string.action_ok, new DialogInterface.OnClickListener() {

			@Override
			public void onClick(DialogInterface dialog, int which) {
				try {
					int position = value.getCheckedItemPosition();
					mAsReaderP252BQueryTarget = AsReaderP252BSessionFlag.valueOf(adapter.getValue(position));
					getReader().setSessionFlag(mAsReaderP252BQueryTarget);
					MainActivity.mUserConfigs.setTarget(mAsReaderP252BQueryTarget);
					MainActivity.mUserConfigs.Save();
				} catch (Exception e) {
					AsReaderP252BLog.e(TAG, "ERROR.  showQueryTargetDialog().$PositiveButton.onClick() - [%s]"
							, e.getMessage());
				}
				displayQueryTarget();
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showQueryTargetDialog().$PositiveButton.onClick()");
			}
		});
		builder.setNegativeButton(R.string.action_cancel, new DialogInterface.OnClickListener() {

			@Override
			public void onClick(DialogInterface dialog, int which) {
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showQueryTargetDialog().$NegativeButton.onClick()");
			}
		});
		builder.setCancelable(true);
		builder.setOnCancelListener(new DialogInterface.OnCancelListener() {

			@Override
			public void onCancel(DialogInterface dialog) {
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showQueryTargetDialog().onCancel()");
			}
		});
		AlertDialog dialog = builder.create();
		dialog.setOnShowListener(new DialogInterface.OnShowListener() {

			@Override
			public void onShow(DialogInterface dialog) {
				int position = adapter.getPosition(mAsReaderP252BQueryTarget.getValue());
				value.setItemChecked(position, true);
				value.setSelectionFromTop(position, 0);
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showQueryTargetDialog().onShow()");
			}
		});
		dialog.show();
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showQueryTargetDialog()");
	}

	@Override
	public void onClick(View v) {
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. onClick(%s)", ResUtil.getId(v.getId()));
		switch (v.getId()) {
		case R.id.option:
			if(layoutOption.getVisibility() == View.VISIBLE) {
				layoutOption.setVisibility(View.GONE);
			} else {
				layoutOption.setVisibility(View.VISIBLE);
			}
			break;
		case R.id.inventory_power_gain:
			showPowerGainDialog();
			break;
		case R.id.inventory_display_pc:
			showDisplayPcDialog();
			break;
		case R.id.inventory_continuous_mode:
			showContinuousModeDialog();
			break;
		case R.id.inventory_report_rssi:
			showReportRssiDialog();
			break;
		case R.id.inventory_operation_time:
			showOperationTimeDialog();
			break;
		case R.id.inventory_query_session:
			showQuerySessionDialog();
			break;
		case R.id.inventory_query_target:
			showQueryTargetDialog();
			break;
		case R.id.mask:
			asReaderP252BSelectMaskEpcParam.setMask("");
			break;
		}
		
		super.onClick(v);
	}

	@Override
	public void onReadTag(AsReaderP252B reader, AsReaderP252BActionState action, String tag, float rssi, float phase, float frequency) {
//		long time = System.currentTimeMillis();
//		double interval;

		AsReaderP252BLog.d(TAG, AsReaderP252BLog.DEBUG, "EVENT. onReadTag(%s, [%s], %.2f, %.2f, %.2f)", action, tag, rssi, phase, frequency);

		mTotalTagCounts++;
		mSpeedTagCount++;
//		if (mLastTime == 0) {
//			mTagSpeed = 0.0;
//			mLastTime = time;
//		} else {
//			interval = (double) (time - mLastTime) / 1000.0;
//			mTagSpeed = (double) mSpeedTagCount / interval;
//		}

		super.onReadTag(reader, action, tag, rssi, phase, frequency);

		txtTotalCount.setText(String.format(Locale.US, "%d", mTotalTagCounts));
//		txtSpeed.setText(String.format(Locale.US, "%.2f tps", mTagSpeed));
	}

	@Override
	public void onReadBarcode(AsReaderP252B reader, AsReaderP252BBarcodeType type, String barcode) {
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "EVENT. onReadBarcode (%s, [%s])", type, barcode);
	}

	@Override
	public void onReadBarcode(AsReaderP252B reader, AsReaderP252BBarcodeType type, byte[] barcodeData) {
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "EVENT. onReadBarcode (%s, [%s])", type, barcodeData);
	}

	@Override
	public void onReadTemperatureTag(AsReaderP252B reader, AsReaderP252BActionState action, String tag, float rssi, float phase, float frequency, float temperature) {

	}

	@Override
	public void onReadHumidityTag(AsReaderP252B reader, AsReaderP252BActionState action, String tag, float rssi, float phase, float frequency, float humidity) {

	}

	@Override
	public void onActionChanged(AsReaderP252B reader, AsReaderP252BActionState action) {
		
		if (mIsRunRestart) {
			adpTags.notifyDataSetChanged();
			if (action != AsReaderP252BActionState.Stop) {
				enableActionWidgets(true);
			}
		} else {
			super.onActionChanged(reader, action);
		}
		
		if(action == AsReaderP252BActionState.Stop){
			mSpeedTagCount = 0;
			mLastTime =0;
			
			if (mRestartTime > 0 && mIsRunRestart) {
				mHandler.postDelayed(mRestartHandler, mRestartTime);
			}
		}
	}

	@Override
	public void onReceivedData(byte[] data) {

	}

	@Override
	public boolean onKeyEvent(AsReaderP252B reader, AsReaderP252BKeyState state) {
		if (state == AsReaderP252BKeyState.KeyDown) {
			if (reader.getAction() != AsReaderP252BActionState.Stop) {
				stopInventory();
			} else {
				startInventory();
			}
		}
		return false;
	}

	@Override
	public boolean onModeKeyEvent(AsReaderP252B reader, AsReaderP252BKeyState state) {
		return false;
	}

	// Initialize Reader
	@Override
	protected void initReader() {
		try {
			Thread.sleep(1000);
		} catch (InterruptedException e) {
		}
		super.initReader();
		try {
			getReader().setScanMode(AsReaderP252BScanMode.RFIDScanMode);
			adpTags.setReportRSSI(getReader().getReportRSSI());
		} catch (AsReaderP252BException e) {
			AsReaderP252BLog.e(TAG, e, "ERROR. initReader() - Failed to get report rssi mode");
		}
		
		loadContinuousMode();
		
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. initReader()");
	}
	
	// Initialize Widgets
	@Override
	protected void initWidgets() {
		super.initWidgets();
		
		// Total Count TextView
		txtTotalCount = (TextView) findViewById(R.id.total_tag_count);
		txtTotalCount.setText(String.format(Locale.US, "%d", mTotalTagCounts));
		txtSpeed = (TextView) findViewById(R.id.speed);
		txtSpeed.setText(R.string.init_tps);
		layoutOption = (LinearLayout) findViewById(R.id.inventory_option);
		layoutOption.setVisibility(View.VISIBLE);
		layoutOption.setBackgroundColor(getColor(getApplicationContext(), R.color.message_background));
		txtPowerGain = (TextView) findViewById(R.id.inventory_power_gain);
		txtPowerGain.setOnClickListener(this);
		txtDisplayPC = (TextView) findViewById(R.id.inventory_display_pc);
		txtDisplayPC.setOnClickListener(this);
		txtContinuousMode = (TextView) findViewById(R.id.inventory_continuous_mode);
		txtContinuousMode.setOnClickListener(this);
		txtReportRssi = (TextView) findViewById(R.id.inventory_report_rssi);
		txtReportRssi.setOnClickListener(this);
		txtOperationTime = (TextView) findViewById(R.id.inventory_operation_time);
		txtOperationTime.setOnClickListener(this);
		txtQuerySession = (TextView) findViewById(R.id.inventory_query_session);
		txtQuerySession.setOnClickListener(this);
		txtQueryTarget = (TextView) findViewById(R.id.inventory_query_target);
		txtQueryTarget.setOnClickListener(this);
		
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. initWidgets()");
	}

	// Enable/Disable Action Widgets
	@Override
	protected void enableActionWidgets(boolean enabled) {
		super.enableActionWidgets(enabled);
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. enableActionWidgets(%s)", enabled);
	}

	@Override
	protected void clearWidgets() {
		super.clearWidgets();
		
//		mSpeedTagCount =0;
//		mTotalTagCount = 0;
		mLastTime = 0;
		mTagSpeed = 0.0;
		mTotalTagCounts = 0;
		tagArray = new ArrayList();
		txtTotalCount.setText(String.format(Locale.US, "%d", mTotalTagCounts));
		txtSpeed.setText(String.format(Locale.US, "%.2f tps", mTagSpeed));
		
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. clearWidgets()");
	}

	@Override
	protected void startInventory() {
//		if(getReader().getAction() != ActionState.Stop)
//			return;
		
		mIsRunRestart = mRestartTime > 0;
		startInventoryTimer();
		new Thread(new Runnable() {
			public void run() {
				while (isRunning) {
					tagArray.add(0, String.valueOf(mTotalTagCounts));
					AsReaderP252BLog.e(TAG, "====SSS===" + tagArray );

					if (tagArray.size() > 2) {
						tagArray.remove(tagArray.size() - 1);
					}

					String last = tagArray.get(0);
					String first = tagArray.get(tagArray.size() - 1);
					mTagSpeed = (Long.valueOf(last) - Long.valueOf(first)) ;
					AsReaderP252BLog.e(TAG, "====EEE===" + tagArray +"====" + mTagSpeed);
					Log.e("Test~~~mTagSpeed", String.valueOf(mTagSpeed));
					Log.e("Test~~~isRunning", String.valueOf(isRunning));
					runOnUiThread(calculateTheMean);
					try {
						Thread.sleep(1000);
					} catch (InterruptedException e) {
						throw new RuntimeException(e);
					}
				}
			}

		}).start();
		super.startInventory();
		if (wakeLock!=null)
			wakeLock.acquire();
	}

	@Override
	protected void stopInventory() {
//		if(getReader().getAction() == ActionState.Stop)
//			return;
		isRunning = false;
		mIsRunRestart = false;
		super.stopInventory();
		if (wakeLock!=null)
			wakeLock.release();
	}

	private void startInventoryTimer() {
		tagArray.clear();
		tagArray.add(0, String.valueOf(mTotalTagCounts));
		isRunning = true;
	}


	private Runnable calculateTheMean = new Runnable() {
		@Override
		public void run() {
			txtSpeed.setText(String.format(Locale.US, "%.2f tps", mTagSpeed));
		}
	};

	private Runnable mRestartHandler = new Runnable() {

		@Override
		public void run() {
			if (getReader().inventory() != AsReaderP252BResultCode.NoError) {
				AsReaderP252BLog.e(TAG, "ERROR. $mRestartHandler.run() - Failed to start inventory()");
				enableActionWidgets(true);
				return;
			}
			AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. $mRestartHandler.run()");
		}
	};
	
	private void saveConinuousMode() {
		SharedPreferences prefs = getSharedPreferences(MainActivity.APP_NAME, MODE_PRIVATE);
		SharedPreferences.Editor editor = prefs.edit();

		editor.putBoolean(KEY_LAST_CONTINUOUS_MODE, mContinuousMode);
		editor.apply();
		AsReaderP252BLog.d(TAG, AsReaderP252BLog.DEBUG, "DEBUG. saveConinuousMode() - last Continuous Mode : [%s]", mContinuousMode);
	}
	
	private void loadContinuousMode() {
		SharedPreferences prefs = getSharedPreferences(MainActivity.APP_NAME, MODE_PRIVATE);
		mContinuousMode = prefs.getBoolean(KEY_LAST_CONTINUOUS_MODE, true);
		AsReaderP252BLog.d(TAG, AsReaderP252BLog.DEBUG, "DEBUG. loadContinuousMode() - last Continuous Mode : [%s]", mContinuousMode);
		
		if(getReader() != null) {
			try {
				getReader().setContinuousMode(mContinuousMode);
			} catch (AsReaderP252BException e) {
				AsReaderP252BLog.e(TAG, e, "ERROR. loadContinuousMode() - Failed to set continuous mode");
			}
		}
	}
}
