package support.andro.app.rfid.view.base;

import support.andro.app.rfid.util.ResUtil;
import com.asreader.p252b.AsReaderP252BManager;
import com.asreader.p252b.AsReaderP252B;
import com.asreader.p252b.device.type.AsReaderP252BConnectionState;
import com.asreader.p252b.diagnostics.AsReaderP252BLog;
import com.asreader.p252b.rfid.event.AsReaderP252BEventListener;
import com.asreader.p252b.rfid.type.AsReaderP252BActionState;
import com.asreader.p252b.device.type.AsReaderP252BKeyState;
import com.asreader.p252b.rfid.type.AsReaderP252BResultCode;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.widget.Button;

public abstract class RfidActivity extends SubActivity implements AsReaderP252BEventListener {

	private static final String TAG = RfidActivity.class.getSimpleName();

	protected static final int VIEW_MASK = 1000;
	protected static final int VIEW_BARCODE_OPTION_GS1_COMPOSITE = 2001;
	protected static final int VIEW_BARCODE_OPTION_OTHERS = 2010;

	protected static final int RESULT_DISCONNECTED = Activity.RESULT_FIRST_USER + 1;

	public static final String KEY_ACTION = "key_action";
	
	public static final boolean DEFAULT_KEY_ACTION = true;

	private AsReaderP252B mReader = null;
	private boolean mKeyAction;
	
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
	
		mKeyAction = getIntent().getBooleanExtra(KEY_ACTION, DEFAULT_KEY_ACTION);
	}

	// Retreive RFID Reader
	protected AsReaderP252B getReader() {
		return mReader;
	}

	// Create Reader
	protected void createReader() {
		mReader = AsReaderP252BManager.getInstance();
		mReader.setEventListener(this);

		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. createReader()");
	}

	// Destroy Reader
	protected void destroyReader() {
		mReader.removeEventListener(this);
		if (mReader.getAction() != AsReaderP252BActionState.Stop &&
				mReader.getState() == AsReaderP252BConnectionState.Connected) {
			mReader.stop();
		}
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. destroyReader()");
	}

	// Initialize Reader
	protected abstract void initReader();

	protected boolean isReaderAction() {
		return mReader.getAction() != AsReaderP252BActionState.Stop;
	}

	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data) {

		AsReaderP252BLog.d(TAG, AsReaderP252BLog.DEBUG, "DEBUG. onActivityResult(%s, %s)", getRequestCode(requestCode), getResultCode(resultCode));

		//if (requestCode == VIEW_MASK && resultCode == RESULT_DISCONNECTED) {
		if ((requestCode == VIEW_MASK || requestCode == VIEW_BARCODE_OPTION_GS1_COMPOSITE || requestCode == VIEW_BARCODE_OPTION_OTHERS) &&
				resultCode == RESULT_DISCONNECTED) {
			setResult(RESULT_DISCONNECTED);
			finish();
			return;
		}

		super.onActivityResult(requestCode, resultCode, data);
	}

	@Override
	public void onStateChanged(AsReaderP252B reader, AsReaderP252BConnectionState state) {
		AsReaderP252BLog.d(TAG, AsReaderP252BLog.DEBUG, "EVENT. onStateChanged(%s)", state);

		if (state == AsReaderP252BConnectionState.Disconnected) {
			setResult(RESULT_DISCONNECTED);
			finish();
		}
	}

	@Override
	public void onActionChanged(AsReaderP252B reader, AsReaderP252BActionState action) {
		AsReaderP252BLog.d(TAG, AsReaderP252BLog.DEBUG, "EVENT. onActionChanged(%s)", action);
	}

	@Override
	public void onReadTag(AsReaderP252B reader, AsReaderP252BActionState action, String tag, float rssi, float phase, float frequency) {
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "EVENT. onReadedTag(%s, [%s], %.2f, %.2f)", action, tag, rssi, phase);
	}

	@Override
	public void onAccessResult(AsReaderP252B reader, AsReaderP252BResultCode code, AsReaderP252BActionState action, String epc, String data,
							   float rssi, float phase, float frequency) {
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "EVENT. onAccessResult(%s, %s, [%s], [%s], %.2f, %.2f)", code, action, epc, data, rssi, phase);
	}

	@Override
	public boolean onKeyEvent(AsReaderP252B reader, AsReaderP252BKeyState state) {
		return false;
	}

	@Override
	public boolean onModeKeyEvent(AsReaderP252B reader, AsReaderP252BKeyState state) {
		return false;
	}

	@Override
	protected void initWidgets() {
		
	}

	@Override
	protected void enableActionWidgets(boolean enabled) {
		
	}

	protected void enableActionButton(Button action, boolean enabled, int actionId, int stopId) {
		action.setEnabled(enabled);
		
		if (enabled) {
			action.setText(getReader().getAction() == AsReaderP252BActionState.Stop ? actionId : stopId);
		}
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. enableActionButton(%s, %s, %d, %d)", ResUtil.getId(action.getId()), enabled, actionId,
				stopId);
	}

	protected boolean isEnabledWidget(boolean enabled) {
		AsReaderP252BActionState action = getReader().getAction();
		return enabled ? (action == AsReaderP252BActionState.Stop ? enabled : false) : enabled;
	}

	protected boolean isEnabledWidget(boolean enabled, AsReaderP252BActionState state) {
		AsReaderP252BActionState action = getReader().getAction();
		return enabled ? (action == AsReaderP252BActionState.Stop ? enabled : (action == state ? enabled : false)) : enabled;
	}

	protected String getResultCode(int resultCode) {

		switch (resultCode) {
		case RESULT_DISCONNECTED:
			return "RESULT_DISCONNECTED";
		}
		return super.getResultCode(resultCode);
	}
	
	protected boolean getKeyAction() {
		return mKeyAction;
	}
	
	protected void setKeyAction(boolean enabled) {
		mKeyAction = enabled;
	}
	
	@SuppressLint("NewApi")
	@SuppressWarnings("deprecation")
	protected int getColor(Context context, int id) {
		final int version = Build.VERSION.SDK_INT;
		if(version >= Build.VERSION_CODES.M)
			return context.getColor(id);
		else
			return context.getResources().getColor(id);
	}
}
