package support.andro.app.rfid.data;

import android.app.AlertDialog;
import android.content.Context;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Environment;
import android.util.Log;
import android.widget.BaseAdapter;
import support.andro.app.rfid.adapter.BarcodeListAdapter;
import support.andro.app.rfid.adapter.TagListAdapter;
import support.andro.app.rfid.dialog.WaitDialog;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

import com.asreader.app.rfid.R;
import com.asreader.p252b.diagnostics.AsReaderP252BLog;

public class SaveAsCSV extends AsyncTask<Void, Void, Boolean>{
	
	private static final String TAG = SaveAsCSV.class.getSimpleName();
	private WeakReference<Context> mWeakContext;
	private Context context;
	private int mMaxCount = 0;
	private int mDataType = DATA_TYPE_UNKNOWN;
	private TagListAdapter mTagList = null;
	private BarcodeListAdapter mBarcodeList;
	private File download;
	private String mFileName = "";
	private String mColumnName = "";
	private boolean mDisplayPc = false;

	public static final int DATA_TYPE_UNKNOWN = 0;
	public static final int DATA_TYPE_RFID = 1;
	public static final int DATA_TYPE_BARCODE = 2;

	public SaveAsCSV(Context context, int dataType, BaseAdapter data, boolean displayPc) {

		mWeakContext = new WeakReference<>(context);
		this.context = context;
		mDataType = dataType;
		mDisplayPc = displayPc;

		long now = System.currentTimeMillis();
		SimpleDateFormat simpleDate = new SimpleDateFormat("yyMMddHHmmss");
		String getTime = simpleDate.format(new Date(now));

		switch (mDataType) {
			case DATA_TYPE_RFID:
				mTagList = (TagListAdapter)data;
				mFileName = "/rfid_"+getTime+".csv";
				if (mTagList.getReportRSSI())
					mColumnName = String.format(Locale.US, "%s,time,count,rssi", mDisplayPc ? "pcepc hex" : "epc hex");
				else
					mColumnName = String.format(Locale.US, "%s,time,count", mDisplayPc ? "pcepc hex" : "epc hex");
				break;
			case DATA_TYPE_BARCODE:
				mBarcodeList = (BarcodeListAdapter) data;
				mFileName = "/barcode_" + getTime + ".csv";
				mColumnName = "barcode,time";
				break;
			default:
				mTagList = null;
				break;
		}
		AsReaderP252BLog.e(TAG, mWeakContext.get().getPackageName());
	}

	@Override
	protected void onPreExecute() {
		
		if(mWeakContext == null)
			return;
		
		if(mDataType == DATA_TYPE_RFID && mTagList == null)
			return;

		
		switch(mDataType) {
			case DATA_TYPE_RFID:
				mMaxCount = mTagList.getCount();
				break;
			case DATA_TYPE_BARCODE:
				mMaxCount = mBarcodeList.getCount();
				break;
		default:
			return;
		}
		
		WaitDialog.showProgess(mWeakContext.get(), R.string.saving_csv);
		WaitDialog.setMax(mMaxCount);
		
		super.onPreExecute();
	}

	@Override
	protected Boolean doInBackground(Void... params) {
		download = Environment.getExternalStoragePublicDirectory(Environment.DIRECTORY_DOWNLOADS);
		if(!download.exists()) {
			if(!download.mkdirs()) {
				AsReaderP252BLog.e(TAG, "doInBackground() - failed to create directory (%s)", download.getAbsolutePath());
				return false;
			}
		}

		String fileName = download.getPath() + mFileName;
		BufferedWriter writer;
		try {
			writer = new BufferedWriter(new FileWriter(fileName, false));
		} catch (IOException e) {
			AsReaderP252BLog.e(TAG, "doInBackground() - failed to create BufferedWriter");
			return false;
		}

		try {
			writer.write(mColumnName);
			writer.write("\n");
		} catch (IOException e1) {
			try {
				writer.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
			AsReaderP252BLog.e(TAG, "doInBackground() - failed to write the data");
			return false;
		}

		String data;
		for(int i=0; i<mMaxCount; i++) {
			switch(mDataType) {
				case DATA_TYPE_RFID:
					data = mTagList.getItemForCsv(i, mDisplayPc);
					break;
				case DATA_TYPE_BARCODE:
					data = mBarcodeList.getItemForCsv(i);
					if(data.contains("\r\n")) {
						data = data.replace("\r\n", "");
					}
					break;
				default:
					return false;
			}

			try {
				writer.write(data);
				writer.write("\n");
			} catch (IOException e) {
				try {
					writer.close();
				} catch (IOException e1) {
					e1.printStackTrace();
				}
				AsReaderP252BLog.e(TAG, "doInBackground() - failed to write the data");
				return false;
			}
			WaitDialog.setProgress(i);
		}

		try {
			writer.flush();
			writer.close();
		} catch (IOException e) {
			AsReaderP252BLog.e(TAG, "doInBackground() - failed to flush");
		}

		setUpdateFileList();

		return true;
	}

	@Override
	protected void onPostExecute(Boolean result) {
		WaitDialog.hide();

		AlertDialog.Builder builder = new AlertDialog.Builder(mWeakContext.get());
		builder.setMessage(result ? R.string.save_complete : R.string.failed_to_save);
		builder.setPositiveButton(R.string.action_ok, null);
		builder.setCancelable(true);
		builder.show();
		super.onPostExecute(result);
	}

	/**
	 * [Note]  Update saved log file list in directory (Android OS function)
	 * @Method setUpdateFileList
	 * @param  con : Context
	 * @return none
	 */
	private File mScanDir;
	private MediaScannerConnection mScanner;
	public void setUpdateFileList()
	{
		mScanDir = new File(download.getAbsolutePath());
		mScanner = new MediaScannerConnection(context, new MediaScannerConnection.MediaScannerConnectionClient() {
			@Override
			public void onMediaScannerConnected() {
				File[] files = mScanDir.listFiles();
				for (File f : files) {
					String path = f.getAbsolutePath();
					mScanner.scanFile(path, null);
					Log.i("onMediaScannerConnected", "Media Scan completed on file: path=" + path);
				}
			}

			@Override
			public void onScanCompleted(String path, Uri uri) {
				Log.i("onScanCompleted", "Media Scan completed on directory: path=" + path + " uri=" + uri);
				if (mScanner!=null){
					mScanner.disconnect();
					mScanner = null;
				}
			}
		});
		mScanner.connect();
	}
}
