package com.asreader.app.rfid.view.widges;

import android.app.Activity;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.os.Handler;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.View.OnTouchListener;
import android.widget.PopupWindow;

import com.asreader.app.rfid.R;

/**
 * popUpWindow 工具類
 *
 * @author hh
 */
public class ShowPopUpWindow extends PopupWindow {

    public static final int POP_TOP = 1;
    public static final int POP_DOWN = 2;

    private Activity activity;

    private View view;

    private View popLayout;

    public ShowPopUpWindow() {
        super();
    }


    /**
     * 初始化基础的popwindow
     *
     * @param layoutID
     * @return
     */
    public View initBasePopWindow(int layoutID, int width, int height, final int orientation) {
        LayoutInflater mLayoutInflater = (LayoutInflater) activity
                .getSystemService(activity.LAYOUT_INFLATER_SERVICE);
        view = mLayoutInflater.inflate(layoutID, null);
        popLayout = view.findViewById(R.id.pop_layout);
        this.setTouchable(true);
        this.setFocusable(true);
        this.setBackgroundDrawable(new BitmapDrawable());
        this.setOutsideTouchable(true);

        view.setOnTouchListener(new OnTouchListener() {

            public boolean onTouch(View v, MotionEvent event) {

                int height = popLayout.getTop();
                int y = (int) event.getY();
                if (event.getAction() == MotionEvent.ACTION_UP) {
                    if (orientation == POP_DOWN) {
                        if (y < height) {
//                            canclePopUpWindowWithAnima();
                        }
                    } else if (orientation == POP_TOP) {
                        if (y > height) {
//                            canclePopUpWindowWithAnima();
                        }
                    }

                }
                return true;
            }
        });

        // 设置视图
        this.setContentView(this.view);
        // 设置弹出窗体的宽和高
        this.setHeight(height);
        this.setWidth(width);

        // 实例化一个ColorDrawable颜色为半透明
        ColorDrawable dw = new ColorDrawable(0xb2000000);
        // 设置弹出窗体的背景
        this.setBackgroundDrawable(dw);

//        // 设置弹出窗体显示时的动画，从底部向上弹出
//        this.setAnimationStyle(R.style.pop_window_anim);

        return view;

    }

    /**
     * 展示菜单窗口
     *
     * @param
     * @author hefeng
     */
    public void showAtBottomWithAnima(View v) {
//        getPopLayout().startAnimation(AnimationUtils.loadAnimation(getContext(), R.anim.pop_bottom_in));
        showAtLocation(v, Gravity.BOTTOM, 0, 0);
        update();
    }

    /**
     * 展示菜单窗口
     *
     * @param
     * @author hefeng
     */
    public void showAtBottom(View v) {
        showAtLocation(v, Gravity.BOTTOM, 0, 0);
        update();
    }

    /**
     * 取消菜单窗口
     *
     * @author hefeng
     */
    public void canclePopUpWindowWithAnima() {
        if (isShowing()) {
//            getPopLayout().startAnimation(AnimationUtils.loadAnimation(getContext(), R.anim.pop_top_out));
            new Handler().postDelayed(new Runnable() {
                public void run() {
                    //execute the task
                    dismiss();
                }
            }, 200);
        }
    }



    /**
     * 取消菜单窗口
     *
     * @author hefeng
     */
    public void canclePopUpWindow() {
        if (isShowing()) {
            dismiss();
        }
    }

    public View getView() {
        return view;
    }


    public Activity getContext() {
        return activity;
    }


    public void setContext(Activity activity) {
        this.activity = activity;
    }


    public void setView(View view) {
        this.view = view;
    }

    public void setPopViewBg(ColorDrawable dw) {
        this.setBackgroundDrawable(dw);
    }

    public View getPopLayout() {
        return popLayout;
    }

    public void setPopLayout(View popLayout) {
        this.popLayout = popLayout;
    }
}