package com.asreader.app.rfid.view;

import android.app.ActionBar;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.view.View;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.TextView;

import support.andro.app.rfid.adapter.HumitureListAdapter;
import support.andro.app.rfid.adapter.SpinnerAdapter;
import support.andro.app.rfid.dialog.WaitDialog;
import support.andro.app.rfid.util.ResUtil;
import support.andro.app.rfid.view.base.RfidActivity;

import com.asreader.app.rfid.MainActivity;
import com.asreader.app.rfid.R;
import com.asreader.p252b.AsReaderP252B;
import com.asreader.p252b.barcode.AsReaderP252BBarcodeType;
import com.asreader.p252b.device.type.AsReaderP252BConnectionState;
import com.asreader.p252b.device.type.AsReaderP252BKeyState;
import com.asreader.p252b.diagnostics.AsReaderP252BLog;
import com.asreader.p252b.rfid.exception.AsReaderP252BException;
import com.asreader.p252b.rfid.type.AsReaderP252BActionState;
import com.asreader.p252b.rfid.type.AsReaderP252BTemperatureTagType;
import com.asreader.p252b.rfid.type.AsReaderP252BResultCode;

import android.view.View.OnClickListener;
import android.widget.Toast;

import java.util.Locale;

public class HumitureActivity extends RfidActivity implements OnClickListener {
    private static final String TAG = HumitureActivity.class.getSimpleName();
    private static final String KEY_LAST_CONTINUOUS_MODE = "last_continuous_mode";

    private ListView lstTags;
    private TextView txtContinuousMode;
    private TextView txtReportRssi;
    private TextView txtHumitureMode;
    private boolean mContinuousMode;
    private boolean mReportRssi;
    private boolean mTemperatureBool;
    private Button btnInventory;
    private Button btnClear;
    protected boolean mIsEnabled;

    protected HumitureListAdapter adpTags;

    private Handler mHandler;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_humiture);

        ActionBar actionBar = getActionBar();
        if(actionBar != null) {
            actionBar.setDisplayOptions(ActionBar.DISPLAY_SHOW_CUSTOM);
            actionBar.setCustomView(R.layout.activity_title);
            actionBar.setDisplayHomeAsUpEnabled(true);
            actionBar.setDisplayShowHomeEnabled(true);
        }
        TextView titleText = (TextView)findViewById(R.id.title_text);
        titleText.setText(R.string.humiture_name);
        final int version = Build.VERSION.SDK_INT;
        if(version >= Build.VERSION_CODES.M)
            titleText.setTextColor(getColor(getApplicationContext(), R.color.black));

        AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. onCreate()");

        mHandler = new Handler();
        // Create Reader
        createReader();

        // Initialize Widget
        initWidgets();

        mContinuousMode = false;
        mReportRssi = false;
        mTemperatureBool = true;
        mIsEnabled = false;
        loadContinuousMode();

        // Enable action widget
        enableActionWidgets(true);

        if(getReader().getState() == AsReaderP252BConnectionState.Connected) {
            // Load Option
            WaitDialog.show(this, R.string.load_option);
            new Thread(mLoadOption).start();
        }
    }

    @Override
    protected void initReader() {

        try {
            adpTags.setReportRSSI(getReader().getReportRSSI());
        } catch (AsReaderP252BException e) {
            AsReaderP252BLog.e(TAG, e, "ERROR. initReader() - Failed to get report rssi mode");
        }

        loadContinuousMode();

        AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. initReader()");
    }


    // Initialize Widgets
    @Override
    protected void initWidgets() {
        // Total Count TextView

        // Tag ListView
        lstTags = (ListView) findViewById(R.id.tag_list);
        adpTags = new HumitureListAdapter(this);
        lstTags.setAdapter(adpTags);
        adpTags.start();
        txtContinuousMode = (TextView) findViewById(R.id.humiture_continuous_mode);
        txtContinuousMode.setOnClickListener(this);
        txtReportRssi = (TextView) findViewById(R.id.humiture_report_rssi);
        txtReportRssi.setOnClickListener(this);
        txtHumitureMode = (TextView) findViewById(R.id.humiture_mode);
        txtHumitureMode.setOnClickListener(this);
        btnInventory = (Button) findViewById(R.id.humiture_inventory);
        btnInventory.setOnClickListener(this);
        btnClear = (Button) findViewById(R.id.humiture_clear);
        btnClear.setOnClickListener(this);
        AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. initWidgets()");
    }

    @Override
    protected void onDestroy() {

        AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. onDestroy()");

        // Destroy Reader
        destroyReader();

        adpTags.shutDown();

        super.onDestroy();
    }

    // Enable/Disable Action Widgets
    protected void enableActionWidgets(boolean enabled) {
        super.enableActionWidgets(enabled);

        mIsEnabled = isEnabledWidget(enabled);

        enableActionButton(btnInventory, enabled, R.string.action_inventory, R.string.action_stop);
        AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. enableActionWidgets(%s)", enabled);
    }

    private void displayContinuousMode() {
        txtContinuousMode.setText(mContinuousMode ? "On" : "Off");
    }

    private void displayReportRSSI() {
        txtReportRssi.setText(mReportRssi ? "On" : "Off");
        adpTags.setReportRSSI(mReportRssi);
    }

    private void displayHumitureMode() {
        txtHumitureMode.setText(mTemperatureBool ? "Temperature" : "Moisture");

    }
    @Override
    public boolean onKeyEvent(AsReaderP252B reader, AsReaderP252BKeyState state) {
        if (state == AsReaderP252BKeyState.KeyDown) {
            if (reader.getAction() != AsReaderP252BActionState.Stop) {
                enableActionWidgets(false);
                if (getReader().stop() != AsReaderP252BResultCode.NoError) {
                    AsReaderP252BLog.e(TAG, "ERROR. stopInventory() - Failed to stop inventory()");
                    enableActionWidgets(true);
                }
                AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. stopInventory()");
            } else {
                if (mTemperatureBool) {
                    enableActionWidgets(false);
                    AsReaderP252BResultCode res;
                    if ((res = getReader().inventoryTemperatureTagWithType(AsReaderP252BTemperatureTagType.Type_0)) != AsReaderP252BResultCode.NoError) {
                        AsReaderP252BLog.e(TAG, "ERROR. startInventory() - Failed to inventoryTemperatureTagWithType()");
                        String msg = String.format(Locale.US, "%s : 0x%04X", res.toString(), res.getCode());
                        Toast.makeText(this, msg, Toast.LENGTH_SHORT).show();
                        enableActionWidgets(true);
                    }
                    AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. inventoryTemperature()");
                }else  {
                    enableActionWidgets(false);
                    AsReaderP252BResultCode res;
                    if ((res = getReader().inventoryHumidityTag()) != AsReaderP252BResultCode.NoError) {
                        AsReaderP252BLog.e(TAG, "ERROR. startInventory() - Failed to inventoryHumidityTag()");
                        String msg = String.format(Locale.US, "%s : 0x%04X", res.toString(), res.getCode());
                        Toast.makeText(this, msg, Toast.LENGTH_SHORT).show();
                        enableActionWidgets(true);
                    }
                    AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. startInventory()");
                }
            }
        }
        return false;
    }
    @Override
    public void onReadTemperatureTag(AsReaderP252B reader, AsReaderP252BActionState action, String tag, float rssi, float phase, float frequency, float temperature) {
        adpTags.addTag(tag, rssi, phase, frequency, temperature, true);
        adpTags.notifyDataSetChanged();
    }

    @Override
    public void onReadHumidityTag(AsReaderP252B reader, AsReaderP252BActionState action, String tag, float rssi, float phase, float frequency, float humidity) {
        adpTags.addTag(tag, rssi, phase, frequency, humidity, false);
        adpTags.notifyDataSetChanged();
    }

    @Override
    public void onReadBarcode(AsReaderP252B reader, AsReaderP252BBarcodeType type, String barcode) {
        AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "EVENT. onReadBarcode (%s, [%s])", type, barcode);
    }

    @Override
    public void onReadBarcode(AsReaderP252B reader, AsReaderP252BBarcodeType type, byte[] barcodeData) {
        AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "EVENT. onReadBarcode (%s, [%s])", type, barcodeData);
    }

    @Override
    public void onActionChanged(AsReaderP252B reader, AsReaderP252BActionState action) {
        AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "EVENT. onActionChanged(%s)", action);
        enableActionWidgets(true);
    }

    @Override
    public void onReceivedData(byte[] data) {

    }

    @Override
    public boolean onModeKeyEvent(AsReaderP252B reader, AsReaderP252BKeyState state) {
        AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "EVENT. onModeKeyEvent [%s]", state);
        return false;
    }

    @Override
    public void onClick(View v) {
        AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. onClick(%s)", ResUtil.getId(v.getId()));
        switch (v.getId()) {
            case R.id.humiture_continuous_mode:
                showContinuousModeDialog();
                break;
            case R.id.humiture_report_rssi:
                showReportRssiDialog();
                break;
            case  R.id.humiture_mode:
                showHumitureModeDialog();
                break;
            case R.id.humiture_inventory:
                if (getReader().getAction() == AsReaderP252BActionState.Stop) {
                    if (mTemperatureBool) {
                        enableActionWidgets(false);
                        AsReaderP252BResultCode res;
                        if ((res = getReader().inventoryTemperatureTagWithType(AsReaderP252BTemperatureTagType.Type_0)) != AsReaderP252BResultCode.NoError) {
                            AsReaderP252BLog.e(TAG, "ERROR. startInventory() - Failed to inventoryTemperatureTagWithType()");
                            String msg = String.format(Locale.US, "%s : 0x%04X", res.toString(), res.getCode());
                            Toast.makeText(this, msg, Toast.LENGTH_SHORT).show();
                            enableActionWidgets(true);
                            return;
                        }
                        AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. inventoryTemperature()");
                    }else  {
                        enableActionWidgets(false);
                        AsReaderP252BResultCode res;
                        if ((res = getReader().inventoryHumidityTag()) != AsReaderP252BResultCode.NoError) {
                            AsReaderP252BLog.e(TAG, "ERROR. startInventory() - Failed to inventoryHumidityTag()");
                            String msg = String.format(Locale.US, "%s : 0x%04X", res.toString(), res.getCode());
                            Toast.makeText(this, msg, Toast.LENGTH_SHORT).show();
                            enableActionWidgets(true);
                            return;
                        }
                        AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. startInventory()");
                    }
                } else {
                    enableActionWidgets(false);
                    if (getReader().stop() != AsReaderP252BResultCode.NoError) {
                        AsReaderP252BLog.e(TAG, "ERROR. stopInventory() - Failed to stop inventory()");
                        enableActionWidgets(true);
                        return;
                    }
                    AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. stopInventory()");
                }
                break;
            case R.id.humiture_clear:
                adpTags.clear();
                break;
        }
    }

    private Runnable mLoadOption = new Runnable() {

        @Override
        public void run() {
            try {
                mContinuousMode = getReader().getContinuousMode();
            } catch (AsReaderP252BException e) {
                AsReaderP252BLog.e(TAG, e, "ERROR. initReader() - Failed to get continuous mode");
            }
            try {
                mReportRssi = getReader().getReportRSSI();
            } catch (AsReaderP252BException e) {
                AsReaderP252BLog.e(TAG, e, "ERROR. initReader() - Failed to get report rssi");
            }
            mHandler.post(new Runnable() {

                @Override
                public void run() {
                    displayContinuousMode();
                    displayReportRSSI();
                    displayHumitureMode();
                    WaitDialog.hide();
                    enableActionWidgets(true);
                }

            });
        }

    };

    private void showContinuousModeDialog() {
        if (!mIsEnabled)
            return;

        LinearLayout root = (LinearLayout) LinearLayout.inflate(this, R.layout.dialog_list_view, null);
        final ListView value = (ListView) root.findViewById(R.id.list);
        final SpinnerAdapter adapter = new SpinnerAdapter(this, android.R.layout.simple_list_item_single_choice);
        adapter.addItem(0, "Off");
        adapter.addItem(1, "On");
        value.setAdapter(adapter);
        value.setChoiceMode(ListView.CHOICE_MODE_SINGLE);

        AlertDialog.Builder builder = new AlertDialog.Builder(this);
        builder.setTitle(R.string.continuous_mode);
        builder.setView(root);
        builder.setPositiveButton(R.string.action_ok, new DialogInterface.OnClickListener() {

            @Override
            public void onClick(DialogInterface dialog, int which) {
                try {
                    int position = value.getCheckedItemPosition();
                    mContinuousMode = adapter.getValue(position) > 0;
                    getReader().setContinuousMode(mContinuousMode);
                    saveConinuousMode();
                } catch (Exception e) {
                    AsReaderP252BLog.e(TAG, "ERROR.  showContinuousModeDialog().$PositiveButton.onClick() - [%s]"
                            , e.getMessage());
                }
                displayContinuousMode();
                AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showContinuousModeDialog().$PositiveButton.onClick()");
            }
        });
        builder.setNegativeButton(R.string.action_cancel, new DialogInterface.OnClickListener() {

            @Override
            public void onClick(DialogInterface dialog, int which) {
                AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showContinuousModeDialog().$NegativeButton.onClick()");
            }
        });
        builder.setCancelable(true);
        builder.setOnCancelListener(new DialogInterface.OnCancelListener() {

            @Override
            public void onCancel(DialogInterface dialog) {
                AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showContinuousModeDialog().onCancel()");
            }
        });
        AlertDialog dialog = builder.create();
        dialog.setOnShowListener(new DialogInterface.OnShowListener() {

            @Override
            public void onShow(DialogInterface dialog) {
                int position = adapter.getPosition(mContinuousMode ? 1 : 0);
                value.setItemChecked(position, true);
                value.setSelectionFromTop(position, 0);
                AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showContinuousModeDialog().onShow()");
            }
        });
        dialog.show();
        AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showContinuousModeDialog()");
    }

    private void showReportRssiDialog() {
        if (!mIsEnabled)
            return;

        LinearLayout root = (LinearLayout) LinearLayout.inflate(this, R.layout.dialog_list_view, null);
        final ListView value = (ListView) root.findViewById(R.id.list);
        final SpinnerAdapter adapter = new SpinnerAdapter(this, android.R.layout.simple_list_item_single_choice);
        adapter.addItem(0, "Off");
        adapter.addItem(1, "On");
        value.setAdapter(adapter);
        value.setChoiceMode(ListView.CHOICE_MODE_SINGLE);

        AlertDialog.Builder builder = new AlertDialog.Builder(this);
        builder.setTitle(R.string.report_rssi);
        builder.setView(root);
        builder.setPositiveButton(R.string.action_ok, new DialogInterface.OnClickListener() {

            @Override
            public void onClick(DialogInterface dialog, int which) {
                try {
                    int position = value.getCheckedItemPosition();
                    mReportRssi = adapter.getValue(position) > 0;
                    getReader().setReportRSSI(mReportRssi);
                    MainActivity.mUserConfigs.setReportRssi(mReportRssi);
                    MainActivity.mUserConfigs.Save();
                } catch (Exception e) {
                    AsReaderP252BLog.e(TAG, "ERROR.  showReportRssiDialog().$PositiveButton.onClick() - [%s]"
                            , e.getMessage());
                }
                displayReportRSSI();
                AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showReportRssiDialog().$PositiveButton.onClick()");
            }
        });
        builder.setNegativeButton(R.string.action_cancel, new DialogInterface.OnClickListener() {

            @Override
            public void onClick(DialogInterface dialog, int which) {
                AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showReportRssiDialog().$NegativeButton.onClick()");
            }
        });
        builder.setCancelable(true);
        builder.setOnCancelListener(new DialogInterface.OnCancelListener() {

            @Override
            public void onCancel(DialogInterface dialog) {
                AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showReportRssiDialog().onCancel()");
            }
        });
        AlertDialog dialog = builder.create();
        dialog.setOnShowListener(new DialogInterface.OnShowListener() {

            @Override
            public void onShow(DialogInterface dialog) {
                int position = adapter.getPosition(mReportRssi ? 1 : 0);
                value.setItemChecked(position, true);
                value.setSelectionFromTop(position, 0);
                AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showReportRssiDialog().onShow()");
            }
        });
        dialog.show();
        AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showReportRssiDialog()");
    }

    private void showHumitureModeDialog() {
        if (!mIsEnabled)
            return;

        LinearLayout root = (LinearLayout) LinearLayout.inflate(this, R.layout.dialog_list_view, null);
        final ListView value = (ListView) root.findViewById(R.id.list);
        final SpinnerAdapter adapter = new SpinnerAdapter(this, android.R.layout.simple_list_item_single_choice);
        adapter.addItem(0, "Moisture");
        adapter.addItem(1, "Temperature");
        value.setAdapter(adapter);
        value.setChoiceMode(ListView.CHOICE_MODE_SINGLE);

        AlertDialog.Builder builder = new AlertDialog.Builder(this);
        builder.setTitle(R.string.humiture_mode);
        builder.setView(root);
        builder.setPositiveButton(R.string.action_ok, new DialogInterface.OnClickListener() {

            @Override
            public void onClick(DialogInterface dialog, int which) {
                try {
                    boolean tTemperatureBool = mTemperatureBool;
                    int position = value.getCheckedItemPosition();
                    mTemperatureBool = adapter.getValue(position) > 0;

                    if (tTemperatureBool != mTemperatureBool) {
                        adpTags.clear();
                    }
                } catch (Exception e) {
                    AsReaderP252BLog.e(TAG, "ERROR.  showContinuousModeDialog().$PositiveButton.onClick() - [%s]"
                            , e.getMessage());
                }
                displayHumitureMode();
                AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showContinuousModeDialog().$PositiveButton.onClick()");
            }
        });
        builder.setNegativeButton(R.string.action_cancel, new DialogInterface.OnClickListener() {

            @Override
            public void onClick(DialogInterface dialog, int which) {
                AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showContinuousModeDialog().$NegativeButton.onClick()");
            }
        });
        builder.setCancelable(true);
        builder.setOnCancelListener(new DialogInterface.OnCancelListener() {

            @Override
            public void onCancel(DialogInterface dialog) {
                AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showContinuousModeDialog().onCancel()");
            }
        });
        AlertDialog dialog = builder.create();
        dialog.setOnShowListener(new DialogInterface.OnShowListener() {

            @Override
            public void onShow(DialogInterface dialog) {
                int position = adapter.getPosition(mTemperatureBool ? 1 : 0);
                value.setItemChecked(position, true);
                value.setSelectionFromTop(position, 0);
                AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showContinuousModeDialog().onShow()");
            }
        });
        dialog.show();
        AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showContinuousModeDialog()");
    }

    private void saveConinuousMode() {
        SharedPreferences prefs = getSharedPreferences(MainActivity.APP_NAME, MODE_PRIVATE);
        SharedPreferences.Editor editor = prefs.edit();

        editor.putBoolean(KEY_LAST_CONTINUOUS_MODE, mContinuousMode);
        editor.apply();
        AsReaderP252BLog.d(TAG, AsReaderP252BLog.DEBUG, "DEBUG. saveConinuousMode() - last Continuous Mode : [%s]", mContinuousMode);
    }

    private void loadContinuousMode() {
        SharedPreferences prefs = getSharedPreferences(MainActivity.APP_NAME, MODE_PRIVATE);
        mContinuousMode = prefs.getBoolean(KEY_LAST_CONTINUOUS_MODE, true);
        AsReaderP252BLog.d(TAG, AsReaderP252BLog.DEBUG, "DEBUG. loadContinuousMode() - last Continuous Mode : [%s]", mContinuousMode);

        if(getReader() != null) {
            try {
                getReader().setContinuousMode(mContinuousMode);
            } catch (AsReaderP252BException e) {
                AsReaderP252BLog.e(TAG, e, "ERROR. loadContinuousMode() - Failed to set continuous mode");
            }
        }
    }

}