package support.andro.app.rfid.view.base;

import support.andro.app.rfid.util.ResUtil;
import com.asreader.p252b.diagnostics.AsReaderP252BLog;
import com.asreader.app.rfid.R;

import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;

public abstract class RfidClearActivity extends RfidActivity implements
		OnClickListener {

	private static final String TAG = RfidClearActivity.class.getSimpleName();
	
	protected Button btnClear;
	protected Button btnOption;

	@Override
	public void onClick(View v) {
		
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. onClick(%s)", ResUtil.getId(v.getId()));
		
		if (v.getId() == R.id.clear) {
			clearWidgets();
		} 
	}

	protected abstract void clearWidgets();

	protected void initWidgets() {

		btnClear = (Button) findViewById(R.id.clear);
		if(btnClear != null)
			btnClear.setOnClickListener(this);
		
		btnOption = (Button) findViewById(R.id.option);
		if(btnOption != null)
			btnOption.setOnClickListener(this);
		
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. initWidgets()");
	}

	protected void enableActionWidgets(boolean enabled) {
		if(btnClear != null)
			btnClear.setEnabled(isEnabledWidget(enabled));
		
		if(btnOption != null)
			btnOption.setEnabled(isEnabledWidget(enabled));
		
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. enableActionWidgets(%s)", enabled);
	}
}
