package com.asreader.app.rfid.view;

import support.andro.app.rfid.dialog.WaitDialog;
import support.andro.app.rfid.util.ResUtil;
import support.andro.app.rfid.view.base.MemoryActivity;

import com.asreader.p252b.barcode.AsReaderP252BBarcodeType;
import com.asreader.p252b.device.type.AsReaderP252BKeyState;
import com.asreader.p252b.rfid.exception.AsReaderP252BException;
import com.asreader.p252b.rfid.type.AsReaderP252BActionState;
import com.asreader.p252b.rfid.type.AsReaderP252BMemoryBank;
import com.asreader.p252b.rfid.type.AsReaderP252BResultCode;

import java.lang.ref.WeakReference;
import java.util.Locale;

import com.asreader.app.rfid.R;
import com.asreader.p252b.AsReaderP252B;
import com.asreader.p252b.diagnostics.AsReaderP252BLog;

import android.app.ActionBar;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import android.widget.Toast;

public class WriteMemoryActivity extends MemoryActivity {

	private static final String TAG = WriteMemoryActivity.class.getSimpleName();

	private TextView txtValue;

	private Button btnWrite;
	private String mValue;
	private Handler mHandler;
	private AlertDialog writeDialog;
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_write_memory);
		ActionBar actionBar = getActionBar();
		if(actionBar != null) {
			actionBar.setDisplayOptions(ActionBar.DISPLAY_SHOW_CUSTOM);
			actionBar.setCustomView(R.layout.activity_title);
			actionBar.setDisplayHomeAsUpEnabled(true);
			actionBar.setDisplayShowHomeEnabled(true);
		}
		TextView titleText = (TextView)findViewById(R.id.title_text);
		titleText.setText(R.string.write_memory_name);
		final int version = Build.VERSION.SDK_INT;
		if(version >= Build.VERSION_CODES.M)
			titleText.setTextColor(getColor(getApplicationContext(), R.color.black));

		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. onCreate()");

		mHandler = new Handler();

		// Initialize Widget
		initWidgets();

		InitTask task = new InitTask(this);
		task.execute();
		
//		// Initialize Mask
//		initMask();
//
//		resetActionResult();
//
//		setMask(getMask());
//
//		// Enable action widget
//		enableActionWidgets(true);
//
//		outputMessage(R.string.write_memory_intro_message);
	}

	@Override
	protected void onDestroy() {

		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. onDestroy()");

		// Destroy Reader
		destroyReader();

		super.onDestroy();
	}

	@Override
	protected void onStart() {
		super.onStart();
		new Thread(mLoadOptionOnStart).start();
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. onStart()");
	}

	@Override
	protected void onStop() {
		


		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. onStop()");
		super.onStop();
	}
	
	@Override
	protected void onResume() {
		super.onResume();
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. onResume()");
	}

	@Override
	protected void onPause() {
		if(getReader().getAction() == AsReaderP252BActionState.WriteMemory)
			getReader().stop();

		// Rollback Mask
		exitMask();
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. onPause()");
		super.onPause();
	}
	private Runnable mLoadOptionOnStart = new Runnable() {
		@Override
		public void run() {
			createReader();
			initReader();
			mHandler.post(new Runnable() {
				@Override
				public void run() {
					enableActionWidgets(true);
				}
			});
		}
	};
	@Override
	public void onClick(View v) {

		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. onClick(%s)", ResUtil.getId(v.getId()));
		
		switch (v.getId()) {
		case R.id.write_value:
			showWriteValueDialog();
			break;
		case R.id.action_write:
			if (getReader().getAction() == AsReaderP252BActionState.Stop) {
				writeMemory();
			} else {
				stopAction();
			}
			break;
		}
		super.onClick(v);
	}

	@Override
	public void onActionChanged(AsReaderP252B reader, AsReaderP252BActionState action) {
		AsReaderP252BLog.d(TAG, AsReaderP252BLog.DEBUG, "EVENT. onActionChanged(%s)", action);

		enableActionWidgets(true);

		if (action == AsReaderP252BActionState.Stop) {
			dialogDismiss();
			if (!isActionResult()) {
				outputMessage(R.string.write_memory_intro_message);
			}
		}
	}

	@Override
	public void onReadBarcode(AsReaderP252B reader, AsReaderP252BBarcodeType type, String barcode) {
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "EVENT. onReadBarcode (%s, [%s])", type, barcode);
	}

	@Override
	public void onReadBarcode(AsReaderP252B reader, AsReaderP252BBarcodeType type, byte[] barcodeData) {
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "EVENT. onReadBarcode (%s, [%s])", type, barcodeData);
	}

	@Override
	public void onAccessResult(AsReaderP252B reader, AsReaderP252BResultCode code, AsReaderP252BActionState action, String epc, String data,
							   float rssi, float phase, float frequency) {
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "EVENT. onAccessResult(%s, %s, [%s], [%s], %.2f, %.2f)", code, action, epc == null ? "" : epc,
				data == null ? "" : data, rssi, phase);

		setActionResult();

		if (code != AsReaderP252BResultCode.NoError) {
			outputFailMessage(code.toString());
			return;
		}

		if(epc != null)
			outputSelection(epc.length() > 4 ? epc.substring(4) : epc);

		outputSuccessMessage(R.string.access_success);
		setRssi(rssi, phase, frequency);
	}

	@Override
	public void onReadTemperatureTag(AsReaderP252B reader, AsReaderP252BActionState action, String tag, float rssi, float phase, float frequency, float temperature) {

	}

	@Override
	public void onReadHumidityTag(AsReaderP252B reader, AsReaderP252BActionState action, String tag, float rssi, float phase, float frequency, float humidity) {

	}

	@Override
	public void onReceivedData(byte[] data) {

	}

	@Override
	public boolean onModeKeyEvent(AsReaderP252B reader, AsReaderP252BKeyState state) {
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "EVENT. onModeKeyEvent [%s]", state);
		return false;
	}

	@Override
	public boolean onKeyEvent(AsReaderP252B reader, AsReaderP252BKeyState state) {
		return false;
	}
	@Override
	protected void clearWidgets() {
		super.clearWidgets();
		
		resetActionResult();
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. clearWidgets()");
	}

	// Write Memory
	private void writeMemory() {
		clearWidgets();
		enableActionWidgets(false);
		outputSelection("");
		outputMessage(R.string.read_memory_read_message);

		resetActionResult();

		AsReaderP252BMemoryBank bank = getMemBank();
		int offset = getMemOffset();
		String data = getWriteValue();
		int time = getOperationTime();

		String password = getAccessPassword();
		try {
			getReader().setAccessPassword(password);
		} catch (AsReaderP252BException e) {
			AsReaderP252BLog.e(TAG, "ERROR. writeMemory() - Failed to set password [%s]", password);
		}

		try {
			getReader().setOperationTime(time);
		} catch (AsReaderP252BException e) {
			AsReaderP252BLog.e(TAG, "ERROR. writeMemory() - Failed to set operation time(%d)", time);
		}
		dialogDismiss();
		dialogShow();
		AsReaderP252BResultCode res;
		if ((res = getReader().writeMemory(bank, offset, data)) != AsReaderP252BResultCode.NoError) {
			dialogDismiss();
			AsReaderP252BLog.e(TAG, "ERROR. writeMemory() - Failed to start write memory(%s, %d, [%s])", bank, offset, data);
			String msg = String.format(Locale.US, "%s : 0x%04X", res.toString(), res.getCode());
			Toast.makeText(this, msg, Toast.LENGTH_SHORT).show();
			enableActionWidgets(true);
			outputFailMessage(R.string.write_memory_fail_write_message);
			return;
		}
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. writeMemory()");
	}

	// Initialize Reader
	@Override
	protected void initReader() {
		super.initReader();
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. initReader()");
	}

	// Initialize Widgets
	@Override
	protected void initWidgets() {
		super.initWidgets();

		ScrollView scrlParams = (ScrollView) findViewById(R.id.write_params);
		scrlParams.setBackgroundColor(getColor(getApplicationContext(), R.color.message_background));
		
		// Value EditText
		txtValue = (TextView) findViewById(R.id.write_value);
		txtValue.setOnClickListener(this);
		setWriteValue("");
		// Write Button
		btnWrite = (Button) findViewById(R.id.action_write);
		btnWrite.setOnClickListener(this);
		
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. initWidgets()");
	}

	// Enable/Disable Action Widgets
	@Override
	protected void enableActionWidgets(boolean enabled) {
		super.enableActionWidgets(enabled);

		btnWrite.setEnabled(isEnabledWidget(enabled, AsReaderP252BActionState.WriteMemory));
		if (enabled) {
			switch (getReader().getAction()) {
			case WriteMemory:
				btnWrite.setText(R.string.action_stop);
				break;
			case Stop:
				btnWrite.setText(R.string.action_write_memory);
				break;
			default:
				break;
			}
		}
		
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. enableActionWidgets(%s)", enabled);
	}
	
	protected void setWriteValue(String value) {
		mValue = value;
		txtValue.setText(mValue);
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. setWriteValue([%s])", value);
	}
	
	protected String getWriteValue() {
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. getWriteValue() - [%s]", mValue);
		return mValue;
	}
	
	private void showWriteValueDialog() {
		if (!mIsEnabled)
			return;
		
		LinearLayout root = (LinearLayout)LinearLayout.inflate(this, R.layout.dialog_input_hex, null);
		final EditText writeValue = (EditText)root.findViewById(R.id.value);
		
		AlertDialog.Builder builder = new AlertDialog.Builder(this);
		builder.setTitle(R.string.write_data);
		builder.setView(root);
		builder.setPositiveButton(R.string.action_ok, new DialogInterface.OnClickListener() {
			
			@Override
			public void onClick(DialogInterface dialog, int which) {
				setWriteValue(writeValue.getText().toString());
				InputMethodManager imm = (InputMethodManager)getSystemService(Context.INPUT_METHOD_SERVICE);
				if(imm != null)
					imm.hideSoftInputFromWindow(writeValue.getWindowToken(), 0);
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showWriteValueDialog().$PositiveButton.onClick()");
			}
		});
		builder.setNegativeButton(R.string.action_cancel, new DialogInterface.OnClickListener() {
			
			@Override
			public void onClick(DialogInterface dialog, int which) {
				InputMethodManager imm = (InputMethodManager)getSystemService(Context.INPUT_METHOD_SERVICE);
				if(imm != null)
					imm.hideSoftInputFromWindow(writeValue.getWindowToken(), 0);
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showWriteValueDialog().$NegativeButton.onClick()");
			}
		});
		builder.setCancelable(true);
		builder.setOnCancelListener(new DialogInterface.OnCancelListener() {
			
			@Override
			public void onCancel(DialogInterface dialog) {
				InputMethodManager imm = (InputMethodManager)getSystemService(Context.INPUT_METHOD_SERVICE);
				if(imm != null)
					imm.hideSoftInputFromWindow(writeValue.getWindowToken(), 0);
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showWriteValueDialog().onCancel()");
			}
		});
		AlertDialog dialog = builder.create();
		dialog.setOnShowListener(new DialogInterface.OnShowListener() {
			
			@Override
			public void onShow(DialogInterface dialog) {
				writeValue.setText(mValue);
				writeValue.selectAll();
				writeValue.requestFocus();
				InputMethodManager imm = (InputMethodManager)getSystemService(Context.INPUT_METHOD_SERVICE);
				if(imm != null)
					imm.showSoftInput(writeValue, InputMethodManager.SHOW_FORCED);
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showWriteValueDialog().onShow()");
			}
		});
		dialog.show();
		
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showWriteValueDialog()");
	}
	private void dialogShow() {
		AlertDialog.Builder builder = new AlertDialog.Builder(this);
		builder.setTitle("Please wait...");
		builder.setMessage(R.string.writing_tag_memory);
		builder.setNegativeButton(R.string.action_stop, new DialogInterface.OnClickListener() {
			@Override
			public void onClick(DialogInterface dialog, int which) {
				getReader().stop();
			}
		});
		builder.setCancelable(true);
		builder.setOnCancelListener(new DialogInterface.OnCancelListener() {

			@Override
			public void onCancel(DialogInterface dialog) {
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showPowerGinaDialog().onCancel()");
			}
		});
		writeDialog = builder.create();
		writeDialog.show();
	}
	private void dialogDismiss () {
		if (writeDialog != null && writeDialog.isShowing()) {
			writeDialog.dismiss();
			writeDialog = null;
		}
	}
	private static class InitTask extends AsyncTask<Void, Void, Boolean> {
		private final WeakReference<WriteMemoryActivity> mActivity;

		InitTask(WriteMemoryActivity activity) {
			mActivity = new WeakReference<>(activity);
		}

		@Override
		protected void onPreExecute() {
			WriteMemoryActivity activity = mActivity.get();
			WaitDialog.show(activity, R.string.init_mask);
			super.onPreExecute();
		}

		@Override
		protected Boolean doInBackground(Void... params) {
			// Initialize Mask
			WriteMemoryActivity activity = mActivity.get();
			activity.initMask();
			
			return true;
		}
		
		@Override
		protected void onPostExecute(Boolean result) {
			WriteMemoryActivity activity  = mActivity.get();
			activity.resetActionResult();

			activity.setMask(activity.getMask());

			// Enable action widget
			activity.enableActionWidgets(true);

			activity.outputMessage(R.string.write_memory_intro_message);
			WaitDialog.hide();
			super.onPostExecute(result);
		}
	}
}
