package com.asreader.app.rfid.view;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.CheckBox;

import com.asreader.app.rfid.R;

import java.util.List;

public class UpdateFirmwareListViewAdapter extends BaseAdapter {

    private UpdateFirmwareActivity context;
    private LayoutInflater layoutInflater;
    private List<FirmwareInfo> list;
    private CheckBox currentClickCheckBox;

    private int lastPos = 0;
    private boolean enableFlag = true;

    public void setEnableFlag(boolean enableFlag) {
        this.enableFlag = enableFlag;
        if(list != null && list.size() > 0) notifyDataSetChanged();
    }

    public UpdateFirmwareListViewAdapter(UpdateFirmwareActivity context) {
        this.context = context;
        layoutInflater = LayoutInflater.from(context);
    }

    public void setList(List<FirmwareInfo> list){
        if (list != null && list.size() > 0){
            this.list = list;
            notifyDataSetChanged();
        }
    }

    @Override
    public int getCount() {
        return this.list!=null? this.list.size(): 0 ;
    }

    @Override
    public Object getItem(int position) {
        return this.list.get(position);
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public View getView(final int position, View convertView, ViewGroup parent) {
        if(convertView == null)
        {
            convertView = layoutInflater.inflate(R.layout.update_firmware_list_view_item, null);
        }

        final FirmwareInfo firmwareInfo = list.get(position);
        final String firmwareName = firmwareInfo.getFirmwareName();
        String firmwareMode = firmwareInfo.getFirmwareMode();

        final CheckBox cbItem = (CheckBox) convertView.findViewById(R.id.cb_update_item);
        cbItem.setText(firmwareMode + "_" + firmwareName);

        if (currentClickCheckBox != null && !currentClickCheckBox.equals(cbItem)) cbItem.setChecked(false);
        // cbItem.setOnCheckedChangeListener(new );

        cbItem.setEnabled(enableFlag);

        cbItem.setOnClickListener(new CheckBox.OnClickListener() {
            @Override
            public void onClick(View v) {
                if(cbItem.isChecked())  {
                    currentClickCheckBox = cbItem;

                    context.onClickList(firmwareInfo);
                    notifyDataSetChanged();

                } else {
                    context.onClickList(null);
                    // Toast.makeText(context, "取消了 " + firmwareName, Toast.LENGTH_SHORT).show();
                }
            }
        });

        return convertView;
    }
    public void clearCurrentCheckBoxChecked() {
        if (currentClickCheckBox != null) {
            currentClickCheckBox.setChecked(false);
            notifyDataSetChanged();
        }
    }

    public boolean getCurrentCheckBoxState() {
        if (currentClickCheckBox != null) {
            return currentClickCheckBox.isChecked();
        }

        return false;
    }
 }
