package com.asreader.app.rfid.view;

import android.app.ActionBar;
import android.app.AlertDialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.PowerManager;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.RadioButton;
import android.widget.TextView;

import com.asreader.app.rfid.MainActivity;
import com.asreader.app.rfid.R;
import com.asreader.p252b.AsReaderP252B;
import com.asreader.p252b.barcode.AsReaderP252BBarcodeType;
import com.asreader.p252b.device.type.AsReaderP252BConnectionState;
import com.asreader.p252b.device.type.AsReaderP252BKeyState;
import com.asreader.p252b.diagnostics.AsReaderP252BLog;
//import com.asreader.lib.rfid.R2000.R2000Model;
import com.asreader.p252b.rfid.exception.AsReaderP252BException;
import com.asreader.p252b.rfid.type.AsReaderP252BActionState;
import com.asreader.p252b.rfid.type.AsReaderP252BScanMode;
import com.asreader.p252b.rfid.type.AsReaderP252BResultCode;

import java.nio.charset.Charset;
import java.util.Locale;

import support.andro.app.rfid.adapter.BarcodeListAdapter;
import support.andro.app.rfid.adapter.SpinnerAdapter;
//import support.andro.app.rfid.data.MySQLiteOpenHelper;
import support.andro.app.rfid.data.SaveAsCSV;
//import support.andro.app.rfid.data.SaveAsExcel;
import support.andro.app.rfid.util.ResUtil;
import support.andro.app.rfid.view.base.RfidClearActivity;

import static com.asreader.app.rfid.R.string.rescan_time;

public class BarcodeDemoActivity extends RfidClearActivity implements OnClickListener {

	private static final String TAG = BarcodeDemoActivity.class.getSimpleName();

	private static final int VIEW_BARCODE_OPTION = 1000;

	private TextView txtCount;
	private TextView txtRescanTime;
	private Button btnAction;
	private Button btnRescan;
	private RadioButton rbtnAscii;
	private RadioButton rbtnUTF8;
	private RadioButton rbtnShiftJIS;
	private MenuItem mnuSaveFile;
	private MenuItem mnuSaveExcel;

	private BarcodeListAdapter adpBarcode;
	private boolean isScanning;
	private boolean isScanningHw;

	// Rescan
	private boolean isReScanning = true;
	private String[] mArrayRescanTime = new String[]{"Not Used","100 ms","200 ms","300 ms","400 ms", "500 ms", "600 ms", "700 ms", "800 ms",
			"900 ms", "1000 ms", "1100 ms", "1200 ms", "1300 ms", "1500 ms", "2000 ms", "2500 ms", "3000 ms", "3500 ms", "5000 ms"};

	// DB
//	protected MySQLiteOpenHelper dbHelper;

	// Encoding
	private Charset mCharset_ASCii = Charset.forName("ASCII");
	private Charset mCharset_UTF8 = Charset.forName("UTF-8");
	private Charset mCharset_ShiftJIS = Charset.forName("Shift_JIS");
	private int charsetStatus = 0;
	private static final Object objLock = new Object();

	private Handler handler;
	private Runnable runnable;
	PowerManager powerManager;
	PowerManager.WakeLock wakeLock;


	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_barcode_demo);

		// Android OS screen power saving mode control.
		powerManager = (PowerManager) getSystemService(POWER_SERVICE);
		wakeLock = powerManager.newWakeLock(PowerManager.FULL_WAKE_LOCK, "BarcodeScan:WakeLock");

		ActionBar actionBar = getActionBar();
		if(actionBar != null) {
			actionBar.setDisplayOptions(ActionBar.DISPLAY_SHOW_CUSTOM);
			actionBar.setCustomView(R.layout.activity_title);
			actionBar.setDisplayHomeAsUpEnabled(true);
			actionBar.setDisplayShowHomeEnabled(true);
		}
		
		TextView titleText = (TextView)findViewById(R.id.title_text);
		titleText.setText(R.string.barcode_demo_name);
		final int version = Build.VERSION.SDK_INT;
		if(version >= Build.VERSION_CODES.M)
			titleText.setTextColor(getColor(getApplicationContext(), R.color.black));

		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. onCreate()");

		// Create Reader
		createReader();

		// Initialize Widget
		initWidgets();

		// Initialize Reader
		initReader();

		txtRescanTime.setText((MainActivity.mUserConfigs.getDecodeRescanTime()==0)?"Not Used":MainActivity.mUserConfigs.getDecodeRescanTime()+" ms");
		handler = new Handler();
		runnable = new Runnable(){
			@Override
			public void run() {
				if (isReScanning) {
					getReader().startDecode();
				}
			}
		};
	}

	@Override
	protected void onDestroy() {

		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. onDestroy()");

		try {
			getReader().setScanMode(AsReaderP252BScanMode.RFIDScanMode);
		} catch (AsReaderP252BException e) {
			e.printStackTrace();
		}

		// Destroy Reader
		destroyReader();

		unregisterReceiver(screenOnReceiver);
		if (handler != null) {
			handler.removeCallbacksAndMessages(null);
			handler = null;
		}
		super.onDestroy();
	}

	@Override
	protected void onStart() {
		super.onStart();
	}

	@Override
	protected void onStop() {
		getReader().stopDecode();
//		dbHelper.deleteBarcode();

		// DB insert
//		for (int i =0; i<adpBarcode.getCount(); i++){
//			Log.d(TAG,"# DB stop : set DB Barcode List item : " + adpBarcode.getBarcodeItemForDB(i));

			//Barcode, count, type, codeid, time
//			String[] temp = adpBarcode.getBarcodeItemForDB(i);
//			dbHelper.insertBarcode(temp[0],temp[1],temp[2],temp[3], temp[4]);
//		}

		super.onStop();
	}

	@Override
	protected void onResume() {
		super.onResume();
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. onResume()");
//		R2000Model.getInstance().isTriggerEnable = true;
	}

	@Override
	protected void onPause() {
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. onPause()");
//		R2000Model.getInstance().isTriggerEnable = false;
		super.onPause();
	}

	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data) {

		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. onActivityResult(%s, %s)", getRequestCode(requestCode), getResultCode(resultCode));

		if (requestCode == VIEW_BARCODE_OPTION) {
			enableActionWidgets(true);
		}
		super.onActivityResult(requestCode, resultCode, data);
	}

	@Override
	public void onClick(View v) {
		super.onClick(v);

		int id = v.getId();
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. onClick(%s)", ResUtil.getId(id));

		switch (id) {
		case R.id.action:
			if (!isScanning)
				scanEnabled(true);
			else
				scanEnabled(false);

			break;

		case R.id.btn_rescan:
			showRescanTimeDialog();
			break;

		case R.id.ascii:
			charsetStatus = 0;
			encodingType(mCharset_ASCii);
			break;
		case R.id.utf8:
			charsetStatus = 1;
			encodingType(mCharset_UTF8);
			break;
		case R.id.shiftjis:
			charsetStatus = 2;
			encodingType(mCharset_ShiftJIS);
			break;
		}
	}

	private void encodingType(Charset charset){
		try {
			getReader().setCharset(charset);
		} catch (AsReaderP252BException e) {
			e.printStackTrace();
		}
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. onCreateOptionsMenu()");
		getMenuInflater().inflate(R.menu.save_file, menu);
		return true;
	}

	@Override
	public boolean onPrepareOptionsMenu(Menu menu) {
		mnuSaveFile = menu.findItem(R.id.save_csv);
		mnuSaveFile.setEnabled(getReader().getAction() == AsReaderP252BActionState.Stop);
		return super.onPrepareOptionsMenu(menu);
	}
	
	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		int id = item.getItemId();

		switch (id) {
		case R.id.save_csv:
			if(adpBarcode.getCount() < 1)
				return true;
			
			SaveAsCSV task = new SaveAsCSV(BarcodeDemoActivity.this, SaveAsCSV.DATA_TYPE_BARCODE, adpBarcode, false);
			task.execute();
			return true;
		}
		return super.onOptionsItemSelected(item);
	}

	public boolean getIsScanning() {
		synchronized(objLock) {
			return isScanning;
		}
	}
	public void setIsScanning(boolean value) {
		synchronized(objLock) {
			isScanning = value;
		}
	}
	
	@Override
	public void onStateChanged(AsReaderP252B reader, AsReaderP252BConnectionState state) {
		if (state == AsReaderP252BConnectionState.Disconnected) {
			setResult(RESULT_DISCONNECTED);
			finish();
		}
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "EVENT. onStateChanged(%s)", state);
	}

	@Override
	public void onReadTag(AsReaderP252B reader, AsReaderP252BActionState action, String tag, float rssi, float phase, float frequency) {

	}

	@Override
	public void onAccessResult(AsReaderP252B reader, AsReaderP252BResultCode code, AsReaderP252BActionState action, String epc, String data, float rssi, float phase, float frequency) {

	}

	@Override
	public void onReadTemperatureTag(AsReaderP252B reader, AsReaderP252BActionState action, String tag, float rssi, float phase, float frequency, float temperature) {

	}

	@Override
	public void onReadHumidityTag(AsReaderP252B reader, AsReaderP252BActionState action, String tag, float rssi, float phase, float frequency, float humidity) {

	}

	@Override
	public boolean onKeyEvent(AsReaderP252B reader, AsReaderP252BKeyState state) {
//		if (state == KeyState.KeyUp) {
//			if (!isScanning) {
//				scanEnabled(true);
//			} else {
//				scanEnabled(false);
//			}
//		}
//		return false;
//		if (state == AsReaderP252BKeyState.KeyDown) {
//			isReScanning = true;
//			scanEnabled(true);
//		} else {
//			isReScanning = false;
//			scanEnabled(false);
//		}
		if (state == AsReaderP252BKeyState.KeyDown) {
			if (!isScanning)
				scanEnabled(true);
			else
				scanEnabled(false);
		}
		return false;
	}

	@Override
	public boolean onModeKeyEvent(AsReaderP252B reader, AsReaderP252BKeyState state) {
		return false;
	}
	@Override
	public void onReceivedData(byte[] data) {

	}

	@Override
	public void onActionChanged(AsReaderP252B reader, AsReaderP252BActionState action) {
		if (action == AsReaderP252BActionState.StartDecode) {
			scanElemEnabled(false);
		} else if (action == AsReaderP252BActionState.Stop) {
			final int mRescanTime = MainActivity.mUserConfigs.getDecodeRescanTime();

			// Rescan Time > 0
			if (mRescanTime>0 && isReScanning){
				handler.removeCallbacks(runnable);
				handler.postDelayed(runnable, mRescanTime);
			}else {
				scanElemEnabled(true);
			}
		}
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "EVENT. onActionChanged(%s)", action);
	}

	@Override
	public void onReadBarcode(AsReaderP252B reader, AsReaderP252BBarcodeType type, String barcode) {
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "EVENT. onReadBarcode (%s, [%s])", type, barcode);
	}

	@Override
	public void onReadBarcode(AsReaderP252B reader, AsReaderP252BBarcodeType type, byte[] barcodeData) {
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "EVENT. onReadBarcode (%s, [%s])", type, barcodeData);
		Charset charset = mCharset_ASCii;
		if (charsetStatus == 0) {
			charset = mCharset_ASCii;
		} else if (charsetStatus == 1) {
			charset = mCharset_UTF8;
		} else if (charsetStatus == 2) {
			charset = mCharset_ShiftJIS;
		}
		String data = new String(barcodeData, charset);
		if (data == null || data == "") {
			data = new String(barcodeData, mCharset_ASCii);
		}
		adpBarcode.addItem(type, data);
		txtCount.setText(String.format(Locale.US, "%d", adpBarcode.getCount()));
	}

	// Initialize Reader
	protected void initReader() {
		// encoding type reset.
		try {
			getReader().setCharset(Charset.forName("ASCII"));
			rbtnAscii.setChecked(true);
		} catch (AsReaderP252BException e) {
			e.printStackTrace();
		}

		isScanning = false;
		isScanningHw = true;
		mnuSaveFile = null;

		try {
			getReader().setScanMode(AsReaderP252BScanMode.BarcodeScanMode);

		} catch (AsReaderP252BException e) {
			e.printStackTrace();
		}
		// Blocked trigger event when off screen.
//		R2000Model.getInstance().isTriggerEnable = true;
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. initReader()");
	}

	protected void initWidgets() {
		super.initWidgets();
		// new database
//		dbHelper = MySQLiteOpenHelper.getInstance(this);

		ListView lstBarcodes = (ListView) findViewById(R.id.barcodes);
		adpBarcode = new BarcodeListAdapter(this);

		// data from db
//		ArrayList dbBarcode = dbHelper.selectBarcode();

		try {
//			for (int i = 0; i < dbBarcode.size(); i++) {
//				String[] temp = dbBarcode.get(i).toString().split("<split>");
//				BarcodeType type = super.getBarcodeType(temp[3]);
//				adpBarcode.addItem(type, Integer.parseInt(temp[1]), temp[3], temp[0], Long.parseLong(temp[4]));
//			}
		}catch (Exception e){
			e.getStackTrace();
		}

		lstBarcodes.setAdapter(adpBarcode);

		txtCount = (TextView) findViewById(R.id.barcode_count);
		txtCount.setText(String.format(Locale.US, "%d", adpBarcode.getCount()));
		btnAction = (Button) findViewById(R.id.action);
		btnAction.setOnClickListener(this);
		btnRescan = (Button) findViewById(R.id.btn_rescan);
		btnRescan.setOnClickListener(this);
		rbtnAscii = (RadioButton) findViewById(R.id.ascii);
		rbtnAscii.setOnClickListener(this);
		rbtnUTF8 = (RadioButton) findViewById(R.id.utf8);
		rbtnUTF8.setOnClickListener(this);
		rbtnShiftJIS = (RadioButton) findViewById(R.id.shiftjis);
		rbtnShiftJIS.setOnClickListener(this);

		txtRescanTime = (TextView) findViewById(R.id.tv_rescan_time);

		// Enable action widget
//		enableActionWidgets(getReader().isBarcodeEnabled());

		// Screen On/Off event
		useScreenOnOffMonitoring();

		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. initWidgets()");
	}


	@Override
	protected void clearWidgets() {
//		dbHelper.deleteBarcode();
		adpBarcode.clear();
		txtCount.setText(String.format(Locale.US, "%d", adpBarcode.getCount()));
		enableActionWidgets(true);
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. clearWidgets()");
	}

	// Enable/Disable Action Widgets
	protected void enableActionWidgets(boolean enabled) {
		btnAction.setEnabled(enabled);
		btnClear.setEnabled(!getIsScanning() && enabled);
		btnRescan.setEnabled(!getIsScanning() && enabled);
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. enableActionWidgets(%s)", enabled);
	}

	@Override
	protected String getRequestCode(int requestCode) {
		switch (requestCode) {
		case VIEW_BARCODE_OPTION:
			return "VIEW_BARCODE_OPTION";
		}
		return super.getRequestCode(requestCode);
	}

	private void scanEnabled(boolean enabled){
		if (enabled){
			getReader().startDecode();
			scanElemEnabled(false);

			if (wakeLock!=null)
				wakeLock.acquire();		// Preventing screen sleep during scanning.
		}else {
			handler.removeCallbacks(runnable);
			getReader().stopDecode();
			scanElemEnabled(true);

			if (wakeLock!=null)
				wakeLock.release();		// After the scan is finished, cancels blocking the screen sleep mode.
		}
	}

	private void scanElemEnabled(boolean enabled){
		if (enabled){
			isReScanning = false;

			setIsScanning(false);
			btnAction.setText(R.string.action_scan_start);
			enableActionWidgets(true);
		}else {
			isReScanning = true;

			setIsScanning(true);
			btnAction.setText(R.string.action_scan_stop);
			enableActionWidgets(true);
		}
	}


	private void showRescanTimeDialog() {

		LinearLayout root = (LinearLayout) LinearLayout.inflate(this, R.layout.dialog_list_view, null);
		final ListView value = (ListView) root.findViewById(R.id.list);
		final SpinnerAdapter adapter = new SpinnerAdapter(this, android.R.layout.simple_list_item_single_choice);
		adapter.addItem(mArrayRescanTime);				// 임시 데이터
		value.setAdapter(adapter);
		value.setChoiceMode(ListView.CHOICE_MODE_SINGLE);

		AlertDialog.Builder builder = new AlertDialog.Builder(this);
		builder.setTitle(rescan_time);
		builder.setView(root);
		builder.setPositiveButton(R.string.action_ok, new DialogInterface.OnClickListener() {

			@Override
			public void onClick(DialogInterface dialog, int which) {
				int position;
				try {
					position = value.getCheckedItemPosition();
					adapter.getValue(position);
				}catch (ArrayIndexOutOfBoundsException e){
					Log.d(TAG, e.getMessage());
					position = 0;
				}

				value.setItemChecked(position,true);
				txtRescanTime.setText(adapter.getName(position));
				String[] str_temp = adapter.getName(position).split(" ");
				int value;
				if (str_temp[0].contains("Not"))
					value = 0;
				else
					value = Integer.parseInt(str_temp[0]);

				MainActivity.mUserConfigs.setDecodeRescanTime(value);
				MainActivity.mUserConfigs.setDecodeRescanTimePostion(position);
				MainActivity.mUserConfigs.Save();
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showRescanTimeDialog().$PositiveButton.onClick()");
			}
		});
		builder.setCancelable(true);
		AlertDialog dialog = builder.create();
		dialog.setOnShowListener(new DialogInterface.OnShowListener() {

			@Override
			public void onShow(DialogInterface dialog) {
				int position = MainActivity.mUserConfigs.getDecodeRescanTimePostion();
				value.setItemChecked(position, true);
				value.setSelectionFromTop(position, 0);
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showRescanTimeDialog().onShow()");
			}
		});
		dialog.show();
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showRescanTimeDialog()");
	}


	/************************************************************
	 *  Screen On/Off Event
	 ************************************************************/
	private ScreenOnReceiver screenOnReceiver =null;
	class ScreenOnReceiver extends BroadcastReceiver {
		public void onReceive(Context context, Intent intent) {
			String action = intent.getAction();
			if (action.equals(Intent.ACTION_SCREEN_ON)) {
//				R2000Model.getInstance().isTriggerEnable = true;
			} else if (action.equals(Intent.ACTION_SCREEN_OFF)) {
//				R2000Model.getInstance().isTriggerEnable = false;
			}
		}
	}

	private void useScreenOnOffMonitoring()
	{
		if(screenOnReceiver == null)
		{
			screenOnReceiver = new ScreenOnReceiver();
			IntentFilter filter = new IntentFilter();
			filter.addAction("android.intent.action.SCREEN_ON");
			filter.addAction("android.intent.action.SCREEN_OFF");
			registerReceiver(screenOnReceiver, filter);
		}
	}
}

