package support.andro.app.rfid.view.base;

import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;


import support.andro.app.rfid.adapter.TagListAdapter;
import support.andro.app.rfid.dialog.WaitDialog;
import support.andro.app.rfid.util.ResUtil;

import com.asreader.app.rfid.MainActivity;
import com.asreader.p252b.AsReaderP252B;
import com.asreader.p252b.diagnostics.AsReaderP252BLog;
import com.asreader.p252b.rfid.exception.AsReaderP252BException;
import com.asreader.p252b.rfid.params.AsReaderP252BSelectMaskEpcParam;
import com.asreader.p252b.rfid.type.AsReaderP252BActionState;
import com.asreader.p252b.rfid.type.AsReaderP252BMemoryBank;
import com.asreader.p252b.rfid.type.AsReaderP252BResultCode;
import com.asreader.app.rfid.view.ReadMemoryActivity;
import com.asreader.app.rfid.view.TagAccessActivity;
import com.asreader.app.rfid.view.WriteMemoryActivity;
import com.asreader.app.rfid.R;

import android.content.Intent;
import android.view.ContextMenu;
import android.view.ContextMenu.ContextMenuInfo;
import android.view.MenuItem;
import android.view.View;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.CompoundButton;
import android.widget.CompoundButton.OnCheckedChangeListener;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;

public abstract class BaseInventoryActivity extends RfidMaskActivity implements OnCheckedChangeListener {

	private static final String TAG = BaseInventoryActivity.class.getSimpleName();

	protected ListView lstTags;
	protected TextView txtCount;
	protected Button btnInventory;

	protected TagListAdapter adpTags;

	private MenuItem mnuReadMemory;
	private MenuItem mnuWriteMemory;
	private MenuItem mnuTagAccess;
	private MenuItem openLEDEL;
	private MenuItem openLEDKX;

	private Timer openLEDELTimer;
	private Timer openLEDKXTimer;

	private boolean mLastContinuousMode = true;
	private boolean mLastReportRssi = false;

	@Override
	protected void onStart() {
		super.onStart();
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. onStart()");
	}
	
	@Override
	protected void onResume() {
		super.onResume();
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. onResume()");
//		try {
//			if (getReader() != null) {
//				getReader().clearEpcMask();
//			}
//		} catch (AsReaderP252BException e) {
//			e.printStackTrace();
//		}
		try {
			if(asReaderP252BSelectMaskEpcParam.getMask().length() != 0) {
				getReader().addEpcMask(asReaderP252BSelectMaskEpcParam);
			}
		} catch (AsReaderP252BException e) {
			e.printStackTrace();
		}
	}

	@Override
	protected void onPause() {
		super.onPause();
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. onPause()");
	}

	@Override
	protected void onStop() {
		super.onStop();
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. onStop()");
	}

	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data) {

		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. onActivityResult(%s, %s)", getRequestCode(requestCode), getResultCode(resultCode));

		if (resultCode == RESULT_DISCONNECTED) {
			setResult(RESULT_DISCONNECTED);
			finish();
			return;
		}

		switch (requestCode) {
		case AccessActivity.VIEW_READ_MEMORY:
		case AccessActivity.VIEW_WRITE_MEMORY:
		case AccessActivity.VIEW_TAG_ACCESS:
//			try {
//				getReader().setContinuousMode(mLastContinuousMode);
//			} catch (AsReaderP252BException e) {
//				AsReaderP252BLog.e(TAG, "onActivityResult - Failed to setContinuousMode");
//			}
//			try {
//				getReader().setReportRSSI(mLastReportRssi);
//				MainActivity.mUserConfigs.setReportRssi(mLastReportRssi);
//				MainActivity.mUserConfigs.Save();
//			} catch (AsReaderP252BException e) {
//				AsReaderP252BLog.e(TAG, "onActivityResult - Failed to setReportRSSI");
//			}
			enableActionWidgets(true);
			return;
		}
		super.onActivityResult(requestCode, resultCode, data);
	}

	@Override
	public void onCreateContextMenu(ContextMenu menu, View v, ContextMenuInfo menuInfo) {
		super.onCreateContextMenu(menu, v, menuInfo);
		
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. onCreateContextMenu()");

		if (v.getId() != R.id.tag_list || getReader().getAction() != AsReaderP252BActionState.Stop)
			return;

		getMenuInflater().inflate(R.menu.inventory_menu, menu);

		mnuReadMemory = menu.findItem(R.id.read_memory);
		mnuWriteMemory = menu.findItem(R.id.write_memory);
		mnuTagAccess = menu.findItem(R.id.tag_access);
		openLEDEL = menu.findItem(R.id.open_led_el);
	}

	@Override
	public boolean onContextItemSelected(MenuItem item) {

		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. onContextItemSelected(%s)", ResUtil.getId(item.getItemId()));

		Intent intent;
		AdapterView.AdapterContextMenuInfo menuInfo = (AdapterView.AdapterContextMenuInfo) item.getMenuInfo();
		int position = menuInfo.position;

		if (position < 0)
			return false;

		mnuReadMemory.setEnabled(false);
		mnuWriteMemory.setEnabled(false);
		mnuTagAccess.setEnabled(false);

		String tag = adpTags.getItem(position, false);
		
		try {
			mLastContinuousMode = getReader().getContinuousMode();
		} catch (AsReaderP252BException e) {
			AsReaderP252BLog.e(TAG, "onContextItemSelected - Failed to getContinuousMode");
		}
		
		try {
			mLastReportRssi = getReader().getReportRSSI();
		} catch (AsReaderP252BException e) {
			AsReaderP252BLog.e(TAG, "onContextItemSelected - Failed to getReportRSSI");
		}

		switch (item.getItemId()) {
			case R.id.read_memory:
				intent = new Intent(this, ReadMemoryActivity.class);
				intent.putExtra(KEY_MASK, tag);
				setupMask(tag);
				startActivityForResult(intent, AccessActivity.VIEW_READ_MEMORY);
				break;
			case R.id.write_memory:
				intent = new Intent(this, WriteMemoryActivity.class);
				intent.putExtra(KEY_MASK, tag);
				setupMask(tag);
				startActivityForResult(intent, AccessActivity.VIEW_WRITE_MEMORY);
				break;
			case R.id.tag_access:
				intent = new Intent(this, TagAccessActivity.class);
				intent.putExtra(KEY_MASK, tag);
				setupMask(tag);
				startActivityForResult(intent, AccessActivity.VIEW_TAG_ACCESS);
				break;
			case R.id.open_led_el: {
				WaitDialog.show(this, R.string.open_led_el);
				setupMask(tag);
				openLEDELTimer = new Timer();
				openLEDELTimer.schedule(new TimerTask() {
					@Override
					public void run() {
						runOnUiThread(calculateTheELMean);
					}
				}, 0, 1000);
				break;
			}
			case R.id.open_led_kx: {
				WaitDialog.show(this, R.string.open_led_kx);
				setupMask(tag);
				openLEDKXTimer = new Timer();
				openLEDKXTimer.schedule(new TimerTask() {
					@Override
					public void run() {
						runOnUiThread(calculateTheKXMean);
					}
				}, 0, 1000);
			}
				break;
		}
		return true;
	}
	private int openLEDCount = 6;
	public AsReaderP252BSelectMaskEpcParam asReaderP252BSelectMaskEpcParam = new AsReaderP252BSelectMaskEpcParam();

	private Runnable calculateTheELMean = new Runnable() {
		@Override
		public void run() {
			getReader().stop();
			openLEDCount--;
			if(openLEDCount <= 0){
				if (openLEDELTimer != null) {
					openLEDELTimer.cancel();
					openLEDELTimer = null;
				}
				openLEDCount = 6;
				exitMask();
				try {
					getReader().clearEpcMask();
				} catch (AsReaderP252BException e) {
					e.printStackTrace();
				}
				try {
					if(asReaderP252BSelectMaskEpcParam.getMask().length() != 0) {
						getReader().addEpcMask(asReaderP252BSelectMaskEpcParam);
					}
				} catch (AsReaderP252BException e) {
					e.printStackTrace();
				}
				WaitDialog.hide();
			} else {
				getReader().readMemory(AsReaderP252BMemoryBank.User,112,1);
			}
		}
	};
	private Runnable calculateTheKXMean = new Runnable() {
		@Override
		public void run() {
			getReader().stop();
			openLEDCount--;
			if(openLEDCount <= 0){
				if (openLEDKXTimer != null) {
					openLEDKXTimer.cancel();
					openLEDKXTimer = null;
				}
				openLEDCount = 6;
				exitMask();
				try {
					getReader().clearEpcMask();
				} catch (AsReaderP252BException e) {
					e.printStackTrace();
				}
				try {
					if(asReaderP252BSelectMaskEpcParam.getMask().length() != 0) {
						getReader().addEpcMask(asReaderP252BSelectMaskEpcParam);
					}
				} catch (AsReaderP252BException e) {
					e.printStackTrace();
				}
				WaitDialog.hide();
			} else {
				getReader().readMemory(AsReaderP252BMemoryBank.Reserved,4,1);
			}
		}
	};
	private void setupMask(String tag) {
		try {
			int count = getReader().getEpcMaskCount();

			if (count != 0) {
				asReaderP252BSelectMaskEpcParam = getReader().getEpcMask(0);
				if (asReaderP252BSelectMaskEpcParam == null) {
					asReaderP252BSelectMaskEpcParam = new AsReaderP252BSelectMaskEpcParam();
					asReaderP252BSelectMaskEpcParam.setOffset(16);
					asReaderP252BSelectMaskEpcParam.setLength(16);
				}
			} else {
				asReaderP252BSelectMaskEpcParam = new AsReaderP252BSelectMaskEpcParam();
				asReaderP252BSelectMaskEpcParam.setOffset(16);
				asReaderP252BSelectMaskEpcParam.setLength(16);
			}
		} catch (AsReaderP252BException e) {
			asReaderP252BSelectMaskEpcParam = new AsReaderP252BSelectMaskEpcParam();
			asReaderP252BSelectMaskEpcParam.setOffset(16);
			asReaderP252BSelectMaskEpcParam.setLength(16);
			e.printStackTrace();
		}
		AsReaderP252BSelectMaskEpcParam param = new AsReaderP252BSelectMaskEpcParam();
		param.setOffset(32);
		param.setMask(tag);
		param.setLength(tag.length() * 4);
		try {
			getReader().clearEpcMask();
		} catch (AsReaderP252BException e) {
			e.printStackTrace();
		}
		//save epc
		try {
			getReader().addEpcMask(param);
		} catch (AsReaderP252BException e) {
			e.printStackTrace();
		}
	}
		@Override
	public void onClick(View v) {

		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. onClick(%s)", ResUtil.getId(v.getId()));

		switch (v.getId()) {
		case R.id.inventory:
			if (getReader().getAction() == AsReaderP252BActionState.Stop) {
				startInventory();
			} else {
				stopInventory();
				
			}
			break;
		}

		super.onClick(v);
	}

	@Override
	public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {

		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. onCheckedChanged(%s, %s)", ResUtil.getId(buttonView.getId()), isChecked);
	}

	@Override
	public void onActionChanged(AsReaderP252B reader, AsReaderP252BActionState action) {
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "EVENT. onActionChanged(%s)", action);

		adpTags.notifyDataSetChanged();

		enableActionWidgets(true);
	}

	@Override
	public void onReadTag(AsReaderP252B reader, AsReaderP252BActionState action, String tag, float rssi, float phase, float frequency) {
		
		AsReaderP252BLog.d(TAG, AsReaderP252BLog.DEBUG, "EVENT. onReadTag(%s, [%s], %.2f, %.2f)", action, tag, rssi, phase);
		
		adpTags.addTag(tag, rssi, phase, frequency, System.currentTimeMillis());
		txtCount.setText(String.format(Locale.US, "%d", adpTags.getCount()));
	}
	
	@Override
	public void onAccessResult(AsReaderP252B reader, AsReaderP252BResultCode code, AsReaderP252BActionState action, String epc, String data,
							   float rssi, float phase, float frequency) {
		
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "EVENT. onAccessResult(%s, [%s], [%s]%.2f, %.2f)", action, epc, data, rssi, phase);
		
//		adpTags.addTag(epc, data, rssi, phase, frequency, System.currentTimeMillis());
//		txtCount.setText(String.format(Locale.US, "%d", adpTags.getCount()));
	}

	// Initialize Widgets
	@Override
	protected void initWidgets() {
		super.initWidgets();
		
		btnOption = (Button) findViewById(R.id.option);
		if(btnOption != null)
			btnOption.setOnClickListener(this);

		// Tag ListView
		lstTags = (ListView) findViewById(R.id.tag_list);
		adpTags = new TagListAdapter(this);
		lstTags.setAdapter(adpTags);
		adpTags.start();

		registerForContextMenu(lstTags);

		// Count TextView
		txtCount = (TextView) findViewById(R.id.tag_count);
		txtCount.setText(String.format(Locale.US, "%d", adpTags.getCount()));
		// Inventory Button
		btnInventory = (Button) findViewById(R.id.inventory);
		btnInventory.setOnClickListener(this);
		
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. initWidgets()");
	}

	// Enable/Disable Action Widgets
	@Override
	protected void enableActionWidgets(boolean enabled) {
		super.enableActionWidgets(enabled);

		btnMask.setEnabled(isEnabledWidget(enabled));
		lstTags.setEnabled(isEnabledWidget(enabled));
		enableActionButton(btnInventory, enabled, R.string.action_inventory, R.string.action_stop);
		
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. enableActionWidgets(%s)", enabled);
	}
	
	@Override
	protected void clearWidgets() {

		adpTags.clear();
		txtCount.setText(String.format(Locale.US, "%d", adpTags.getCount()));

		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. clearWidgets()");
	}

	protected void startInventory() {
		enableActionWidgets(false);
		AsReaderP252BResultCode res;
		if ((res = getReader().inventory()) != AsReaderP252BResultCode.NoError) {
			AsReaderP252BLog.e(TAG, "ERROR. startInventory() - Failed to start inventory()");
			String msg = String.format(Locale.US, "%s : 0x%04X", res.toString(), res.getCode());
			Toast.makeText(this, msg, Toast.LENGTH_SHORT).show();
			enableActionWidgets(true);
			return;
		}
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. startInventory()");
	}

	protected void stopInventory() {
		enableActionWidgets(false);
		if (getReader().stop() != AsReaderP252BResultCode.NoError) {
			AsReaderP252BLog.e(TAG, "ERROR. stopInventory() - Failed to stop inventory()");
			enableActionWidgets(true);
			return;
		}
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. stopInventory()");
	}

	public void setReportRssiMode(boolean enabled) {
		if (enabled == this.adpTags.getReportRSSI()){
			return;
		}
		clearWidgets();
		this.adpTags.setReportRSSI(enabled);
	}
	
	public void setDisplayPC(boolean enabled) {
		this.adpTags.setDisplayPc(enabled);
	}

}
