package support.andro.app.rfid.adapter;

import java.util.ArrayList;
import java.util.Locale;

import com.asreader.p252b.rfid.params.AsReaderP252BSelectMaskEpcParam;
import com.asreader.app.rfid.R;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;

public class SelectMaskEpcAdapter extends BaseAdapter {

	@SuppressWarnings("unused")
	private static final String TAG = SelectMaskEpcAdapter.class.getSimpleName();

	private LayoutInflater mInflater;
	private ArrayList<AsReaderP252BSelectMaskEpcParam> lstItems;

	public SelectMaskEpcAdapter(Context context) {
		super();

		this.mInflater = (LayoutInflater) context
				.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
		this.lstItems = new ArrayList<>();
	}

	public void addItem(AsReaderP252BSelectMaskEpcParam item) {
		lstItems.add(item);
	}
	
	public void updateItem(int position, AsReaderP252BSelectMaskEpcParam item) {
		this.lstItems.set(position, item);
	}
	
	public void removeItem(int position) {
		this.lstItems.remove(position);
	}
	
	public void clear() {
		this.lstItems.clear();
		this.notifyDataSetChanged();
	}
	
	@Override
	public int getCount() {
		return this.lstItems.size();
	}

	@Override
	public AsReaderP252BSelectMaskEpcParam getItem(int position) {
		return this.lstItems.get(position);
	}

	@Override
	public long getItemId(int position) {
		return position;
	}

	@Override
	public View getView(int position, View convertView, ViewGroup parent) {
		SelectMaskEpcViewHolder holder;

		if (null == convertView) {
			convertView = this.mInflater.inflate(R.layout.item_select_mask_epc,
					parent, false);
			holder = new SelectMaskEpcViewHolder(convertView, this);
		} else {
			holder = (SelectMaskEpcViewHolder)convertView.getTag();
		}
		holder.setItem(this.lstItems.get(position));
		return convertView;
	}

	private class SelectMaskEpcViewHolder {
		private TextView txtOffset;
		private TextView txtLength;
		private TextView txtMask;

		private SelectMaskEpcViewHolder(View parent,
				SelectMaskEpcAdapter adapter) {
			this.txtOffset = (TextView) parent.findViewById(R.id.offset);
			this.txtLength = (TextView) parent.findViewById(R.id.length);
			this.txtMask = (TextView) parent.findViewById(R.id.mask);
			parent.setTag(this);
		}

		public void setItem(AsReaderP252BSelectMaskEpcParam item) {
			this.txtOffset.setText(String.format(Locale.US, "%d", item.getOffset()));
			this.txtLength.setText(String.format(Locale.US, "%d", item.getLength()));
			this.txtMask.setText(item.getMask());
		}
	}
}
