package support.andro.app.rfid.widgets;

import android.content.Context;
import android.util.AttributeSet;
import android.widget.Checkable;
import android.widget.LinearLayout;

public class CheckableLinearLayout extends LinearLayout implements Checkable {

	private int mCheckableId;
	private Checkable mCheckable;

	public CheckableLinearLayout(Context context, AttributeSet attrs) {
		super(context, attrs);
		this.mCheckableId = attrs.getAttributeResourceValue("http://schemas.android.com/apk/res-auto",
															"checkable", 0);
	}

	@Override
	public void setChecked(boolean checked) {
		this.mCheckable = (Checkable)findViewById(this.mCheckableId);
		if (this.mCheckable == null) {
			return;
		}
		this.mCheckable.setChecked(checked);
	}

	@Override
	public boolean isChecked() {
		this.mCheckable = (Checkable)findViewById(this.mCheckableId);
		return this.mCheckable != null && this.mCheckable.isChecked();
	}

	@Override
	public void toggle() {
		this.mCheckable = (Checkable)findViewById(this.mCheckableId);
		if (this.mCheckable == null) {
			return;
		}
		this.mCheckable.toggle();
	}
}
