package support.andro.app.rfid.view.sub;

import support.andro.app.rfid.dialog.WaitDialog;
import support.andro.app.rfid.dialog.WheelDialog.MaskWheelDialog;
import support.andro.app.rfid.util.ResUtil;
//import support.andro.app.rfid.util.UserConfigs;

import com.asreader.app.rfid.MainActivity;
import com.asreader.p252b.barcode.AsReaderP252BBarcodeType;
import com.asreader.p252b.device.type.AsReaderP252BConnectionState;
import com.asreader.p252b.device.type.AsReaderP252BKeyState;
import com.asreader.p252b.diagnostics.AsReaderP252BLog;
import com.asreader.p252b.rfid.event.AsReaderP252BEventListener;
import com.asreader.p252b.rfid.exception.AsReaderP252BException;
import com.asreader.p252b.rfid.params.AsReaderP252BSelectMaskEpcParam;
import com.asreader.p252b.rfid.type.AsReaderP252BActionState;
import com.asreader.p252b.rfid.type.AsReaderP252BResultCode;
import com.asreader.app.rfid.R;
import com.asreader.p252b.AsReaderP252BManager;
import com.asreader.p252b.AsReaderP252B;
import com.wx.wheelview.widget.WheelViewDialog;

import android.annotation.SuppressLint;
import android.app.ActionBar;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.text.InputType;
import android.text.TextUtils;
import android.text.method.DigitsKeyListener;
import android.view.MenuItem;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.inputmethod.InputMethodManager;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class EpcMaskActivity extends Activity implements AsReaderP252BEventListener, OnClickListener,
		OnItemClickListener, android.content.DialogInterface.OnClickListener {

	private static final String TAG = EpcMaskActivity.class.getSimpleName();

	private static final int DEFAULT_OFFSET = 16;
	private static final String DEFAULT_MASK = "";
	private static final int DEFAULT_LENGTH = 16;
	private static final int NIBBLE_SIZE = 4;
	private static final String UNIT_BIT = " bit";

	private static final int RESULT_DISCONNECTED = Activity.RESULT_FIRST_USER + 1;

	private AsReaderP252B mReader = null;
	private Button btnSave;
	private Button btnClear;

	private TextView tvOffset;
	private TextView tvMask;
	private TextView tvLength;
	private int mOffset;
	private String mMask;
	private int mLength;

	private MaskWheelDialog offsetDialog;
	private MaskWheelDialog lengthDialog;
	private List<String> lengthList;

	private Handler mEvent;
	private AsReaderP252BSelectMaskEpcParam asReaderP252BSelectMaskEpcParam;
	// ************************************************************************
	// Activity Event Methods
	// ************************************************************************

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_selection_mask_epc);
		ActionBar actionBar = getActionBar();
		if(actionBar != null) {
			actionBar.setDisplayHomeAsUpEnabled(true);
		}

		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. onCreate()");

		//_userMasks = new UserMasks(this.getApplicationContext());


		// Get RFID Reader Instance
		mReader = AsReaderP252BManager.getInstance();
		mReader.setEventListener(this);

		// Initialize Widget
		initWidgets();
		// Enable action widget
		enableActionWidgets(false);

		mEvent = new Handler();

		// Load Selection Mask
		WaitDialog.show(this, R.string.load_EPC_mask);
		new Thread(new Runnable() {

			@Override
			public void run() {
				int count = 0;
				try {
					count = mReader.getEpcMaskCount();

					if (count != 0) {
						asReaderP252BSelectMaskEpcParam = mReader.getEpcMask(0);
						if (asReaderP252BSelectMaskEpcParam == null) {
							asReaderP252BSelectMaskEpcParam = new AsReaderP252BSelectMaskEpcParam();
							asReaderP252BSelectMaskEpcParam.setOffset(16);
							asReaderP252BSelectMaskEpcParam.setLength(16);
						}
					}else {
						asReaderP252BSelectMaskEpcParam = new AsReaderP252BSelectMaskEpcParam();
						asReaderP252BSelectMaskEpcParam.setOffset(16);
						asReaderP252BSelectMaskEpcParam.setLength(16);
					}

					mEvent.post(new Runnable() {

						@Override
						public void run() {
							enableActionWidgets(true);
							mOffset = asReaderP252BSelectMaskEpcParam.getOffset();
							mMask = (asReaderP252BSelectMaskEpcParam.getMask() == null) ? "" : asReaderP252BSelectMaskEpcParam.getMask();
							if (asReaderP252BSelectMaskEpcParam.getLength() == 0){
								asReaderP252BSelectMaskEpcParam.setLength(16);
							}
							mLength = asReaderP252BSelectMaskEpcParam.getLength();

							displayOffSet();
							displayMask();
							displayLength();
							WaitDialog.hide();
						}

					});
				} catch (Exception e) {
					mEvent.post(new Runnable() {

						@Override
						public void run() {
							WaitDialog.hide();
						}

					});
					AsReaderP252BLog.e(TAG, e, "ERROR. onCreate().$Runnable.run() - Failed to load select mask EPC");
				}
			}

		}).start();
	}

	@Override
	protected void onDestroy() {
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. onDestroy()");

		mReader.removeEventListener(this);
		// Destroy RFID Reader
		if (mReader.getAction() != AsReaderP252BActionState.Stop &&
				mReader.getState() == AsReaderP252BConnectionState.Connected) {
			mReader.stop();
		}
		super.onDestroy();
	}

	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		switch (item.getItemId()) {
		case android.R.id.home:
			AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. onOptionsItemSelected(home)");
			setResult(Activity.RESULT_CANCELED);
			finish();
			return true;
		}
		return super.onOptionsItemSelected(item);
	}

	@SuppressWarnings("deprecation")
	@Override
	public void onClick(View v) {
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. onClick(%s)", ResUtil.getId(v.getId()));

		switch (v.getId()) {
			case R.id.tv_offset:
				offsetDialog.show();
				break;
			case R.id.tv_mask:
				showMaskDialog();
				break;
			case R.id.tv_length:
				lengthDialog.show();
				break;
			case R.id.save:

				if (TextUtils.isEmpty(mMask) || TextUtils.isEmpty(tvMask.getText().toString().trim())) {
					return;
				}
				if (mLength == 0) {
					Toast.makeText(this, R.string.length_error, Toast.LENGTH_SHORT).show();
					return;
				}

				if (mMask.length() != mLength / NIBBLE_SIZE) {
					Toast.makeText(EpcMaskActivity.this, getString(R.string.length_error), Toast.LENGTH_SHORT).show();
					return;
				}

				enableActionWidgets(false);
				WaitDialog.show(this, R.string.save_EPC_mask);
				new Thread(new Runnable() {

					@Override
					public void run() {
						try {
							AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "+++ INFO. onClick(save)$Runnable.run()");

							AsReaderP252BSelectMaskEpcParam item = new AsReaderP252BSelectMaskEpcParam();
							item.setOffset(mOffset);
							item.setMask(mMask);
							item.setLength(mLength);

							mReader.clearEpcMask();
							//save epc
							mReader.addEpcMask(item);
							MainActivity.mUserConfigs.clearEpcMasks();
							MainActivity.mUserConfigs.addEpcMask(item);
							MainActivity.mUserConfigs.Save();

							mEvent.post(new Runnable() {

								@Override
								public void run() {
									AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. onClick(save)$Runnable.run()$Runable.run()");
									WaitDialog.hide();
									finish();
								}

							});

						} catch (AsReaderP252BException e) {
							e.printStackTrace();
							AsReaderP252BLog.e(TAG, e, "--- ERROR. onClick(save)$Runnable.run() - Failed to save select mask EPC" + e.getMessage());
							WaitDialog.hide();
							finish();
							return;
						}
						AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "--- INFO. onClick(save)$Runnable.run()");
					}

				}).start();
				break;
			case R.id.btn_clear:

				MainActivity.mUserConfigs.clearEpcMasks();
				MainActivity.mUserConfigs.Save();
				try {
					mReader.clearEpcMask();
				} catch (AsReaderP252BException e) {
					e.printStackTrace();
				}

				mOffset = DEFAULT_OFFSET;
				mMask = DEFAULT_MASK;
				mLength = DEFAULT_LENGTH;

				displayOffSet();
				displayMask();
				displayLength();

				break;
		}
	}

	@Override
	public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. onItemClick(mask_list, %d, %d)", position, id);
		enableActionWidgets(true);
	}

	// ************************************************************************
	// RFID Reader Event Methods
	// ************************************************************************
	@Override
	public void onStateChanged(AsReaderP252B reader, AsReaderP252BConnectionState state) {
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "EVENT. onStateChanged(%s)", state);
		if (state == AsReaderP252BConnectionState.Disconnected) {
			setResult(RESULT_DISCONNECTED);
			finish();
		}
	}

	@Override
	public void onReadBarcode(AsReaderP252B reader, AsReaderP252BBarcodeType type, String barcode) {
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "EVENT. onReadBarcode (%s, [%s])", type, barcode);
	}

	@Override
	public void onReadBarcode(AsReaderP252B reader, AsReaderP252BBarcodeType type, byte[] barcodeData) {
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "EVENT. onReadBarcode (%s, [%s])", type, barcodeData);
	}

	@Override
	public void onActionChanged(AsReaderP252B reader, AsReaderP252BActionState action) {
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "EVENT. onActionChanged(%s)", action);
	}

	@Override
	public void onReadTag(AsReaderP252B reader, AsReaderP252BActionState action, String tag, float rssi, float phase, float frequency) {
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "EVENT. onReadedTag(%s, [%s], %.2f, %.2f)", action, tag, rssi, phase);
	}

	@Override
	public void onAccessResult(AsReaderP252B reader, AsReaderP252BResultCode code, AsReaderP252BActionState action, String epc, String data,
							   float rssi, float phase, float frequency) {
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "EVENT. onAccessResult(%s, %s, [%s], [%s], %.2f, %.2f)", code, action, epc, data, rssi, phase);
	}

	@Override
	public void onReadTemperatureTag(AsReaderP252B reader, AsReaderP252BActionState action, String tag, float rssi, float phase, float frequency, float temperature) {

	}

	@Override
	public void onReadHumidityTag(AsReaderP252B reader, AsReaderP252BActionState action, String tag, float rssi, float phase, float frequency, float humidity) {

	}

	@Override
	public void onReceivedData(byte[] data) {

	}

	@Override
	public boolean onKeyEvent(AsReaderP252B reader, AsReaderP252BKeyState state) {
		return false;
	}

	@Override
	public boolean onModeKeyEvent(AsReaderP252B reader, AsReaderP252BKeyState state) {
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "EVENT. onModeKeyEvent [%s]", state);
		return false;
	}

	// ************************************************************************
	// Helper Methods
	// ************************************************************************
	// Initialize Widgets
	// Initialize Widgets
	private void initWidgets() {
		btnSave = (Button) findViewById(R.id.save);
		btnSave.setOnClickListener(this);

		btnClear = (Button) findViewById(R.id.btn_clear);
		btnClear.setOnClickListener(this);

		tvOffset = (TextView) findViewById(R.id.tv_offset);
		tvOffset.setOnClickListener(this);

		tvMask = (TextView) findViewById(R.id.tv_mask);
		tvMask.setOnClickListener(this);
		tvMask.setText("");

		tvLength = (TextView) findViewById(R.id.tv_length);
		tvLength.setOnClickListener(this);

		initLengthDialog();

		mOffset = DEFAULT_OFFSET;
		mMask = DEFAULT_MASK;
		mLength = DEFAULT_LENGTH;

		displayOffSet();
		displayMask();
		displayLength();
	}

	private void initLengthDialog() {

		lengthList = new ArrayList<>();
		for (int i = 0; i < DEFAULT_OFFSET; i++) {
			lengthList.add(i, String.valueOf(i * DEFAULT_OFFSET) + UNIT_BIT);
		}

		offsetDialog = new MaskWheelDialog(this);
		offsetDialog.setTitle(getString(R.string.length))
				.setButtonText("OK")
				.setDialogStyle(getColor(R.color.black)) // 选中文字的颜色
				.setCount(3)
				.setOnDialogItemClickListener(new WheelViewDialog.OnDialogItemClickListener() {
					@Override
					public void onItemClick(int position, String s) {

//						if ("0".equals(s.trim())) {
//							return;
//						}

						String str = s.substring(0, s.length() - 4).trim();
						mOffset = Integer.parseInt(str);
						displayOffSet();

					}
				});

		offsetDialog.setListItems(lengthList);

		lengthDialog = new MaskWheelDialog(this);
		lengthDialog.setTitle(getString(R.string.length))
				.setButtonText("OK")
				.setDialogStyle(getColor(R.color.black)) // 选中文字的颜色
				.setCount(3)
				.setOnDialogItemClickListener(new WheelViewDialog.OnDialogItemClickListener() {
					@Override
					public void onItemClick(int position, String s) {

						if ("0".equals(s.trim())) {
							tvMask.setText("");
							mMask = "";

							return;
						}

						String str = s.substring(0, s.length() - 4).trim();
						mLength = Integer.parseInt(str);
						// tvLength.setText(s);
						displayLength();

					}
				});

		lengthDialog.setListItems(lengthList);
	}

	// Enable/Disable Action Widgets
	private void enableActionWidgets(boolean enabled) {
		btnSave.setEnabled(enabled);
		btnClear.setEnabled(enabled);
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. enableActionWidgets(%s)", enabled);
	}

	private void showMaskDialog() {

		LinearLayout root = (LinearLayout) LinearLayout.inflate(this, R.layout.dialog_input_number_16, null);

		final EditText etInput = (EditText) root.findViewById(R.id.et_mask_input);

//		InputFilter[] filters = new InputFilter[] { new InputFilterMinMax(0, 255) };
//		etInput.setFilters(filters);

		AlertDialog.Builder builder = new AlertDialog.Builder(this);
		builder.setTitle(R.string.mask);
		builder.setView(root);
		builder.setPositiveButton(R.string.action_ok, null);

		// 点对话框以外的时候触发
		builder.setNegativeButton(R.string.action_cancel, new DialogInterface.OnClickListener() {
			@Override
			public void onClick(DialogInterface dialog, int which) {
				InputMethodManager imm = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
				if (imm != null)
					imm.hideSoftInputFromWindow(etInput.getWindowToken(), 0);
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showAutoOffTimeDialog().$NegativeButton.onClick()");
			}
		});
		builder.setCancelable(true);

		// 点取消时触发
		builder.setOnCancelListener(new DialogInterface.OnCancelListener() {

			@Override
			public void onCancel(DialogInterface dialog) {
				InputMethodManager imm = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
				if (imm != null)
					imm.hideSoftInputFromWindow(etInput.getWindowToken(), 0);
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showAutoOffTimeDialog().onCancel()");
			}
		});

		AlertDialog dialog = builder.create();

		dialog.setOnShowListener(new DialogInterface.OnShowListener() {

			@Override
			public void onShow(DialogInterface dialog) {
				// 显示(对话框刚出来)的时候执行
				final AlertDialog dlg = (AlertDialog) dialog;
				etInput.setText(String.format(Locale.US, "%s", mMask));
				etInput.selectAll();

				//	etInput.setKeyListener(DigitsKeyListener.getInstance(digists));
				// Edittext.setInputType(InputType.TYPE_CLASS_TEXT);
//				etInput.setInputType(InputType.TYPE_TEXT_VARIATION_EMAIL_ADDRESS); // 英文键盘
//				etInput.setImeOptions(EditorInfo.IME_ACTION_DONE); // 输入法右下角的按钮变"完成"

				etInput.setKeyListener(new DigitsKeyListener() {
					@Override
					public int getInputType() {
						return InputType.TYPE_CLASS_TEXT | InputType.TYPE_TEXT_VARIATION_NORMAL; // 弹英文键盘
					}

					@Override
					protected char[] getAcceptedChars() {
						return "0123456789abcdefABCDEF".toCharArray(); // 限制 16 进制
					}
				});

				etInput.requestFocus();

				// OK 按钮
				Button positiveButton = dlg.getButton(AlertDialog.BUTTON_POSITIVE);
				positiveButton.setOnClickListener(new View.OnClickListener() {
					@Override
					public void onClick(View v) {
						if (TextUtils.isEmpty(etInput.getText().toString())) {
							InputMethodManager imm = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
							if (imm != null) {
								imm.hideSoftInputFromWindow(etInput.getWindowToken(), 0);
							}
							Toast.makeText(EpcMaskActivity.this, getString(R.string.length_error), Toast.LENGTH_SHORT).show();
							dlg.dismiss();
							return;
						}

						try {
							String inputStr = etInput.getText().toString();
							if (inputStr.length() != mLength / NIBBLE_SIZE) {
								InputMethodManager imm = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
								if (imm != null) {
									imm.hideSoftInputFromWindow(etInput.getWindowToken(), 0);
								}
								// dlg.dismiss();
								Toast.makeText(EpcMaskActivity.this, getString(R.string.length_error), Toast.LENGTH_SHORT).show();
							} else {
								mMask = inputStr;
							}

							// mOffset = Integer.parseInt(etInput.getText().toString().trim());
						} catch (Exception e) {
							mLength = 0;
							tvLength.setText("0");
							mMask = "";
							// tvMask.setText("");
						}

						displayMask();

						InputMethodManager imm = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
						if (imm != null)
							imm.hideSoftInputFromWindow(etInput.getWindowToken(), 0);
						dlg.dismiss();
					}
				});
				InputMethodManager imm = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
				if (imm != null)
					imm.showSoftInput(etInput, InputMethodManager.SHOW_FORCED);
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showAutoOffTimeDialog().onShow()");
			}
		});
		dialog.show();
	}

	private void displayOffSet() {
		tvOffset.setText(String.format(Locale.US, "%d%s", mOffset, UNIT_BIT));
	}

	private void displayMask() {
		tvMask.setText(String.format(Locale.US, "%s", mMask));
	}

	private void displayLength() {
		tvLength.setText(String.format(Locale.US, "%d%s", mLength, UNIT_BIT));
	}

	@SuppressLint("NewApi")
	@SuppressWarnings("deprecation")
	protected int getColor(Context context, int id) {
		final int version = Build.VERSION.SDK_INT;
		if (version >= Build.VERSION_CODES.M)
			return context.getColor(id);
		else
			return context.getResources().getColor(id);
	}

	@Override
	public void onClick(DialogInterface dialog, int which) {

	}
}
