package com.asreader.app.rfid.view;

import java.util.ArrayList;
import java.util.Locale;

import support.andro.app.rfid.adapter.LbtChannelAdapter;
import support.andro.app.rfid.adapter.SpinnerAdapter;
import support.andro.app.rfid.dialog.WaitDialog;
import support.andro.app.rfid.filter.InputFilterMinMax;
import support.andro.app.rfid.util.ResUtil;
import support.andro.app.rfid.view.base.RfidPowerGainActivity;

import com.asreader.app.rfid.MainActivity;
import com.asreader.p252b.barcode.AsReaderP252BBarcodeType;
import com.asreader.p252b.device.type.AsReaderP252BKeyState;
import com.asreader.p252b.rfid.exception.AsReaderP252BException;
import com.asreader.p252b.rfid.params.AsReaderP252BPowerRange;
import com.asreader.p252b.rfid.type.AsReaderP252BActionState;
import com.asreader.p252b.rfid.type.AsReaderP252BBuzzerState;
import com.asreader.p252b.rfid.type.AsReaderP252BLbtItem;
import com.asreader.p252b.rfid.type.AsReaderP252BResultCode;
import com.asreader.app.rfid.R;
import com.asreader.p252b.AsReaderP252B;
import com.asreader.p252b.diagnostics.AsReaderP252BLog;
import android.annotation.SuppressLint;
import android.app.ActionBar;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.text.InputFilter;
import android.util.Log;
import android.view.MenuItem;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.TextView;

public class OptionActivity extends RfidPowerGainActivity implements OnClickListener {

	private static final String TAG = OptionActivity.class.getSimpleName();

	private static final int EVENT_LOAD_OPTION = 1000;
	private static final String KEY_BATTERY_INTERVAL = "battery_interval";
	private static final String KEY_MASK_TYPE = "mask_type";
	public static final String KEY_REPORT_RSSI = "report_rssi";
	private static final int DEFAULT_BATTERY_INTERVAL = 10;
	private static final int DEFAULT_MASK_TYPE = 1;
	private static final int MIN_AUTO_OFF_TIME = 0;
	private static final int MIN_BARCODE_TIMEOUT = 4;
	private static final int MIN_SLEEP_TIME = 0;

	private TextView txtBuzzer;
	private TextView txtIdleTime;
	private TextView txtAutoOffTime;
	private TextView txtBarcodeTimeout;
	private TextView txtBaudRate;
	private TextView txtSleepTime;
	private TextView txtQValue;
	private TextView txtMaxQ;
	private TextView txtMinQ;
	private TextView txtLinkProfile;
	private TextView txtDefaultLinkProfile;
	private TextView txtFrequencyAutomatic;
	private TextView txtBatteryInterval;
	private Button btnSave;
	private Button btnDefault;
	private Button btnLbtChannel;
	private boolean mIsEnabled;
	private AsReaderP252BBuzzerState mBuzzer;
//	private int mInventoryTime;
	private int mIdleTime;
	private int mAutoOffTime;
	private int mBarcodeTimeout;
	private int mBaudRate;
	private ArrayList<String> mBaudRateList;
	private int mSleepTime;
	private int mQValue;
	private int mMaxQ;
	private int mMinQ;
	private int mLinkProfile;
	private int mDefaultLinkProfile;
	private int mBatteryInterval;
	private int mPowerGain;
	private int mOperationTime;
	private AsReaderP252BPowerRange mAsReaderP252BPowerRange;
	private boolean mReportRSSI;
	private boolean mContinuousMode;
	private String mAsReaderP252BGlobalBandType;
	private int mLogLevel;
	private int showFrequency;
	private AsReaderP252BLbtItem[] mFreqTable;
	private boolean mIsSaved;
	private boolean mIsDefault;
	private LinearLayout layoutLBT;
	private LinearLayout layoutFreAuto;
	private boolean mFrequencyAutomatic;
	private FreqSlotItem[] mFreqSlots;

	private Handler mEvent;
	
	private String[] mLogLevelText = new String[]{"ERROR", "INFO", "DEBUG", "API", "LIB1", "LIB2", "WATCH", "UTIL", "IO", "DUMP"};

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_option);
		ActionBar actionBar = getActionBar();
		if(actionBar != null) {
			actionBar.setDisplayOptions(ActionBar.DISPLAY_SHOW_CUSTOM);
			actionBar.setCustomView(R.layout.activity_title);
			actionBar.setDisplayHomeAsUpEnabled(true);
			actionBar.setDisplayShowHomeEnabled(true);
		}

		TextView titleText = (TextView)findViewById(R.id.title_text);
		titleText.setText(R.string.option_name);
		final int version = Build.VERSION.SDK_INT;
		if(version >= Build.VERSION_CODES.M)
			titleText.setTextColor(getColor(getApplicationContext(), R.color.black));

		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. onCreate()");

		mIsSaved = false;
		mIsDefault = false;
		mFrequencyAutomatic = true;
		mBaudRateList = new ArrayList<>();;
		// Create Reader
		createReader();

		Intent intent = getIntent();
		mBatteryInterval = intent.getIntExtra(KEY_BATTERY_INTERVAL, DEFAULT_BATTERY_INTERVAL);
		int code = intent.getIntExtra(KEY_MASK_TYPE, DEFAULT_MASK_TYPE);

		// Initialize Widget
		initWidgets();

		// Initialize Reader
		initReader();

		// Enable action widget
		enableActionWidgets(false);

		mEvent = new Handler();
	}

	@Override
	protected void onDestroy() {

		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. onDestroy()");

		// Destroy Reader
		destroyReader();

//		Intent intent = new Intent();
//		intent.putExtra(KEY_BATTERY_INTERVAL, mBatteryInterval);
//		intent.putExtra(KEY_MASK_TYPE, mMaskType.getCode());
//		intent.putExtra(KEY_REPORT_RSSI, mReportRSSI);
//		intent.putExtra(KEY_ACTION, getKeyAction());
//		setResult(Activity.RESULT_OK, intent);

		super.onDestroy();
	}

	@Override
	protected void onStart() {
		super.onStart();

		// Load Option
		WaitDialog.show(this, R.string.load_option);
		new Thread(mLoadOption).start();

		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. onStart()");
	}

	@Override
	protected void onStop() {

		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. onStart()");
		super.onStop();
	}

	@Override
	protected void onResume() {
		super.onResume();
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. onResume()");
	}

	@Override
	protected void onPause() {
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. onPause()");
		super.onPause();
	}

	@Override
	public boolean onOptionsItemSelected(MenuItem item) {

		switch (item.getItemId()) {
			case android.R.id.home:
				if(mIsSaved) {
					Intent intent = new Intent();
					intent.putExtra(KEY_BATTERY_INTERVAL, mBatteryInterval);
					this.setResult(Activity.RESULT_OK, intent);
				} else {
					this.setResult(Activity.RESULT_CANCELED);
				}
				this.finish();

				return true;
		}
		return super.onOptionsItemSelected(item);
	}

	@Override
	public void onBackPressed() {

		if(mIsSaved) {
			Intent intent = new Intent();
			intent.putExtra(KEY_BATTERY_INTERVAL, mBatteryInterval);
			this.setResult(Activity.RESULT_OK, intent);
		} else {
			this.setResult(Activity.RESULT_CANCELED);
		}

		super.onBackPressed();
	}

	@Override
	public void onClick(View v) {

		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. onClick(%s)", ResUtil.getId(v.getId()));
		mIsDefault = (v.getId() == R.id.option_default);

		switch (v.getId()) {
			case R.id.buzzer:
				showBuzzerDialog();
				break;
			case R.id.idle_time:
				showIdleTimeDialog();
				break;
			case R.id.auto_off_time:
				showAutoOffTimeDialog();
				break;
			case R.id.sleep_time:
				showSleepTimeDialog();
				break;
			case R.id.q_value:
				showQValueDialog();
				break;
			case R.id.max_q:
				showMaxQDialog();
				break;
			case R.id.min_q:
				showMinQDialog();
				break;
			case R.id.link_profile:
				showLinkProfileDialog();
				break;
			case R.id.default_link_profile:
				showDefaultLinkProfileDialog();
				break;
			case R.id.battery_interval:
				showBatteryIntervalDialog();
				break;
			case R.id.frequency_automatic:
				showFrequencyAutomaticDialog();
				break;
			case R.id.btn_lbt_channel:
				WaitDialog.show(this, R.string.load_frequency);
				new Thread(mLoadFrequencyTable).start();
				break;
			case R.id.barcode_timeout:
				showBarcodeTimeoutDialog();
				break;
			case R.id.baud_rate:
				showBaudRateDialog();
				break;
			case R.id.save:
				// Enable action widget
				enableActionWidgets(false);
				// Save Option
				WaitDialog.show(this, R.string.save_option);
				new Thread(mSaveOption).start();
				break;
			case R.id.option_default:
				mDefaultOption();
				break;
		}
	}

	private void mDefaultOption() {
		AsReaderP252BResultCode res;
		enableActionWidgets(false);
		WaitDialog.show(this, R.string.load_default_option);
		if ((res = getReader().defaultParameter()) != AsReaderP252BResultCode.NoError) {
			mIsDefault = false;
			WaitDialog.hide();
			AlertDialog.Builder builder = new AlertDialog.Builder(OptionActivity.this);
			builder.setTitle("Fail");
			builder.setMessage("Saved Fail")
					.setCancelable(false)
					.setPositiveButton("OK", null);

			AlertDialog dlg = builder.create();
			dlg.show();
			enableActionWidgets(true);
		} else {
			mIsDefault = true;
			mIsSaved = true;
			new Thread(mLoadDefaultOption).start();
		}
	};
	@Override
	public void onReadBarcode(AsReaderP252B reader, AsReaderP252BBarcodeType type, String barcode) {
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "EVENT. onReadBarcode (%s, [%s])", type, barcode);
	}

	@Override
	public void onReadBarcode(AsReaderP252B reader, AsReaderP252BBarcodeType type, byte[] barcodeData) {
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "EVENT. onReadBarcode (%s, [%s])", type, barcodeData);
	}

	@Override
	public void onReadTemperatureTag(AsReaderP252B reader, AsReaderP252BActionState action, String tag, float rssi, float phase, float frequency, float temperature) {

	}

	@Override
	public void onReadHumidityTag(AsReaderP252B reader, AsReaderP252BActionState action, String tag, float rssi, float phase, float frequency, float humidity) {

	}

	@Override
	public void onReceivedData(byte[] data) {

	}

	@Override
	public boolean onModeKeyEvent(AsReaderP252B reader, AsReaderP252BKeyState state) {
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "EVENT. onModeKeyEvent [%s]", state);
		return false;
	}

	@Override
	public boolean onKeyEvent(AsReaderP252B reader, AsReaderP252BKeyState state) {
		return false;
	}

	@Override
	protected void clearWidgets() {
	}

	// Asynchronous Load Option
	private Runnable mLoadOption = new Runnable() {

		@Override
		public void run() {
			AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "+++ INFO. $mLoadOption.run()");

			mBatteryInterval = MainActivity.mUserConfigs.getBatteryInterval();

			try {
				Thread.sleep(1000);
				mBuzzer = getReader().getBuzzer();
			} catch (AsReaderP252BException | InterruptedException e) {
				AsReaderP252BLog.e(TAG, e, "ERROR. $mLoadOption.run() - Failed to get buzzer");
				mBuzzer = AsReaderP252BBuzzerState.Off;
			}
//			try {
//				Thread.sleep(100);
//				mInventoryTime = getReader().getInventoryTime();
//			} catch (AsReaderException | InterruptedException e) {
//				ASRLog.e(TAG, e, "ERROR. $mLoadOption.run() - Failed to get inventory time");
//				mInventoryTime = 150;
//			}
			try {
				Thread.sleep(100);
				mIdleTime = getReader().getIdleTime();
			} catch (AsReaderP252BException | InterruptedException e) {
				AsReaderP252BLog.e(TAG, e, "ERROR. $mLoadOption.run() - Failed to get idle time");
				mIdleTime = 0;
			}
			try {
				Thread.sleep(100);
				mAutoOffTime = getReader().getAutoOffTime();
			} catch (AsReaderP252BException | InterruptedException e) {
				AsReaderP252BLog.e(TAG, e, "ERROR. $mLoadOption.run() - Failed to get auto off time");
				mAutoOffTime = 30;
			}
			
			try {
				Thread.sleep(100);
				mSleepTime = getReader().getSleepTime();
			} catch (AsReaderP252BException | InterruptedException e2) {
				AsReaderP252BLog.e(TAG, e2, "ERROR. $mLoadOption.run() - Failed to get sleep time");
				mSleepTime = 30;
			}

			try {
				Thread.sleep(100);
				mQValue = getReader().getQValue();
			} catch (AsReaderP252BException | InterruptedException e2) {
				AsReaderP252BLog.e(TAG, e2, "ERROR. $mLoadOption.run() - Failed to get Q value");
				mQValue = 4;
			}
			
			try {
				Thread.sleep(100);
				mMaxQ = getReader().getMaxQ();
			} catch (AsReaderP252BException | InterruptedException e2) {
				AsReaderP252BLog.e(TAG, e2, "ERROR. $mLoadOption.run() - Failed to get MAx Q value");
				mMaxQ = 15;
			}
			
			try {
				Thread.sleep(100);
				mMinQ = getReader().getMinQ();
			} catch (AsReaderP252BException | InterruptedException e2) {
				AsReaderP252BLog.e(TAG, e2, "ERROR. $mLoadOption.run() - Failed to get Min Q value");
				mMinQ = 0;
			}
			
			try {
				Thread.sleep(100);
				mLinkProfile = getReader().getLinkProfile();
			} catch (AsReaderP252BException | InterruptedException e2) {
				AsReaderP252BLog.e(TAG, e2, "ERROR. $mLoadOption.run() - Failed to get link profile");
				mLinkProfile = 1;
			}
			mDefaultLinkProfile = MainActivity.mUserConfigs.getDefaultLinkProfileValue();

			try {
				Thread.sleep(100);
				mAsReaderP252BGlobalBandType = getReader().getRegion();

			} catch (AsReaderP252BException | InterruptedException e2) {
				AsReaderP252BLog.e(TAG, e2, "ERROR. $mLoadOption.run() - Failed to get global band type");
				mAsReaderP252BGlobalBandType = "Unknown";
			}

			// Get Barcode Timeout
			try {
				Thread.sleep(100);
				mBarcodeTimeout = getReader().getBarcodeTimeOut();
			} catch (AsReaderP252BException | InterruptedException e2) {
				AsReaderP252BLog.e(TAG, e2, "ERROR. $mLoadOption.run() - Failed to get barcode timeout");
				mBarcodeTimeout = 4;
			}

			// Get Baud Rate List
			try {
				Thread.sleep(100);
				mBaudRateList = getReader().getBaudRateList();
			} catch (AsReaderP252BException | InterruptedException e2) {
				AsReaderP252BLog.e(TAG, e2, "ERROR. $mLoadOption.run() - Failed to get baud rate list");
				mBaudRateList.add("9600bps");
				mBaudRateList.add("19200bps");
				mBaudRateList.add("115200bps");
				mBaudRateList.add("230400bps");
				mBaudRateList.add("460800bps");
			}

			// Get Baud Rate
			try {
				Thread.sleep(100);
				mBaudRate = getReader().getBaudRate();
			} catch (AsReaderP252BException | InterruptedException e2) {
				AsReaderP252BLog.e(TAG, e2, "ERROR. $mLoadOption.run() - Failed to get baud rate");
				mBaudRate = 0;
			}

			// Get Frequency Automatic
			try {
				Thread.sleep(100);
				mFrequencyAutomatic = getReader().getFrequencyAutomatic();
			} catch (AsReaderP252BException | InterruptedException e) {
				AsReaderP252BLog.e(TAG, e, "ERROR. initReader() - Failed to get frequency automatic");
				mFrequencyAutomatic = true;
			}
//			MainActivity.mUserConfigs.setIsFrequencyAutomatic(mFrequencyAutomatic);
//			MainActivity.mUserConfigs.Save();
			mLogLevel = AsReaderP252BLog.getLogLevel();

			mEvent.post(new Runnable() {

				@Override
				public void run() {

					displayBuzzer();
					displayIdleTime();
					displayAutoOffTime();
					displaySleepTime();
					displayBarcodeTimeout();
					displayBaudRate();
					displayQValue();
					displayMaxQ();
					displayMinQ();
					displayLinkProfile();
					displayDefaultLinkProfile();
					displayFrequencyTable();
					displayBatteryInterval();
					WaitDialog.hide();
					if(mIsDefault) {
						AlertDialog.Builder builder = new AlertDialog.Builder(OptionActivity.this);
						builder.setTitle("Success");
						builder.setMessage("Set to default successfully")
								.setCancelable(false)
								.setPositiveButton("OK", null);

						AlertDialog dlg = builder.create();
						dlg.show();
					}
					enableActionWidgets(true);
					if (isJapaneseType()) {
						layoutFreAuto.setVisibility(View.VISIBLE);
						try {
							boolean sta = getReader().getFrequencyAutomatic();
							if (sta) {
								txtFrequencyAutomatic.setText("On");
								layoutLBT.setVisibility(View.GONE);
							} else {
								txtFrequencyAutomatic.setText("Off");
								layoutLBT.setVisibility(View.VISIBLE);
							}
						} catch (AsReaderP252BException e) {
						}
					} else {
						layoutFreAuto.setVisibility(View.GONE);
						layoutLBT.setVisibility(View.GONE);
					}
				}

			});
			mEvent.sendEmptyMessage(EVENT_LOAD_OPTION);
			AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "--- INFO. $mLoadOption.run()");
		}

	};

	// Asynchronous Load Default Option
	private Runnable mLoadDefaultOption = new Runnable() {

		@Override
		public void run() {
			AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "+++ INFO. $mLoadDefaultOption.run()");
//			try {
//				Thread.sleep(1000);
//			} catch (InterruptedException e) {
//			}

			try {
				Thread.sleep(1000);
				mBuzzer = getReader().getBuzzer();
				MainActivity.mUserConfigs.setBuzzerState(mBuzzer);
				MainActivity.mUserConfigs.Save();
			} catch (AsReaderP252BException | InterruptedException e) {
				AsReaderP252BLog.e(TAG, e, "ERROR. $mLoadDefaultOption.run() - Failed to get buzzer");
				mBuzzer = AsReaderP252BBuzzerState.Off;
			}
//			try {
//				Thread.sleep(100);
//				mInventoryTime = getReader().getInventoryTime();
//				MainActivity.mUserConfigs.setInventoryTime(mInventoryTime);
//				MainActivity.mUserConfigs.Save();
//			} catch (AsReaderException | InterruptedException e) {
//				ASRLog.e(TAG, e, "ERROR. $mLoadDefaultOption.run() - Failed to get inventory time");
//				mInventoryTime = 150;
//			}
			try {
				Thread.sleep(100);
				mIdleTime = getReader().getIdleTime();
				MainActivity.mUserConfigs.setIdleTime(mIdleTime);
				MainActivity.mUserConfigs.Save();
			} catch (AsReaderP252BException | InterruptedException e) {
				AsReaderP252BLog.e(TAG, e, "ERROR. $mLoadDefaultOption.run() - Failed to get idle time");
				mIdleTime = 0;
			}
			try {
				Thread.sleep(100);
				mAutoOffTime = getReader().getAutoOffTime();
				MainActivity.mUserConfigs.setAutoOffTime(mAutoOffTime);
				MainActivity.mUserConfigs.Save();
			} catch (AsReaderP252BException | InterruptedException e) {
				AsReaderP252BLog.e(TAG, e, "ERROR. $mLoadDefaultOption.run() - Failed to get auto off time");
				mAutoOffTime = 30;
			}

			try {
				Thread.sleep(100);
				mSleepTime = getReader().getSleepTime();
				MainActivity.mUserConfigs.setSleepTime(mSleepTime);
				MainActivity.mUserConfigs.Save();
			} catch (AsReaderP252BException | InterruptedException e2) {
				AsReaderP252BLog.e(TAG, e2, "ERROR. $mLoadDefaultOption.run() - Failed to get sleep time");
				mSleepTime = 30;
			}

			try {
				Thread.sleep(100);
				mQValue = getReader().getQValue();
				MainActivity.mUserConfigs.setQValue(mQValue);
				MainActivity.mUserConfigs.Save();
			} catch (AsReaderP252BException | InterruptedException e2) {
				AsReaderP252BLog.e(TAG, e2, "ERROR. $mLoadDefaultOption.run() - Failed to get Q value");
				mQValue = 4;
			}

			try {
				Thread.sleep(100);
				mMaxQ = getReader().getMaxQ();
			} catch (AsReaderP252BException | InterruptedException e2) {
				AsReaderP252BLog.e(TAG, e2, "ERROR. $mLoadDefaultOption.run() - Failed to get MAx Q value");
				mMaxQ = 15;
			}

			try {
				Thread.sleep(100);
				mMinQ = getReader().getMinQ();
			} catch (AsReaderP252BException | InterruptedException e2) {
				AsReaderP252BLog.e(TAG, e2, "ERROR. $mLoadDefaultOption.run() - Failed to get Min Q value");
				mMinQ = 0;
			}

			try {
				Thread.sleep(100);
				mLinkProfile = getReader().getLinkProfile();
//				MainActivity.mUserConfigs.setLinkProfileValue(mLinkProfile);
//				MainActivity.mUserConfigs.Save();
			} catch (AsReaderP252BException | InterruptedException e2) {
				AsReaderP252BLog.e(TAG, e2, "ERROR. $mLoadDefaultOption.run() - Failed to get link profile");
				mLinkProfile = 1;
			}
			mDefaultLinkProfile = 1;
			MainActivity.mUserConfigs.setDefaultLinkProfileValue(mDefaultLinkProfile);
			MainActivity.mUserConfigs.Save();


			try {
				Thread.sleep(100);
				mAsReaderP252BGlobalBandType = getReader().getRegion();
			} catch (AsReaderP252BException | InterruptedException e2) {
				AsReaderP252BLog.e(TAG, e2, "ERROR. $mLoadDefaultOption.run() - Failed to get global band type");
				mAsReaderP252BGlobalBandType = "Unknown";
			}

			// Get Barcode Timeout
			try {
				Thread.sleep(100);
				mBarcodeTimeout = getReader().getBarcodeTimeOut();
				MainActivity.mUserConfigs.setBarcodeTimeout(mBarcodeTimeout);
				MainActivity.mUserConfigs.Save();
			} catch (AsReaderP252BException | InterruptedException e2) {
				AsReaderP252BLog.e(TAG, e2, "ERROR. $mLoadDefaultOption.run() - Failed to get barcode timeout");
				mBarcodeTimeout = 4;
			}

			// Get Baud Rate
			try {
				Thread.sleep(100);
				mBaudRate = getReader().getBaudRate();
				MainActivity.mUserConfigs.setBaudRate(mBaudRate);
				MainActivity.mUserConfigs.Save();
			} catch (AsReaderP252BException | InterruptedException e2) {
				AsReaderP252BLog.e(TAG, e2, "ERROR. $mLoadDefaultOption.run() - Failed to get baud rate");
				mBaudRate = 0;
			}

			// Get Frequency Automatic
			try {
				Thread.sleep(100);
				mFrequencyAutomatic = getReader().getFrequencyAutomatic();
//				MainActivity.mUserConfigs.setIsFrequencyAutomatic(mFrequencyAutomatic);
//				MainActivity.mUserConfigs.Save();
			} catch (AsReaderP252BException | InterruptedException e) {
				AsReaderP252BLog.e(TAG, e, "ERROR. initReader() - Failed to get frequency automatic");
				mFrequencyAutomatic = true;
			}

			MainActivity.mUserConfigs.setBatteryInterval(10);
			mBatteryInterval = MainActivity.mUserConfigs.getBatteryInterval();

			// Get Power Gain
			try {
				Thread.sleep(100);
				MainActivity.mUserConfigs.setPowerGain(getReader().getPowerGain());
				MainActivity.mUserConfigs.Save();
			} catch (AsReaderP252BException | InterruptedException e2) {
				AsReaderP252BLog.e(TAG, e2, "ERROR. $mLoadDefaultOption.run() - Failed to get power gain");
			}

			// Get Report RSSI
			try {
				Thread.sleep(100);
				MainActivity.mUserConfigs.setReportRssi(getReader().getReportRSSI());
				MainActivity.mUserConfigs.Save();
			} catch (AsReaderP252BException | InterruptedException e2) {
				AsReaderP252BLog.e(TAG, e2, "ERROR. $mLoadDefaultOption.run() - Failed to get report RSSI");
			}

			// Get Operation Time
			try {
				Thread.sleep(100);
				MainActivity.mUserConfigs.setOperationTime(getReader().getOperationTime());
				MainActivity.mUserConfigs.Save();
			} catch (AsReaderP252BException | InterruptedException e2) {
				AsReaderP252BLog.e(TAG, e2, "ERROR. $mLoadDefaultOption.run() - Failed to get operation time");
			}

			// Get Query Session
			try {
				Thread.sleep(100);
				MainActivity.mUserConfigs.setSession(getReader().getQuerySession());
				MainActivity.mUserConfigs.Save();
			} catch (AsReaderP252BException | InterruptedException e2) {
				AsReaderP252BLog.e(TAG, e2, "ERROR. $mLoadDefaultOption.run() - Failed to get query session");
			}

			// Get Query Target
			try {
				Thread.sleep(100);
				MainActivity.mUserConfigs.setTarget(getReader().getSessionFlag());
				MainActivity.mUserConfigs.Save();
			} catch (AsReaderP252BException | InterruptedException e2) {
				AsReaderP252BLog.e(TAG, e2, "ERROR. $mLoadDefaultOption.run() - Failed to get query target");
			}
			mLogLevel = AsReaderP252BLog.getLogLevel();

			mEvent.post(new Runnable() {

				@Override
				public void run() {

					displayBuzzer();
					displayIdleTime();
					displayAutoOffTime();
					displaySleepTime();
					displayBarcodeTimeout();
					displayBaudRate();
					displayQValue();
					displayMaxQ();
					displayMinQ();
					displayLinkProfile();
					displayDefaultLinkProfile();
					displayFrequencyTable();
					displayBatteryInterval();
					WaitDialog.hide();
					if(mIsDefault) {
						AlertDialog.Builder builder = new AlertDialog.Builder(OptionActivity.this);
						builder.setTitle("Success");
						builder.setMessage("Set to default successfully")
								.setCancelable(false)
								.setPositiveButton("OK", null);

						AlertDialog dlg = builder.create();
						dlg.show();
					}
					enableActionWidgets(true);
				}

			});
			mEvent.sendEmptyMessage(EVENT_LOAD_OPTION);
			AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "--- INFO. $mLoadOption.run()");
		}

	};
	// Asynchronously Load Frequency table
	private Runnable mLoadFrequencyTable = new Runnable() {

		@Override
		public void run() {
			AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "+++ INFO. $mLoadFrequencyTable.run()");

			Log.d(TAG, "mLoadFrequencyTable > start ");

				try {
					AsReaderP252BLbtItem[] slots = getReader().getDefaultLbtMask();
					mFreqSlots = new FreqSlotItem[slots.length];
					for (int i = 0; i < slots.length; i++){
						mFreqSlots[i] = new FreqSlotItem(slots[i].getSlot(), slots[i].getFrequency());
					}

					mFreqTable = getReader().getLbt();
					int i = -1;
					ArrayList<String> mList = new ArrayList<>();
					for (AsReaderP252BLbtItem item : mFreqTable) {
						i ++;
						if (item.isUsed() == true)
						{
							String isUsedString = String.valueOf(i);
							mList.add(isUsedString);
						}
					}
					if (!mList.isEmpty())
					{
						String[] result = new String[mList.size()];
						result = mList.toArray(result);
						String str = "";
						for(int j = 0; j < result.length; j++)
						{
							if (str.equals(""))
							{
								str = result[j];
							} else {
								str = str + "," +  result[j];
							}
						}
//						MainActivity.mUserConfigs.setFrequency(str);
//						MainActivity.mUserConfigs.Save();
					}
				} catch (AsReaderP252BException e) {
					AsReaderP252BLog.e(TAG, e, "ERROR. $mLoadFrequencyTable.run() - Failed to get LBT table");
				}

			mEvent.post(new Runnable() {

				@Override
				public void run() {
					WaitDialog.hide();
					showFrequencyDialog();
				}

			});
			mEvent.sendEmptyMessage(EVENT_LOAD_OPTION);
			AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "--- INFO. $mLoadOption.run()");
		}

	};

	// Asynchronous Save Option
	private Runnable mSaveOption = new Runnable() {

		@Override
		public void run() {
			AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "+++ INFO. $mSaveOption.run()");

			// Set Battery
			MainActivity.mUserConfigs.setBatteryInterval(mBatteryInterval);
			MainActivity.mUserConfigs.Save();

			// Set Buzzer
			try {
				getReader().setBuzzer(mBuzzer);
				MainActivity.mUserConfigs.setBuzzerState(mBuzzer);
				MainActivity.mUserConfigs.Save();
			} catch (AsReaderP252BException e) {
				AsReaderP252BLog.e(TAG, e, "ERROR. $mSaveOption.run() - Failed to set buzzer (%s)", mBuzzer);
			}

			// Set Idle Time
			try {
				getReader().setIdleTime(mIdleTime);
				MainActivity.mUserConfigs.setIdleTime(mIdleTime);
				MainActivity.mUserConfigs.Save();
			} catch (AsReaderP252BException e) {
				AsReaderP252BLog.e(TAG, e, "ERROR. $mSaveOption.run() - Failed to set idle time (%d)", mIdleTime);
			}
			// Set Inventory Time
//			try {
//				getReader().setInventoryTime(mInventoryTime);
//				MainActivity.mUserConfigs.setInventoryTime(mInventoryTime);
//				MainActivity.mUserConfigs.Save();
//			} catch (AsReaderException e) {
//				ASRLog.e(TAG, e, "ERROR. $mSaveOption.run() - Failed to set inventory time (%d)", mInventoryTime);
//			}

			// Set Auto Off Time
			try {
				getReader().setAutoOffTime(mAutoOffTime);
				MainActivity.mUserConfigs.setAutoOffTime(mAutoOffTime);
				MainActivity.mUserConfigs.Save();
			} catch (AsReaderP252BException e) {
				AsReaderP252BLog.e(TAG, e, "ERROR. $mSaveOption.run() - Failed to set auto off time (%d)", mAutoOffTime);
			}
			// Set Sleep Time
			try {
				getReader().setSleepTime(mSleepTime);
				MainActivity.mUserConfigs.setSleepTime(mSleepTime);
				MainActivity.mUserConfigs.Save();
			} catch (AsReaderP252BException e) {
				AsReaderP252BLog.e(TAG, e, "ERROR. $mSaveOption.run() - Failed to set sleep time (%d)", mSleepTime);
			}
			// Set Q Value
			try {
				getReader().setQValue(mQValue);
				MainActivity.mUserConfigs.setQValue(mQValue);
				MainActivity.mUserConfigs.Save();
			} catch (AsReaderP252BException e) {
				AsReaderP252BLog.e(TAG, e, "ERROR. $mSaveOption.run() - Failed to set Q value (%d)", mQValue);
			}
//			// Set Max Q Value
//			try {
//				getReader().setMaxQ(mMaxQ);
//			} catch (AsReaderException e) {
//				ASRLog.e(TAG, e, "ERROR. $mSaveOption.run() - Failed to set Max Q value (%d)", mMaxQ);
//			}
//			// Set Min Q Value
//			try {
//				getReader().setMinQ(mMinQ);
//			} catch (AsReaderException e) {
//				ASRLog.e(TAG, e, "ERROR. $mSaveOption.run() - Failed to set Min Q value (%d)", mMinQ);
//			}
			// Set Link Profile
			try {
				getReader().setLinkProfile(mLinkProfile);
//				MainActivity.mUserConfigs.setLinkProfileValue(mLinkProfile);
//				MainActivity.mUserConfigs.Save();
			} catch (AsReaderP252BException e) {
				AsReaderP252BLog.e(TAG, e, "ERROR. $mSaveOption.run() - Failed to set Link profile (%d)", mLinkProfile);
			}

			MainActivity.mUserConfigs.setDefaultLinkProfileValue(mDefaultLinkProfile);
			MainActivity.mUserConfigs.Save();

			// Set Barcode Timeout
			try {
				getReader().setBarcodeTimeOut(mBarcodeTimeout);
				MainActivity.mUserConfigs.setBarcodeTimeout(mBarcodeTimeout);
				MainActivity.mUserConfigs.Save();
			} catch (AsReaderP252BException e) {
				AsReaderP252BLog.e(TAG, e, "ERROR. $mSaveOption.run() - Failed to set barcode timeout (%d)", mBarcodeTimeout);
			}

			// Set Baud Rate
			try {
				getReader().setBaudRate(mBaudRate);
				MainActivity.mUserConfigs.setBaudRate(mBaudRate);
				MainActivity.mUserConfigs.Save();
			} catch (AsReaderP252BException e) {
				AsReaderP252BLog.e(TAG, e, "ERROR. $mSaveOption.run() - Failed to set baud rate (%d)", mBaudRate);
			}
			AsReaderP252BLog.setLogLevel(mLogLevel);

			mEvent.post(new Runnable() {

				@Override
				public void run() {
					WaitDialog.hide();
//					Intent intent = new Intent();
//					intent.putExtra(KEY_BATTERY_INTERVAL, mBatteryInterval);
//					intent.putExtra(KEY_MASK_TYPE, mMaskType.getCode());
//					intent.putExtra(KEY_REPORT_RSSI, mReportRSSI);
//					intent.putExtra(KEY_ACTION, getKeyAction());
//					setResult(Activity.RESULT_OK, intent);
					//finish();
					mIsSaved = true;

					AlertDialog.Builder builder = new AlertDialog.Builder(OptionActivity.this);
					builder.setTitle("Success");
					builder.setMessage("Saved successfully")
							.setCancelable(false)
							.setPositiveButton("OK", null);

					AlertDialog dlg = builder.create();
					dlg.show();
					enableActionWidgets(true);
				}

			});
			AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "+++ INFO. $mSaveOption.run()");
		}

	};

	// Initialize Reader
	@Override
	protected void initReader() {
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. initReader()");
	}

	// Initialize Widgets
	protected void initWidgets() {
		txtBuzzer = (TextView) findViewById(R.id.buzzer);
		txtBuzzer.setOnClickListener(this);
		txtIdleTime = (TextView) findViewById(R.id.idle_time);
		txtIdleTime.setOnClickListener(this);
		txtAutoOffTime = (TextView) findViewById(R.id.auto_off_time);
		txtAutoOffTime.setOnClickListener(this);
		txtSleepTime = (TextView) findViewById(R.id.sleep_time);
		txtSleepTime.setOnClickListener(this);
		txtBarcodeTimeout = (TextView) findViewById(R.id.barcode_timeout);
		txtBarcodeTimeout.setOnClickListener(this);
		txtBaudRate = (TextView) findViewById(R.id.baud_rate);
		txtBaudRate.setOnClickListener(this);
		txtQValue = (TextView) findViewById(R.id.q_value);
		txtQValue.setOnClickListener(this);
		txtMaxQ = (TextView) findViewById(R.id.max_q);
		txtMaxQ.setClickable(false);
//		txtMaxQ.setOnClickListener(this);
		txtMinQ = (TextView) findViewById(R.id.min_q);
		txtMinQ.setClickable(false);
//		txtMinQ.setOnClickListener(this);
		txtLinkProfile = (TextView) findViewById(R.id.link_profile);
		txtLinkProfile.setOnClickListener(this);
		txtDefaultLinkProfile = (TextView) findViewById(R.id.default_link_profile);
		txtDefaultLinkProfile.setOnClickListener(this);
		txtFrequencyAutomatic = (TextView) findViewById(R.id.frequency_automatic);
		txtFrequencyAutomatic.setOnClickListener(this);
		txtBatteryInterval = (TextView) findViewById(R.id.battery_interval);
		txtBatteryInterval.setOnClickListener(this);

		btnSave = (Button) findViewById(R.id.save);
		btnSave.setOnClickListener(this);
		btnDefault = (Button) findViewById(R.id.option_default);
		btnDefault.setOnClickListener(this);
		btnLbtChannel = (Button) findViewById(R.id.btn_lbt_channel);
		btnLbtChannel.setOnClickListener(this);
		layoutLBT = (LinearLayout) findViewById(R.id.lay_lbt);
		layoutFreAuto = (LinearLayout) findViewById(R.id.lay_freauto);

		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. initWidgets()");
	}

	// Enable/Disable Action Widgets
	protected void enableActionWidgets(boolean enabled) {
		super.enableActionWidgets(enabled);
		mIsEnabled = enabled;
		btnSave.setEnabled(enabled);
		btnDefault.setEnabled(enabled);

		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. enableActionWidgets(%s)", enabled);
	}
	
	private void displayBuzzer() {
		txtBuzzer.setText(mBuzzer.toString());
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. displayBuzzer() - [%s]", mBuzzer);
	}

	private void displayIdleTime() {
		txtIdleTime.setText(String.format(Locale.US, "%d", mIdleTime));
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. displayIdleTime() - [%d]", mIdleTime);
	}

	private void displayAutoOffTime() {
		txtAutoOffTime.setText(String.format(Locale.US, "%d", mAutoOffTime));
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. displayAutoOffTime() - [%d]", mAutoOffTime);
	}

	private void displayBarcodeTimeout() {
		txtBarcodeTimeout.setText(String.format(Locale.US, "%d", mBarcodeTimeout));
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. displayBarcodeTimeout() - [%d]", mBarcodeTimeout);
	}

	private void displayBaudRate() {
		txtBaudRate.setText(changeBaudRate(mBaudRate));
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. displayBaudRate() - [%s]", changeBaudRate(mBaudRate));
	}

	private void displaySleepTime() {
		txtSleepTime.setText(String.format(Locale.US, "%d", mSleepTime));
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. displaySleepTime() - [%d]", mSleepTime);
	}
	
	private void displayQValue() {
		txtQValue.setText(String.format(Locale.US, "%d", mQValue));
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. displayQValue() - [%s]", mQValue);
	}
	
	private void displayMaxQ() {
		txtMaxQ.setText(String.format(Locale.US, "%d", mMaxQ));
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. displayMaxQ() - [%s]", mMaxQ);
	}
	
	private void displayMinQ() {
		txtMinQ.setText(String.format(Locale.US, "%d", mMinQ));
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. displayMinQ() - [%s]", mMinQ);
	}
	
	private void displayLinkProfile() {
		txtLinkProfile.setText(String.format(Locale.US, "%d", mLinkProfile));
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. displayLinkProfile() - [%s]", mLinkProfile);
	}
	
	private void displayDefaultLinkProfile() {
		txtDefaultLinkProfile.setText(String.format(Locale.US, "%d", mDefaultLinkProfile));
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. displayDefaultLinkProfile() - [%s]", mDefaultLinkProfile);
	}

	private void displayFrequencyTable() {
		txtFrequencyAutomatic.setText(mFrequencyAutomatic ? "On" : "Off");
		if (!mFrequencyAutomatic)
			layoutLBT.setVisibility(View.VISIBLE);
		else
			layoutLBT.setVisibility(View.GONE);
	}

	private boolean isJapaneseType() {
		return mAsReaderP252BGlobalBandType.contains("Japan");
	}

	private void displayBatteryInterval() {
		txtBatteryInterval.setText(String.format(Locale.US, "%d", mBatteryInterval));
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. displayBatteryInterval() - [%d]", mBatteryInterval);
	}

	private String changeBaudRate(int index) {
		return mBaudRateList.get(index);
	}
	private void showBuzzerDialog() {
		if (!mIsEnabled)
			return;

		LinearLayout root = (LinearLayout) LinearLayout.inflate(this, R.layout.dialog_list_view, null);
		final ListView value = (ListView) root.findViewById(R.id.list);
		final SpinnerAdapter adapter = new SpinnerAdapter(this, android.R.layout.simple_list_item_single_choice);
		for (AsReaderP252BBuzzerState item : AsReaderP252BBuzzerState.values()) {
			adapter.addItem(item.getCode(), item.toString());
		}
		value.setAdapter(adapter);
		value.setChoiceMode(ListView.CHOICE_MODE_SINGLE);

		AlertDialog.Builder builder = new AlertDialog.Builder(this);
		builder.setTitle(R.string.buzzer);
		builder.setView(root);
		builder.setPositiveButton(R.string.action_ok, new DialogInterface.OnClickListener() {

			@Override
			public void onClick(DialogInterface dialog, int which) {
				int position = value.getCheckedItemPosition();
				mBuzzer = AsReaderP252BBuzzerState.valueOf(adapter.getValue(position));
				displayBuzzer();
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showBuzzerDialog().$PositiveButton.onClick()");
			}
		});
		builder.setNegativeButton(R.string.action_cancel, new DialogInterface.OnClickListener() {

			@Override
			public void onClick(DialogInterface dialog, int which) {
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showBuzzerDialog().$NegativeButton.onClick()");
			}
		});
		builder.setCancelable(true);
		builder.setOnCancelListener(new DialogInterface.OnCancelListener() {

			@Override
			public void onCancel(DialogInterface dialog) {
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showBuzzerDialog().onCancel()");
			}
		});
		AlertDialog dialog = builder.create();
		dialog.setOnShowListener(new DialogInterface.OnShowListener() {

			@Override
			public void onShow(DialogInterface dialog) {
				int position = adapter.getPosition(mBuzzer.getCode());
				value.setItemChecked(position, true);
				value.setSelectionFromTop(position, 0);
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showBuzzerDialog().onShow()");
			}
		});
		dialog.show();
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showBuzzerDialog()");
	}

	private void showIdleTimeDialog() {
		if (!mIsEnabled)
			return;

		LinearLayout root = (LinearLayout) LinearLayout.inflate(this, R.layout.dialog_input_unit, null);
		final EditText value = (EditText) root.findViewById(R.id.value);
		final TextView unit = (TextView) root.findViewById(R.id.unit);
		unit.setText(R.string.unit_ten_ms);
		InputFilter[] filters = new InputFilter[] { new InputFilterMinMax(0, 65535) };

		value.setFilters(filters);

		AlertDialog.Builder builder = new AlertDialog.Builder(this);
		builder.setTitle(R.string.idle_time);
		builder.setView(root);
		builder.setPositiveButton(R.string.action_ok, new DialogInterface.OnClickListener() {

			@Override
			public void onClick(DialogInterface dialog, int which) {
				//int idleTime = 0;
				int txOffTime = 0;
				try {
					txOffTime = Integer.parseInt(value.getText().toString());
				} catch (Exception e) {
					AsReaderP252BLog.e(TAG, "ERROR. showIdleTimeDialog().$PositiveButton.onClick() - parseInt(%s)", value.getText().toString());
				}

				mIdleTime = txOffTime;
				displayIdleTime();
				InputMethodManager imm = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
				if(imm != null)
					imm.hideSoftInputFromWindow(value.getWindowToken(), 0);
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showIdleTimeDialog().$PositiveButton.onClick()");
			}
		});
		builder.setNegativeButton(R.string.action_cancel, new DialogInterface.OnClickListener() {

			@Override
			public void onClick(DialogInterface dialog, int which) {
				InputMethodManager imm = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
				if(imm != null)
					imm.hideSoftInputFromWindow(value.getWindowToken(), 0);
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showIdleTimeDialog().$NegativeButton.onClick()");
			}
		});
		builder.setCancelable(true);
		builder.setOnCancelListener(new DialogInterface.OnCancelListener() {

			@Override
			public void onCancel(DialogInterface dialog) {
				InputMethodManager imm = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
				if(imm != null)
					imm.hideSoftInputFromWindow(value.getWindowToken(), 0);
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showIdleTimeDialog().onCancel()");
			}
		});
		AlertDialog dialog = builder.create();
		dialog.setOnShowListener(new DialogInterface.OnShowListener() {

			@Override
			public void onShow(DialogInterface dialog) {
				value.setText(String.format(Locale.US, "%d", mIdleTime));
				value.selectAll();
				value.requestFocus();
				InputMethodManager imm = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
				if(imm != null)
					imm.showSoftInput(value, InputMethodManager.SHOW_FORCED);
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showIdleTimeDialog().onShow()");
			}
		});
		dialog.show();
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showIdleTimeDialog()");
	}
	
	private void showSleepTimeDialog() {
		if (!mIsEnabled)
			return;

		LinearLayout root = (LinearLayout) LinearLayout.inflate(this, R.layout.dialog_input_unit, null);
		final EditText value = (EditText) root.findViewById(R.id.value);
		final TextView unit = (TextView) root.findViewById(R.id.unit);
		unit.setText(R.string.unit_sec);
		InputFilter[] filters = new InputFilter[] { new InputFilterMinMax(0, 1800) };
		value.setFilters(filters);

		AlertDialog.Builder builder = new AlertDialog.Builder(this);
		builder.setTitle(R.string.sleep_time);
		builder.setView(root);
		builder.setPositiveButton(R.string.action_ok, null);
		builder.setNegativeButton(R.string.action_cancel, new DialogInterface.OnClickListener() {

			@Override
			public void onClick(DialogInterface dialog, int which) {
				InputMethodManager imm = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
				if(imm != null)
					imm.hideSoftInputFromWindow(value.getWindowToken(), 0);
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showSleepTimeDialog().$NegativeButton.onClick()");
			}
		});
		builder.setCancelable(true);
		builder.setOnCancelListener(new DialogInterface.OnCancelListener() {

			@Override
			public void onCancel(DialogInterface dialog) {
				InputMethodManager imm = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
				if(imm != null)
					imm.hideSoftInputFromWindow(value.getWindowToken(), 0);
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showSleepTimeDialog().onCancel()");
			}
		});
		AlertDialog dialog = builder.create();
		dialog.setOnShowListener(new DialogInterface.OnShowListener() {

			@Override
			public void onShow(DialogInterface dialog) {
				final AlertDialog dlg = (AlertDialog) dialog;
				value.setText(String.format(Locale.US, "%d", mSleepTime));
				value.selectAll();
				value.requestFocus();
				Button positiveButton = dlg.getButton(AlertDialog.BUTTON_POSITIVE);
				positiveButton.setOnClickListener(new View.OnClickListener() {

					@SuppressLint("ShowToast")
					@Override
					public void onClick(View v) {
						int time;
						try {
							time = Integer.parseInt(value.getText().toString());
						} catch (Exception e) {
							time = 0;
						}
						if (time !=0 && time < MIN_SLEEP_TIME) {
							AlertDialog.Builder builder = new AlertDialog.Builder(OptionActivity.this);
							builder.setMessage(R.string.min_sleep_time);
							builder.setPositiveButton(R.string.action_ok, new DialogInterface.OnClickListener() {

								@Override
								public void onClick(DialogInterface dialog, int which) {
									value.selectAll();
									value.requestFocus();
								}
							});
							builder.setCancelable(true);
							builder.show();
							return;
						}
						mSleepTime = time;
						displaySleepTime();
						InputMethodManager imm = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
						if(imm != null)
							imm.hideSoftInputFromWindow(value.getWindowToken(), 0);
						dlg.dismiss();
					}
				});
				InputMethodManager imm = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
				if(imm != null)
					imm.showSoftInput(value, InputMethodManager.SHOW_FORCED);
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showSleepTimeDialog().onShow()");
			}
		});
		dialog.show();
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showSleepTimeDialog()");
	}

	private void showBarcodeTimeoutDialog() {
		if (!mIsEnabled)
			return;

		LinearLayout root = (LinearLayout) LinearLayout.inflate(this, R.layout.dialog_input_unit, null);
		final EditText value = (EditText) root.findViewById(R.id.value);
		final TextView unit = (TextView) root.findViewById(R.id.unit);
		unit.setText(R.string.unit_sec);
		InputFilter[] filters = new InputFilter[] { new InputFilterMinMax(1 , 300) };
		value.setFilters(filters);

		AlertDialog.Builder builder = new AlertDialog.Builder(this);
		builder.setTitle(R.string.barcode_time);
		builder.setView(root);
		builder.setPositiveButton(R.string.action_ok, null);
		builder.setNegativeButton(R.string.action_cancel, new DialogInterface.OnClickListener() {

			@Override
			public void onClick(DialogInterface dialog, int which) {
				InputMethodManager imm = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
				if(imm != null)
					imm.hideSoftInputFromWindow(value.getWindowToken(), 0);
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showBarcodeTimeoutDialog().$NegativeButton.onClick()");
			}
		});
		builder.setCancelable(true);
		builder.setOnCancelListener(new DialogInterface.OnCancelListener() {

			@Override
			public void onCancel(DialogInterface dialog) {
				InputMethodManager imm = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
				if(imm != null)
					imm.hideSoftInputFromWindow(value.getWindowToken(), 0);
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showBarcodeTimeoutDialog().onCancel()");
			}
		});
		AlertDialog dialog = builder.create();
		dialog.setOnShowListener(new DialogInterface.OnShowListener() {

			@Override
			public void onShow(DialogInterface dialog) {
				final AlertDialog dlg = (AlertDialog) dialog;
				value.setText(String.format(Locale.US, "%d", mBarcodeTimeout));
				value.selectAll();
				value.requestFocus();
				Button positiveButton = dlg.getButton(AlertDialog.BUTTON_POSITIVE);
				positiveButton.setOnClickListener(new View.OnClickListener() {

					@SuppressLint("ShowToast")
					@Override
					public void onClick(View v) {
						int time;
						try {
							time = Integer.parseInt(value.getText().toString());
						} catch (Exception e) {
							time = 4;
						}
						if (time == 0)
						{
							time = 4;
						}
						if (time !=0 && time < MIN_BARCODE_TIMEOUT) {
							AlertDialog.Builder builder = new AlertDialog.Builder(OptionActivity.this);
							builder.setMessage(R.string.min_barcode_time);
							builder.setPositiveButton(R.string.action_ok, new DialogInterface.OnClickListener() {

								@Override
								public void onClick(DialogInterface dialog, int which) {
									value.selectAll();
									value.requestFocus();
								}
							});
							builder.setCancelable(true);
							builder.show();
							return;
						}
						mBarcodeTimeout = time;
						displayBarcodeTimeout();
						InputMethodManager imm = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
						if(imm != null)
							imm.hideSoftInputFromWindow(value.getWindowToken(), 0);
						dlg.dismiss();
					}
				});
				InputMethodManager imm = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
				if(imm != null)
					imm.showSoftInput(value, InputMethodManager.SHOW_FORCED);
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showBarcodeTimeoutDialog().onShow()");
			}
		});
		dialog.show();
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showBarcodeTimeoutDialog()");
	}
	private void showBaudRateDialog() {
		if (!mIsEnabled)
			return;

		LinearLayout root = (LinearLayout) LinearLayout.inflate(this, R.layout.dialog_list_view, null);
		final ListView value = (ListView) root.findViewById(R.id.list);
		final SpinnerAdapter adapter = new SpinnerAdapter(this, android.R.layout.simple_list_item_single_choice);
		String[] str = new String[mBaudRateList.size()];
		str = mBaudRateList.toArray(str);
		adapter.addItem(str);
		value.setAdapter(adapter);
		value.setChoiceMode(ListView.CHOICE_MODE_SINGLE);

		AlertDialog.Builder builder = new AlertDialog.Builder(this);
		builder.setTitle(R.string.baud_rate);
		builder.setView(root);
		builder.setPositiveButton(R.string.action_ok, new DialogInterface.OnClickListener() {

			@Override
			public void onClick(DialogInterface dialog, int which) {
				mBaudRate = value.getCheckedItemPosition();
				displayBaudRate();
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showBaudRateDialog().$PositiveButton.onClick()");
			}
		});
		builder.setNegativeButton(R.string.action_cancel, new DialogInterface.OnClickListener() {

			@Override
			public void onClick(DialogInterface dialog, int which) {
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showBaudRateDialog().$NegativeButton.onClick()");
			}
		});
		builder.setCancelable(true);
		builder.setOnCancelListener(new DialogInterface.OnCancelListener() {

			@Override
			public void onCancel(DialogInterface dialog) {
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showBaudRateDialog().onCancel()");
			}
		});
		AlertDialog dialog = builder.create();
		dialog.setOnShowListener(new DialogInterface.OnShowListener() {

			@Override
			public void onShow(DialogInterface dialog) {
				int position = adapter.getPosition(mBaudRate);
				value.setItemChecked(position, true);
				value.setSelectionFromTop(position, 0);
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showBaudRateDialog().onShow()");
			}
		});
		dialog.show();
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showBaudRateDialog()");
	}
	private void showAutoOffTimeDialog() {
		if (!mIsEnabled)
			return;

		LinearLayout root = (LinearLayout) LinearLayout.inflate(this, R.layout.dialog_input_unit, null);
		final EditText value = (EditText) root.findViewById(R.id.value);
		final TextView unit = (TextView) root.findViewById(R.id.unit);
		unit.setText(R.string.unit_sec);
		InputFilter[] filters = new InputFilter[] { new InputFilterMinMax(0, 1800) };
		value.setFilters(filters);

		AlertDialog.Builder builder = new AlertDialog.Builder(this);
		builder.setTitle(R.string.auto_off_time);
		builder.setView(root);
		builder.setPositiveButton(R.string.action_ok, null);
		builder.setNegativeButton(R.string.action_cancel, new DialogInterface.OnClickListener() {

			@Override
			public void onClick(DialogInterface dialog, int which) {
				InputMethodManager imm = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
				if(imm != null)
					imm.hideSoftInputFromWindow(value.getWindowToken(), 0);
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showAutoOffTimeDialog().$NegativeButton.onClick()");
			}
		});
		builder.setCancelable(true);
		builder.setOnCancelListener(new DialogInterface.OnCancelListener() {

			@Override
			public void onCancel(DialogInterface dialog) {
				InputMethodManager imm = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
				if(imm != null)
					imm.hideSoftInputFromWindow(value.getWindowToken(), 0);
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showAutoOffTimeDialog().onCancel()");
			}
		});
		AlertDialog dialog = builder.create();
		dialog.setOnShowListener(new DialogInterface.OnShowListener() {

			@Override
			public void onShow(DialogInterface dialog) {
				final AlertDialog dlg = (AlertDialog) dialog;
				value.setText(String.format(Locale.US, "%d", mAutoOffTime));
				value.selectAll();
				value.requestFocus();
				Button positiveButton = dlg.getButton(AlertDialog.BUTTON_POSITIVE);
				positiveButton.setOnClickListener(new View.OnClickListener() {

					@SuppressLint("ShowToast")
					@Override
					public void onClick(View v) {
						int time;
						try {
							time = Integer.parseInt(value.getText().toString());
						} catch (Exception e) {
							time = 0;
						}
						if (time != 0 && time < MIN_AUTO_OFF_TIME) {
							AlertDialog.Builder builder = new AlertDialog.Builder(OptionActivity.this);
							builder.setMessage(R.string.min_auto_off_time);
							builder.setPositiveButton(R.string.action_ok, new DialogInterface.OnClickListener() {

								@Override
								public void onClick(DialogInterface dialog, int which) {
									value.selectAll();
									value.requestFocus();
								}
							});
							builder.setCancelable(true);
							builder.show();
							return;
						}
						mAutoOffTime = time;
						displayAutoOffTime();
						InputMethodManager imm = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
						if(imm != null)
							imm.hideSoftInputFromWindow(value.getWindowToken(), 0);
						dlg.dismiss();
					}
				});
				InputMethodManager imm = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
				if(imm != null)
					imm.showSoftInput(value, InputMethodManager.SHOW_FORCED);
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showAutoOffTimeDialog().onShow()");
			}
		});
		dialog.show();
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showAutoOffTimeDialog()");
	}

	private void showBatteryIntervalDialog() {
		if (!mIsEnabled)
			return;

		LinearLayout root = (LinearLayout) LinearLayout.inflate(this, R.layout.dialog_input_unit, null);
		final TextView unit = (TextView) root.findViewById(R.id.unit);
		unit.setText(R.string.unit_sec);
		final EditText value = (EditText) root.findViewById(R.id.value);
		InputFilter[] filters = new InputFilter[] { new InputFilterMinMax(0, 1800) };
		value.setFilters(filters);

		AlertDialog.Builder builder = new AlertDialog.Builder(this);
		builder.setTitle(R.string.battery_interval);
		builder.setView(root);
		builder.setPositiveButton(R.string.action_ok, new DialogInterface.OnClickListener() {

			@Override
			public void onClick(DialogInterface dialog, int which) {
				try {
					mBatteryInterval = Integer.parseInt(value.getText().toString());
				} catch (Exception e) {
					//ASRLog.e(TAG, "ERROR. showBatteryIntervalDialog().$PositiveButton.onClick() - parseInt(%s)", value.getText().toString());
					mBatteryInterval = 0;
				}
				displayBatteryInterval();
				InputMethodManager imm = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
				if(imm != null)
					imm.hideSoftInputFromWindow(value.getWindowToken(), 0);
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showBatteryIntervalDialog().$PositiveButton.onClick()");
			}
		});
		builder.setNegativeButton(R.string.action_cancel, new DialogInterface.OnClickListener() {

			@Override
			public void onClick(DialogInterface dialog, int which) {
				InputMethodManager imm = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
				if(imm != null)
					imm.hideSoftInputFromWindow(value.getWindowToken(), 0);
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showBatteryIntervalDialog().$NegativeButton.onClick()");
			}
		});
		builder.setCancelable(true);
		builder.setOnCancelListener(new DialogInterface.OnCancelListener() {

			@Override
			public void onCancel(DialogInterface dialog) {
				InputMethodManager imm = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
				if(imm != null)
					imm.hideSoftInputFromWindow(value.getWindowToken(), 0);
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showBatteryIntervalDialog().onCancel()");
			}
		});
		AlertDialog dialog = builder.create();
		dialog.setOnShowListener(new DialogInterface.OnShowListener() {

			@Override
			public void onShow(DialogInterface dialog) {
				value.setText(String.format(Locale.US, "%d", mBatteryInterval));
				value.selectAll();
				value.requestFocus();
				InputMethodManager imm = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
				if(imm != null)
					imm.showSoftInput(value, InputMethodManager.SHOW_FORCED);
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showBatteryIntervalDialog()");
			}
		});
		dialog.show();
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showBatteryIntervalDialog().onShow()");
	}

	private void showQValueDialog() {
		if (!mIsEnabled)
			return;

		LinearLayout root = (LinearLayout) LinearLayout.inflate(this, R.layout.dialog_list_view, null);
		final ListView value = (ListView) root.findViewById(R.id.list);
		final SpinnerAdapter adapter = new SpinnerAdapter(this, android.R.layout.simple_list_item_single_choice);

		for(int n=0; n<=15; n++) {
			adapter.addItem(n, String.format(Locale.US, "%02d", n));
		}
		value.setAdapter(adapter);
		value.setChoiceMode(ListView.CHOICE_MODE_SINGLE);

		AlertDialog.Builder builder = new AlertDialog.Builder(this);
		builder.setTitle(R.string.q_value);
		builder.setView(root);
		builder.setPositiveButton(R.string.action_ok, new DialogInterface.OnClickListener() {

			@Override
			public void onClick(DialogInterface dialog, int which) {
				int position = -1;
				try {
					position = value.getCheckedItemPosition();
					mQValue = adapter.getValue(position);
					// Start Q must be greater than or equal to Min Q and less than or equal to Max Q
					if(mQValue < mMinQ)
						mQValue = mMinQ;
					if(mQValue > mMaxQ)
						mQValue = mMaxQ;
				} catch (Exception e) {
					AsReaderP252BLog.e(TAG, "ERROR. showQValueDialog().$PositiveButton.onClick() - position(%d)", position);
				}
				displayQValue();
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showQValueDialog().$PositiveButton.onClick()");
			}
		});
		builder.setNegativeButton(R.string.action_cancel, new DialogInterface.OnClickListener() {

			@Override
			public void onClick(DialogInterface dialog, int which) {
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showQValueDialog().$NegativeButton.onClick()");
			}
		});
		builder.setCancelable(true);
		builder.setOnCancelListener(new DialogInterface.OnCancelListener() {

			@Override
			public void onCancel(DialogInterface dialog) {
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showQValueDialog().onCancel()");
			}
		});
		AlertDialog dialog = builder.create();
		dialog.setOnShowListener(new DialogInterface.OnShowListener() {

			@Override
			public void onShow(DialogInterface dialog) {
				int position = adapter.getPosition(mQValue);
				value.setItemChecked(position, true);
				value.setSelectionFromTop(position, 0);
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showQValueDialog().onShow()");
			}
		});
		dialog.show();
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showQValueDialog()");
	}

	private void showMaxQDialog() {
		if (!mIsEnabled)
			return;

		LinearLayout root = (LinearLayout) LinearLayout.inflate(this, R.layout.dialog_list_view, null);
		final ListView value = (ListView) root.findViewById(R.id.list);
		final SpinnerAdapter adapter = new SpinnerAdapter(this, android.R.layout.simple_list_item_single_choice);

		for(int n=0; n<=15; n++) {
			adapter.addItem(n, String.format(Locale.US, "%02d", n));
		}
		value.setAdapter(adapter);
		value.setChoiceMode(ListView.CHOICE_MODE_SINGLE);

		AlertDialog.Builder builder = new AlertDialog.Builder(this);
		builder.setTitle(R.string.max_q);
		builder.setView(root);
		builder.setPositiveButton(R.string.action_ok, new DialogInterface.OnClickListener() {

			@Override
			public void onClick(DialogInterface dialog, int which) {
				int position = -1;
				try {
					position = value.getCheckedItemPosition();
					mMaxQ = adapter.getValue(position);
					// Max Q must be greater than or equal to Start Q and Min Q
					if(mMaxQ < mQValue)
						mMaxQ = mQValue;
					if(mMaxQ < mMinQ)
						mMaxQ = mMinQ;

				} catch (Exception e) {
					AsReaderP252BLog.e(TAG, "ERROR. showMaxQDialog().$PositiveButton.onClick() - position(%d)", position);
				}
				displayMaxQ();
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showMaxQDialog().$PositiveButton.onClick()");
			}
		});
		builder.setNegativeButton(R.string.action_cancel, new DialogInterface.OnClickListener() {

			@Override
			public void onClick(DialogInterface dialog, int which) {
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showMaxQDialog().$NegativeButton.onClick()");
			}
		});
		builder.setCancelable(true);
		builder.setOnCancelListener(new DialogInterface.OnCancelListener() {

			@Override
			public void onCancel(DialogInterface dialog) {
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showMaxQDialog().onCancel()");
			}
		});
		AlertDialog dialog = builder.create();
		dialog.setOnShowListener(new DialogInterface.OnShowListener() {

			@Override
			public void onShow(DialogInterface dialog) {
				int position = adapter.getPosition(mMaxQ);
				value.setItemChecked(position, true);
				value.setSelectionFromTop(position, 0);
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showMaxQDialog().onShow()");
			}
		});
		dialog.show();
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showMaxQDialog()");
	}

	private void showMinQDialog() {
		if (!mIsEnabled)
			return;

		LinearLayout root = (LinearLayout) LinearLayout.inflate(this, R.layout.dialog_list_view, null);
		final ListView value = (ListView) root.findViewById(R.id.list);
		final SpinnerAdapter adapter = new SpinnerAdapter(this, android.R.layout.simple_list_item_single_choice);

		for(int n=0; n<=15; n++) {
			adapter.addItem(n, String.format(Locale.US, "%02d", n));
		}
		value.setAdapter(adapter);
		value.setChoiceMode(ListView.CHOICE_MODE_SINGLE);

		AlertDialog.Builder builder = new AlertDialog.Builder(this);
		builder.setTitle(R.string.min_q);
		builder.setView(root);
		builder.setPositiveButton(R.string.action_ok, new DialogInterface.OnClickListener() {

			@Override
			public void onClick(DialogInterface dialog, int which) {
				int position = -1;
				try {
					position = value.getCheckedItemPosition();
					mMinQ = adapter.getValue(position);
					// Min Q must be less than or equal to Start Q and Max Q
					if(mMinQ > mQValue)
						mMinQ = mQValue;
					if(mMinQ > mMaxQ)
						mMinQ = mMaxQ;
				} catch (Exception e) {
					AsReaderP252BLog.e(TAG, "ERROR. showMinQDialog().$PositiveButton.onClick() - position(%d)", position);
				}
				displayMinQ();
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showMinQDialog().$PositiveButton.onClick()");
			}
		});
		builder.setNegativeButton(R.string.action_cancel, new DialogInterface.OnClickListener() {

			@Override
			public void onClick(DialogInterface dialog, int which) {
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showMinQDialog().$NegativeButton.onClick()");
			}
		});
		builder.setCancelable(true);
		builder.setOnCancelListener(new DialogInterface.OnCancelListener() {

			@Override
			public void onCancel(DialogInterface dialog) {
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showMinQDialog().onCancel()");
			}
		});
		AlertDialog dialog = builder.create();
		dialog.setOnShowListener(new DialogInterface.OnShowListener() {

			@Override
			public void onShow(DialogInterface dialog) {
				int position = adapter.getPosition(mMinQ);
				value.setItemChecked(position, true);
				value.setSelectionFromTop(position, 0);
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showMinQDialog().onShow()");
			}
		});
		dialog.show();
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showMinQDialog()");
	}

	private void showLinkProfileDialog() {
		if (!mIsEnabled)
			return;

		LinearLayout root = (LinearLayout) LinearLayout.inflate(this, R.layout.dialog_list_view, null);
		final ListView value = (ListView) root.findViewById(R.id.list);
		final SpinnerAdapter adapter = new SpinnerAdapter(this, android.R.layout.simple_list_item_single_choice);

		for(int n=0; n<=3; n++) {
			adapter.addItem(n, String.format(Locale.US, "%d", n));
		}
		value.setAdapter(adapter);
		value.setChoiceMode(ListView.CHOICE_MODE_SINGLE);

		AlertDialog.Builder builder = new AlertDialog.Builder(this);
		builder.setTitle(R.string.link_profile);
		builder.setView(root);
		builder.setPositiveButton(R.string.action_ok, new DialogInterface.OnClickListener() {

			@Override
			public void onClick(DialogInterface dialog, int which) {
				int position = -1;
				try {
					position = value.getCheckedItemPosition();
					mLinkProfile = adapter.getValue(position);
				} catch (Exception e) {
					AsReaderP252BLog.e(TAG, "ERROR. showLinkProfileDialog().$PositiveButton.onClick() - position(%d)", position);
				}
				displayLinkProfile();
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showLinkProfileDialog().$PositiveButton.onClick()");
			}
		});
		builder.setNegativeButton(R.string.action_cancel, new DialogInterface.OnClickListener() {

			@Override
			public void onClick(DialogInterface dialog, int which) {
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showLinkProfileDialog().$NegativeButton.onClick()");
			}
		});
		builder.setCancelable(true);
		builder.setOnCancelListener(new DialogInterface.OnCancelListener() {

			@Override
			public void onCancel(DialogInterface dialog) {
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showLinkProfileDialog().onCancel()");
			}
		});
		AlertDialog dialog = builder.create();
		dialog.setOnShowListener(new DialogInterface.OnShowListener() {

			@Override
			public void onShow(DialogInterface dialog) {
				int position = adapter.getPosition(mLinkProfile);
				value.setItemChecked(position, true);
				value.setSelectionFromTop(position, 0);
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showLinkProfileDialog().onShow()");
			}
		});
		dialog.show();
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showLinkProfileDialog()");
	}

	private void showDefaultLinkProfileDialog() {
		if (!mIsEnabled)
			return;

		LinearLayout root = (LinearLayout) LinearLayout.inflate(this, R.layout.dialog_list_view, null);
		final ListView value = (ListView) root.findViewById(R.id.list);
		final SpinnerAdapter adapter = new SpinnerAdapter(this, android.R.layout.simple_list_item_single_choice);

		for(int n=0; n<=3; n++) {
			adapter.addItem(n, String.format(Locale.US, "%d", n));
		}
		value.setAdapter(adapter);
		value.setChoiceMode(ListView.CHOICE_MODE_SINGLE);

		AlertDialog.Builder builder = new AlertDialog.Builder(this);
		builder.setTitle(R.string.default_link_profile);
		builder.setView(root);
		builder.setPositiveButton(R.string.action_ok, new DialogInterface.OnClickListener() {

			@Override
			public void onClick(DialogInterface dialog, int which) {
				int position = -1;
				try {
					position = value.getCheckedItemPosition();
					mDefaultLinkProfile = adapter.getValue(position);
				} catch (Exception e) {
					AsReaderP252BLog.e(TAG, "ERROR. showDefaultLinkProfileDialog().$PositiveButton.onClick() - position(%d)", position);
				}
				displayDefaultLinkProfile();
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showDefaultLinkProfileDialog().$PositiveButton.onClick()");
			}
		});
		builder.setNegativeButton(R.string.action_cancel, new DialogInterface.OnClickListener() {

			@Override
			public void onClick(DialogInterface dialog, int which) {
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showDefaultLinkProfileDialog().$NegativeButton.onClick()");
			}
		});
		builder.setCancelable(true);
		builder.setOnCancelListener(new DialogInterface.OnCancelListener() {

			@Override
			public void onCancel(DialogInterface dialog) {
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showDefaultLinkProfileDialog().onCancel()");
			}
		});
		AlertDialog dialog = builder.create();
		dialog.setOnShowListener(new DialogInterface.OnShowListener() {

			@Override
			public void onShow(DialogInterface dialog) {
				int position = adapter.getPosition(mDefaultLinkProfile);
				value.setItemChecked(position, true);
				value.setSelectionFromTop(position, 0);
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showDefaultLinkProfileDialog().onShow()");
			}
		});
		dialog.show();
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showDefaultLinkProfileDialog()");
	}

	private void showFrequencyAutomaticDialog() {
		LinearLayout root = (LinearLayout) LinearLayout.inflate(this, R.layout.dialog_list_view, null);
		final ListView value = (ListView) root.findViewById(R.id.list);
		final SpinnerAdapter adapter = new SpinnerAdapter(this, android.R.layout.simple_list_item_single_choice);
		adapter.addItem(0, "Off");
		adapter.addItem(1, "On");
		value.setAdapter(adapter);
		value.setChoiceMode(ListView.CHOICE_MODE_SINGLE);

		AlertDialog.Builder builder = new AlertDialog.Builder(this);
		builder.setTitle(R.string.frequency_automatic);
		builder.setView(root);
		builder.setPositiveButton(R.string.action_ok, new DialogInterface.OnClickListener() {

			@Override
			public void onClick(DialogInterface dialog, int which) {
				try {
					int position = value.getCheckedItemPosition();
					mFrequencyAutomatic = adapter.getValue(position) > 0;
					getReader().setFrequencyAutomatic(mFrequencyAutomatic);
//					MainActivity.mUserConfigs.setIsFrequencyAutomatic(mFrequencyAutomatic);
//					MainActivity.mUserConfigs.Save();
				} catch (Exception e) {
					AsReaderP252BLog.e(TAG, "ERROR.  showFrequencyAutomaticDialog().$PositiveButton.onClick() - [%s]"
							, e.getMessage());
				}
				displayFrequencyTable();
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showFrequencyAutomaticDialog().$PositiveButton.onClick()");
			}
		});
		builder.setNegativeButton(R.string.action_cancel, new DialogInterface.OnClickListener() {

			@Override
			public void onClick(DialogInterface dialog, int which) {
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showFrequencyAutomaticDialog().$NegativeButton.onClick()");
			}
		});
		builder.setCancelable(true);
		builder.setOnCancelListener(new DialogInterface.OnCancelListener() {

			@Override
			public void onCancel(DialogInterface dialog) {
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showFrequencyAutomaticDialog().onCancel()");
			}
		});
		AlertDialog dialog = builder.create();
		dialog.setOnShowListener(new DialogInterface.OnShowListener() {

			@Override
			public void onShow(DialogInterface dialog) {
				int position = adapter.getPosition(mFrequencyAutomatic ? 1 : 0);
				value.setItemChecked(position, true);
				value.setSelectionFromTop(position, 0);
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showFrequencyAutomaticDialog().onShow()");
			}
		});
		dialog.show();
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showFrequencyAutomaticDialog()");
	}

	private void showFrequencyDialog() {
		final LinearLayout root = (LinearLayout) LinearLayout.inflate(this, R.layout.dialog_list_view, null);
		final ListView table = (ListView) root.findViewById(R.id.list);
		final LbtChannelAdapter adapter = new LbtChannelAdapter(this);
		for (FreqSlotItem item : mFreqSlots) {
			adapter.addItem(item.getSlot(), item.getName());
		}
		table.setAdapter(adapter);
		table.setChoiceMode(ListView.CHOICE_MODE_MULTIPLE);

		AlertDialog.Builder builder = new AlertDialog.Builder(this);
		builder.setTitle(R.string.lbt_channel_title);
		builder.setView(root);
		builder.setPositiveButton(R.string.action_ok, new DialogInterface.OnClickListener() {

			@Override
			public void onClick(DialogInterface dialog, int which) {
				mFreqTable = adapter.getTable();
				try {
					getReader().setFrequencyList(mFreqTable);
					int i = -1;
					ArrayList<String> mList = new ArrayList<>();
					for (AsReaderP252BLbtItem item : mFreqTable) {
						i ++;
						if (item.isUsed() == true)
						{
							String isUsedString = String.valueOf(i);
							mList.add(isUsedString);
						}
					}
					if (!mList.isEmpty())
					{
						String[] result = new String[mList.size()];
						result = mList.toArray(result);
						String str = "";
						for(int j = 0; j < result.length; j++)
						{
							if (str.equals(""))
							{
								str = result[j];
							} else {
								str = str + "," +  result[j];
							}
						}
//						MainActivity.mUserConfigs.setFrequency(str);
//						MainActivity.mUserConfigs.Save();
					}
				} catch (Exception e) {
					AsReaderP252BLog.e(TAG, "ERROR.  showFrequencyAutomaticDialog().$PositiveButton.onClick() - [%s]"
							, e.getMessage());
				}
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showLbtChannelDialog().$PositiveButton.onClick()");
			}
		});
		builder.setNegativeButton(R.string.action_cancel, new DialogInterface.OnClickListener() {

			@Override
			public void onClick(DialogInterface dialog, int which) {
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showLbtChannelDialog().$NegativeButton.onClick()");
			}
		});
		builder.setCancelable(true);
		builder.setOnCancelListener(new DialogInterface.OnCancelListener() {

			@Override
			public void onCancel(DialogInterface dialog) {
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showLbtChannelDialog().onCancel()");
			}
		});
		AlertDialog dialog = builder.create();
		dialog.setOnShowListener(new DialogInterface.OnShowListener() {

			@Override
			public void onShow(DialogInterface dialog) {
				adapter.setTable(mFreqTable);
				adapter.notifyDataSetChanged();
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showLbtChannelDialog().onShow()");
			}
		});
		dialog.show();

		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showLbtChannelDialog()");
	}
	private class FreqSlotItem {
		private int mSlot;
		private String mFreqName;

		private FreqSlotItem(int slot, String name) {
			mSlot = slot;
			mFreqName = name;
		}

		private int getSlot() {
			return mSlot;
		}

		public String getName() {
			return mFreqName;
		}

		@Override
		public String toString() {
			return String.format(Locale.US, "%d, [%s]", mSlot, mFreqName);
		}
	}
}
