package support.andro.app.rfid.util;

import android.content.Context;
import android.content.SharedPreferences;

import com.asreader.app.rfid.MainActivity;
import com.asreader.p252b.AsReaderP252B;
import com.asreader.p252b.diagnostics.AsReaderP252BLog;
import com.asreader.p252b.rfid.params.AsReaderP252BSelectMaskEpcParam;
import com.asreader.p252b.rfid.type.AsReaderP252BBuzzerState;
import com.asreader.p252b.rfid.type.AsReaderP252BQuerySession;
import com.asreader.p252b.rfid.type.AsReaderP252BSessionFlag;

import java.util.ArrayList;
import java.util.Locale;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

/**
 * Created by Kastro on 2018-07-25.
 */

public class UserConfigs {
    private static final String TAG = UserConfigs.class.getSimpleName();
    private static ConfigParams _configParams = null;
    private final String KEY = "mask_params";
    private Context _context = null;
    private Gson _gson = null;
    public UserConfigs(Context context) {
        _context = context;
        _gson = new GsonBuilder().create();
    }
    public void Save() {
        String maskParams = _gson.toJson(_configParams, ConfigParams.class);
        SharedPreferences sharedPreferences = _context.getSharedPreferences(MainActivity.APP_NAME, Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(KEY, maskParams);
        editor.apply();
    }
    public boolean Load(AsReaderP252B reader) {
        SharedPreferences sharedPreferences = _context.getSharedPreferences(MainActivity.APP_NAME, Context.MODE_PRIVATE);
        String maskParams = sharedPreferences.getString(KEY, "");
        if (maskParams.isEmpty()) {
            _configParams = new ConfigParams();
        } else {
            _configParams = _gson.fromJson(maskParams, ConfigParams.class);
        }
        return SaveToDevice(reader, _configParams);
    }
    private boolean SaveToDevice(AsReaderP252B reader, ConfigParams configParams) {
        try {
            //ASRLog.e(TAG, "save query parameters");
//            if(configParams._maskType == null)
//                configParams._maskType = MaskType.NoMask;
//            ASRLog.e(TAG, String.format(Locale.US, "MaskType : %s", configParams._maskType));
//            reader.setMaskType(configParams._maskType);
//            ASRLog.e(TAG, String.format(Locale.US, "SL : %s", configParams._sl));
//            reader.setQuerySL(configParams._sl);
//            ASRLog.e(TAG, String.format(Locale.US, "Session : %s", configParams._session));
//            reader.setQuerySession(configParams._session);
//            ASRLog.e(TAG, String.format(Locale.US, "Target : %s", configParams._target));
//            reader.setSessionFlag(configParams._target);
//
//            //ASRLog.e(TAG, "save select mask");
//            for(int i=0; i<8; i++) {
//                if(configParams._selectMasks.containsKey(i)) {
//                    ASRLog.e(TAG, String.format(Locale.US, "%02d - %s", i, configParams._selectMasks.get(i)._param));
//                    reader.setSelectionMask(i, configParams._selectMasks.get(i)._param);
//                }
//                else
//                    reader.removeSelectionMask(i);
//            }
//
//            //ASRLog.e(TAG, "save epc mask");
//            reader.clearEpcMask();
//            for(int i=0; i<configParams._epcMasks.size(); i++) {
//                reader.addEpcMask(configParams._epcMasks.get(i));
//            }
//            reader.setEpcMaskMatchMode(configParams._epcNotMatching);
//            reader.setReportRSSI(configParams._reportRssi);
            //ASRLog.e(TAG, "finished.");
            return true;
        } catch (Exception ae) {
            AsReaderP252BLog.e(TAG, String.format(Locale.US, "SaveToDevice - %s", ae));
            return false;
        }
    }
    public void resetContents() {
        _configParams._epcMasks.clear();
        _configParams._epcNotMatching = false;
        _configParams._session = AsReaderP252BQuerySession.S0;
        _configParams._target = AsReaderP252BSessionFlag.AB;
        _configParams._reportRssi = false;
        _configParams._displayPc = true;
        _configParams._powerGain = 300;
        _configParams._isContinuousMode = true;
        _configParams._operationTime = 0;
        _configParams._decodeRescanTime = 0;
        _configParams._decodeRescanTimePositon = 0;
        _configParams._buzzertType = AsReaderP252BBuzzerState.High;
        _configParams._idleTime = 0;
        _configParams._sleepTimeValue = 300;
        _configParams._batteryInterval = 10;
        _configParams._autoOffTime = 300;
        _configParams._qValue = 4;
        _configParams._linkProfileValue = 1;
        _configParams._defaultLinkProfileValue = 1;
        _configParams._barcodeTimeout = 4;
        _configParams._baudRate = 2;
        _configParams._isFrequencyAutomatic = true;
    }
    public void clearEpcMasks() {
        _configParams._epcMasks.clear();
    }

    public void addEpcMask(AsReaderP252BSelectMaskEpcParam value) {
        _configParams._epcMasks.add(value);
    }

    public AsReaderP252BSelectMaskEpcParam getEpcMask(int index) {
        return _configParams._epcMasks.get(index);
    }

    public boolean getEpcNotMatching() {
        return _configParams._epcNotMatching;
    }

    public void setEpcNotMatching(boolean value) {
        _configParams._epcNotMatching = value;
    }

    public int getEpcMaskCount() {
        return _configParams._epcMasks.size();
    }

    public AsReaderP252BQuerySession getSession() {
        return _configParams._session;
    }

    public void setSession(AsReaderP252BQuerySession value) {
        _configParams._session = value;
    }

    public AsReaderP252BSessionFlag getTarget() {
        return _configParams._target;
    }

    public void setTarget(AsReaderP252BSessionFlag value) {
        _configParams._target = value;
    }

    public boolean getReportRssi() {
        return _configParams._reportRssi;
    }

    public void setReportRssi(boolean value) {
        _configParams._reportRssi = value;
    }

    public boolean getDisplayPc() {
        return _configParams._displayPc;
    }

    public void setDisplayPc(boolean value) {
        _configParams._displayPc = value;
    }

    public int getPowerGain() {
        return _configParams._powerGain;
    }

    public void setPowerGain(int value) {
        _configParams._powerGain = value;
    }

    public boolean getIsContinuousMode() {
        return _configParams._isContinuousMode;
    }

    public void setIsContinuousMode(boolean value) {
        _configParams._isContinuousMode = value;
    }

    public int getOperationTime() {
        return _configParams._operationTime;
    }

    public void setOperationTime(int value) {
        _configParams._operationTime = value;
    }

    public int getDecodeRescanTime() {
        return _configParams._decodeRescanTime;
    }

    public void setDecodeRescanTime(int value) {
        _configParams._decodeRescanTime = value;
    }

    public int getDecodeRescanTimePostion() {
        return _configParams._decodeRescanTimePositon;
    }

    public void setDecodeRescanTimePostion(int value) {
        _configParams._decodeRescanTimePositon = value;
    }

    public AsReaderP252BBuzzerState getBuzzerState() {
        return _configParams._buzzertType;
    }

    public void setBuzzerState(AsReaderP252BBuzzerState value) {
        _configParams._buzzertType = value;
    }

//    public int getInventoryTime() {
//        return _configParams._inventoryTime;
//    }

//    public void setInventoryTime(int value) {
//        _configParams._inventoryTime = value;
//    }

    public int getIdleTime() {
        return _configParams._idleTime;
    }

    public void setIdleTime(int value) {
        _configParams._idleTime = value;
    }

    public int getSleepTime() {
        return _configParams._sleepTimeValue;
    }

    public void setSleepTime(int value) {
        _configParams._sleepTimeValue = value;
    }

    public int getBatteryInterval() {
        if (_configParams != null) {
            return _configParams._batteryInterval;
        }
        return 0;
    }

    public void setBatteryInterval(int value) {
        _configParams._batteryInterval = value;
    }

    public int getAutoOffTime() {
        return _configParams._autoOffTime;
    }

    public void setAutoOffTime(int value) {
        _configParams._autoOffTime = value;
    }

    public int getQValue() {
        return _configParams._qValue;
    }

    public void setQValue(int value) {
        _configParams._qValue = value;
    }

    public int getLinkProfileValue() {
        return _configParams._linkProfileValue;
    }

    public void setLinkProfileValue(int value) {
        _configParams._linkProfileValue = value;
    }

    public int getDefaultLinkProfileValue() {
        return _configParams._defaultLinkProfileValue;
    }

    public void setDefaultLinkProfileValue(int value) {
        _configParams._defaultLinkProfileValue = value;
    }

    public int getBarcodeTimeout() {
        return _configParams._barcodeTimeout;
    }

    public void setBarcodeTimeout(int value) {
        _configParams._barcodeTimeout = value;
    }

    public int getBaudRate() {
        return _configParams._baudRate;
    }

    public void setBaudRate(int value) {
        _configParams._baudRate = value;
    }

//    public boolean getIsFrequencyAutomatic() {
//        return _configParams._isFrequencyAutomatic;
//    }
//
//    public void setIsFrequencyAutomatic(boolean value) {
//        _configParams._isFrequencyAutomatic = value;
//    }

//    public String getFrequency() {
//        return _configParams._frequency;
//    }
//    public void setFrequency(String value) {
//        _configParams._frequency = value;
//    }

    private class ConfigParams {
        private ArrayList<AsReaderP252BSelectMaskEpcParam> _epcMasks = null;
        private boolean _epcNotMatching = false;
        private AsReaderP252BQuerySession _session = AsReaderP252BQuerySession.S0;
        private AsReaderP252BSessionFlag _target = AsReaderP252BSessionFlag.AB;
        private boolean _reportRssi = false;
        private boolean _displayPc = true;
        private int _powerGain = 0;
        private boolean _isContinuousMode = false;
        private int _operationTime = 0;
        private int _decodeRescanTime = 0;
        private int _decodeRescanTimePositon = 0;
        private AsReaderP252BBuzzerState _buzzertType = AsReaderP252BBuzzerState.Off;
//        private int _inventoryTime = 0;
        private int _idleTime = 0;
        private int _sleepTimeValue = 0;
        private int _batteryInterval = 0;
        private int _autoOffTime = 0;
        private int _qValue = 0;
        private int _linkProfileValue = 0;
        private int _defaultLinkProfileValue = 0;
        private int _barcodeTimeout = 0;
        private int _baudRate = 2;
        private boolean _isFrequencyAutomatic = true;
        private String _frequency = "";

        private ConfigParams() {
            _epcMasks = new ArrayList<AsReaderP252BSelectMaskEpcParam>();
            _epcNotMatching = false;
            _session = AsReaderP252BQuerySession.S0;
            _target = AsReaderP252BSessionFlag.AB;
            _reportRssi = false;
            _displayPc = true;
            _powerGain = 300;
            _isContinuousMode = true;
            _operationTime = 0;
            _decodeRescanTime = 0;
            _decodeRescanTimePositon = 0;
            _buzzertType = AsReaderP252BBuzzerState.High;
//            _inventoryTime = 40;
            _idleTime = 0;
            _sleepTimeValue = 300;
            _batteryInterval = 10;
            _autoOffTime = 300;
            _qValue = 4;
            _linkProfileValue = 1;
            _defaultLinkProfileValue = 1;
            _barcodeTimeout = 4;
            _baudRate = 2;
            _isFrequencyAutomatic = true;
        }
    }
}