package support.andro.app.rfid.util;

import android.content.Context;
import android.content.SharedPreferences;

public class AsReaderP252BUserConfigs {
    public enum AsReaderP252BConnectType {
        AsReaderP252BConnectType_USB,
        AsReaderP252BConnectType_Bluetooth;
    }
    private static final String TAG = "UserConfigs";
    private static String preferenceName = "AsCameraLite";
    private final String KEY_DEVICE_CONNECT_TYPE = "KEY_DEVICE_CONNECT_TYPE";
    private Context _context = null;

    private static AsReaderP252BUserConfigs mUserConfigs;
    private SharedPreferences sharedPreferences;

    public static AsReaderP252BUserConfigs getInstance() {
        if (mUserConfigs == null) {
            mUserConfigs = new AsReaderP252BUserConfigs();
        }
        return mUserConfigs;
    }

    private AsReaderP252BUserConfigs(){}

    public void setContext(Context context) {
        _context = context;
        sharedPreferences = _context.getSharedPreferences(preferenceName, Context.MODE_PRIVATE);
    }

    public Context getContext() {
        return _context;
    }

    public AsReaderP252BConnectType getConnectType() {
        int value = sharedPreferences.getInt(KEY_DEVICE_CONNECT_TYPE, 0);
        if (value == 0) {
            return AsReaderP252BConnectType.AsReaderP252BConnectType_USB;
        } else {
            return AsReaderP252BConnectType.AsReaderP252BConnectType_Bluetooth;
        }
    }

    public void setConnectType(AsReaderP252BConnectType value) {
        SharedPreferences.Editor editor = sharedPreferences.edit();
        if (value == AsReaderP252BConnectType.AsReaderP252BConnectType_USB) {
            editor.putInt(KEY_DEVICE_CONNECT_TYPE, 0);
        } else {
            editor.putInt(KEY_DEVICE_CONNECT_TYPE, 1);
        }
        editor.apply();
    }
}
