package support.andro.app.rfid.dialog.WheelDialog;

import android.annotation.SuppressLint;
import android.app.AlertDialog;
import android.content.Context;
import android.graphics.Color;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.asreader.app.rfid.R;
import com.wx.wheelview.adapter.ArrayWheelAdapter;
import com.wx.wheelview.widget.WheelView;
import com.wx.wheelview.widget.WheelViewDialog;

import java.util.Arrays;
import java.util.List;

/**
 * zsj change ...
 */
public class MaskWheelDialog extends WheelViewDialog implements View.OnClickListener {

  //  private TextView mTitle;

   // private View mLine1, mLine2;

    private com.wx.wheelview.widget.WheelView<String> mWheelView;

   private WheelView.WheelViewStyle mStyle;

    private TextView mButton;

    private AlertDialog mDialog;

    private Context mContext;

    private WheelViewDialog.OnDialogItemClickListener mOnDialogItemClickListener;

    private int mSelectedPos;

    private String mSelectedText;
    private TextView tvClose;
    private TextView tvTitle;

    public MaskWheelDialog(Context context) {
        super(context);
        mContext = context;
        init();
    }

    @SuppressLint("UseCompatLoadingForDrawables")
    private void init() {
        // 对话框的布局
        LayoutInflater layoutInflater = LayoutInflater.from(mContext);
        LinearLayout layout = (LinearLayout) layoutInflater.inflate(R.layout.wheel_view_length_dialog_body, null); // 自定义布局
        layout.setGravity(Gravity.BOTTOM);
        layout.setBackground(mContext.getResources().getDrawable(R.drawable.shape_corners_white_r16_top));

        tvClose = layout.findViewById(R.id.tv_btn_wheel_view_dialog_close);
        tvTitle = layout.findViewById(R.id.tv_btn_wheel_view_dialog_title);
        mButton = (TextView) layout.findViewById(R.id.tv_btn_wheel_view_dialog_ok);
        mButton.setOnClickListener(this);
        //  LinearLayout layout = new LinearLayout(mContext);
       // layout.setOrientation(LinearLayout.VERTICAL);

        // layout.setBackgroundColor(mContext.getResources().getColor(R.color.blueTabTextSelected));
        // layout.setVerticalGravity(Gravity.BOTTOM);
        // layout.setWeightSum(1);
       //  layout.setPadding(WheelUtils.dip2px(mContext, 20), 0, WheelUtils.dip2px(mContext, 20), 0);

        // 标题
//        mTitle = new TextView(mContext);
//        mTitle.setTextColor(WheelConstants.DIALOG_WHEEL_COLOR);
//        mTitle.setTextSize(TypedValue.COMPLEX_UNIT_SP, 16);
//        mTitle.setGravity(Gravity.CENTER);
//        LinearLayout.LayoutParams titleParams = new LinearLayout.LayoutParams(LinearLayout.LayoutParams.MATCH_PARENT,
//                WheelUtils.dip2px(mContext, 50));
//        layout.addView(mTitle, titleParams);

        // 标题下的横线
//        mLine1 = new View(mContext);
//        mLine1.setBackgroundColor(WheelConstants.DIALOG_WHEEL_COLOR);
//        LinearLayout.LayoutParams lineParams = new LinearLayout.LayoutParams(LinearLayout.LayoutParams.MATCH_PARENT,
//                WheelUtils.dip2px(mContext, 2));
//        layout.addView(mLine1, lineParams);

        mWheelView = new WheelView(mContext);
        mWheelView.setSkin(WheelView.Skin.Holo);// 有线
        // mWheelView.setSkin(WheelView.Skin.None);// 无线
        mWheelView.setTextAlignment(View.TEXT_ALIGNMENT_TEXT_START);
        mWheelView.setWheelAdapter(new ArrayWheelAdapter(mContext));
        // mWheelView.setBackgroundColor(Color.argb(0,0,0,255));

        mStyle = new WheelView.WheelViewStyle();
        mStyle.textColor = Color.GRAY;
        // mStyle.selectedTextZoom = 1.2f; // 选中字体放大
        mWheelView.setStyle(mStyle);

        // 选中项的点击
        mWheelView.setOnWheelItemSelectedListener(new WheelView.OnWheelItemSelectedListener<String>() {
            @Override
            public void onItemSelected(int position, String text) {
                mSelectedPos = position;
                mSelectedText = text;
            }
        });

        ViewGroup.MarginLayoutParams wheelParams = new ViewGroup.MarginLayoutParams(LinearLayout.LayoutParams
                .MATCH_PARENT,
                LinearLayout.LayoutParams.WRAP_CONTENT);
        layout.addView(mWheelView, wheelParams);

//        mLine2 = new View(mContext);
//        mLine2.setBackgroundColor(WheelConstants.DIALOG_WHEEL_COLOR);
//        LinearLayout.LayoutParams line2Params = new LinearLayout.LayoutParams(LinearLayout.LayoutParams.MATCH_PARENT,
//                WheelUtils.dip2px(mContext, 1f));
//        layout.addView(mLine2, line2Params);

        // 按钮
       // mButton = new TextView(mContext);
      //  mButton = (TextView) layout.findViewById(R.id.tv_btn_wheel_view_dialog_ok);

      //   mButton.setBackgroundColor(mContext.getResources().getColor(R.color.blueTabTextSelected));
      //  mButton.setTextColor(Color.parseColor("#FFFFFFFF"));
       // mButton.setTextSize(TypedValue.COMPLEX_UNIT_SP, 12);
//        mButton.setTextSize(TypedValue.COMPLEX_UNIT_PT, 9);
//        mButton.setGravity(Gravity.CENTER);
//        mButton.setClickable(true);
//        mButton.setOnClickListener(this);
//        mButton.setText("OK");
//        mButton.setBackground(mContext.getResources().getDrawable(R.drawable.shape_courses_detail_button_blue_double));
        // @drawable/shape_courses_detail_button_blue_double
//        LinearLayout.LayoutParams buttonParams = new LinearLayout.LayoutParams(LinearLayout.LayoutParams.MATCH_PARENT, WheelUtils.dip2px(mContext, 46));
//        buttonParams.setMargins(WheelUtils.dip2px(mContext, 30), WheelUtils.dip2px(mContext, 33), WheelUtils.dip2px(mContext, 30), WheelUtils.dip2px(mContext, 20)); // 左、上、右、下
//        layout.addView(mButton);

        // 对话框
        // mDialog = new AlertDialog.Builder(mContext).create();
        mDialog = new AlertDialog.Builder(mContext, R.style.Dialog_WidthFullscreen).create(); // Dialog_WidthFullscreen 宽全屏
        mDialog.getWindow().setLayout(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        mDialog.getWindow().setGravity(Gravity.BOTTOM);
        mDialog.setView(layout);

        mDialog.setCanceledOnTouchOutside(false);

        tvClose.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                dismiss();
            }
        });

//        WindowManager.LayoutParams ml = mDialog.getWindow().getAttributes();
//        ml.gravity=Gravity.BOTTOM;
//        ml.width= ml.MATCH_PARENT;
//        ml.height= ml.WRAP_CONTENT;
       // mDialog.getWindow().getDecorView().setPadding(0, 0, 0, 0);

      //  mDialog.getWindow().setAttributes(ml);

       // mDialog.getWindow().setGravity(Gravity.BOTTOM);

    }


    /**
     * 点击事件
     *
     * @param onDialogItemClickListener
     * @return
     */
    public WheelViewDialog setOnDialogItemClickListener(WheelViewDialog.OnDialogItemClickListener onDialogItemClickListener) {
        mOnDialogItemClickListener = onDialogItemClickListener;
        return this;
    }

    /**
     * 设置dialog颜色外观
     */
    public WheelViewDialog setDialogStyle(int selectColor) {
      //  mTitle.setTextColor(color);
      //  mLine1.setBackgroundColor(color);
      //  mLine2.setBackgroundColor(color);
      //  mButton.setTextColor(color);
        mStyle.selectedTextColor = selectColor;
        mStyle.holoBorderColor = Color.parseColor("#FFC8C7C8");
        return this;
    }

    /**
     * 设置标题
     *
     * @param title
     * @return
     */
//    public WheelViewDialog setTitle(String title) {
//        mTitle.setText(title);
//        return this;
//    }

    public WheelViewDialog setTitle(String title) {
             tvTitle.setText(title);
        return this;
    }


    /**
     * 设置标题颜色
     *
     * @param color
     * @return
     */
//    public WheelViewDialog setTextColor(int color) {
//        mTitle.setTextColor(color);
//        return this;
//    }

    /**
     * 设置标题大小
     *
     * @param size
     * @return
     */
//    public WheelViewDialog setTextSize(int size) {
//        mTitle.setTextSize(size);
//        return this;
//    }

    /**
     * 设置按钮文本
     *
     * @param text
     * @return
     */
    public WheelViewDialog setButtonText(String text) {
        mButton.setText(text);
        return this;
    }

    /**
     * 设置按钮文本颜色
     *
     * @param color
     * @return
     */
    public WheelViewDialog setButtonColor(int color) {
        mButton.setTextColor(color);
        return this;
    }

    /**
     * 设置按钮文本尺寸
     *
     * @param size
     * @return
     */
    public WheelViewDialog setButtonSize(int size) {
        mButton.setTextSize(size);
        return this;
    }

    /**
     * 设置数据项显示个数
     *
     * @param count
     */
    public WheelViewDialog setCount(int count) {
        mWheelView.setWheelSize(count);
        return this;
    }

    /**
     * 数据项是否循环显示
     *
     * @param loop
     */
    public WheelViewDialog setLoop(boolean loop) {
        mWheelView.setLoop(loop);
        return this;
    }

    /**
     * 设置数据项显示位置
     *
     * @param selection
     */
    public WheelViewDialog setSelection(int selection) {
        mWheelView.setSelection(selection);
        return this;
    }

    /**
     * 设置数据项
     *
     * @param arrays
     */
    public WheelViewDialog setItems(String[] arrays) {
        mWheelView.setWheelData(Arrays.asList(arrays));
        return this;
    }

    /**
     * 设置数据项
     *
     * @param list
     */
    public WheelViewDialog setItems(List<String> list) {
        mWheelView.setWheelData(list);
        return this;
    }

    public WheelViewDialog setListItems(List<String> list) {
        // Log.e("888999", "大小是：" + list.size());
        mWheelView.setWheelData(list);
        return this;
    }

    /**
     * 显示
     */
    public WheelViewDialog show() {
        if (!mDialog.isShowing()) {
            mDialog.show();
        }
        return this;
    }

    /**
     * 隐藏
     */
    public WheelViewDialog dismiss() {
        if (mDialog.isShowing()) {
            mDialog.dismiss();
        }
        return this;
    }

    @Override
    public void onClick(View v) {
        dismiss();
        if (null != mOnDialogItemClickListener) {
            mOnDialogItemClickListener.onItemClick(mSelectedPos, mSelectedText);
        }
    }

//    public void onItemClick(int position, String s) {
//
//    }

    public interface OnDialogItemClickListener {
        void onItemClick(int position, String s);
    }

}
