package com.asreader.app.rfid.view;

import support.andro.app.rfid.dialog.IDialogResultListener;
import support.andro.app.rfid.dialog.PasswordDialog;
import support.andro.app.rfid.dialog.WaitDialog;
import support.andro.app.rfid.util.ResUtil;
import support.andro.app.rfid.view.base.AccessActivity;

import com.asreader.p252b.barcode.AsReaderP252BBarcodeType;
import com.asreader.p252b.device.type.AsReaderP252BKeyState;
import com.asreader.p252b.rfid.exception.AsReaderP252BException;
import com.asreader.p252b.rfid.params.AsReaderP252BLockParam;
import com.asreader.p252b.rfid.type.AsReaderP252BActionState;
import com.asreader.p252b.rfid.type.AsReaderP252BMemoryBank;
import com.asreader.p252b.rfid.type.AsReaderP252BResultCode;

import java.lang.ref.WeakReference;
import java.util.Locale;

import com.asreader.app.rfid.R;
import com.asreader.p252b.AsReaderP252B;
import com.asreader.p252b.diagnostics.AsReaderP252BLog;

import android.app.ActionBar;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.view.View;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.ScrollView;
import android.widget.TextView;
import android.widget.Toast;

public class TagAccessActivity extends AccessActivity {

	private static final String TAG = TagAccessActivity.class.getSimpleName();

	private static final int KILL_PASSWORD = 0;
	private static final int ACCESS_PASSWORD = 1;
	private static final int EPC = 2;
	private static final int TID = 3;
	private static final int USER = 4;
	private static final int MAX_ACCESS = 5;

	private static final int SUBACTION_IDLE = 0;
	private static final int SUBACTION_LOCK = 1;
	private static final int SUBACTION_UNLOCK = 2;
	private static final int SUBACTION_PERMALOCK = 3;
	private static final int SUBACTION_KILL = 4;
	private static final int SUBACTION_SET_ACCESS_PWD = 5;
	private static final int SUBACTION_SET_KILL_PWD = 6;

	private CheckBox[] chkAccess;
	private Button btnLock;
	private Button btnUnlock;
	private Button btnPermaLock;
	private Button btnKill;
	private Button btnSetAccessPassword;
	private Button btnSetKillPassword;


	private int mSubAction = SUBACTION_IDLE;
	private AlertDialog dialog;
	private Handler mHandler;

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_tag_access);
		dialog = new AlertDialog.Builder(this).
				setTitle("On progress").
				setMessage("Waiting Tag Memory").
				setPositiveButton("Stop", new DialogInterface.OnClickListener() {
					@Override
					public void onClick(DialogInterface dialog, int which) {
						getReader().stop();
					}
				}).
				create();
		ActionBar actionBar = getActionBar();
		if(actionBar != null) {
			actionBar.setDisplayOptions(ActionBar.DISPLAY_SHOW_CUSTOM);
			actionBar.setCustomView(R.layout.activity_title);
			actionBar.setDisplayHomeAsUpEnabled(true);
			actionBar.setDisplayShowHomeEnabled(true);
		}
		TextView titleText = (TextView)findViewById(R.id.title_text);
		titleText.setText(R.string.lock_memory_name);
		final int version = Build.VERSION.SDK_INT;
		if(version >= Build.VERSION_CODES.M)
			titleText.setTextColor(getColor(getApplicationContext(), R.color.black));

		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. onCreate()");


		mHandler = new Handler();

		// Initialize Widget
		initWidgets();

		InitTask task = new InitTask(this);
		task.execute();
//		// Initialize Mask
//		initMask();
//
//		resetActionResult();
//
//		setMask(getMask());
//
//		// Enable action widget
//		enableActionWidgets(true);
//
//		outputMessage(R.string.access_intro_message);
//		mSubAction = SUBACTION_IDLE;
	}

	@Override
	protected void onDestroy() {

		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. onDestroy()");

		// Destroy Reader
		destroyReader();

		super.onDestroy();
	}

	@Override
	protected void onStart() {
		super.onStart();
		new Thread(mLoadOptionOnStart).start();
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. onStart()");
	}

	@Override
	protected void onStop() {
		


		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. onStart()");
		super.onStop();
	}
	
	@Override
	protected void onResume() {
		super.onResume();
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. onResume()");
	}
	private Runnable mLoadOptionOnStart = new Runnable() {
		@Override
		public void run() {
			createReader();
			initReader();
			mHandler.post(new Runnable() {
				@Override
				public void run() {
					enableActionWidgets(true);
				}
			});
		}
	};
	@Override
	protected void onPause() {
		if(getReader().getAction() == AsReaderP252BActionState.Lock || getReader().getAction() == AsReaderP252BActionState.Unlock ||
				getReader().getAction() == AsReaderP252BActionState.PermaLock || getReader().getAction() == AsReaderP252BActionState.Kill)
			getReader().stop();

		// Rollback Mask
		exitMask();
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. onPause()");
		super.onPause();
	}

	@Override
	public void onClick(View v) {

		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. onClick(%s)", ResUtil.getId(v.getId()));

		switch (v.getId()) {
		case R.id.action_lock:
			if (getReader().getAction() == AsReaderP252BActionState.Stop) {
				lockTag();
			} else {
				mSubAction = SUBACTION_IDLE;
				stopAction();
			}
			break;
		case R.id.action_unlock:
			if (getReader().getAction() == AsReaderP252BActionState.Stop) {
				unlockTag();
			} else {
				mSubAction = SUBACTION_IDLE;
				stopAction();
			}
			break;
		case R.id.action_perma_lock:
			if (getReader().getAction() == AsReaderP252BActionState.Stop) {
				permaLockTag();
			} else {
				mSubAction = SUBACTION_IDLE;
				stopAction();
			}
			break;
		case R.id.action_kill:
			if (getReader().getAction() == AsReaderP252BActionState.Stop) {
				killTag();
			} else {
				mSubAction = SUBACTION_IDLE;
				stopAction();
			}
			break;
		case R.id.action_access_password:
			if (getReader().getAction() == AsReaderP252BActionState.Stop) {
				setAccessPassword();
			} else {
				mSubAction = SUBACTION_IDLE;
				stopAction();
			}
			break;
		case R.id.action_kill_password:
			if (getReader().getAction() == AsReaderP252BActionState.Stop) {
				setKillPassword();
			} else {
				mSubAction = SUBACTION_IDLE;
				stopAction();
			}
			break;
		}
		super.onClick(v);
	}

	@Override
	public void onReadBarcode(AsReaderP252B reader, AsReaderP252BBarcodeType type, String barcode) {
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "EVENT. onReadBarcode (%s, [%s])", type, barcode);
	}

	@Override
	public void onReadBarcode(AsReaderP252B reader, AsReaderP252BBarcodeType type, byte[] barcodeData) {
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "EVENT. onReadBarcode (%s, [%s])", type, barcodeData);
	}

	@Override
	public void onActionChanged(AsReaderP252B reader, AsReaderP252BActionState action) {
		AsReaderP252BLog.d(TAG, AsReaderP252BLog.DEBUG, "EVENT. onActionChanged(%s)", action);
		enableActionWidgets(true);
		if (action == AsReaderP252BActionState.Stop) {
			if (dialog != null && dialog.isShowing()) {
				dialog.hide();
			}
			mSubAction = SUBACTION_IDLE;
			if (!isActionResult()) {
				outputMessage(R.string.access_intro_message);
			}
		} else {
			if (dialog.isShowing()) {
				dialog.hide();
			}
			dialog.show();
		}
	}

	@Override
	public void onAccessResult(AsReaderP252B reader, AsReaderP252BResultCode code, AsReaderP252BActionState action, String epc, String data,
							   float rssi, float phase, float frequency) {
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "EVENT. onAccessResult(%s, %s, [%s], [%s], %.2f, %.2f)", code, action, epc == null ? "" : epc,
				data == null ? "" : data, rssi, phase);
		if (dialog.isShowing()) {
			dialog.hide();
		}
		setActionResult();

		if (code != AsReaderP252BResultCode.NoError) {
			outputFailMessage(code.toString());
			return;
		}

		if(epc != null)
			outputSelection(epc.length() > 4 ? epc.substring(4) : epc);

		outputSuccessMessage(R.string.access_success);
		setRssi(rssi, phase, frequency);
		mSubAction = SUBACTION_IDLE;
	}

	@Override
	public void onReadTemperatureTag(AsReaderP252B reader, AsReaderP252BActionState action, String tag, float rssi, float phase, float frequency, float temperature) {

	}

	@Override
	public void onReadHumidityTag(AsReaderP252B reader, AsReaderP252BActionState action, String tag, float rssi, float phase, float frequency, float humidity) {

	}

	@Override
	public void onReceivedData(byte[] data) {

	}

	@Override
	public boolean onModeKeyEvent(AsReaderP252B reader, AsReaderP252BKeyState state) {
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "EVENT. onModeKeyEvent [%s]", state);
		return false;
	}

	@Override
	public boolean onKeyEvent(AsReaderP252B reader, AsReaderP252BKeyState state) {
		return false;
	}

	// Lock Tag
	private void lockTag() {
		mSubAction = SUBACTION_LOCK;
		clearWidgets();
		enableActionWidgets(false);
		outputSelection("");
		outputMessage(R.string.access_lock_message);

		resetActionResult();

		AsReaderP252BLockParam param = new AsReaderP252BLockParam(chkAccess[KILL_PASSWORD].isChecked(), chkAccess[ACCESS_PASSWORD].isChecked(),
				chkAccess[EPC].isChecked(), chkAccess[TID].isChecked(), chkAccess[USER].isChecked());

		String password = getAccessPassword();
		try {
			getReader().setAccessPassword(password);
		} catch (AsReaderP252BException e) {
			AsReaderP252BLog.e(TAG, "ERROR. lockTag() - Failed to set password [%s]", password);
		}

		int time = getOperationTime();
		try {
			getReader().setOperationTime(time);
		} catch (AsReaderP252BException e) {
			AsReaderP252BLog.e(TAG, e, "ERROR. lockTag() - Failed to set operation time [%d]", time);
		}

		AsReaderP252BResultCode res;
		if ((res = getReader().lock(param)) != AsReaderP252BResultCode.NoError) {
			AsReaderP252BLog.e(TAG, "ERROR. lockTag() - Failed to start lock tag [%s]", param);
			String msg = String.format(Locale.US, "%s : 0x%04X", res.toString(), res.getCode());
			Toast.makeText(this, msg, Toast.LENGTH_SHORT).show();
			enableActionWidgets(true);
			outputFailMessage(R.string.access_fail_lock_message);
			return;
		}
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. lockTag()");
	}

	// Unlock Tag
	private void unlockTag() {
		mSubAction = SUBACTION_UNLOCK;
		clearWidgets();
		enableActionWidgets(false);
		outputSelection("");
		outputMessage(R.string.access_unlock_message);

		resetActionResult();

		AsReaderP252BLockParam param = new AsReaderP252BLockParam(chkAccess[KILL_PASSWORD].isChecked(), chkAccess[ACCESS_PASSWORD].isChecked(),
				chkAccess[EPC].isChecked(), chkAccess[TID].isChecked(), chkAccess[USER].isChecked());

		String password = getAccessPassword();
		try {
			getReader().setAccessPassword(password);
		} catch (AsReaderP252BException e) {
			AsReaderP252BLog.e(TAG, e, "ERROR. unlockTag() - Failed to set password [%s]", password);
		}

		int time = getOperationTime();
		try {
			getReader().setOperationTime(time);
		} catch (AsReaderP252BException e) {
			AsReaderP252BLog.e(TAG, e, "ERROR. unlockTag() - Failed to set operation time [%d]", time);
		}

		AsReaderP252BResultCode res;
		if ((res = getReader().unlock(param)) != AsReaderP252BResultCode.NoError) {
			AsReaderP252BLog.e(TAG, "ERROR. unlockTag() - Failed to start lock tag [%s]", param);
			String msg = String.format(Locale.US, "%s : 0x%04X", res.toString(), res.getCode());
			Toast.makeText(this, msg, Toast.LENGTH_SHORT).show();
			enableActionWidgets(true);
			outputFailMessage(R.string.access_fail_unlock_message);
			return;
		}
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. unlockTag()");
	}

	// PermaLock Tag
	private void permaLockTag() {
		mSubAction = SUBACTION_PERMALOCK;
		clearWidgets();
		enableActionWidgets(false);
		outputSelection("");
		outputMessage(R.string.access_perma_lock_message);

		resetActionResult();

		AsReaderP252BLockParam param = new AsReaderP252BLockParam(chkAccess[KILL_PASSWORD].isChecked(), chkAccess[ACCESS_PASSWORD].isChecked(),
				chkAccess[EPC].isChecked(), chkAccess[TID].isChecked(), chkAccess[USER].isChecked());

		String password = getAccessPassword();
		try {
			getReader().setAccessPassword(password);
		} catch (AsReaderP252BException e) {
			AsReaderP252BLog.e(TAG, "ERROR. permaLockTag() - Failed to set password [%s]", password);
		}

		int time = getOperationTime();
		try {
			getReader().setOperationTime(time);
		} catch (AsReaderP252BException e) {
			AsReaderP252BLog.e(TAG, e, "ERROR. permaLockTag() - Failed to set operation time [%d]", time);
		}

		AsReaderP252BResultCode res;
		if ((res = getReader().permaLock(param)) != AsReaderP252BResultCode.NoError) {
			AsReaderP252BLog.e(TAG, "ERROR. permaLockTag() - Failed to start lock tag [%s]", param);
			String msg = String.format(Locale.US, "%s : 0x%04X", res.toString(), res.getCode());
			Toast.makeText(this, msg, Toast.LENGTH_SHORT).show();
			enableActionWidgets(true);
			outputFailMessage(R.string.access_fail_perma_lock_message);
			return;
		}
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. permaLockTag()");
	}

	// Kill Tag
	private void killTag() {

		enableActionWidgets(false);
		final PasswordDialog dlg = new PasswordDialog(this, R.string.kill_password);
		dlg.setResultListener(new IDialogResultListener() {

			@Override
			public void onOkClick(int what, DialogInterface dialog) {
				mSubAction = SUBACTION_KILL;
				String password = dlg.getPassword();

				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. killTag().onOkClick() - [%s]", password);

				clearWidgets();
				outputSelection("");
				outputMessage(R.string.access_kill_message);

				resetActionResult();

				int time = getOperationTime();

				try {
					getReader().setOperationTime(time);
				} catch (AsReaderP252BException e) {
					AsReaderP252BLog.e(TAG, e, "ERROR. killTag().onOkClick() - Failed to set operation time [%d]", time);
				}

				AsReaderP252BResultCode res;
				if ((res = getReader().kill(password)) != AsReaderP252BResultCode.NoError) {
					AsReaderP252BLog.e(TAG, "ERROR. killTag().onOkClick() - Failed to start kill tag [%s]", password);
					String msg = String.format(Locale.US, "%s : 0x%04X", res.toString(), res.getCode());
					Toast.makeText(TagAccessActivity.this, msg, Toast.LENGTH_SHORT).show();
					enableActionWidgets(true);
					outputFailMessage(R.string.access_fail_kill_message);
				}
			}

			@Override
			public void onCancelClick(int what, DialogInterface dialog) {
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. killTag().onCancelClick()");
				enableActionWidgets(true);
			}

		});
		dlg.show();
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. killTag()");
	}

	// Set Access Password
	private void setAccessPassword() {
		enableActionWidgets(false);
		final PasswordDialog dlg = new PasswordDialog(this, R.string.set_access_password_title);
		dlg.setResultListener(new IDialogResultListener() {

			@Override
			public void onOkClick(int what, DialogInterface dialog) {
				mSubAction = SUBACTION_SET_ACCESS_PWD;
				String password = dlg.getPassword();
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. setAccessPassword().onOkClick() - [%s]", password);

				clearWidgets();
				outputSelection("");
				outputMessage(R.string.access_set_access_password_message);

				resetActionResult();

				String accessPwd = getAccessPassword();
				try {
					getReader().setAccessPassword(accessPwd);
				} catch (AsReaderP252BException e) {
					AsReaderP252BLog.e(TAG, "ERROR. setAccessPassword().onOkClick() - Failed to set password [%s]", accessPwd);
				}

				int time = getOperationTime();

				try {
					getReader().setOperationTime(time);
				} catch (AsReaderP252BException e) {
					AsReaderP252BLog.e(TAG, e, "ERROR. setAccessPassword().onOkClick() - Failed to set operation time [%d]", time);
				}

				if (getReader().writeMemory(AsReaderP252BMemoryBank.Reserved, 2, password) != AsReaderP252BResultCode.NoError) {
					AsReaderP252BLog.e(TAG, "ERROR. setAccessPassword().onOkClick() - Failed to start write access password [%s]",
							password);
					enableActionWidgets(true);
					outputFailMessage(R.string.access_fail_set_access_password_message);
				}
			}

			@Override
			public void onCancelClick(int what, DialogInterface dialog) {
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. setAccessPassword().onCancelClick()");
				enableActionWidgets(true);
			}

		});
		dlg.show();
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. setAccessPassword()");
	}

	// Set Kill Password
	private void setKillPassword() {
		enableActionWidgets(false);
		final PasswordDialog dlg = new PasswordDialog(this, R.string.set_kill_password_title);
		dlg.setResultListener(new IDialogResultListener() {

			@Override
			public void onOkClick(int what, DialogInterface dialog) {
				mSubAction = SUBACTION_SET_KILL_PWD;
				String password = dlg.getPassword();
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. setKillPassword().onOkClick() - [%s]", password);

				clearWidgets();
				outputSelection("");
				outputMessage(R.string.access_set_kill_password_message);

				resetActionResult();

				String accessPwd = getAccessPassword();
				try {
					getReader().setAccessPassword(accessPwd);
				} catch (AsReaderP252BException e) {
					AsReaderP252BLog.e(TAG, e, "ERROR. setKillPassword() - Failed to set password [%s]", accessPwd);
				}

				int time = getOperationTime();

				try {
					getReader().setOperationTime(time);
				} catch (AsReaderP252BException e) {
					AsReaderP252BLog.e(TAG, e, "ERROR. setKillPassword() - Failed to set operation time [%d]", time);
				}

				if (getReader().writeMemory(AsReaderP252BMemoryBank.Reserved, 0, password) != AsReaderP252BResultCode.NoError) {
					AsReaderP252BLog.e(TAG, "ERROR. setKillPassword() - Failed to start write kill password [%s]", password);
					enableActionWidgets(true);
					outputFailMessage(R.string.access_fail_set_kill_password_message);
				}
			}

			@Override
			public void onCancelClick(int what, DialogInterface dialog) {
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. setKillPassword().onCancelClick()");
				enableActionWidgets(true);
			}

		});
		dlg.show();
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. setKillPassword()");
	}

	// Initialize Reader
	@Override
	protected void initReader() {
		super.initReader();
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. initReader()");
	}

	// Initialize Widgets
	protected void initWidgets() {
		super.initWidgets();

		ScrollView scrlParams = (ScrollView) findViewById(R.id.lock_params);
		scrlParams.setBackgroundColor(getColor(getApplicationContext(), R.color.message_background));

		int[] ids = new int[] { R.id.kill_password, R.id.access_password, R.id.epc, R.id.tid, R.id.user };
		chkAccess = new CheckBox[MAX_ACCESS];

		for (int i = 0; i < MAX_ACCESS; i++) {
			chkAccess[i] = (CheckBox) findViewById(ids[i]);
		}
		// Lock Button
		btnLock = (Button) findViewById(R.id.action_lock);
		btnLock.setOnClickListener(this);
		// Unlock Button
		btnUnlock = (Button) findViewById(R.id.action_unlock);
		btnUnlock.setOnClickListener(this);
		// PermaLock Button
		btnPermaLock = (Button) findViewById(R.id.action_perma_lock);
		btnPermaLock.setOnClickListener(this);
		// Kill Button
		btnKill = (Button) findViewById(R.id.action_kill);
		btnKill.setOnClickListener(this);
		// Set Access Password Button
		btnSetAccessPassword = (Button) findViewById(R.id.action_access_password);
		btnSetAccessPassword.setOnClickListener(this);
		// Set Kill Password Button
		btnSetKillPassword = (Button) findViewById(R.id.action_kill_password);
		btnSetKillPassword.setOnClickListener(this);

		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. initWidgets()");
	}

	private boolean isEnabledWidget(boolean enabled, AsReaderP252BActionState state, int subAction) {
		AsReaderP252BActionState action = getReader().getAction();
		return enabled ? (action == AsReaderP252BActionState.Stop ? enabled
				: (action == state ? (mSubAction == subAction ? enabled : false) : false)) : enabled;
	}

	// Enable/Disable Action Widgets
	protected void enableActionWidgets(boolean enabled) {
		super.enableActionWidgets(enabled);

		for (int i = 0; i < MAX_ACCESS; i++) {
			chkAccess[i].setEnabled(isEnabledWidget(enabled));
		}
		btnLock.setEnabled(isEnabledWidget(enabled, AsReaderP252BActionState.Lock, SUBACTION_LOCK));
		btnUnlock.setEnabled(isEnabledWidget(enabled, AsReaderP252BActionState.Lock, SUBACTION_UNLOCK));
		btnPermaLock.setEnabled(isEnabledWidget(enabled, AsReaderP252BActionState.Lock, SUBACTION_PERMALOCK));
		btnKill.setEnabled(isEnabledWidget(enabled, AsReaderP252BActionState.Kill, SUBACTION_KILL));
		btnSetAccessPassword.setEnabled(isEnabledWidget(enabled, AsReaderP252BActionState.WriteMemory, SUBACTION_SET_ACCESS_PWD));
		btnSetKillPassword.setEnabled(isEnabledWidget(enabled, AsReaderP252BActionState.WriteMemory, SUBACTION_SET_KILL_PWD));
		if (enabled) {
			switch (getReader().getAction()) {
			case Lock:
				switch (mSubAction) {
				case SUBACTION_LOCK:
					btnLock.setText(R.string.action_stop);
					btnUnlock.setText(R.string.action_unlock_tag);
					btnPermaLock.setText(R.string.action_perma_lock_tag);
					btnKill.setText(R.string.action_kill_tag);
					btnSetAccessPassword.setText(R.string.set_access_password);
					btnSetKillPassword.setText(R.string.set_kill_password);
					break;
				case SUBACTION_UNLOCK:
					btnLock.setText(R.string.action_lock_tag);
					btnUnlock.setText(R.string.action_stop);
					btnPermaLock.setText(R.string.action_perma_lock_tag);
					btnKill.setText(R.string.action_kill_tag);
					btnSetAccessPassword.setText(R.string.set_access_password);
					btnSetKillPassword.setText(R.string.set_kill_password);
					break;
				case SUBACTION_PERMALOCK:
					btnLock.setText(R.string.action_lock_tag);
					btnUnlock.setText(R.string.action_unlock_tag);
					btnPermaLock.setText(R.string.action_stop);
					btnKill.setText(R.string.action_kill_tag);
					btnSetAccessPassword.setText(R.string.set_access_password);
					btnSetKillPassword.setText(R.string.set_kill_password);
					break;
				}
				break;
			case Kill:
				if (mSubAction == SUBACTION_KILL) {
					btnLock.setText(R.string.action_lock_tag);
					btnUnlock.setText(R.string.action_unlock_tag);
					btnPermaLock.setText(R.string.action_perma_lock_tag);
					btnKill.setText(R.string.action_stop);
					btnSetAccessPassword.setText(R.string.set_access_password);
					btnSetKillPassword.setText(R.string.set_kill_password);
				}
				break;
			case WriteMemory:
				btnLock.setText(R.string.action_lock_tag);
				btnUnlock.setText(R.string.action_unlock_tag);
				btnPermaLock.setText(R.string.action_perma_lock_tag);
				btnKill.setText(R.string.action_kill_tag);
				switch (mSubAction) {
				case SUBACTION_SET_ACCESS_PWD:
					btnSetAccessPassword.setText(R.string.action_stop);
					btnSetKillPassword.setText(R.string.set_kill_password);
					break;
				case SUBACTION_SET_KILL_PWD:
					btnSetAccessPassword.setText(R.string.set_access_password);
					btnSetKillPassword.setText(R.string.action_stop);
					break;
				}
				break;
			case Stop:
				btnLock.setText(R.string.action_lock_tag);
				btnUnlock.setText(R.string.action_unlock_tag);
				btnPermaLock.setText(R.string.action_perma_lock_tag);
				btnKill.setText(R.string.action_kill_tag);
				btnSetAccessPassword.setText(R.string.set_access_password);
				btnSetKillPassword.setText(R.string.set_kill_password);
				break;
			case Inventory:
				break;
			case PermaLock:
				break;
			case ReadMemory:
				break;
			case Unlock:
				break;
			default:
				break;
			}
		}
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. enableActionWidgets(%s)", enabled);
	}

	private static class InitTask extends AsyncTask<Void, Void, Boolean> {
		private final WeakReference<TagAccessActivity> mActivity;

		InitTask(TagAccessActivity activity) {
			mActivity = new WeakReference<>(activity);
		}

		@Override
		protected void onPreExecute() {
			TagAccessActivity activity = mActivity.get();
			WaitDialog.show(activity, R.string.init_mask);
			super.onPreExecute();
		}

		@Override
		protected Boolean doInBackground(Void... params) {
			TagAccessActivity activity = mActivity.get();
			// Initialize Mask
			activity.initMask();
			
			return true;
		}
		
		@Override
		protected void onPostExecute(Boolean result) {
			TagAccessActivity activity = mActivity.get();

			activity.resetActionResult();

			activity.setMask(activity.getMask());

			// Enable action widget
			activity.enableActionWidgets(true);

			activity.outputMessage(R.string.access_intro_message);
			activity.mSubAction = SUBACTION_IDLE;
			WaitDialog.hide();
			super.onPostExecute(result);
		}
	}
}
