package com.asreader.app.rfid.view;

import android.app.ActionBar;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.util.Xml;
import android.view.KeyEvent;
import android.view.MenuItem;
import android.view.View;
import android.widget.Button;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;

import com.asreader.app.rfid.MainActivity;
import com.asreader.app.rfid.R;
import com.asreader.p252b.AsReaderP252B;
import com.asreader.p252b.barcode.AsReaderP252BBarcodeType;
import com.asreader.p252b.device.type.AsReaderP252BConnectionState;
import com.asreader.p252b.device.type.AsReaderP252BKeyState;
import com.asreader.p252b.diagnostics.AsReaderP252BLog;
import com.asreader.p252b.rfid.exception.AsReaderP252BException;
import com.asreader.p252b.rfid.type.AsReaderP252BActionState;
import com.asreader.p252b.rfid.type.AsReaderP252BResultCode;
import com.dinuscxj.progressbar.CircleProgressBar;

import org.xmlpull.v1.XmlPullParser;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.concurrent.Executors;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

import support.andro.app.rfid.view.base.RfidActivity;

class RFIDMyX509TrustManager implements X509TrustManager {

    @Override
    public void checkClientTrusted(X509Certificate certificates[], String authType) throws CertificateException {
    }

    @Override
    public void checkServerTrusted(X509Certificate[] ax509certificate, String s) throws CertificateException {
        if (ax509certificate == null){
            throw new IllegalArgumentException("X509Certificate array is null");
        }
        if (!(ax509certificate.length > 0)){
            throw new IllegalArgumentException("X509Certificate is empty");
        }
        if (!(null != s && s.toLowerCase().contains("RSA".toLowerCase()))) {
            throw new CertificateException("AuthType is not RSA");
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        // TODO Auto-generated method stub
        return null;
    }
}

class RFIDFirmwareInfo extends Object {
    public String firmwareVersion;
    public String firmwareName;
    public String firmwareMode;

    public RFIDFirmwareInfo() {
    }

    public RFIDFirmwareInfo(String firmwareName) {
        this.firmwareName = firmwareName;
    }

    public RFIDFirmwareInfo(String firmwareVersion, String firmwareName, String firmwareMode) {
        this.firmwareVersion = firmwareVersion;
        this.firmwareName = firmwareName;
        this.firmwareMode = firmwareMode;
    }

    public String getFirmwareVersion() {
        return firmwareVersion;
    }

    public void setFirmwareVersion(String firmwareVersion) {
        this.firmwareVersion = firmwareVersion;
    }

    public String getFirmwareName() {
        return firmwareName;
    }

    public void setFirmwareName(String firmwareName) {
        this.firmwareName = firmwareName;
    }

    public String getFirmwareMode() {
        return firmwareMode;
    }

    public void setFirmwareMode(String firmwareMode) {
        this.firmwareMode = firmwareMode;
    }
}

public class RFIDUpdateFirmwareActivity extends RfidActivity {

    private static final String TAG = MainActivity.class.getSimpleName();

    protected static final String PATH = "https://camera.asreaderapps.com/mrxapp/AsReacher/fw/";
    protected static final String XML = "RFIDModule.xml";
    protected static final int TIME_OUT = 3000;
    private ListView lv_news;
    private boolean clearStatus;
    private Button btnUpdate;
    private CircleProgressBar line_progress;
    private Button btnRefresh;
    //    private TextView textView;
    private RFIDUpdateFirmwareListViewAdapter lvAdapter;
    private String filePath;

    private static final String commandEnd = "\r\n";

    private static com.asreader.app.rfid.view.RFIDFirmwareInfo currentUpdateInfo;

    private final int PACKET = 256;

    private static UpdateFirmwareTask updateFirmwareTask;

    private AlertDialog.Builder warningDialog;


    @Override
    public void onStateChanged(AsReaderP252B reader, AsReaderP252BConnectionState state) {
        super.onStateChanged(reader, state);
    }

    @Override
    public void onReadBarcode(AsReaderP252B reader, AsReaderP252BBarcodeType type, String barcode) {
        AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "EVENT. onReadBarcode (%s, [%s])", type, barcode);
    }

    @Override
    public void onReadBarcode(AsReaderP252B reader, AsReaderP252BBarcodeType type, byte[] barcodeData) {
        AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "EVENT. onReadBarcode (%s, [%s])", type, barcodeData);
    }

    @Override
    public void onActionChanged(AsReaderP252B reader, AsReaderP252BActionState action) {
        super.onActionChanged(reader, action);
    }

    @Override
    public void onReadTag(AsReaderP252B reader, AsReaderP252BActionState action, String tag, float rssi, float phase, float frequency) {

    }

    @Override
    public void onAccessResult(AsReaderP252B reader, AsReaderP252BResultCode code, AsReaderP252BActionState action, String epc, String data, float rssi, float phase, float frequency) {

    }

    @Override
    public void onReadTemperatureTag(AsReaderP252B reader, AsReaderP252BActionState action, String tag, float rssi, float phase, float frequency, float temperature) {

    }

    @Override
    public void onReadHumidityTag(AsReaderP252B reader, AsReaderP252BActionState action, String tag, float rssi, float phase, float frequency, float humidity) {

    }

    @Override
    public boolean onModeKeyEvent(AsReaderP252B reader, AsReaderP252BKeyState state) {
        AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "EVENT. onModeKeyEvent [%s]", state);
        return false;
    }

    @Override
    public boolean onKeyEvent(AsReaderP252B reader, AsReaderP252BKeyState state) {
        return super.onKeyEvent(reader, state);
    }

    @Override
    public void onReceivedData(byte[] data) {

    }

    Handler progressHandler = new Handler() {
        public void handleMessage(Message msg) {
            line_progress.setProgress(msg.what);
        }

        ;
    };

    private Handler xmlHandler = new Handler() {
        @Override
        public void handleMessage(Message msg) {
            enableOrDisableComponent(true);
            switch (msg.what) {
                case RESULT_OK:
                    List<RFIDFirmwareInfo> list = (List<RFIDFirmwareInfo>) msg.obj;
                    lvAdapter.setList(list);
                    break;
                case RESULT_CANCELED:
                    Log.d("tag", "RESULT_CANCELED");
                    break;
                default:
                    break;
            }
        }
    };

    private Handler downloadHandler = new Handler() {
        @Override
        public void handleMessage(Message msg) {
            enableOrDisableComponent(true);
            switch (msg.what) {
                case RESULT_OK:
                    if (updateFirmwareTask != null) {
                        updateFirmwareTask.cancel(true);
                        updateFirmwareTask = null;
                        try {
                            Thread.sleep(500);
                        } catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    updateFirmwareTask = new UpdateFirmwareTask();
                    updateFirmwareTask.execute(currentUpdateInfo.firmwareName);
                    break;
                case RESULT_CANCELED:
                    Toast.makeText(com.asreader.app.rfid.view.RFIDUpdateFirmwareActivity.this, msg.obj.toString(), Toast.LENGTH_SHORT).show();
                    break;
                default:
                    break;
            }
        }
    };

    private Handler updateHandler = new Handler() {
        @Override
        public void handleMessage(Message msg) {
            enableOrDisableComponent(true);
            line_progress.setVisibility(View.GONE);
            switch (msg.what) {
                case RESULT_OK:
                    Toast.makeText(com.asreader.app.rfid.view.RFIDUpdateFirmwareActivity.this, msg.obj.toString(), Toast.LENGTH_SHORT).show();
                    break;
                case RESULT_CANCELED:
                    Toast.makeText(com.asreader.app.rfid.view.RFIDUpdateFirmwareActivity.this, msg.obj.toString(), Toast.LENGTH_SHORT).show();
                    if(lvAdapter != null && lvAdapter.getCount() > 0 && lvAdapter.getCurrentCheckBoxState()) {
                        enableOrDisableUpdateButton(true);
                    }
                    break;
                default:
                    break;
            }
        }
    };

    private Handler clearHandler = new Handler() {
        @Override
        public void handleMessage(Message msg) {
            ActionBar actionBar = getActionBar();
            switch (msg.what) {
                case RESULT_OK:
                    clearStatus = true;
                    if(actionBar != null) {
                        actionBar.setHomeButtonEnabled(false);
                    }
                    break;
                case RESULT_CANCELED:
                    clearStatus = false;
                    if(actionBar != null) {
                        actionBar.setHomeButtonEnabled(true);
                    }
                    break;
                default:
                    break;
            }
        }
    };

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        clearStatus = false;
        ActionBar actionBar = getActionBar();
        if(actionBar != null) {
            actionBar.setDisplayOptions(ActionBar.DISPLAY_SHOW_CUSTOM);
            actionBar.setCustomView(R.layout.activity_title);
            actionBar.setDisplayHomeAsUpEnabled(true);
            actionBar.setDisplayShowHomeEnabled(true);
        }
        TextView titleText = (TextView)findViewById(R.id.title_text);
        titleText.setText(R.string.rfidupdate_firmware);
        titleText.setTextColor(getColor(getApplicationContext(), R.color.black));

        lvAdapter = new RFIDUpdateFirmwareListViewAdapter(this);
        filePath = getApplicationContext().getFilesDir().getAbsolutePath() + "/UpdateFile/";
        setContentView(R.layout.activity_rfid_update_firmware);
        lv_news = (ListView) findViewById(R.id.lv_news);
        lv_news.setAdapter(lvAdapter);
        btnUpdate = (Button) findViewById(R.id.btn_update_firmware);
        btnUpdate.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (currentUpdateInfo == null) return;
                DownloadFile(PATH + currentUpdateInfo.firmwareName, filePath + currentUpdateInfo.firmwareName);
            }
        });
        line_progress = (CircleProgressBar) findViewById(R.id.custom_progress);
        btnRefresh = (Button) findViewById(R.id.btn_refresh);
        btnRefresh.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if(lvAdapter != null && lvAdapter.getCount() > 0) {
                    lvAdapter.clearCurrentCheckBoxChecked();
                }
                readNews();
            }
        });
//        clear_View = (View) findViewById(R.id.clearRFIDViewID);
//        clear_View.setVisibility(View.GONE);
        this.createReader();
        readNews();
    }

    @Override
    protected void onDestroy() {
        AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. onDestroy()");
        // Destroy Reader
        destroyReader();
        super.onDestroy();
    }

    private void enableOrDisableComponent(boolean flag) {
        lvAdapter.setEnableFlag(flag);
        btnRefresh.setEnabled(flag);
    }

    private void enableOrDisableUpdateButton(boolean flag) {
        btnUpdate.setEnabled(flag);
        btnUpdate.setClickable(flag);
        btnUpdate.setFocusable(flag);
    }

    @Override
    protected void initReader() {

    }

    private void initDialog() {
        warningDialog = new AlertDialog.Builder(RFIDUpdateFirmwareActivity.this);
        warningDialog.setTitle("Tip");
        warningDialog.setMessage(getResources().getString(R.string.dialog_update_firmware_version_warning));
        warningDialog.setPositiveButton("OK", new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                finish();
            }
        });
        warningDialog.setCancelable(false);
        warningDialog.create();
        warningDialog.show();
    }
    public void readNews() {
        ///
        enableOrDisableComponent(false);
        new Thread(new Runnable() {
            @Override
            public void run() {
                try {
                    URL url = new URL(PATH + XML);
                    SSLContext sslcontext = SSLContext.getInstance("SSL");
                    sslcontext.init(null, new TrustManager[]{new com.asreader.app.rfid.view.RFIDMyX509TrustManager()}, new java.security.SecureRandom());
                    HostnameVerifier ignoreHostnameVerifier = new HostnameVerifier() {
                        public boolean verify(String s, SSLSession sslsession) {
                            if (s.equals("camera.asreaderapps.com")) {
                                return true;
                            } else {
                                return false;
                            }
                        }
                    };
                    HttpsURLConnection.setDefaultHostnameVerifier(ignoreHostnameVerifier);
                    HttpsURLConnection.setDefaultSSLSocketFactory(sslcontext.getSocketFactory());

                    HttpURLConnection conn = (HttpURLConnection) url.openConnection();
                    conn.setRequestMethod("GET");
                    conn.setReadTimeout(TIME_OUT);
                    conn.connect();
                    int responseCode = conn.getResponseCode();
                    if (responseCode == 200) {
                        InputStream is = conn.getInputStream();
                        List<RFIDFirmwareInfo> items = parserXML(is);

                        xmlHandler.obtainMessage(RESULT_OK, items).sendToTarget();
                    } else {
                        xmlHandler.obtainMessage(RESULT_CANCELED, "List download failed").sendToTarget();
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                    xmlHandler.obtainMessage(RESULT_CANCELED, "List download failed").sendToTarget();
                }
            }
        }).start();
    }

    protected List<RFIDFirmwareInfo> parserXML(InputStream is) throws Exception {

        XmlPullParser parser = Xml.newPullParser();
        parser.setInput(is, "utf-8");
        List<RFIDFirmwareInfo> list = null;
        com.asreader.app.rfid.view.RFIDFirmwareInfo item = null;
        int event = -1;
        while ((event = parser.next()) != XmlPullParser.END_DOCUMENT) {
            String tagName = parser.getName();
            if (event == XmlPullParser.START_TAG) {
                if ("P23_Fw".equals(tagName)) {
                    list = new ArrayList<RFIDFirmwareInfo>();
                } else if ("Fw".equals(tagName)) {
                    item = new com.asreader.app.rfid.view.RFIDFirmwareInfo();
                    item.firmwareMode = parser.getAttributeValue(null, "status").trim();
                } else if ("FwFileName".equals(tagName)) {
                    item.firmwareName = parser.nextText().trim();
                } else if ("Version".equals(tagName)) {
                } else if ("Version".equals(tagName)) {
                    item.firmwareVersion = parser.nextText().trim();
                }

            } else if (event == XmlPullParser.END_TAG) {
                if ("Fw".equals(tagName)) {
                    list.add(item);
                }
            }
        }
        return list;
    }

    private class UpdateFirmwareTask extends AsyncTask<String, Integer, String> {

        // 方法1：onPreExecute（）
        // 作用：执行 线程任务前的操作
        @Override
        protected void onPreExecute() {
            enableOrDisableComponent(false);
            enableOrDisableUpdateButton(false);
            line_progress.setVisibility(View.VISIBLE);
            // 执行前显示提示
        }


        // 方法2：doInBackground（）
        // 作用：接收输入参数、执行任务中的耗时操作、返回 线程任务执行的结果
        // 此处通过计算从而模拟“加载进度”的情况
        @Override
        protected String doInBackground(String... fileName) {
            try {
                if (fileName[0] == null || fileName[0].equals("")) {
                    updateHandler.obtainMessage(RESULT_CANCELED, "update failed").sendToTarget();
                    return null;
                }
                byte[] sendData;
                File file = new File(filePath + fileName[0]);
                FileInputStream inStream = new FileInputStream(file);

                sendData = new byte[inStream.available()];
                inStream.read(sendData);

                double countPicket = Math.ceil((float) sendData.length / PACKET);
                byte[] sendFileData = {0x7E,0x77,0x7B,0x5A,0x00,0x01,0x04,0x01,0x00,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x7A,0x0D,0x0A};
                byte[] fd = getReader().sendData(sendFileData);
                String result = new String(fd, "ASCII");
                if (!result.equals("0000")) {
                    updateHandler.obtainMessage(RESULT_CANCELED, "update failed").sendToTarget();
                    return null;
                }
                clearHandler.obtainMessage(RESULT_OK, "").sendToTarget();
                publishProgress(0);
                for (int i = 0; i < countPicket; i++) {
                    int copyLength = sendData.length - PACKET * (1 + i) < 0 ? sendData.length - PACKET * i : PACKET;
                    if (copyLength <= 0) {
                        updateHandler.obtainMessage(RESULT_CANCELED, "update failed").sendToTarget();
                        clearHandler.obtainMessage(RESULT_CANCELED, "").sendToTarget();
                        return null;
                    }
                    byte[] itemData = new byte[copyLength];
                    System.arraycopy(sendData, i * PACKET, itemData, 0, copyLength);

                    byte[] itemHeader = {0x7E,0x77,0x5E,0x5A,0x00,0x01,0x04,0x01};
                    byte[] itemEnd = commandEnd.getBytes("ASCII");

                    final byte[] sendItemData = new byte[itemHeader.length + 2 + 4 + 2 + itemData.length + 2 + itemEnd.length];

                    System.arraycopy(itemHeader, 0, sendItemData, 0, itemHeader.length);

                    int length = 4 + 2 + itemData.length;

                    convertIntToByteArray(length, sendItemData, itemHeader.length, 2);

                    int index = i + 1;
                    sendItemData[itemHeader.length + 2 + 0] = (byte)((index&0xFF000000)>>24);
                    sendItemData[itemHeader.length + 2 + 1] = (byte)((index&0x00FF0000)>>16);
                    sendItemData[itemHeader.length + 2 + 2] = (byte)((index&0x0000FF00)>>8);
                    sendItemData[itemHeader.length + 2 + 3] = (byte)(index&0x000000FF);

                    convertIntToByteArray(itemData.length, sendItemData, itemHeader.length + 2 + 3 + 1, 2);


                    System.arraycopy(itemData, 0, sendItemData, itemHeader.length + 2 + 4 + 2, itemData.length);

                    byte[] crcData = new byte[4 + 2 + 4 + 2 + itemData.length];


                    System.arraycopy(sendItemData, 4, crcData, 0, crcData.length);

                    convertIntToByteArray(calculateCRC(crcData, (short)crcData.length), sendItemData, itemHeader.length + 2 + 4 + 2 + itemData.length, 2);

                    System.arraycopy(itemEnd, 0, sendItemData, itemHeader.length + 2 + 4 + 2 + itemData.length + 2, itemEnd.length);

                    publishProgress((int) (i / countPicket * 100));

                    byte[] resultByte = getReader().sendData(sendItemData);
                    String resultState = new String(resultByte, "ASCII");
                    if (!resultState.equals("0000")) {
                        updateHandler.obtainMessage(RESULT_CANCELED, "update failed").sendToTarget();
                        clearHandler.obtainMessage(RESULT_CANCELED, "").sendToTarget();
                        return null;
                    }
                }
                publishProgress(100);
                byte[] resultEND = {0x7E,0x77,0x7C,0x5A,0x00,0x01,0x04,0x01,0x00,0x06,(byte)0xFF,(byte)0xFF,(byte)0xFF,(byte)0xFF,0x00,0x00,(byte)0xB5,(byte)0xAA,0x0D,0x0A};
                byte[] resEnd = getReader().sendData(resultEND);
                String ENDStr = new String(resEnd, "ASCII");
                if (!ENDStr.equals("0000")) {
                    updateHandler.obtainMessage(RESULT_CANCELED, "update failed").sendToTarget();
                    clearHandler.obtainMessage(RESULT_CANCELED, "").sendToTarget();
                    return null;
                }
                byte[] resultRESET = {0x7E,0x77,0x7D,0x5A,0x00,0x01,0x01,0x0F,0x00,0x00,(byte)0xF0,(byte)0xD4,0x0D,0x0A};
                getReader().sendData(resultRESET);
                updateHandler.obtainMessage(RESULT_OK, "update success").sendToTarget();
                clearHandler.obtainMessage(RESULT_CANCELED, "").sendToTarget();
            } catch (AsReaderP252BException | UnsupportedEncodingException | FileNotFoundException e) {
                e.printStackTrace();
                updateHandler.obtainMessage(RESULT_CANCELED, "update failed").sendToTarget();
                clearHandler.obtainMessage(RESULT_CANCELED, "").sendToTarget();
            } catch (IOException e) {
                e.printStackTrace();
                updateHandler.obtainMessage(RESULT_CANCELED, "update failed").sendToTarget();
                clearHandler.obtainMessage(RESULT_CANCELED, "").sendToTarget();
            }
            return null;
        }

        // 方法3：onProgressUpdate（）
        // 作用：在主线程 显示线程任务执行的进度
        @Override
        protected void onProgressUpdate(Integer... progresses) {
            line_progress.setProgress(progresses[0]);
        }

        // 方法4：onPostExecute（）
        // 作用：接收线程任务执行结果、将执行结果显示到UI组件
        @Override
        protected void onPostExecute(String result) {
            // 执行完毕后，则更新UI
        }

        // 方法5：onCancelled()
        // 作用：将异步任务设置为：取消状态
        @Override
        protected void onCancelled() {
            line_progress.setProgress(0);
        }
    }

    public void onClickList(com.asreader.app.rfid.view.RFIDFirmwareInfo info) {
        currentUpdateInfo = info;
        if (info != null) btnUpdate.setEnabled(true);
        else enableOrDisableUpdateButton(false);
    }

    private void DownloadFile(final String url, final String filePath) {
        ///////
        enableOrDisableComponent(false);
        enableOrDisableUpdateButton(false);
        if (ConfirmFile(filePath)) {
            downloadHandler.obtainMessage(RESULT_OK, "download data success").sendToTarget();
            return;
        }

        Executors.newCachedThreadPool().execute(new Runnable() {
            @Override
            public void run() {
                try {
                    URL webUrl = new URL(url);
                    URLConnection con = webUrl.openConnection();    // 打开连接
                    int fileSize = con.getContentLength();//根据响应获取文件大小
                    if (fileSize <= 0) throw new RuntimeException("无法获知文件大小 ");

                    InputStream in = con.getInputStream();            // 获取InputStream
                    if (in == null) throw new RuntimeException("stream is null");

                    File f = new File(filePath);                    // 创建文件输出流
                    FileOutputStream fo = new FileOutputStream(f);

                    byte[] buffer = new byte[1024];
                    int len = 0;
                    int downLoadFileSize = 0;
                    while ((len = in.read(buffer)) > 0)        // 读取文件
                    {
                        fo.write(buffer, 0, len);            // 写入文件
                        downLoadFileSize += len;
                    }

                    in.close();

                    fo.flush();
                    fo.close();

                    downloadHandler.obtainMessage(RESULT_OK, "download data success").sendToTarget();
                } catch (Exception e) {
                    e.printStackTrace();
                    downloadHandler.obtainMessage(RESULT_CANCELED, "download data failed").sendToTarget();
                    File f = new File(filePath);

                    if (f.exists() && f.isFile()) {
                        if (!f.delete()) {
                            downloadHandler.obtainMessage(RESULT_CANCELED, "delete file failed").sendToTarget();
                        }
                    }
                }
            }
        });
    }

    /**
     * 创建目录和文件
     */
    private boolean ConfirmFile(String filePath) {
        boolean success = false;

        try {
            File f = new File(filePath);
            File parent = f.getParentFile();

            if (!parent.exists()) {
                parent.mkdirs();
                success = false;
            } else {
                success = true;
            }

            if (!f.exists()) {
                f.createNewFile();
                success = false;
            }

        } catch (Exception ex) {
            ex.printStackTrace();
        }
        return success;
    }

    //转十六进制
    public static String bytesToHexString(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (src == null || src.length <= 0) {
            return null;
        }
        for (int i = 0; i < src.length; i++) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }

    /**
     * This converts int value to byte array.
     *
     * @param number : int value
     * @param array  : destination byte array
     * @param index  : starting index
     * @param count  : count to convert
     */
    private static void convertIntToByteArray(int number, byte[] array, int index, int count) {
        int i;
        byte num;

        for (i = count - 1; i >= 0; i--) {
            num = (byte) (number & 0xFF);
            array[index + i] = num;
            number = number >> 8;
        }
    }


    /**
     * This calculates CRC16 from the RCP packet
     *
     * @return CRC16
     */

    private static short calculateCRC(byte[] pchMsg, short wDataLen) {
        short CRC_16_CCITT = 0x1021;
        char chChar;
        short wCRC = 0;
        for (short i = 0; i < wDataLen; i++) {
            chChar = (char) pchMsg[i];
            wCRC ^= (((short)chChar) << 8);
            for (int j = 0; j < 8; j++)
            {
                int  a = wCRC & 0x8000;
                if ( a != 0)
                    wCRC = (short)((wCRC << 1) ^ CRC_16_CCITT);
                else
                    wCRC <<= 1;
            }
        }
        return wCRC;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {

        switch (item.getItemId()) {
            case android.R.id.home:
                this.finish();
                return true;
        }
        return super.onOptionsItemSelected(item);
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == KeyEvent.KEYCODE_BACK) {
            if (!clearStatus) {
                finish();
            }
            return false;
        }
        return false;

    }
}
