package support.andro.app.rfid.view.base;

import java.util.Locale;


import support.andro.app.rfid.adapter.SpinnerAdapter;
import support.andro.app.rfid.util.ResUtil;

import com.asreader.p252b.diagnostics.AsReaderP252BLog;
import com.asreader.p252b.rfid.type.AsReaderP252BMemoryBank;
import com.asreader.app.rfid.R;

import android.app.AlertDialog;
import android.content.DialogInterface;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.TextView;

public abstract class MemoryActivity extends AccessActivity {

	private static final String TAG = MemoryActivity.class.getSimpleName();

	@SuppressWarnings("unused")
	protected static final int MAX_MEM_OFFSET = 16;
	protected static final int DEFAULT_MEM_OFFSET = 2;

	private TextView txtBank;
	private TextView txtOffset;

	private AsReaderP252BMemoryBank mBank;
	private int mOffset;

	@Override
	protected void initWidgets() {
		super.initWidgets();

		// Bank Spinner
		txtBank = (TextView) findViewById(R.id.bank);
		txtBank.setOnClickListener(this);

		// Offset Spinner
		txtOffset = (TextView) findViewById(R.id.offset);
		txtOffset.setOnClickListener(this);

		setMemBank(AsReaderP252BMemoryBank.EPC);
		setMemOffset(DEFAULT_MEM_OFFSET);

		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. initWidgets()");
	}

	@Override
	public void onClick(View v) {
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. onClick(%s)", ResUtil.getId(v.getId()));

		switch (v.getId()) {
		case R.id.bank:
			showMemBankDialog();
			break;
		case R.id.offset:
			showMemOffsetDialog();
			break;
		}
		super.onClick(v);
	}

	@Override
	protected void clearWidgets() {
		super.clearWidgets();

		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. clearWidgets()");
	}

	protected void setMemBank(AsReaderP252BMemoryBank bank) {
		mBank = bank;
		txtBank.setText(mBank.toString());
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. setMemBank(%s)", bank);
	}

	protected AsReaderP252BMemoryBank getMemBank() {
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. getMemBank() - [%s]", mBank);
		return mBank;
	}

	protected void setMemOffset(int offset) {
		mOffset = offset;
		txtOffset.setText(String.format(Locale.US, "%d WORD", offset));
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. setMemOffset(%d)", offset);
	}

	protected int getMemOffset() {
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. getMemOffset() - [%d]", mOffset);
		return mOffset;
	}

	private void showMemBankDialog() {

		if (!mIsEnabled)
			return;

		LinearLayout root = (LinearLayout) LinearLayout.inflate(this, R.layout.dialog_list_view, null);
		final ListView bank = (ListView) root.findViewById(R.id.list);
		final SpinnerAdapter adapter = new SpinnerAdapter(this, android.R.layout.simple_list_item_single_choice);
		for (AsReaderP252BMemoryBank item : AsReaderP252BMemoryBank.values()) {
			adapter.addItem(item.getValue(), item.toString());
		}
		bank.setAdapter(adapter);
		bank.setChoiceMode(ListView.CHOICE_MODE_SINGLE);
		
		AlertDialog.Builder builder = new AlertDialog.Builder(this);
		builder.setTitle(R.string.bank);
		builder.setView(root);
		builder.setPositiveButton(R.string.action_ok, new DialogInterface.OnClickListener() {
			
			@Override
			public void onClick(DialogInterface dialog, int which) {
				int position = bank.getCheckedItemPosition();
				AsReaderP252BMemoryBank value = AsReaderP252BMemoryBank.valueOf(adapter.getValue(position));
				setMemBank(value);
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showMemBankDialog().$PositiveButton.onClick()");
			}
		});
		builder.setNegativeButton(R.string.action_cancel, new DialogInterface.OnClickListener() {
			
			@Override
			public void onClick(DialogInterface dialog, int which) {
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showMemBankDialog().$NegativeButton.onClick()");
			}
		});
		builder.setCancelable(true);
		builder.setOnCancelListener(new DialogInterface.OnCancelListener() {
			
			@Override
			public void onCancel(DialogInterface dialog) {
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showMemBankDialog().onCancel()");
			}
		});
		AlertDialog dialog = builder.create();
		dialog.setOnShowListener(new DialogInterface.OnShowListener() {
			
			@Override
			public void onShow(DialogInterface dialog) {
				int position = adapter.getPosition(mBank.getValue());
				bank.setItemChecked(position, true);
				bank.setSelectionFromTop(position, 0);
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showMemBankDialog().onShow()");
			}
		});
		dialog.show();
		
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showMemBankDialog()");
	}

	private void showMemOffsetDialog() {
		if (!mIsEnabled)
			return;

		LinearLayout root = (LinearLayout) LinearLayout.inflate(this, R.layout.dialog_list_view, null);
		final ListView value = (ListView) root.findViewById(R.id.list);
		final SpinnerAdapter adapter = new SpinnerAdapter(this, android.R.layout.simple_list_item_single_choice);

		for(int n=0; n<=15; n++) {
			adapter.addItem(n, String.format(Locale.US, "%d WORD", n));
		}
		value.setAdapter(adapter);
		value.setChoiceMode(ListView.CHOICE_MODE_SINGLE);

		AlertDialog.Builder builder = new AlertDialog.Builder(this);
		builder.setTitle(R.string.offset);
		builder.setView(root);
		builder.setPositiveButton(R.string.action_ok, new DialogInterface.OnClickListener() {

			@Override
			public void onClick(DialogInterface dialog, int which) {
				int position;
				try {
					position = value.getCheckedItemPosition();
				} catch (Exception e) {
					position = DEFAULT_MEM_OFFSET;
				}
				setMemOffset(position);
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showMemOffsetDialog().$PositiveButton.onClick()");
			}
		});
		builder.setNegativeButton(R.string.action_cancel, new DialogInterface.OnClickListener() {

			@Override
			public void onClick(DialogInterface dialog, int which) {
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showMemOffsetDialog().$NegativeButton.onClick()");
			}
		});
		builder.setCancelable(true);
		builder.setOnCancelListener(new DialogInterface.OnCancelListener() {

			@Override
			public void onCancel(DialogInterface dialog) {
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showMemOffsetDialog().onCancel()");
			}
		});
		AlertDialog dialog = builder.create();
		dialog.setOnShowListener(new DialogInterface.OnShowListener() {

			@Override
			public void onShow(DialogInterface dialog) {
				int position = adapter.getPosition(mOffset);
				value.setItemChecked(position, true);
				value.setSelectionFromTop(position, 0);
				AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showMemOffsetDialog().onShow()");
			}
		});
		dialog.show();
		AsReaderP252BLog.i(TAG, AsReaderP252BLog.INFO, "INFO. showMemOffsetDialog()");
	}

}
