package support.andro.app.rfid.filter;

import android.text.InputFilter;
import android.text.Spanned;

import com.asreader.p252b.diagnostics.AsReaderP252BLog;

public class InputFilterMinMax implements InputFilter {
	private static final String TAG = InputFilterMinMax.class.getSimpleName();
	private int min, max;

	public InputFilterMinMax(int min, int max) {
		this.min = min;
		this.max = max;
	}

	public InputFilterMinMax(String min, String max) {
		this.min = Integer.parseInt(min);
		this.max = Integer.parseInt(max);
	}

	@Override
	public CharSequence filter(CharSequence source, int start, int end,
			Spanned dest, int dstart, int dend) {
		try {
			String input = "";
			input += dest.subSequence(0, dstart);
			input += source.subSequence(start, end);
			input += dest.subSequence(dend, dest.length());
			int value = Integer.parseInt(input);
			if (isInRange(this.min, this.max, value)) {
				return null;
			}
		} catch (NumberFormatException e) {
			AsReaderP252BLog.e(TAG, "ERROR. filter - [%s]", e.getMessage());
		}
		return "";
	}

	private boolean isInRange(int min, int max, int value) {
		return max > min ? value >= min && value <= max : value >= max && value <= min;
	}

}
