package com.asreader.app.rfid.view.widges;

import android.app.Activity;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.TextView;

import com.asreader.app.rfid.R;
import com.asreader.app.rfid.interfaces.OnSearchListener;

public class ShowSearchWindow extends ShowPopUpWindow implements View.OnClickListener, AdapterView.OnItemClickListener {


    private View view;
    private ArrayAdapter<String> mNewDevicesAdapter;
    private OnSearchListener onSearchListener;

    private Button mStartDiscovery;
    private TextView mTitleNewDevices;


    public ShowSearchWindow(Activity context, OnSearchListener onSearchListener) {
        super.setContext(context);
        this.onSearchListener = onSearchListener;
        view = initBasePopWindow(R.layout.popwindow_search, LinearLayout.LayoutParams.MATCH_PARENT,
                LinearLayout.LayoutParams.MATCH_PARENT, POP_DOWN);
        initView();
    }

    public void initView() {
        mStartDiscovery = (Button) view.findViewById(R.id.start_discovery);
        mTitleNewDevices = (TextView) view.findViewById(R.id.title_new_devices);
        mStartDiscovery.setOnClickListener(this);
        mNewDevicesAdapter = new ArrayAdapter<String>(getContext(), R.layout.bluetooth_name);

        // Find and set up the ListView for newly discovered devices
        ListView newDevicesRecyclerView = (ListView) view.findViewById(R.id.new_devices);
        newDevicesRecyclerView.setAdapter(mNewDevicesAdapter);
        newDevicesRecyclerView.setOnItemClickListener(this);
    }


    @Override
    public void onClick(View v) {
        if(onSearchListener != null){
            onSearchListener.onStartDiscovery();
        }
    }



    public void refreshTextView(boolean bool){
        if(bool){
            mTitleNewDevices.setText(R.string.discovering);
            mStartDiscovery.setText(R.string.stop_discovery);
        }else{
            mStartDiscovery.setText(R.string.start_discovery);
            mTitleNewDevices.setText(R.string.title_other_devices);
        }
    }


    @Override
    public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
        onSearchListener.onCancelDiscovery();
        String info = ((TextView) view).getText().toString();
        if (info.equals(getContext().getResources().getText(R.string.none_paired).toString())) {
            return;
        } else {
            String address = info.substring(info.length() - 17);
            onSearchListener.onConnect(address);
            dismiss();
        }
    }

    public ArrayAdapter<String> getmNewDevicesAdapter() {
        return mNewDevicesAdapter;
    }


}




