//
//  JvmaText.h
//  JvmaSDK
//
//  Created by DS.Zhang on 2017/3/24.
//  Copyright © 2017年 MRX_DS.Zhang. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "JvmaRecord.h"
#import "JvmaItem.h"
#import "Define.h"

typedef NS_ENUM(NSInteger, JvmaHasNext){
    JvmaHasNextTypeETX        =0x03,  //連続するデータテキストの最後のパケット末尾を表す。
    JvmaHasNextTypeETB        =0x17   //連続するデータテキストの途中のパケット末尾を表す。
};

//添加CommandCode一定要在JvmaProtocol中添加对应的处理case！！！！！！！！！！！！
typedef NS_ENUM(NSInteger, CommandCode){
    VmDataCollect             = 0x01, //自販機データ収集
    VmDataCollectClear        = 0x02, //自販機データ収集クリア
    SettingDataCollect        = 0x03, //設定データ収集
    SettingDataSet            = 0x41, //設定データ設定
    SettingDataSet2           = 0x49, //設定データ設定Ⅱ
    AllClear                  = 0x81, //オールクリア
    VmDataCollectClearConfirm = 0x87, //０２クリア確認
    AllClearConfirm           = 0x88, //８１クリア確認
    
    OnLineSettingDataCollect  = 0x06, //オンライン用設定データ収集
    OnLineSettingDataSet      = 0x46,  //オンライン用設定データ設定
    OnLineWorkingSettingDataSet=0x47, //作業時データ設定
    OnLineAllClear            = 0x86, //自動機オンラインデータオールクリア
    CenterPasswordSet         = 0x92,  //センターパスワード
    OnLineAllClearConfirm     = 0x89, //86クリア確認
    TCP_IPSettingDataCollect  = 0x08, //TCP/IP用設定データ収集
    TCP_IPSettingDataSet      = 0x48, // TCP/IP用設定データ設定
    
};

@interface JvmaText : NSObject

@property (nonatomic ,assign, readonly) textHeader   stx;
@property (nonatomic ,assign, readonly) JvmaTextType textType;
@property (nonatomic ,strong, readonly) NSString    *dataLengthBCD;
@property (nonatomic ,strong)           NSNumber    *blockNumber;
@property (nonatomic ,strong, readonly) NSString    *bccHex;
@property (nonatomic ,strong, readonly) NSArray<JvmaRecord *>     *jvmaRecords;
@property (nonatomic ,assign)           JvmaHasNext  hasNext;

@property (nonatomic ,strong, readonly) NSString    *hexStr;
@property (nonatomic ,strong, readonly) NSData      *hexData;

@property (nonatomic ,strong, readonly) NSString *offlinePassword;
@property (nonatomic ,strong, readonly) NSString *terminalPassword;
@property (nonatomic ,assign)           BOOL isTestData;


- (instancetype)initWithOfflinePassword:(NSString *)offlinePassword TerminalPassword:(NSString *)terminalPassword textType:(JvmaTextType)textType;

- (BOOL)addJvmaRecord:(JvmaRecord *)jvmaRecord;

- (instancetype)initWithOfflinePassword:(NSString *)offlinePassword TerminalPassword:(NSString *)terminalPassword jvmaData:(NSData *)jvmaData;
@end
