//
//  JvmaDataId.h
//  JvmaSDK
//
//  Created by DS.Zhang on 2017/2/20.
//  Copyright © 2017年 MRX_DS.Zhang. All rights reserved.
//

#import <Foundation/Foundation.h>
typedef NS_ENUM(NSInteger, JvmaDataIdCode) {
    VmIdentifyCode          = 0x0A1A, //識別コード指定レコード（HTからVMへの転送データ）
    CommunicationCommand    = 0x0AA0, //交信コマンドレコード（HTからVMへの転送データ）
    ClearStutas             = 0x0AA1, //クリア状態データレコード（VMからHTへの転送データ）
    VmTime                  = 0x0BA0, //時刻レコード（HTからVMへの転送データ）
    ManageData              = 0x0BA1, //自販機管理データレコード（HTからVMへ、VMからHTへの転送データ）
    IndividualData          = 0x0BB0, //自販機個別データレコード（VMからHTへの転送データ）
    VmFaultCode             = 0x0BB1, //故障コード履歴レコード（VMからHTへの転送データ）
    MonitorCode             = 0x0BB2, //モニターコード履歴レコード（VMからHTへの転送データ）
    OfflineLog              = 0x0BB3, //オフライン用交信LOGレコード（VMからHTへの転送データ）
    SetTotal                = 0x0BB4, //トータル集計レコード（VMからHTへの転送データ）
    SetTotalBackUp          = 0x0BB5, //トータル集計バックアップレコードVMからHTへの転送データ）
    PriceQuantity           = 0x0BB6, //価格別累計販売数レコード（VMからHTへの転送データ）
    DateQuantity            = 0x0BB7, //日別販売数レコード（VMからHTへの転送データ）
    MaterialKindCode        = 0x0BB8, //商材別コードレコード（カップ機）(VMからHTへ、HTからHTへの転送データ)
    SupMaterialKindCode     = 0x0BB9, //補材別コードレコードカップ機）(VMからHTへ、HTからHTへの転送データ)
    SaleAmount              = 0x0BBA, //部署別IDカード販売金額レコード(VMからHTへの転送データ）
    SaleAmountBackUp        = 0x0BBB, //部署別IDカード販売金額バックアップレコード(VMからHTへの転送データ）
    ShouhinCD               = 0x0BC0, //商品コードレコード（HTからVMへ、VMからHTへの転送データ)(VMからHTへの転送データ）（カップ機）（パッケージ商品機）
    KindCD                  = 0x0BC1, //分類コードレコード（パッケージ商品機）(VMからHTへ、HTからHTへの転送データ)
    CupKindCD               = 0x0BC2, //分類コードレコード（カップ機）(VMからHTへの転送データ）
    ColumnCashPrice         = 0x0BC3, //コラム別現金売り販売単価レコード(VMからHTへの転送データ）
    ColumnQuantity          = 0x0BC4, //コラム別販売数レコード(VMからHTへの転送データ）
    ColumnSaleOutTime       = 0x0BC5, //コラム別売切時間レコード（パッケージ商品機）(VMからHTへの転送データ）
    ColumnCardPrice         = 0x0BC6, //コラム別カード販売単価レコード(VMからHTへの転送データ）
    PrepayCardQuantity      = 0x0BC7, //コラム別プリペイドカード売り販売数レコード(VMからHTへの転送データ）
    PrepayCardSaleAmount    = 0x0BC8, //コラム別プリペイドカード・現金併用販売時カード売り金額レコード(VMからHTへの転送データ）
    IdCardQuantity          = 0x0BC9, //コラム別IDカード売り販売数レコード(VMからHTへの転送データ）
    FreeSaleQuantity        = 0x0BCA, //コラム別フリーベンド販売数レコード(VMからHTへの転送データ）
    InputCashQuantity       = 0x0BE0, //金種別投入枚数レコード(VMからHTへの転送データ）
    QuitCashQuantity        = 0x0BE1, //金種別排出枚数レコード(VMからHTへの転送データ）
    ChangEmptyTime          = 0x0BE2, //釣切時間レコード(VMからHTへの転送データ）
    VmRunTime               = 0x0BE3, //自販機稼働時間レコード(VMからHTへの転送データ）
    MonitorSaleOutTime      = 0x0BE4, //売切モニター時間レコード(VMからHTへの転送データ）（カップ機）
    MaterialSaleOutTime     = 0x0BE5, //商材別売切時間レコード(VMからHTへの転送データ）（カップ機）
    SupMaterialSaleOutTime  = 0x0BE6, //補材別売切時間レコード(VMからHTへの転送データ）（カップ機）
    LargeValueInputQuantity = 0x0BE7, //高額金種別投入枚数レコード(VMからHTへの転送データ）
    LargeValueQuitQuantity  = 0x0BE8, //高額金種別払出枚数レコード(VMからHTへの転送データ）
    LargeValueChangEmptyTime= 0x0BE9, //高額金種別釣切時間レコード(VMからHTへの転送データ）
    Total                   = 0x0C0A, //トータル累計レコード(VMからHTへの転送データ）
    TotalSaleQuantity       = 0x0C0B, //コラム別累計販売数レコード(VMからHTへの転送データ）
    OfflinePassword         = 0x0D0B, //オフラインシステム パスワード
    TerminalPassword        = 0x0D0D, //ターミナルパスワード
    CenterPasswordRecord    = 0x0D0C, //センターパスワードレコード

    //自販機〜ハンディターミナル間の交信仕様
#pragma mark F010-1 追加仕様版（2000円札・小額金種対応版）Ver.1.0.5
    InputMoneyQuantity      = 0x0BEA, //金種別投入枚数レコード２（VMからHTへの転送データ）
    ExhaustMoneyQuantity    = 0x0BEB, //金種別排出枚数レコード２（VMからセンターへの転送デー  タ）
    NoChangeTime            = 0x0BEC, //金種別釣切時間レコード２（VMからHTへの転送データ）
    
#pragma mark F010-2 追加仕様版（チャージ金額対応）Ver.1.0.0
    TotalRecords            = 0x0BBC, //トータル集計レコード２（VMからHTへの転送データ）
    DataBackupCD            = 0x0BBD, //トータル集計バックアップレコード２（VMからHTへの転送データ）
    CumulativeRecord        = 0x0C7A, //トータル累計レコード２（VMからHTへの転送データ）

#pragma mark F010-3 追加仕様版（マルチブランド対応版）Ver.1.0.0
    BrandNumberRecord       = 0x0BD0, //ブランド番号レコード（VMからHTへの転送データ）
    BrandNameRecord         = 0x0BD1, //ブランド名称レコード（VMからHTへの転送データ）
    AllBrandsRecord         = 0x0BD2, //ブランド別トータル集計レコード（VMからHTへの転送データ）
    AllBrandsDataBackupCD   = 0x0BD3, //ブランド別トータル集計バックアップレコード（VMからHTへの転送データ）
    DifferentBrandsSaleNum  = 0x0BD4, //ブランド別コラム別販売数（VMからHTへの転送データ）
    DifferentBrandsSalePrice= 0x0BD5, //ブランド別コラム別販売価格（VMからHTへの転送データ）
    BrandSalaQuantity       = 0x0BD6, //ブランド別販売数（VMからHTへの転送データ）
    TotalBrandRecord        = 0x0BDA, //ブランド別トータル累計レコード（VMからHTへの転送データ）
    OtherBrandSaleQuantity  = 0x0BDB, //ブランド別コラム別累計販売数（VMからHTへの転送データ）
    TotalBrandQuantity      = 0x0BDC, //ブランド別累計販売数（VMからHTへの転送データ）
    
#pragma mark F010-4 追加仕様版（売上集計機能追加）Ver.1.0.0
    DayTotalRecord1         = 0x0BBE, //当日トータル集計レコード（VMからHTへの転送データ）
    DayTotalRecord2         = 0x0BBF, //当日トータル集計レコード２（VMからHTへの転送データ）
    DayTotalSales           = 0x0BCC, //日別売上金累計レコード（VMからHTへの転送データ）
    
#pragma mark F010-5 追加仕様版（ルーレット対応版）Ver.1.0.0
    ColumnRouletteNumber    = 0x0BCD, //コラム別ルーレット当たり回数レコード（VMからHTへの転送データ）
    
#pragma mark F010-6 追加仕様版（高額商品対応版）Ver.1.0.0
    HighPriceSaleNumRecord  = 0x0BEF, //高額商品対応価格別累計販売数レコード（VMからセンターへの転送データ）
    HighPriceOtherSaleRecord= 0x0BED, //高額商品対応コラム別現金売り販売単価レコード（VMからセンターへの転送データ）
    HighPriceOtherCardSale  = 0x0BEE, //高額商品対応コラム別カード販売単価レコード（VMからセンターへの転送データ）

#pragma mark F010-7 追加仕様版（販売単価設定追加）Ver.1.0.0
    AnotherCashSaleSetRecord= 0x0CC0, //コラム別現金売り販売単価設定レコード（HTからVMへの転送データ）
    AnotherCardSaleSetRecord= 0x0CC1, //コラム別カード販売単価設定レコード（HTからVMへの転送データ）
    BrandOtherSalePrice     = 0x0CC2, //ブランド別コラム別販売単価設定レコード（HTからVMへの転送データ）
    CashSaleChangeRecord    = 0x0CC3, //現金売り販売単価変更履歴レコード（VMからHTへの転送データ）
    CardSalePriceChange     = 0x0CC4, //カード売り販売単価変更履歴レコード（VMからHTへの転送データ）
    BrandOtherSalePriceChange=0x0CC5, //ブランド別コラム別販売単価変更履歴レコード（VMからHTへの転送データ）
    
    VersionRecord           =0xFFFF,
    TestRecord              =0xEEEE,
    
#pragma mark オンライン式自動販売機情報管理システム Ver. 1. 0.2
    //補給コマンド
    SupplyCommand1 = 0x0A0A,        //交信モードデータ
    SupplyCommand2 = 0x0B1A,        //補給データ（バッケージ商品機）
    
    CenterIP              = 0x0C5A,
    VMIP                  = 0x0C5B,
    //电话号码式样书的10代表电话号码的位数，20位item前两位代表位数，后面18位代表电话。
    TcpIPSendNo           = 0x0C5C, //発信電話番号データレコード
    AdministrationGroupNo = 0x0B0A,  //自動機郡管理レコード
    VMCall                = 0x0B0C,  //発呼制御データレコード
#pragma mark F010-8 自動販売機情報管理システム(TCP/IP編)Ver.1.0.0
    Automaticcalltime     = 0x0B0D, //自動機発呼時刻レコード
    FullRecord            = 0x0B2A, //コラム別満杯数レコード
    ValueRecord           = 0x0B3E, //在庫アラームニアエンド値レコード
    SetRecord             = 0x0B5C, //サンプリング周期設定レコード
    SpecifiedRecord       = 0x0B4A, //汎用ポート指定レコード
    CodeRecord            = 0x0C5D, //自動機認証コードレコード
    CenterCodeRecord      = 0x0C5E, //センター認証コードレコード
    MaxMaterials          = 0x0B2B, //商材別満杯数レコード
    AuxiliaryMaterials    = 0x0B2C, //補材別満杯数レコード
    CommercialValueRecord = 0x0C3A, //商材在庫アラームニアエンド値レコード
    AuxiliaryValueRecord  = 0x0C3B, //補材在庫アラームニアエンド値レコード
    CenterPhoneRecord     = 0x0B0B, //センター電話番号データレコード
    PortSpecifiedRecord   = 0x0C4A, //汎用ポート指定レコード
    Datarecovery          = 0x0B1D, //回収データレコード
    MaterialsSupplyRecord = 0x0B1B, //商材補給データレコード
    AuxiliaryDataRecord   = 0x0B1C, //補材補給データレコード
    ConfirmationData      = 0x0A0B, //継続確認データ
    Endconfirmationdata   = 0x0A0C, //終了確認データ
    Downloadsendmode      = 0x0A0D, //ダウンロード送信モード
    DownloadSendmode      = 0x0A0E, //ダウンロード確認データ
    MachineData           = 0x0B0E, //自動機バージョンデータ
    Faultmonitorcode      = 0x0B3A, //故障・モニターコード
    SellColumn            = 0x0B3B, //コラム別売切状態（パッケージ商品機）
    DifferentMaterials    = 0x0B3C, //商材別売切状態（カップ機）
    Auxiliarymaterial     = 0x0B3D, //補材別売切状態（カップ機）
    ValueRecord1          = 0x0B3E, //在庫アラームニアエンド値（パッケージ商品機）
    ContainerColumn       = 0x0B3F, //コラム別容器番号（カップ機）
    SalesReplenishment    = 0x0B4B, //コラム別補給後販売数（パッケージ商品機）
    QuantityReplenishment = 0x0B4C, //商材別補給後販売数（カップ機）
    Salesreplenishment    = 0x0B4D, //補材別補給後販売数（カップ機）
    Datagenerationtime    = 0x0B5A, //データ発生時刻
    Timedata              = 0x0B5B, //設定データ変化有り日時
    Communicationlog      = 0x0B5D, //交信LOG
    TotalRecovery         = 0x0B6A, //回収時トータル累計
    AccumulatedSales      = 0x0B6B, //回収時コラム別累計販売数
    CashSalesVolume       = 0x0B6C, //回収時コラム別現金売り累計販売数
    PrepaidCardSales      = 0x0B6D, //回収時コラム別プリペイドカード売り累計販売数
    IDCardSalesQuantity   = 0x0B6F, //回収時コラム別IDカード売り累計販売数
    SalesbyBend           = 0x0B7A, //回収時コラム別フリーベンド累計販売数
    IDCardSales           = 0x0B7B, //回収時部署別IDカード売り累計販売金額
    Cumulativeinvestment  = 0x0B7C, //回収時金種別累計投入枚数
    Totalexpenditure      = 0x0B7D, //回収時金種別累計払出枚数
    CumulativeInvestment  = 0x0B7E, //回収時高額金種別累計投入枚数
    CumulativeExpenditure = 0x0B7F, //回収時高額金種別累計払出枚数
    SalesduringSampling   = 0x0B8A, //サンプリング時コラム別販売数
    Samplingchange        = 0x0B8B, //サンプリング時釣り切れ有無
    DifferentColumns      = 0x0B8C, //サンプリング時コラム別売り切れ有無（パッケージ商品）
    SuckerMaterial        = 0x0B8D, //サンプリング時商材別売り切れ有無（カップ機）
    Suckermaterial1       = 0x0B8E, //サンプリング時補材別売り切れ有無（カップ機）
    CurrentType           = 0x0B8F, //サンプリング時高額金種釣り切れ有無
    PrepaidcardSales      = 0x0C0D, //コラム別プリペイドカード売り累計販売数
    AdvanceCashSales      = 0x0C0E, //コラム別プリペイドカード・現金併用時累計販売数
    PrepaidCardSales1     = 0x0C0F, //コラム別IDカード売り累計販売数
    ReebendsSalesQuantity = 0x0C1A, //コラム別フリーベンド累計販売数
    CumulativeSales       = 0x0C1B, //部署別IDカード売り累計販売金額
    InvestmentTensor      = 0x0C1C, //金種別累計投入枚数
    ExpansionRate         = 0x0C1D, //金種別累計払出枚数
    InvestmentTensor2     = 0x0C1E, //高額金種別累計投入枚数
    CurrencyType          = 0x0C1F, //高額金種別累計払出枚数
    ConsumptionOfSucker   = 0x0C2A, //商材別累計消費量（カップ機）
    ConsumptionOfSucker1  = 0x0C2B, //補材別累計消費量（カップ機）
    SupplementaryQuantity = 0x0C2C, //商材別累計補給量（カップ機）
    SupplementaryQuantity1= 0x0C2D, //補材別累計補給量（カップ機）
    Proximalcupmachine    = 0x0C3A, //商材在庫アラームニアエンド値（カップ機）
    Proximalcupmachine1   = 0x0C3B, //補材在庫アラームニアエンド値（カップ機）
    
};
@interface JvmaDataId : NSObject
@property (nonatomic, assign ,readonly) JvmaDataIdCode code;
@property (nonatomic, strong ,readonly) NSString *hexStrCode;

- (instancetype)initWithDataIdCode:(JvmaDataIdCode)code;

- (instancetype)initWithHexStrCode:(NSString *)hexStrCode;
- (instancetype)initWithHexData:(NSData *)hexData;
@end
