//
//  BLEManager.h
//  JvmaSDK
//
//  Created by ZDS on 2025/4/3.
//  Copyright © 2025 MRX_DS.Zhang. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <CoreBluetooth/CoreBluetooth.h>
#import "BluetoothModule.h"

NS_ASSUME_NONNULL_BEGIN
@protocol BLEManagerDelegate <NSObject>
@optional
- (void)onBluetoothStateDidChange:(CBManagerState)state;
- (void)onDiscoverBluetoothModule:(BluetoothModule *)bluetoothModule;
@end

@interface BLEManager : NSObject
@property (nonatomic, weak) id<BLEManagerDelegate> delegate;
@property (nonatomic, assign) CBManagerState currentBluetoothState;

+ (BLEManager *)sharedBLEManager;
- (BOOL)startScan;
- (void)stopScan;

- (void)setBluetoothLogOn:(BOOL)on;
- (void)removeAllBluetoothLog;
@end

NS_ASSUME_NONNULL_END
