//
//  AsReaderAsk.h
//  JvmaSDK
//
//  Created by DS.Zhang on 2017/2/14.
//  Copyright © 2017年 MRX_DS.Zhang. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "JvmaText.h"
#import "BLEManager.h"
#import "BluetoothModule.h"

@protocol AsReaderAskStatusDelegate <NSObject>
@optional
- (void)onReceivedConnectedState:(BOOL)isConnected;

//This feature only works on the ASR-M60DB
- (void)onReceivedBLEConnectedState:(BOOL)isConnected;
//This feature only works on the ASR-M60DB
- (void)onReceivedBLEError:(NSError *)error;

- (void)onReceivedBatteryState:(int)gauge;
- (void)onReceivedTriggerState:(BOOL)isTriggerDown;

- (void)onReceivedPowerState:(BOOL)isOn beep:(BOOL)isBeep vib:(BOOL)isVib led:(BOOL)isLed;
- (void)onReceivedReaderSettingBeep:(BOOL)isOn Vib:(BOOL)isVib Led:(BOOL)isLed;

@end
@protocol AsReaderAskDataDelegate <NSObject>
@optional
- (void)onReceivedFromModule:(NSData*)rawData;
@end
@interface AsReaderAsk : NSObject
@property (nonatomic, assign, readonly) BOOL isConnected;

//This feature only works on the ASR-M60DB
@property (nonatomic, assign, readonly) BOOL isBLEConnected;

@property (nonatomic, weak) id<AsReaderAskStatusDelegate>        statusDelegate;
@property (nonatomic, weak) id<AsReaderAskDataDelegate>          dataDelegate;

+ (AsReaderAsk *)sharedAsReaderAsk;

//This feature only works on the ASR-M60DB
- (void)connectBluetooth:(BluetoothModule *)bluetoothModule;
//This feature only works on the ASR-M60DB
- (void)disConnectBluetooth;

- (BOOL)sendPowerOn:(BOOL)isOn setBeep:(BOOL)isBeep setVib:(BOOL)isVib setLed:(BOOL)isLED;
- (BOOL)sendSettingBeep:(BOOL)isBeep setVib:(BOOL)isVib setLed:(BOOL)isLED;

- (void)setAsReaderAskLogOn:(BOOL)on;
- (void)removeAllAsReaderAskLog;

- (void)setTriggerModeDefault:(BOOL)isDefault;

- (BOOL)sendData:(NSData *)data;

- (BOOL)makeBeep;

- (BOOL)makeVibration;

- (BOOL)makeBeepVibration;

@end
