package com.asreader.jvmasample;

import android.app.Dialog;
import android.bluetooth.BluetoothDevice;
import android.content.Context;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ListView;
import android.widget.TextView;

import java.util.ArrayList;
import java.util.Collections;

public class BleListViewDialog extends Dialog {
    private ListViewAdapter adapter = null;
    public ArrayList<ListData> listData = new ArrayList<>();
    private ListView listView = null;
    public ListViewDialogSelectListener dialogSelectListener;

    public interface ListViewDialogSelectListener {
        void onSetOnItemClickListener(int i);
    }

    public class ListData implements Comparable<ListData> {
        public String address;
        public BluetoothDevice bluetoothDevice;
        public String name;
        public String rssi;

        public ListData() {
        }

        public BluetoothDevice getBluetoothDevice() {
            return bluetoothDevice;
        }

        public void setBluetoothDevice(BluetoothDevice bluetoothDevice) {
            this.bluetoothDevice = bluetoothDevice;
            this.address = bluetoothDevice.getAddress();
        }

        public String getAddress() {
            return address;
        }

        public void setAddress(String str) {
            address = str;
        }

        public String getName() {
            return name;
        }

        public void setName(String str) {
            this.name = str;
        }

        public String getRssi() {
            return rssi;
        }

        public void setRssi(String str) {
            this.rssi = str;
        }

        public int compareTo(ListData listData) {
            return rssi.compareTo(listData.rssi);
        }
    }

    public void clearData() {
        synchronized (listData) {
            listData.clear();
            adapter.notifyDataSetChanged();
        }
    }

    public void addData(BluetoothDevice bluetoothDevice, String name, String rssi)
    {
        synchronized (listData) {
            boolean isNew = true;
            for(int i = 0; i< listData.size(); i++)
            {
                ListData data = listData.get(i);
                if(data.name.equals(name)){
                    isNew = false;
                    listData.get(i).setRssi(rssi);
                }
            }
            if(isNew)
            {
                Log.d("LIST","NEW LIST");
                adapter.addItem(bluetoothDevice, name, rssi);
                Collections.sort(listData);
                adapter.notifyDataSetChanged();
            }
        }
    }

    public BleListViewDialog(Context context, int layout) {
        super(context);
        this.requestWindowFeature(Window.FEATURE_NO_TITLE);
        setContentView(layout);
        listView = (ListView) findViewById(R.id.list);
        adapter = new ListViewAdapter(this.getContext());
        listView.setAdapter(adapter);

        listView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            public void onItemClick(AdapterView<?> arg0, View arg1, int arg2, long arg3) {
                Log.i("Touch", "onItemClick");
                dialogSelectListener.onSetOnItemClickListener(arg2);
            }
        });
    }

    public ListData getDataIndex(int i) {
        if (i > listData.size() - 1) {
            return null;
        }
        return listData.get(i);
    }

    private class ListViewAdapter extends BaseAdapter {
        private Context context = null;

        public long getItemId(int position) {
            return position;
        }

        public void clearData() {
            listData.clear();
        }

        public ListViewAdapter(Context context) {
            this.context = context;
        }

        public void addItem(BluetoothDevice bluetoothDevice, String name, String rssi) {
            ListData listData = new ListData();
            listData.bluetoothDevice = bluetoothDevice;
            listData.address = bluetoothDevice.getAddress();
            listData.name = name;
            listData.rssi = rssi;
            BleListViewDialog.this.listData.add(listData);
        }

        public int getCount() {
            return listData.size();
        }

        public Object getItem(int i) {
            return listData.get(i);
        }

        private class ViewHolder {
            public TextView name;
            public TextView rssi;
            public TextView uuid;

            private ViewHolder() {
            }
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {

            ViewHolder viewHolder;
            if (convertView == null) {
                viewHolder = new ViewHolder();
                LayoutInflater inflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
                convertView = inflater.inflate(R.layout.listview_ble_item, null);
                viewHolder.uuid = (TextView) convertView.findViewById(R.id.tv_uuid);
                viewHolder.name = (TextView) convertView.findViewById(R.id.tv_name);
                viewHolder.rssi = (TextView) convertView.findViewById(R.id.tv_rssi);
                convertView.setTag(viewHolder);
            } else {
                viewHolder = (ViewHolder) convertView.getTag();
            }

            ListData listData = BleListViewDialog.this.listData.get(position);

            viewHolder.uuid.setText(listData.address);
            viewHolder.name.setText(listData.name);
            viewHolder.rssi.setText(listData.rssi);

            return convertView;
        }
    }

    public void onOnSetItemClickListener(ListViewDialogSelectListener listViewDialogSelectListener) {
        this.dialogSelectListener = listViewDialogSelectListener;
    }
}
