package jp.co.asterisk.asreader.a60d.demoapp.util;

import android.content.Context;
import android.content.SharedPreferences;

import jp.co.asterisk.asreader.a60d.demoapp.enums.LogTypeCommands;
import jp.co.asterisk.asreader.a60d.sdk.device.connection.ConnectionType;

public class AppSharedData {
    private static final String APP_SAVE_DATA = "app_save_data";

    private static final String PREF_KEY_OFFLINE_SYSTEM_PASSWORD = "KEY_PREF_OFFLINE_SYSTEM_PASSWORD";
    private static final String PREF_KEY_TERMINAL_PASSWORD = "KEY_PREF_TERMINAL_PASSWORD";
    private static final String PREF_KEY_IS_INPUT_TIME_RECORD = "PREF_KEY_IS_INPUT_TIME_RECORD";
    private static final String PREF_KEY_LOG_TYPE = "PREF_KEY_LOG_TYPE";
    private static final String PREF_KEY_CURRENT_CONNECTION_MODE = "PREF_KEY_CURRENT_CONNECTION_MODE";

    private static AppSharedData mInstance = null;
    private final SharedPreferences mSharedPreferences = null;
    private Context mContext = null;

    private AppSharedData() {

    }

    public static AppSharedData getInstance() {
        if( mInstance==null ) {
            mInstance = new AppSharedData();
        }
        return mInstance;
    }

    public void initialize(Context context) {
        mContext = context;
    }

    private void putStringItem(String key, String value) {
        SharedPreferences preferences = mContext.getSharedPreferences(APP_SAVE_DATA, Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putString(key, value).apply();
    }

    private String getStringItem(String key, String defaultValue) {
        return mContext.getSharedPreferences(APP_SAVE_DATA, 0).getString(key, defaultValue);
    }

    private void putBooleanItem(String key, boolean value) {
        SharedPreferences preferences = mContext.getSharedPreferences(APP_SAVE_DATA, Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putBoolean(key, value).apply();
    }

    private boolean getBooleanItem(String key, boolean defaultValue) {
        return mContext.getSharedPreferences(APP_SAVE_DATA, 0).getBoolean(key, defaultValue);
    }

    /**
     * Public Method
     **/
    public String getOfflineSystemPassword() {
        return getStringItem(PREF_KEY_OFFLINE_SYSTEM_PASSWORD, "");
    }

    public void setOfflineSystemPassword(String offlineSystemPassword) {
        putStringItem(PREF_KEY_OFFLINE_SYSTEM_PASSWORD, offlineSystemPassword);
    }

    public String getTerminalPassword() {
        return getStringItem(PREF_KEY_TERMINAL_PASSWORD, "");
    }

    public void setTerminalPassword(String terminalPassword) {
        putStringItem(PREF_KEY_TERMINAL_PASSWORD, terminalPassword);
    }

    public Boolean getIsInputTimeRecord() {
        return getBooleanItem(PREF_KEY_IS_INPUT_TIME_RECORD, false);
    }

    public void setIsInputTimeRecord(boolean isInputTimeRecord) {
        putBooleanItem(PREF_KEY_IS_INPUT_TIME_RECORD, isInputTimeRecord);
    }

    public String getLogType() {
        return getStringItem(PREF_KEY_LOG_TYPE, LogTypeCommands.LogTypeAPPCommands.getName());
    }

    public void setLogType(String logTypeCommands) {
        putStringItem(PREF_KEY_LOG_TYPE, logTypeCommands);
    }

    public String getCurrentConnectionMode(){
        return getStringItem(PREF_KEY_CURRENT_CONNECTION_MODE, "USB");
    }

    public void setCurrentConnectionMode(ConnectionType connectionType) {
        putStringItem(PREF_KEY_CURRENT_CONNECTION_MODE, connectionType.toString());
    }
}
