package jp.co.asterisk.asreader.a60d.demoapp.fragments.menu.setdata;

import android.os.Bundle;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.EditorInfo;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.navigation.fragment.NavHostFragment;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.co.asterisk.asreader.a60d.demoapp.R;
import jp.co.asterisk.asreader.a60d.demoapp.databinding.FragmentSetKindCodeBinding;
import jp.co.asterisk.asreader.a60d.demoapp.databinding.FragmentSetVmManageDataBinding;
import jp.co.asterisk.asreader.a60d.demoapp.fragments.base.BaseFragment;
import jp.co.asterisk.asreader.a60d.demoapp.fragments.menu.home.ClearDataFragment;
import jp.co.asterisk.asreader.a60d.demoapp.util.AppSharedData;
import jp.co.asterisk.asreader.a60d.sdk.type.jvma.JVMADataId;

public class SetVmManageDataFragment extends BaseFragment {

    private FragmentSetVmManageDataBinding binding;

    @Override
    public View onCreateView(
            LayoutInflater inflater, ViewGroup container,
            Bundle savedInstanceState
    ) {
        binding = FragmentSetVmManageDataBinding.inflate(inflater, container, false);
        getMainActivity().setToolbarTitle(getString(R.string.toolbar_title_set_vm_manage_data));
        getMainActivity().setResultTextVisibility(View.VISIBLE);
        getMainActivity().resetResultText();
        return binding.getRoot();
    }

    public void onViewCreated(@NonNull View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        binding.item2EditText.setOnEditorActionListener((v, actionId, event) -> {

            if (actionId == EditorInfo.IME_ACTION_DONE || actionId == EditorInfo.IME_ACTION_NEXT) {
                hideKeyboard(v);
                return true;
            }
            return false;
        });

        binding.setButton.setOnClickListener(v -> {
            getMainActivity().resetResultText();

            String item1 = binding.item1EditText.getText().toString();
            String item2 = binding.item2EditText.getText().toString();

            String offlineSystemPassword = AppSharedData.getInstance().getOfflineSystemPassword();
            String terminalPassword = AppSharedData.getInstance().getTerminalPassword();
            boolean isInputTimeRecord = AppSharedData.getInstance().getIsInputTimeRecord();

            if (!checkPasswords(offlineSystemPassword, terminalPassword)) {
                return;
            }

            if (checkItemsTextLength(item1, item2)) {
                List<String> vmManageDataList = new ArrayList<>();
                if (item1.length() == 10) {
                    vmManageDataList.add(item1);
                }

                if (item2.length() == 10) {
                    vmManageDataList.add(item2);
                }

                setPasswords(offlineSystemPassword, terminalPassword);

                // 設定データ
                Map<JVMADataId, List<String>> settingData = new HashMap<>();
                settingData.put(JVMADataId.ManageData, vmManageDataList);
                getASKManager().setSettingDataList(settingData);

                getASKManager().sendSettingData(isInputTimeRecord);

            } else {
                showToast(getString(R.string.dialog_message_input_error), Toast.LENGTH_SHORT);
            }
        });
    }

    private boolean checkItemsTextLength(String item1, String item2) {
        if (item1.length() == 10 && item2.length() == 10) return true;
        if (item1.length() == 10 && item2.length() == 0) return true;
        if (item1.length() == 0 && item2.length() == 10) return true;

        return false;
    }

    @Override
    public void onClickBackButton() {
        NavHostFragment.findNavController(SetVmManageDataFragment.this).popBackStack();
    }
}
