package jp.co.asterisk.asreader.a60d.demoapp.fragments.menu.setdata;

import android.os.Bundle;

import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.navigation.fragment.NavHostFragment;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.co.asterisk.asreader.a60d.demoapp.R;
import jp.co.asterisk.asreader.a60d.demoapp.adapters.KindCodeAdapter;
import jp.co.asterisk.asreader.a60d.demoapp.databinding.FragmentSetKindCodeBinding;
import jp.co.asterisk.asreader.a60d.demoapp.fragments.base.BaseFragment;
import jp.co.asterisk.asreader.a60d.demoapp.util.AppSharedData;
import jp.co.asterisk.asreader.a60d.sdk.type.jvma.JVMADataId;

public class SetKindCodeFragment extends BaseFragment {

    private FragmentSetKindCodeBinding binding;
    private KindCodeAdapter adpTags;

    @Override
    public View onCreateView(
            LayoutInflater inflater, ViewGroup container,
            Bundle savedInstanceState
    ) {
        binding = FragmentSetKindCodeBinding.inflate(inflater, container, false);
        getMainActivity().setToolbarTitle(getString(R.string.toolbar_title_set_kind_code));
        getMainActivity().setResultTextVisibility(View.VISIBLE);
        getMainActivity().resetResultText();
        return binding.getRoot();
    }

    public void onViewCreated(@NonNull View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        adpTags = new KindCodeAdapter(getActivity());
        binding.listview.setAdapter(adpTags);
        adpTags.add("");
        binding.addButton.setOnClickListener(v -> {
            adpTags.add("");
        });
        binding.setButton.setOnClickListener(v -> {
            getMainActivity().resetResultText();

            String offlineSystemPassword = AppSharedData.getInstance().getOfflineSystemPassword();
            String terminalPassword = AppSharedData.getInstance().getTerminalPassword();
            boolean isInputTimeRecord = AppSharedData.getInstance().getIsInputTimeRecord();

            if (!checkPasswords(offlineSystemPassword, terminalPassword)) {
                return;
            }

            setPasswords(offlineSystemPassword, terminalPassword);

            List<String> kindCodeList = new ArrayList<>();
            for (int i = 0; i < adpTags.getCount(); i++) {
                String string = adpTags.getItem(i);
                if (string.equals("") || string.length() == 0) {
                    showToast("分類コードが入力されていません", Toast.LENGTH_SHORT);
                    return;
                }
                kindCodeList.add(string);
            }
            if (kindCodeList.size() == 0) {
                showToast("分類コードが入力されていません", Toast.LENGTH_SHORT);
                return;
            }
            Map<JVMADataId, List<String>> settingData = new HashMap<>();
            settingData.put(JVMADataId.KindCD, kindCodeList);

            // 分類コード設定
            getASKManager().setSettingDataList(settingData);

            getASKManager().sendSettingData(isInputTimeRecord);
        });
    }

    @Override
    public void onClickBackButton() {
        NavHostFragment.findNavController(SetKindCodeFragment.this).popBackStack();
    }
}
