package jp.co.asterisk.asreader.a60d.demoapp.fragments.menu.home;

import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.navigation.fragment.NavHostFragment;

import jp.co.asterisk.asreader.a60d.demoapp.R;
import jp.co.asterisk.asreader.a60d.demoapp.databinding.FragmentSettingBinding;
import jp.co.asterisk.asreader.a60d.demoapp.fragments.base.BaseFragment;
import jp.co.asterisk.asreader.a60d.demoapp.util.AppSharedData;

public class SettingFragment extends BaseFragment {

    private static final String TAG = "[DemoApp] : " + SettingFragment.class.getSimpleName();

    private Context context;
    private FragmentSettingBinding binding;


    @Override
    public void onAttach(@NonNull Context context) {
        super.onAttach(context);
        this.context = context;
    }

    @Override
    public View onCreateView(
            LayoutInflater inflater, ViewGroup container,
            Bundle savedInstanceState
    ) {
        binding = FragmentSettingBinding.inflate(inflater, container, false);
        return binding.getRoot();
    }

    @Override
    public void onResume() {
        super.onResume();
        getMainActivity().setToolbarTitle(getString(R.string.toolbar_title_setting));
        getMainActivity().showBackButton(true);
    }

    public void onViewCreated(@NonNull View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        String offlineSystemPassword = AppSharedData.getInstance().getOfflineSystemPassword();
        String terminalPassword = AppSharedData.getInstance().getTerminalPassword();
        boolean time = AppSharedData.getInstance().getIsInputTimeRecord();

        binding.offlineSystemPasswordEditText.setText(offlineSystemPassword);
        binding.terminalPasswordEditText.setText(terminalPassword);
        binding.timeToggleButton.setChecked(time);

        binding.startCommunicationButton.setOnClickListener(v -> {
            getASKManager().setTerminalPassword("");
            getASKManager().setTerminalSettingCode("");
            getASKManager().startCommunication();
        });

//        if (!BuildConfig.DEBUG) {
            binding.startCommunicationButton.setVisibility(View.GONE);
//        }

        binding.saveButton.setOnClickListener(v -> {
            if( binding.offlineSystemPasswordEditText.length()>0 && binding.offlineSystemPasswordEditText.length()!=10) {
                showToast("オフラインシステムパスワードの桁数が正しくありません", Toast.LENGTH_SHORT);
                return;
            }

            if( binding.terminalPasswordEditText.length()>0 && binding.terminalPasswordEditText.length()!=10 ){
                showToast("ターミナルパスワードの桁数が正しくありません", Toast.LENGTH_SHORT);
                return;
            }

            AppSharedData.getInstance().setOfflineSystemPassword(
                    binding.offlineSystemPasswordEditText.getText().toString());
            AppSharedData.getInstance().setTerminalPassword(
                    binding.terminalPasswordEditText.getText().toString());
            AppSharedData.getInstance().setIsInputTimeRecord(binding.timeToggleButton.isChecked());

            showToast("保存しました。", Toast.LENGTH_SHORT);
        });
    }

    @Override
    public void onClickBackButton() {
        NavHostFragment.findNavController(SettingFragment.this).popBackStack();
    }
}
