package jp.co.asterisk.asreader.a60d.demoapp.fragments.menu.home;

import android.os.Bundle;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.navigation.fragment.NavHostFragment;

import java.util.ArrayList;
import java.util.List;

import jp.co.asterisk.asreader.a60d.demoapp.R;
import jp.co.asterisk.asreader.a60d.demoapp.adapters.SelectListAdapter;
import jp.co.asterisk.asreader.a60d.demoapp.databinding.FragmentSetDataBinding;
import jp.co.asterisk.asreader.a60d.demoapp.enums.SetDataMenuItems;
import jp.co.asterisk.asreader.a60d.demoapp.fragments.base.BaseFragment;

public class SetDataFragment extends BaseFragment {

    private List<String> items;
    FragmentSetDataBinding binding;

    @Override
    public View onCreateView(
            LayoutInflater inflater, ViewGroup container,
            Bundle savedInstanceState
    ) {
        binding = FragmentSetDataBinding.inflate(inflater, container, false);
        getMainActivity().setToolbarTitle(getString(R.string.toolbar_title_set_data));
        return binding.getRoot();
    }

    @Override
    public void onResume() {
        super.onResume();
        getMainActivity().setResultTextVisibility(View.INVISIBLE);
        getMainActivity().showBackButton(true);
    }

    public void onViewCreated(@NonNull View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        items = new ArrayList<>();
        for (SetDataMenuItems command: SetDataMenuItems.values()) {
            items.add(command.getName());
        }

        SelectListAdapter selectListAdapter = new SelectListAdapter(this.getContext(), R.layout.select_list_item, items);
        binding.listView.setAdapter(selectListAdapter);

        binding.listView.setOnItemClickListener((parent, view1, position, id) -> {
            Bundle args = new Bundle();

            if (position == SetDataMenuItems.SET_VM_MANAGE_DATA.ordinal()) {
                NavHostFragment.findNavController(SetDataFragment.this)
                        .navigate(R.id.action_SetDataFragment_to_SetVMManageDataFragment, args);

            } else if (position == SetDataMenuItems.SET_ITEM_CODE.ordinal()) {
                NavHostFragment.findNavController(SetDataFragment.this)
                        .navigate(R.id.action_SetDataFragment_to_SetItemCodeFragment, args);

            } else if (position == SetDataMenuItems.SET_KIND_CODE.ordinal()) {
                NavHostFragment.findNavController(SetDataFragment.this)
                        .navigate(R.id.action_SetDataFragment_to_SetKindCodeFragment, args);

            } else if (position == SetDataMenuItems.SET_CASH_SALE_SET_RECORD.ordinal()) {
                NavHostFragment.findNavController(SetDataFragment.this)
                        .navigate(R.id.action_SetDataFragment_to_SetCashSaleRecordFragment, args);

            } else if (position == SetDataMenuItems.SET_CARD_SALE_SET_RECORD.ordinal()) {
                NavHostFragment.findNavController(SetDataFragment.this)
                        .navigate(R.id.action_SetDataFragment_to_SetCardSaleRecordFragment, args);

            } else if (position == SetDataMenuItems.SET_CASH_SALE_SET_RECORD_VM.ordinal()) {
                NavHostFragment.findNavController(SetDataFragment.this)
                        .navigate(R.id.action_SetDataFragment_to_SetCashSaleRecordVMFragment, args);

            } else if (position == SetDataMenuItems.SET_CARD_SALE_SET_RECORD_VM.ordinal()) {
                NavHostFragment.findNavController(SetDataFragment.this)
                        .navigate(R.id.action_SetDataFragment_to_SetCardSaleRecordVMFragment, args);

            } else if (position == SetDataMenuItems.SET_COLUMN_DISTINCTION.ordinal()) {
                NavHostFragment.findNavController(SetDataFragment.this)
                        .navigate(R.id.action_SetDataFragment_to_SetColumnDistinctionFragment, args);

            }
        });
    }

    @Override
    public void onClickBackButton() {
        NavHostFragment.findNavController(SetDataFragment.this).popBackStack();
    }
}
