package jp.co.asterisk.asreader.a60d.demoapp.fragments.menu.home;

import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.provider.Settings;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import androidx.annotation.NonNull;
import androidx.navigation.fragment.NavHostFragment;
import java.util.ArrayList;
import jp.co.asterisk.asreader.a60d.demoapp.R;
import jp.co.asterisk.asreader.a60d.demoapp.databinding.FragmentLogTypeBinding;
import jp.co.asterisk.asreader.a60d.demoapp.enums.LogTypeCommands;
import jp.co.asterisk.asreader.a60d.demoapp.fragments.base.BaseFragment;
import jp.co.asterisk.asreader.a60d.demoapp.util.AppSharedData;
import jp.co.asterisk.asreader.a60d.sdk.AsReaderSDK;
import jp.co.asterisk.asreader.a60d.sdk.util.SDKLog;

public class LogTypeFragment extends BaseFragment {

    private static final String TAG = "[DemoApp] : " + LogTypeFragment.class.getSimpleName();

    FragmentLogTypeBinding binding;
    private ArrayList<String> recordNameList;

    @Override
    public View onCreateView(
            LayoutInflater inflater, ViewGroup container,
            Bundle savedInstanceState ) {
        binding = FragmentLogTypeBinding.inflate(inflater, container, false);
        return binding.getRoot();
    }

    @Override
    public void onResume() {
        super.onResume();
        getMainActivity().setToolbarTitle(getString(R.string.toolbar_title_log_type));
        getMainActivity().setResultTextVisibility(View.VISIBLE);
        getMainActivity().resetResultText();
        getMainActivity().showBackButton(true);
        if (AppSharedData.getInstance().getLogType().equals(LogTypeCommands.LogTypeAPPCommands.getName())) {
            binding.recordsSpinner.setSelection(0);
        } else {
            binding.recordsSpinner.setSelection(1);
        }
    }

    public void onViewCreated(@NonNull View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        recordNameList = new ArrayList<>();
        for (LogTypeCommands command : LogTypeCommands.values()) {
            recordNameList.add(command.getName());
        }

        ArrayAdapter<String> adapter = new ArrayAdapter<>(getContext(), android.R.layout.simple_spinner_item, recordNameList);
        adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        binding.recordsSpinner.setAdapter(adapter);

        binding.collectButton.setOnClickListener(v -> {
            int position = binding.recordsSpinner.getSelectedItemPosition();
            if (position == 0) {
                AsReaderSDK.getInstance().changeSDKLogType(SDKLog.LogType.LogType_APP);
                AppSharedData.getInstance().setLogType(LogTypeCommands.LogTypeAPPCommands.getName());
            } else {
//                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.R) {
//                    if (!Environment.isExternalStorageManager()) {
//                        AlertDialog.Builder builder = new AlertDialog.Builder(getContext());
//                        builder.setTitle("アプリを使用するために、全てのファイルへのアクセスの許可をONにしてください");
//                        builder.setPositiveButton("OK", new DialogInterface.OnClickListener() {
//                            @Override
//                            public void onClick(DialogInterface dialog, int which) {
//                                Intent intent = new Intent(Settings.ACTION_MANAGE_ALL_FILES_ACCESS_PERMISSION);
//                                startActivity(intent);
//                            }
//                        });
//                        builder.setNegativeButton("Cancel", new DialogInterface.OnClickListener() {
//                            @Override
//                            public void onClick(DialogInterface dialog, int which) {
//
//                            }
//                        });
//                        builder.setCancelable(true);
//                        builder.setOnCancelListener(new DialogInterface.OnCancelListener() {
//                            @Override
//                            public void onCancel(DialogInterface dialog) {
//                            }
//                        });
//                        AlertDialog dialog = builder.create();
//                        dialog.show();
//                    } else {
//                        AsReaderSDK.getInstance().changeSDKLogType(SDKLog.LogType.LogType_Root);
//                        AppSharedData.getInstance().setLogType(LogTypeCommands.LogTypeRootCommands.getName());
//                    }
//                } else {
                    AsReaderSDK.getInstance().changeSDKLogType(SDKLog.LogType.LogType_Root);
                    AppSharedData.getInstance().setLogType(LogTypeCommands.LogTypeRootCommands.getName());
//                }
            }
        });
    }

    @Override
    public void onClickBackButton() {
        NavHostFragment.findNavController(LogTypeFragment.this).popBackStack();
    }
}
