package jp.co.asterisk.asreader.a60d.demoapp.fragments.menu.home;

import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;

import androidx.annotation.NonNull;
import androidx.navigation.fragment.NavHostFragment;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import jp.co.asterisk.asreader.a60d.demoapp.R;
import jp.co.asterisk.asreader.a60d.demoapp.databinding.FragmentCollectDataBinding;
import jp.co.asterisk.asreader.a60d.demoapp.enums.DataCollectCommands;
import jp.co.asterisk.asreader.a60d.demoapp.fragments.base.BaseFragment;
import jp.co.asterisk.asreader.a60d.demoapp.util.AppSharedData;
import jp.co.asterisk.asreader.a60d.sdk.type.jvma.JVMADataId;

public class CollectDataFragment extends BaseFragment {

    private static final String TAG = "[DemoApp] : " + CollectDataFragment.class.getSimpleName();

    FragmentCollectDataBinding binding;
    private ArrayList<String> recordNameList;

    @Override
    public View onCreateView(
            LayoutInflater inflater, ViewGroup container,
            Bundle savedInstanceState ) {
        binding = FragmentCollectDataBinding.inflate(inflater, container, false);
        return binding.getRoot();
    }

    @Override
    public void onResume() {
        super.onResume();
        getMainActivity().setToolbarTitle(getString(R.string.toolbar_title_collect_data));
        getMainActivity().setResultTextVisibility(View.VISIBLE);
        getMainActivity().resetResultText();
        getMainActivity().showBackButton(true);
    }

    public void onViewCreated(@NonNull View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        recordNameList = new ArrayList<>();
        for (DataCollectCommands command : DataCollectCommands.values()) {
            recordNameList.add(command.getName());
        }

        ArrayAdapter<String> adapter = new ArrayAdapter<>(getContext(), android.R.layout.simple_spinner_item, recordNameList);
        adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        binding.recordsSpinner.setAdapter(adapter);

        binding.collectButton.setOnClickListener(v -> {
            getMainActivity().resetResultText();

            List<String> dataRecords = null;
            int position = binding.recordsSpinner.getSelectedItemPosition();
            Log.d(TAG, "position:" + position);
            String record = getDataRecord(position);
            Log.d(TAG, "record:" + record);
            if (!TextUtils.isEmpty(record)) {
                dataRecords = new ArrayList<>();
                dataRecords.add(record);
            }

            String offlineSystemPassword = AppSharedData.getInstance().getOfflineSystemPassword();
            String terminalPassword = AppSharedData.getInstance().getTerminalPassword();
            boolean isInputTimeRecord = AppSharedData.getInstance().getIsInputTimeRecord();

            if (!checkPasswords(offlineSystemPassword, terminalPassword)) {
                return;
            }

            setPasswords(offlineSystemPassword, terminalPassword);

            if (position == DataCollectCommands.ManageData03.ordinal()) {
                getASKManager().collectSettingData(isInputTimeRecord);
            }
            else {
                getASKManager().getVmData(isInputTimeRecord, dataRecords);
            }
        });
    }

    public String getDataRecord(int position) {

        String record = "";

        if (position == DataCollectCommands.IndividualData.ordinal()) {
            record = JVMADataId.IndividualData.getName();
        }
        else if (position == DataCollectCommands.OfflineLog.ordinal()) {
            record = JVMADataId.OfflineLog.getName();
        }
        else if (position == DataCollectCommands.SetTotal.ordinal()) {
            record = JVMADataId.SetTotal.getName();
        }
        else if (position == DataCollectCommands.SaleAmount.ordinal()) {
            record = JVMADataId.SaleAmount.getName();
        }
        else if (position == DataCollectCommands.ShouhinCD.ordinal()) {
            record = JVMADataId.ShouhinCD.getName();
        }
        else if (position == DataCollectCommands.KindCD.ordinal()) {
            record = JVMADataId.KindCD.getName();
        }
        else if (position == DataCollectCommands.ColumnCashPrice.ordinal()) {
            record = JVMADataId.ColumnCashPrice.getName();
        }
        else if (position == DataCollectCommands.ColumnQuantity.ordinal()) {
            record = JVMADataId.ColumnQuantity.getName();
        }
        else if (position == DataCollectCommands.ColumnSaleOutTime.ordinal()) {
            record = JVMADataId.ColumnSaleOutTime.getName();
        }
        else if (position == DataCollectCommands.ColumnCardPrice.ordinal()) {
            record = JVMADataId.ColumnCardPrice.getName();
        }
        else if (position == DataCollectCommands.PrepayCardQuantity.ordinal()) {
            record = JVMADataId.PrepayCardQuantity.getName();
        }
        else if (position == DataCollectCommands.PrepayCardSaleAmount.ordinal()) {
            record = JVMADataId.PrepayCardSaleAmount.getName();
        }
        else if (position == DataCollectCommands.IdCardQuantity.ordinal()) {
            record = JVMADataId.IdCardQuantity.getName();
        }
        else if (position == DataCollectCommands.FreeSaleQuantity.ordinal()) {
            record = JVMADataId.FreeSaleQuantity.getName();
        }
        else if (position == DataCollectCommands.InputCashQuantity.ordinal()) {
            record = JVMADataId.InputCashQuantity.getName();
        }
        else if (position == DataCollectCommands.QuitCashQuantity.ordinal()) {
            record = JVMADataId.QuitCashQuantity.getName();
        }
        else if (position == DataCollectCommands.ChangEmptyTime.ordinal()) {
            record = JVMADataId.ChangEmptyTime.getName();
        }
        else if (position == DataCollectCommands.InputMoneyQuantity.ordinal()) {
            record = JVMADataId.InputMoneyQuantity.getName();
        }
        else if (position == DataCollectCommands.ExhaustMoneyQuantity.ordinal()) {
            record = JVMADataId.ExhaustMoneyQuantity.getName();
        }
        else if (position == DataCollectCommands.ManageData01.ordinal()) {
            record = JVMADataId.ManageData.getName();
        }
        else if (position == DataCollectCommands.ManageData03.ordinal()) {
            record = JVMADataId.ManageData.getName();;

        }
        return record;
    }

    @Override
    public void onClickBackButton() {
        NavHostFragment.findNavController(CollectDataFragment.this).popBackStack();
    }
}
