package jp.co.asterisk.asreader.a60d.demoapp.fragments.menu.home;

import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;

import androidx.annotation.NonNull;
import androidx.navigation.fragment.NavHostFragment;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import jp.co.asterisk.asreader.a60d.demoapp.R;
import jp.co.asterisk.asreader.a60d.demoapp.databinding.FragmentClearDataBinding;
import jp.co.asterisk.asreader.a60d.demoapp.enums.DataClearCommands;
import jp.co.asterisk.asreader.a60d.demoapp.fragments.base.BaseFragment;
import jp.co.asterisk.asreader.a60d.demoapp.util.AppSharedData;
import jp.co.asterisk.asreader.a60d.sdk.ASKManager;
import jp.co.asterisk.asreader.a60d.sdk.AsReaderSDK;
import jp.co.asterisk.asreader.a60d.sdk.type.jvma.JVMACommand;
import jp.co.asterisk.asreader.a60d.sdk.type.jvma.JVMADataId;

public class ClearDataFragment extends BaseFragment {

    private static final String TAG = "[DemoApp] : " + ClearDataFragment.class.getSimpleName();

    private FragmentClearDataBinding binding;

    private ArrayList<String> recordNameList;

    boolean test = false;

    public ClearDataFragment() {
    }

    @Override
    public View onCreateView(
            LayoutInflater inflater, ViewGroup container,
            Bundle savedInstanceState
    ) {
        binding = FragmentClearDataBinding.inflate(inflater, container, false);
        return binding.getRoot();
    }

    @Override
    public void onResume() {
        super.onResume();
        getMainActivity().setResultTextVisibility(View.VISIBLE);
        getMainActivity().resetResultText();
        getMainActivity().setToolbarTitle(getString(R.string.toolbar_title_clear_data));
        getMainActivity().showBackButton(true);
    }

    public void onViewCreated(@NonNull View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        recordNameList = new ArrayList<>();
        for (DataClearCommands command : DataClearCommands.values()) {
            recordNameList.add(command.getName());
        }

        ArrayAdapter<String> adapter = new ArrayAdapter<>(getContext(), android.R.layout.simple_spinner_item, recordNameList);
        adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        binding.recordsSpinner.setAdapter(adapter);

        binding.getRoot();

        binding.clearButton.setOnClickListener(v -> {
            getMainActivity().resetResultText();

            List<String> dataRecords = null;
            int position = binding.recordsSpinner.getSelectedItemPosition();
            String record = getDataRecord(position);
            Log.d(TAG, "record:" + record);
            if (!TextUtils.isEmpty(record)) {
                dataRecords = new ArrayList<>();
                dataRecords.add(record);
            }

            try {
                int retry = Integer.parseInt(binding.retryEditText.getText().toString());
                retry = (retry <= 0) ? 5 : retry;
                getASKManager().setRetryTime(retry);
            } catch (NumberFormatException e) {
                e.printStackTrace();
                getASKManager().setRetryTime(5);
            }

            String offlineSystemPassword = AppSharedData.getInstance().getOfflineSystemPassword();
            String terminalPassword = AppSharedData.getInstance().getTerminalPassword();
            boolean isInputTimeRecord = AppSharedData.getInstance().getIsInputTimeRecord();

            if (!checkPasswords(offlineSystemPassword, terminalPassword)) {
                return;
            }

            setPasswords(offlineSystemPassword, terminalPassword);

            if (dataRecords == null) {
                getASKManager().allClear(isInputTimeRecord);
            } else {
                if (binding.automaticConfirmationSwitch.isChecked()) {
                    getASKManager().clearVmData(isInputTimeRecord, dataRecords);
                } else {
                    getASKManager().clearVmDataWithoutConfirmation(isInputTimeRecord,dataRecords);
                }
            }
        });
        binding.confirmButton.setOnClickListener(v -> {
            getASKManager().confirmClear();
        });
        binding.automaticConfirmationSwitch.setOnClickListener(v -> {
            if (binding.automaticConfirmationSwitch.isChecked()) {
                binding.confirmButton.setVisibility(View.GONE);
                binding.retryEditText.setEnabled(true);
            } else {
                binding.confirmButton.setVisibility(View.VISIBLE);
                binding.retryEditText.setEnabled(false);
            }
        });
        binding.recordsSpinner.setOnItemSelectedListener(new android.widget.AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(android.widget.AdapterView<?> parent, android.view.View view, int position, long id) {
                if (position == 20) {
                    binding.automaticConfirmationSwitch.setChecked(true);
                    binding.automaticConfirmationSwitch.setEnabled(false);
                    binding.confirmButton.setVisibility(View.GONE);
                    binding.retryEditText.setEnabled(true);
                } else {
                    binding.automaticConfirmationSwitch.setEnabled(true);
                }
            }

            @Override
            public void onNothingSelected(android.widget.AdapterView<?> parent) {

            }
        });
    }

    public String getDataRecord(int position) {
        String record = "";
        if (position == DataClearCommands.IndividualData.ordinal()) {
            record = JVMADataId.IndividualData.getName();

        } else if (position == DataClearCommands.OfflineLog.ordinal()) {
            record = JVMADataId.OfflineLog.getName();

        } else if (position == DataClearCommands.SetTotal.ordinal()) {
            record = JVMADataId.SetTotal.getName();

        } else if (position == DataClearCommands.SaleAmount.ordinal()) {
            record = JVMADataId.SaleAmount.getName();

        } else if (position == DataClearCommands.ShouhinCD.ordinal()) {
            record = JVMADataId.ShouhinCD.getName();

        } else if (position == DataClearCommands.KindCD.ordinal()) {
            record = JVMADataId.KindCD.getName();

        } else if (position == DataClearCommands.ColumnCashPrice.ordinal()) {
            record = JVMADataId.ColumnCashPrice.getName();

        } else if (position == DataClearCommands.ColumnQuantity.ordinal()) {
            record = JVMADataId.ColumnQuantity.getName();

        } else if (position == DataClearCommands.ColumnSaleOutTime.ordinal()) {
            record = JVMADataId.ColumnSaleOutTime.getName();

        } else if (position == DataClearCommands.ColumnCardPrice.ordinal()) {
            record = JVMADataId.ColumnCardPrice.getName();

        } else if (position == DataClearCommands.PrepayCardQuantity.ordinal()) {
            record = JVMADataId.PrepayCardQuantity.getName();

        } else if (position == DataClearCommands.PrepayCardSaleAmount.ordinal()) {
            record = JVMADataId.PrepayCardSaleAmount.getName();

        } else if (position == DataClearCommands.IdCardQuantity.ordinal()) {
            record = JVMADataId.IdCardQuantity.getName();

        } else if (position == DataClearCommands.FreeSaleQuantity.ordinal()) {
            record = JVMADataId.FreeSaleQuantity.getName();

        } else if (position == DataClearCommands.InputCashQuantity.ordinal()) {
            record = JVMADataId.InputCashQuantity.getName();

        } else if (position == DataClearCommands.QuitCashQuantity.ordinal()) {
            record = JVMADataId.QuitCashQuantity.getName();

        } else if (position == DataClearCommands.ChangEmptyTime.ordinal()) {
            record = JVMADataId.ChangEmptyTime.getName();

        } else if (position == DataClearCommands.InputMoneyQuantity.ordinal()) {
            record = JVMADataId.InputMoneyQuantity.getName();

        } else if (position == DataClearCommands.ExhaustMoneyQuantity.ordinal()) {
            record = JVMADataId.ExhaustMoneyQuantity.getName();

        } else if (position == DataClearCommands.ManageData.ordinal()) {
            record = JVMADataId.ManageData.getName();
        }

        return record;
    }

    @Override
    public void onClickBackButton() {
        NavHostFragment.findNavController(ClearDataFragment.this).popBackStack();
    }
}
