package jp.co.asterisk.asreader.a60d.demoapp.fragments.base;

import android.content.Context;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.Toast;

import androidx.fragment.app.Fragment;

import jp.co.asterisk.asreader.a60d.demoapp.MainActivity;
import jp.co.asterisk.asreader.a60d.demoapp.R;
import jp.co.asterisk.asreader.a60d.sdk.ASKManager;
import jp.co.asterisk.asreader.a60d.sdk.AsReaderSDK;

public class BaseFragment  extends Fragment {

    private Toast mToast = null;

    protected void showToast(String massage, int duration) {
        if(mToast != null) mToast.cancel();
        mToast = Toast.makeText(this.getContext(), massage, Toast.LENGTH_SHORT);
        mToast.show();

        Toast.makeText(getContext(), massage, duration).show();
    }

    protected MainActivity getMainActivity() {
        return ((MainActivity)getActivity());
    }

    protected void hideKeyboard(View view) {
        ((InputMethodManager)getActivity().getSystemService(Context.INPUT_METHOD_SERVICE)).
                hideSoftInputFromWindow(view.getWindowToken(), 0);
    }

    protected ASKManager getASKManager() {
        return AsReaderSDK.getInstance().getASKManager();
    }

    protected boolean checkPasswords(String offlineSystemPassword, String terminalPassword) {

//        if (BuildConfig.DEBUG) {
//            return true;
//        }

        if (offlineSystemPassword.equals("") || terminalPassword.equals("")) {
            showToast(getString(R.string.error_not_set_password), Toast.LENGTH_LONG);
            return false;
        }

        return true;
    }

    protected void setPasswords(String offlineSystemPassword, String terminalPassword) {

//        if (BuildConfig.DEBUG) {
//            getASKManager().setTerminalPassword(terminalPassword);
//            getASKManager().setTerminalSettingCode(offlineSystemPassword);
//        } else {
            getASKManager().setTerminalPassword(terminalPassword);
            getASKManager().setTerminalSettingCode(offlineSystemPassword);
//        }
    }

    public void onClickBackButton() {

    }
}

