package jp.co.asterisk.asreader.a60d.demoapp.fragments;

import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.navigation.fragment.NavHostFragment;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.co.asterisk.asreader.a60d.demoapp.R;
import jp.co.asterisk.asreader.a60d.demoapp.adapters.SelectListAdapter;
import jp.co.asterisk.asreader.a60d.demoapp.databinding.FragmentHomeBinding;
import jp.co.asterisk.asreader.a60d.demoapp.enums.HomeMenuItems;
import jp.co.asterisk.asreader.a60d.demoapp.fragments.base.BaseFragment;
import jp.co.asterisk.asreader.a60d.sdk.AsReaderSDK;
import jp.co.asterisk.asreader.a60d.sdk.type.jvma.JVMADataId;

public class HomeFragment extends BaseFragment {

    public static final String TAG = "[DemoApp] : " + HomeFragment.class.getSimpleName();

    private List<String> items;

    private FragmentHomeBinding binding;

    @Override
    public View onCreateView(
            LayoutInflater inflater, ViewGroup container,
            Bundle savedInstanceState
    ) {
        Log.d(TAG, "onCreateView");
        binding = FragmentHomeBinding.inflate(inflater, container, false);

//         setToolbarTitle(getString(R.string.toolbar_title_main));
        return binding.getRoot();
    }

    @Override
    public void onResume() {
        super.onResume();
        getMainActivity().setResultTextVisibility(View.INVISIBLE);
        getMainActivity().setToolbarTitle(getString(R.string.toolbar_title_main));
        getMainActivity().showBackButton(false);
    }

    public void onViewCreated(@NonNull View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        items = new ArrayList<>();
        for (HomeMenuItems command: HomeMenuItems.values()) {
            items.add(command.getName());
        }

        SelectListAdapter selectListAdapter = new SelectListAdapter(this.getContext(), R.layout.select_list_item, items);
        binding.listView.setAdapter(selectListAdapter);
        binding.listView.setOnItemClickListener((parent, view1, position, id) -> {
            Bundle args = new Bundle();

            if (position == HomeMenuItems.COLLECT_DATA.ordinal()) {
                NavHostFragment.findNavController(HomeFragment.this)
                        .navigate(R.id.action_HomeFragment_to_CollectFragment, args);

            } else if (position == HomeMenuItems.SET_DATA.ordinal()) {
                NavHostFragment.findNavController(HomeFragment.this)
                        .navigate(R.id.action_HomeFragment_to_SetDataFragment, args);

            } else if (position == HomeMenuItems.CLEAR_DATA.ordinal()) {
                NavHostFragment.findNavController(HomeFragment.this)
                        .navigate(R.id.action_HomeFragment_to_ClearDataFragment, args);

            } else if (position == HomeMenuItems.SETTING.ordinal()) {
                NavHostFragment.findNavController(HomeFragment.this)
                        .navigate(R.id.action_HomeFragment_to_SettingFragment, args);

//            } else if (position == HomeMenuItems.RESTART_DEVICE.ordinal()) {
//                AsReaderSDK.getInstance().getDeviceManager().setPower(false);
//                try {
//                    Thread.sleep(300L);
//                } catch (InterruptedException var2) {
//                }
//                AsReaderSDK.getInstance().getDeviceManager().setPower(true);
//            AsReaderSDK.getDeviceManager().notifyApplicationActive();

//            } else if (position == HomeMenuItems.CHANGE_LOG_TYPE.ordinal()) {
//                NavHostFragment.findNavController(HomeFragment.this)
//                        .navigate(R.id.action_HomeFragment_to_LogTypeFragment, args);

            } else if (position == HomeMenuItems.REMOVE_ALL_LOG_FILES.ordinal()) {
//            LogManager.getInstance().removeAllFiles();
                AsReaderSDK.getInstance().removeSDKLog();
                showToast("ログファイルを削除しました", 1);
            }
            else if (position == HomeMenuItems.TEST_DATA_MULTIPLE.ordinal()) {
                List<String> itemCodeList = new ArrayList<>();
                for (int i = 0; i < 50;i++){
                    itemCodeList.add("10513800000"+String.format("%03d",i));
                }
                List<String> itemCodeList1 = new ArrayList<>();
                for (int i = 0; i < 50;i++){
                    itemCodeList1.add("205138000"+String.format("%03d",i));
                }
                Map<JVMADataId, List<String>> settingData = new HashMap<>();
                settingData.put(JVMADataId.ShouhinCD, itemCodeList);
                settingData.put(JVMADataId.KindCD, itemCodeList1);
                settingData.put(JVMADataId.AnotherCardSaleSetRecord, itemCodeList1);
                settingData.put(JVMADataId.BrandOtherSalePrice, itemCodeList);
                settingData.put(JVMADataId.VmIdentifyCode, itemCodeList1);
                settingData.put(JVMADataId.SetTotal, itemCodeList);
                settingData.put(JVMADataId.SaleAmount, itemCodeList1);
                settingData.put(JVMADataId.ColumnCashPrice, itemCodeList);
                settingData.put(JVMADataId.ColumnQuantity, itemCodeList1);
                settingData.put(JVMADataId.ColumnSaleOutTime, itemCodeList);
                settingData.put(JVMADataId.ColumnCardPrice, itemCodeList1);
                settingData.put(JVMADataId.PrepayCardQuantity, itemCodeList);
                settingData.put(JVMADataId.PrepayCardSaleAmount, itemCodeList1);
                AsReaderSDK.getInstance().getASKManager().sendTestData(settingData);
            } else if (position == HomeMenuItems.TEST_DATA_SINGLE.ordinal()) {
                List<String> itemCodeList = new ArrayList<>();
                itemCodeList.add("10513800000000");
                itemCodeList.add("12004400000000");
                itemCodeList.add("10500400000000");
                Map<JVMADataId, List<String>> settingData = new HashMap<>();
                settingData.put(JVMADataId.ShouhinCD, itemCodeList);
                AsReaderSDK.getInstance().getASKManager().sendTestData(settingData);
            }
        });
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        binding = null;
    }

    @Override
    public void onClickBackButton() {
    }
}