package jp.co.asterisk.asreader.a60d.demoapp.dialog;

import android.app.Dialog;
import android.app.TimePickerDialog;
import android.os.Bundle;
import android.widget.TimePicker;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.DialogFragment;

import java.util.Calendar;
import java.util.Date;

public class TimePickerDialogFragment extends DialogFragment implements TimePickerDialog.OnTimeSetListener {
    public interface OnSelectedTimeListener {
        void selectedTime(int hour, int minute);
    }

    private OnSelectedTimeListener listener;

    public TimePickerDialogFragment(OnSelectedTimeListener listener) {
        this.listener = listener;
    }

    @NonNull
    @Override
    public Dialog onCreateDialog(@Nullable Bundle savedInstanceState) {
        final Calendar calendar = Calendar.getInstance();
        Date date = new Date();
        calendar.setTimeInMillis(date.getTime());

        return new TimePickerDialog(
                getContext(),
                this,
                calendar.get(Calendar.HOUR_OF_DAY),
                calendar.get(Calendar.MINUTE),
                true
        );
    }

    @Override
    public void onTimeSet(TimePicker view, int hourOfDay, int minute) {
        listener.selectedTime(hourOfDay, minute);
    }
}
