package jp.co.asterisk.asreader.a60d.demoapp.adapters;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import java.util.List;

import jp.co.asterisk.asreader.a60d.demoapp.R;

public class SelectListAdapter extends ArrayAdapter<String> {

    private int resource;
    private List<String> items;
    private LayoutInflater inflater;

    public SelectListAdapter(Context context, int resource, List<String> items) {
        super(context, resource, items);

        this.resource = resource;
        this.items = items;
        this.inflater = (LayoutInflater)context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
    }

    @NonNull
    @Override
    public View getView(int position, @Nullable View convertView, @NonNull ViewGroup parent) {
        View view;

        if (convertView != null) {
            view = convertView;
        } else {
            view = inflater.inflate(resource,  null);
        }

        String item = items.get(position);

        TextView titleTextView = view.findViewById(R.id.title_text_view);
        titleTextView.setText(item);

        ImageView arrowImage = view.findViewById(R.id.arrow_image);
        if (position == 0 || position == 1 || position == 2 || position == 3){
            arrowImage.setVisibility(View.VISIBLE);
        }else {
            arrowImage.setVisibility(View.INVISIBLE);
        }

        return view;
    }
}
