package jp.co.asterisk.asreader.a60d.demoapp.adapters;

import android.content.Context;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.EditText;
import android.widget.ImageButton;

import java.util.ArrayList;

import jp.co.asterisk.asreader.a60d.demoapp.R;

public class ItemCodeAdapter extends BaseAdapter {
    private LayoutInflater mInflater;
    private ArrayList<String> mData = new ArrayList<>();

    public ItemCodeAdapter(Context context) {
        mInflater = LayoutInflater.from(context);
    }

    public void add(String newData) {
        mData.add(newData);
        notifyDataSetChanged();
    }

    public void delete(int position) {
        if (position < mData.size()) {
            mData.remove(position);
            notifyDataSetChanged();
        }
    }

    @Override
    public int getCount() {
        return mData.size();
    }

    @Override
    public String getItem(int position) {
        return mData.get(position);
    }

    @Override
    public long getItemId(int position) {
        return 0;
    }

    private Integer index = -1;

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        ItemCodeAdapter.ViewHolder holder;
        if (convertView == null) {
            holder = new ItemCodeAdapter.ViewHolder();
            convertView = mInflater.inflate(R.layout.set_item_code_list_item, null);
            holder.deleteButton = convertView
                    .findViewById(R.id.delete_button);
            holder.value = convertView
                    .findViewById(R.id.item1_edit_text);
            holder.value.setTag(position);
            holder.value.setOnTouchListener(new View.OnTouchListener() {
                @Override
                public boolean onTouch(View v, MotionEvent event) {
                    if (event.getAction() == MotionEvent.ACTION_UP) {
                        index = (Integer) v.getTag();
                    }
                    return false;
                }
            });
            class MyTextWatcher implements TextWatcher {
                public MyTextWatcher(ItemCodeAdapter.ViewHolder holder) {
                    mHolder = holder;
                }

                private ItemCodeAdapter.ViewHolder mHolder;

                @Override
                public void onTextChanged(CharSequence s, int start,
                                          int before, int count) {
                }

                @Override
                public void beforeTextChanged(CharSequence s, int start,
                                              int count, int after) {
                }

                @Override
                public void afterTextChanged(Editable s) {
                    int position = (Integer) mHolder.value.getTag();
                    if (s != null && !"".equals(s.toString())) {
                        String str = s.toString();
                        int zeroCount = 14 - str.length();
                        if (str.length() < 14) {
                            for (int i =0; i < zeroCount; i++)
                                str = "0" + str;
                        }
                        mData.set(position, str);
                    } else {
                        mData.set(position, "");
                    }
                }
            }
            holder.value.addTextChangedListener(new MyTextWatcher(holder));
            convertView.setTag(holder);
        } else {
            holder = (ItemCodeAdapter.ViewHolder) convertView.getTag();
            holder.value.setTag(position);
        }
        String value = mData.get(position);
        if (value != null && !"".equals(value)) {
            holder.value.setText(value);
        } else {
            holder.value.setText("");
        }
        holder.value.clearFocus();
        if (index != -1 && index == position) {
            holder.value.requestFocus();
        }
        holder.deleteButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                delete(position);
            }
        });
        return convertView;
    }

    public final class ViewHolder {
        public EditText value;
        public ImageButton deleteButton;
    }
}
