package jp.co.asterisk.asreader.a60d.demoapp;

import android.app.AlertDialog;
import android.bluetooth.BluetoothDevice;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.Color;
import android.net.Uri;
import android.os.Bundle;

import androidx.annotation.ColorRes;
import androidx.appcompat.app.AppCompatActivity;

import android.os.Handler;
import android.provider.Settings;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;

import androidx.fragment.app.Fragment;
import androidx.navigation.Navigator;
import androidx.navigation.ui.AppBarConfiguration;

import jp.co.asterisk.asreader.a60d.demoapp.databinding.ActivityMainBinding;
import jp.co.asterisk.asreader.a60d.demoapp.dialog.BleListViewDialog;
import jp.co.asterisk.asreader.a60d.demoapp.fragments.base.BaseFragment;
import jp.co.asterisk.asreader.a60d.demoapp.util.AppSharedData;
import jp.co.asterisk.asreader.a60d.sdk.AsReaderSDK;
import jp.co.asterisk.asreader.a60d.sdk.device.connection.ConnectionType;
import jp.co.asterisk.asreader.a60d.sdk.device.connection.PermissionState;
import jp.co.asterisk.asreader.a60d.sdk.event.ASKManagerCallBack;
import jp.co.asterisk.asreader.a60d.sdk.event.BLEScanCallback;
import jp.co.asterisk.asreader.a60d.sdk.event.DeviceManagerCallback;
import jp.co.asterisk.asreader.a60d.sdk.protocol.JVMAModel;
import jp.co.asterisk.asreader.a60d.sdk.protocol.JVMARecord;
import jp.co.asterisk.asreader.a60d.sdk.type.PacketValue;
import jp.co.asterisk.asreader.a60d.sdk.type.ask.TriggerStatus;
import jp.co.asterisk.asreader.a60d.sdk.util.SDKLog;

import android.view.Menu;
import android.view.MenuItem;
import android.widget.Button;
import android.widget.ProgressBar;
import android.widget.Toast;

import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MainActivity extends AppCompatActivity implements DeviceManagerCallback, BLEScanCallback, ASKManagerCallBack {

    private static final String TAG = "[DemoApp] : " + MainActivity.class.getSimpleName();

    private AppBarConfiguration appBarConfiguration;
    private ActivityMainBinding binding;
    private boolean isScrollBottom = true;

    private Navigator navigator;
    private AlertDialog alertDialog;
    private BleListViewDialog bleListDialog;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        binding = ActivityMainBinding.inflate(getLayoutInflater());
        setContentView(binding.getRoot());

        AppSharedData.getInstance().initialize(getApplicationContext());
//        AppSharedData.getInstance().setTerminalPassword("");
//        AppSharedData.getInstance().setOfflineSystemPassword("");


        setSupportActionBar(binding.toolbar);
//        binding.toolbar.setElevation(10);
        getSupportActionBar().setDisplayShowTitleEnabled(false);
        showLeftButton(false);

        AsReaderSDK.getInstance().getDeviceManager().setDeviceManagerCallback(this);
        AsReaderSDK.getInstance().getASKManager().setAskManagerCallBack(this);

        // set BLE or USB module
        String currentMode = AppSharedData.getInstance().getCurrentConnectionMode();
        setConnectionModule(ConnectionType.checkConnectionType(currentMode));

        binding.sdkVersionTextView.setText("SDK Ver: " + AsReaderSDK.getInstance().getVersion());

        binding.scrollView.setOnScrollChangeListener(scrollChangeListener);

        binding.logClearImageButton.setOnClickListener(v -> {
            binding.logTextView.setText("");
        });

        binding.bleScanButton.setOnClickListener(v -> {
            showScanPopUp();
        });
        binding.modeBleButton.setOnClickListener(v -> {
            AsReaderSDK.getInstance().getDeviceManager().destroy();
            setConnectionModule(ConnectionType.BLE);
        });
        binding.modeUsbButton.setOnClickListener(v -> {
            AsReaderSDK.getInstance().getDeviceManager().destroy();
            setConnectionModule(ConnectionType.USB);
        });
        binding.testMode.setOnClickListener(v -> {
            addToLogText("startTestMode " + "\r\n");
            new Thread(new Runnable() {
                @Override
                public void run() {
                    boolean success = AsReaderSDK.getInstance().getDeviceManager().startTestMode();
                    runOnUiThread(() -> {
                        addToLogText("startTestMode:"+success + "\r\n");
                    });

                }
            }).start();

        });
        binding.restart.setOnClickListener(v -> {
            AsReaderSDK.getInstance().getDeviceManager().setPower(false);
            try {
                Thread.sleep(300L);
            } catch (InterruptedException var2) {
            }
            AsReaderSDK.getInstance().getDeviceManager().setPower(true);
        });
    }

    @Override
    protected void onStart() {
        super.onStart();
        setBatteryState(0);

//        // 復帰した場合
//        if (AsReaderSDK.getInstance().getDeviceManager() != null) {
//            // 再接続
//            AsReaderSDK.getInstance().getDeviceManager().notifyApplicationActive();
//        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();

        AsReaderSDK.getInstance().getDeviceManager().setPower(false);
        AsReaderSDK.getInstance().getDeviceManager().destroy();
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
//        getMenuInflater().inflate(R.menu.menu_main, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        int id = item.getItemId();

        //noinspection SimplifiableIfStatement
        if (id == R.id.action_settings) {
            return true;
        }

        return super.onOptionsItemSelected(item);
    }

    @Override
    public boolean onSupportNavigateUp() {
        onClickBackButton();
        return super.onSupportNavigateUp();
//        NavController navController = Navigation.findNavController(this, R.id.nav_host_fragment_content_main);
//        return NavigationUI.navigateUp(navController, appBarConfiguration)
//                || super.onSupportNavigateUp();
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == KeyEvent.KEYCODE_BACK) {
            onClickBackButton();
            return false;
        }

        return super.onKeyDown(keyCode, event);
    }

    /**
     * Public method
     */
    private Fragment getCurrentFragment() {
        Fragment navHostFragment = getSupportFragmentManager().findFragmentById(R.id.nav_host_fragment_content_main);
        return (navHostFragment != null) ? navHostFragment.getChildFragmentManager().getFragments().get(0) : null;
    }

    private void onClickBackButton() {
        runOnUiThread(() -> {

            Fragment currentFragment = getCurrentFragment();
            if (currentFragment instanceof BaseFragment) {
                ((BaseFragment) currentFragment).onClickBackButton();
            }
        });
    }

    public void showBackButton(boolean show) {
        Objects.requireNonNull(getSupportActionBar()).setDisplayShowHomeEnabled(show);
        getSupportActionBar().setDisplayHomeAsUpEnabled(show);
    }

    public void showLeftButton(boolean show) {
        Objects.requireNonNull(getSupportActionBar()).setDisplayShowHomeEnabled(show);
        getSupportActionBar().setDisplayHomeAsUpEnabled(show);
    }

    public void showToast(String message) {
        Toast.makeText(this, message, Toast.LENGTH_SHORT).show();
    }

    public void setToolbarTitle(String title) {

        if( binding.titleTextView!=null && title!=null) {
            binding.titleTextView.setText(title);
        }
    }

    public void resetResultText() {
        binding.resultTextView.setText(getString(R.string.connect_result_none));
        binding.resultTextView.setBackgroundColor(getColor(R.color.white));
        binding.resultTextView.setTextColor(getColor(R.color.black));
    }

    public void setResultTextColor(@ColorRes int color) {
        binding.resultTextView.setTextColor(getColor(color));
    }

    public void setResultTextVisibility(int visibility) {
        binding.resultTextView.setVisibility(visibility);
    }

    /**
     * Private method
     */
    public void setBatteryState(int battery) {
        int batteryImageID = R.drawable.btb_0;

        if (battery > 80) {
            batteryImageID = R.drawable.btb_100;

        } else if (battery > 60) {
            batteryImageID = R.drawable.btb_75;

        } else if (battery > 40) {
            batteryImageID = R.drawable.btb_50;

        } else if (battery > 20) {
            batteryImageID = R.drawable.btb_25;
        }

        binding.batteryImageView.setImageDrawable(getDrawable(batteryImageID));
    }

    private void addToLogText(String logText) {
        binding.logTextView.append(logText);
        if (isScrollBottom) {
            binding.scrollView.post(() -> {
                binding.scrollView.fullScroll(View.FOCUS_DOWN);
            });
        }
    }

    private View.OnScrollChangeListener scrollChangeListener = (View v, int scrollX, int scrollY, int oldScrollX, int oldScrollY) -> {
        View content = binding.scrollView.getChildAt(0);
        if (content == null) return;

        isScrollBottom = (scrollY + binding.scrollView.getHeight()) >= content.getHeight();
    };

    /**
     * DeviceManager Callback
     */
    @Override
    public void onConnect(boolean isConnect) {
        runOnUiThread(() -> {
            String msg = "onConnect 状態 : " + isConnect;
            Toast.makeText(getApplicationContext(),msg, Toast.LENGTH_SHORT).show();

            String text = isConnect ? "Connect" : "Disconnect";
            binding.stateTextView.setText(text);

            try {
                Thread.sleep(1000);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if(isConnect){
                AsReaderSDK.getInstance().getDeviceManager().setPower(false);
                try {
                    Thread.sleep(1000);
                } catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }

            AsReaderSDK.getInstance().getDeviceManager().setPower(isConnect);

            if (isConnect) {
//                new Handler().postDelayed(() -> {
//                    AsReaderSDK.getInstance().getDeviceManager().getModuleVersion();
//                },1000);
            } else {
                setBatteryState(0);
                binding.moduleVersionTextView.setText("Module Ver: -");
            }
        });
    }

    @Override
    public void onCompletedPreparation(boolean isPowerOn) {
        if (isPowerOn){
            AsReaderSDK.getInstance().getDeviceManager().getModuleVersion();
        }
    }

    @Override
    public void onReceivedBattery(int battery) {
        runOnUiThread(() -> {
//            String msg = "onReceivedBattery:" + battery;
//            addToLogText(msg + "\r\n");
            setBatteryState(battery);
        });
    }

    @Override
    public void onReceivedTriggerState(TriggerStatus status) {
        runOnUiThread(() -> {
            String msg = "onReceivedTriggerState:" + status;
            showToast(msg);
            addToLogText(msg + "\r\n");
        });
    }

    @Override
    public void onDeviceManagerError(String message) {
        runOnUiThread(() -> {
            String msg = "onReceivedDeviceError:" + message;
            addToLogText(msg + "\r\n");
        });
    }

    @Override
    public void onReceiveModuleVersion(String versionText) {
        runOnUiThread(() -> binding.moduleVersionTextView.setText("Module Ver: " + versionText));
    }

    @Override
    public void onReceivedSettingParameter(Map<String, String> params) {
        runOnUiThread(() -> {
            addToLogText("DeviceParameters:\n");
            for (Map.Entry<String,String> entry : params.entrySet()) {
                addToLogText(entry.getKey() +":" + entry.getValue() + "\n");
            }
        });
    }

    /**
     * ASKManager Callback
     */
    @Override
    public void onReceivedJVMAResult(List<JVMARecord> result, JVMAModel ackNakResult) {
        runOnUiThread(() -> {
            Log.d("TEST1", "onReceivedJVMAResult");
            if (result != null) {
                for (JVMARecord jvmaRecord : result) {
                    addToLogText("Record identifyingCode: " + jvmaRecord.getIdentifyingCode() + "\r\n");
                    addToLogText("Record recordLength: " + jvmaRecord.getRecordLength() + "\r\n");
                    addToLogText("Record itemDigitNumber: " + jvmaRecord.getItemDigitNumber() + "\r\n");

                    for (String item : jvmaRecord.getItems()) {
                        addToLogText("Record item: " + item + "\r\n");
                    }
                }
            }
            if (ackNakResult.getPacketType() == PacketValue.RESPONSE_ACK) {
                binding.resultTextView.setText(getString(R.string.connect_result_success));
                binding.resultTextView.setBackgroundColor(getColor(R.color.blue));
            }
            else if (ackNakResult.getPacketType() == PacketValue.RESPONSE_NAK) {
                binding.resultTextView.setText(getString(R.string.connect_result_error));
                binding.resultTextView.setBackgroundColor(getColor(R.color.red));
            }
            setResultTextColor(R.color.white);
        });
    }

    @Override
    public void onASKManagerError(String message) {
        runOnUiThread(() -> addToLogText("エラー：" + message + "\r\n"));
    }

    @Override
    public void onReceiveASKCommandMessage(String message) {
        runOnUiThread(() -> addToLogText(message + "\r\n"));
    }

    private void setConnectionModule(ConnectionType connectionType){
        if(connectionType == ConnectionType.BLE){
            binding.bleScanButton.setVisibility(View.VISIBLE);

            binding.modeBleButton.setBackgroundColor(Color.CYAN);
            binding.modeBleButton.setTextColor(Color.BLACK);
            binding.modeUsbButton.setBackgroundColor(Color.WHITE);
            binding.modeUsbButton.setTextColor(Color.GRAY);
        }

        if(connectionType == ConnectionType.USB){
            binding.bleScanButton.setVisibility(View.GONE);

            binding.modeUsbButton.setBackgroundColor(Color.CYAN);
            binding.modeUsbButton.setTextColor(Color.BLACK);
            binding.modeBleButton.setBackgroundColor(Color.WHITE);
            binding.modeBleButton.setTextColor(Color.GRAY);
        }

        AppSharedData.getInstance().setCurrentConnectionMode(connectionType);
        initializeModule(connectionType);
    }

    private void initializeModule(ConnectionType connectionType){
        if(connectionType == ConnectionType.BLE){

            // To use BLE Step 1 : declare connection type to BLE
            AsReaderSDK.getInstance().initialize(getApplicationContext(), ConnectionType.BLE);
            AsReaderSDK.getInstance().changeSDKLogType(SDKLog.LogType.LogType_APP);
            AsReaderSDK.getInstance().setLogLevel(SDKLog.LogLevel.Debug);
            AsReaderSDK.getInstance().setLog(true);

            // To use BLE Step 2 : Set BLE scan callback
            AsReaderSDK.getInstance().setBLEScanCallback(this);

            // To use BLE Step 3 : Check BLE permission from the app
            PermissionState permissionState = AsReaderSDK.getInstance().checkBlePermission(this);

            // To use BLE Step 4 : If one of the BLE permission is denied forever, show dialog to manually allow permission
            if(permissionState == PermissionState.LOCATION_PERMISSION_DENIED_FOREVER ||
                    permissionState == PermissionState.BLUETOOTH_PERMISSION_DENIED_FOREVER) {
                showPermissionDialog(permissionState);
            }
        }

        if(connectionType == ConnectionType.USB){
            AsReaderSDK.getInstance().initialize(getApplicationContext(), ConnectionType.USB);
            AsReaderSDK.getInstance().changeSDKLogType(SDKLog.LogType.LogType_APP);
            AsReaderSDK.getInstance().setLogLevel(SDKLog.LogLevel.Debug);
            AsReaderSDK.getInstance().setLog(true);
        }
    }

    //  BLE Permission -----------------------------------------------------------------------------

    /**
     * Show dialog if one of the permission is denied forever
     * @param permissionState permission state is one of 'denied forever'.
     */
    private void showPermissionDialog(PermissionState permissionState) {
        if(alertDialog !=null) alertDialog.dismiss();

        String title = "";
        String message = "Permission has been denied more than once. \nPlease allow it from app setting page";

        switch (permissionState){

            case LOCATION_PERMISSION_DENIED_FOREVER:
                title = "Location Permission";
                break;
            case BLUETOOTH_PERMISSION_DENIED_FOREVER:
                title = "Bluetooth Permission";
                break;
        }

        AlertDialog.Builder builder = new AlertDialog.Builder(this);
        builder.setTitle(title).setMessage(message);
        builder.setPositiveButton("OK", new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialogInterface, int i) {
                openPermissionSettings();
            }
        });
        alertDialog = builder.create();
        alertDialog.show();
    }

    /**
     * Opens application settings in Android Settings app.
     */
    private void openPermissionSettings() {
        final Intent intent = new Intent(Settings.ACTION_APPLICATION_DETAILS_SETTINGS);
        intent.setData(Uri.fromParts("package", getPackageName(), null));
        intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        startActivity(intent);
    }


//  BLE Scan -----------------------------------------------------------------------------------
    public void showScanPopUp() {
        //disconnect any device
        AsReaderSDK.getInstance().closeBle();

        if (bleListDialog == null) {
            bleListDialog = new BleListViewDialog(this, R.layout.listview_ble_dialog);
        }
        final ProgressBar progressBar = (ProgressBar) this.bleListDialog.findViewById(R.id.progresscircle);
        bleListDialog.clearData();
        progressBar.setVisibility(View.INVISIBLE);
        bleListDialog.setOnDismissListener(new DialogInterface.OnDismissListener() {
            public void onDismiss(DialogInterface dialogInterface) {
                AsReaderSDK.getInstance().stopBLEScanDevice();
            }
        });
        bleListDialog.onOnSetItemClickListener(new BleListViewDialog.ListViewDialogSelectListener() {
            public void onSetOnItemClickListener(int i) {
                BleListViewDialog.ListData dataIndex = bleListDialog.getDataIndex(i);
                if (dataIndex != null) {
                    AsReaderSDK.getInstance().stopBLEScanDevice();
                    AsReaderSDK.getInstance().open(dataIndex.getBluetoothDevice());
                }
                bleListDialog.dismiss();
            }
        });
        ((Button) bleListDialog.findViewById(R.id.btn_cancel)).setOnClickListener(new View.OnClickListener() {
            public void onClick(View view) {
                bleListDialog.dismiss();
            }
        });
        ((Button) bleListDialog.findViewById(R.id.btn_search)).setOnClickListener(new View.OnClickListener() {
            public void onClick(View view) {
                progressBar.setVisibility(View.VISIBLE);
                bleListDialog.clearData();
                AsReaderSDK.getInstance().startBLEScanDevice();
                new Handler().postDelayed(new Runnable() {
                    public void run() {
                        progressBar.setVisibility(View.INVISIBLE);
                    }
                }, 3000); // scan for 3 sec and stops
            }
        });
        this.bleListDialog.show();
    }

    @Override
    public void onBLEScanError(String errorMsg) {

    }

    @Override
    public void onBLEScanResult(BluetoothDevice bluetoothDevice, String name, String rssi) {
        runOnUiThread(new Runnable() {
            public void run() {
                bleListDialog.addData(bluetoothDevice, name, rssi);
            }
        });
    }

}