//
//  SearchView.m
//  JvmaSample
//
//  Created by ios on 2025/4/15.
//  Copyright © 2025 mac. All rights reserved.
//

#import "SearchView.h"
@interface SearchView ()<UITableViewDataSource, UITableViewDelegate>
@property (nonatomic, strong) NSMutableArray *dataArray;

@end
@implementation SearchView{
    UILabel *titleLable;
    UITableView *tableView;
    UIButton *button;
}
 
- (instancetype)initWithFrame:(CGRect)frame{
    return [super initWithFrame:frame];
}
- (void)showWithlistTitle:(NSString *)title view:(UIView *)view{
    if (!self.dataArray) {
        self.dataArray = [[NSMutableArray alloc] init];
    }
    [self.dataArray removeAllObjects];
    self.backgroundColor = [UIColor whiteColor];
    self.layer.cornerRadius = 10;
    self.layer.borderWidth = 2;
    self.layer.borderColor = [UIColor blackColor].CGColor;
    self.layer.masksToBounds = YES;
    if (!titleLable) {
        titleLable = [[UILabel alloc] initWithFrame: CGRectMake(0, 0, self.frame.size.width, 50)];
        titleLable.text = title;
        titleLable.textAlignment = NSTextAlignmentCenter;
        [self addSubview:titleLable];
    }
    if (!tableView) {
        tableView = [[UITableView alloc] initWithFrame:CGRectMake(0, 50, self.frame.size.width, self.frame.size.height - 100) style:UITableViewStylePlain];
        tableView.dataSource = self;
        tableView.delegate = self;
        tableView.layer.borderWidth = 2;
        tableView.layer.borderColor = [UIColor blackColor].CGColor;
        [self addSubview:tableView];
    }
    if (!button) {
        button = [UIButton buttonWithType:UIButtonTypeSystem];
        button.frame = CGRectMake(0, self.frame.size.height - 50, self.frame.size.width, 50);
        [button setTitle:@"Cancel" forState:UIControlStateNormal];
        [button addTarget:self action:@selector(showAlertWithTableView) forControlEvents:UIControlEventTouchUpInside];
        [self addSubview:button];
    }
    [tableView reloadData];
    if (_backView) {
        [view addSubview:_backView];
    }
    [view addSubview:self];
}
- (void)addBluetoothModule:(BluetoothModule *)bluetoothModule{
    [self.dataArray addObject:bluetoothModule];
    [tableView reloadData];
}

- (void)removeView{
    if (_backView) {
        [_backView removeFromSuperview];
    }
    [self removeFromSuperview];
}
- (void)showAlertWithTableView {
    if (self.delegate && [self.delegate respondsToSelector:@selector(whenClickCancel)]) {
        [self.delegate whenClickCancel];
    }
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return self.dataArray.count;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *cellIdentifier = @"Cell";
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:cellIdentifier];
    if (cell == nil) {
        cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleSubtitle reuseIdentifier:cellIdentifier];
    }
    BluetoothModule * module = self.dataArray[indexPath.row];
    if (module.isConnected)  {
        cell.accessoryType = UITableViewCellAccessoryCheckmark;
    } else {
        cell.accessoryType = UITableViewCellAccessoryNone;
    }
    cell.selectionStyle = UITableViewCellSelectionStyleNone;
    cell.textLabel.text = module.name;
    cell.detailTextLabel.text = module.identifier;
    cell.textLabel.numberOfLines = 0;
    cell.detailTextLabel.numberOfLines = 0;
    return cell;
}
#pragma mark - UITableViewDelegate
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    BluetoothModule * module = self.dataArray[indexPath.row];
    if (self.delegate && [self.delegate respondsToSelector:@selector(whenSelectDevice:)]) {
        [self.delegate whenSelectDevice: module];
    }
}

@end
