//
//  RootViewController.m
//  testApp
//
//  Created by mac on 2017/2/27.
//  Copyright © 2017年 mac. All rights reserved.
//

#import "RootViewController.h"
#import "BatteryView.h"
#import "AddCell.h"
#import "CommandCell.h"
#import "DataIDAddCell.h"
#import "RecordCell.h"
#import "SendCell.h"
#import "ItemCell.h"
#import "JvmaHandler.h"
#import "MBProgressHUD.h"
#import "TableViewGroupModel.h"
#import "RecordCellModel.h"
#import "CommandCellModel.h"
#import "DataItemCellModel.h"
#import "DataIdAddCellModel.h"
#import "AddCellModel.h"
#import "SendCellModel.h"
#import "ItemCellModel.h"
#import "SearchView.h"

#define PASSWORDWORDKEY @"Password"
#define TERMINALPASSWORDWORDKEY @"TerminalPassWord"
@interface RootViewController ()<AsReaderAskStatusDelegate, UITableViewDelegate,UITableViewDataSource,JvmaHandlerDelegate,UITextFieldDelegate,AddCellDelegate,RecordCellDelegate,SearchViewDelegate>{
    NSString *password;
    JvmaHandler *jvmaHandler;
    BOOL inputTimeRecord;
    NSString *version;
    BatteryView *batteryView;
    BOOL testModel;
    NSMutableArray *groupArray;
    UIView *backView;
    SearchView * searchView;
}
@property (strong,nonatomic) MBProgressHUD * hud;
@property (weak, nonatomic) IBOutlet UITableView *tableview;
@property (weak, nonatomic) IBOutlet UILabel *versionLabel;
@property (weak, nonatomic) IBOutlet UILabel *appVersionLabel;
@property (weak, nonatomic) IBOutlet UITextView *textview;
@property (weak, nonatomic) IBOutlet UIView *statusView;
@property (weak, nonatomic) IBOutlet UILabel *connectStutas;
@property (weak, nonatomic) IBOutlet UIButton *clearBtn;
@property (weak, nonatomic) IBOutlet UITextField *passWordText;
@property (weak, nonatomic) IBOutlet UITextField *terminalPassWordText;
@property (weak, nonatomic) IBOutlet UITextField *communicationRetryTimesText;
@property (weak, nonatomic) IBOutlet UIButton *testBtn;
@property (weak, nonatomic) IBOutlet UISwitch *timeSwitch;
@property (weak, nonatomic) IBOutlet UIButton *bleButton;

@end

@implementation RootViewController


- (void)viewDidLoad {
    [super viewDidLoad];
    NSDictionary *infoDictionary = [[NSBundle mainBundle] infoDictionary];
//    self.versionLabel.text=[NSString stringWithFormat:@"Ver:%@",[infoDictionary objectForKey:@"CFBundleShortVersionString"]];
//    self.appVersionLabel.text = [NSString stringWithFormat:@"App Ver:%@\nBuild:%@",[self getAPPVersion],[self getAPPBuild]];
    [_bleButton setBackgroundImage:[UIImage imageNamed:@"ble_off"] forState:UIControlStateNormal];
    self.hud = [[MBProgressHUD alloc] initWithView:self.view];
    self.hud.mode = MBProgressHUDModeIndeterminate;
    self.hud.only = YES;
    [self.view addSubview:self.hud];
    
    self.navigationController.navigationBar.hidden = YES;
    self.tableview.dataSource = self;
    self.tableview.delegate = self;
    [self.tableview setEditing:YES];
    self.tableview.allowsSelectionDuringEditing = YES;
    
    NSUserDefaults *userDefault = [NSUserDefaults standardUserDefaults];
    NSString *passwordValue = [userDefault valueForKey:PASSWORDWORDKEY];
    NSString *terminalPasswordValue = [userDefault valueForKey:TERMINALPASSWORDWORDKEY];
    if (passwordValue && ![passwordValue isEqualToString:@""]) {
        self.passWordText.text = passwordValue;
        password = passwordValue;
    }
    
    if (terminalPasswordValue && ![terminalPasswordValue isEqualToString:@""]) {
        self.terminalPassWordText.text = terminalPasswordValue;
    }
    
    jvmaHandler = [JvmaHandler sharedJvmaHandler];
    jvmaHandler.delegate = self;
    self.textview.editable = NO;
    inputTimeRecord = YES;
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(resultMessage:) name:@"RESULT" object:nil];
    batteryView = [BatteryView sharedBatteryView];
    [batteryView setBatteryVolumeImage:0];
    [self.statusView addSubview:batteryView];
    self.tableview.rowHeight = 60;
    self.tableview.separatorColor = [UIColor blackColor];
    self.communicationRetryTimesText.text = [NSString stringWithFormat:@"%d",[jvmaHandler getCommunicationRetryTimes]];
    groupArray = [NSMutableArray array];
    [self setupData];
    [[NSNotificationCenter defaultCenter] addObserver:self
                                             selector:@selector(keyboardWillShow:)
                                                 name:UIKeyboardWillShowNotification
                                               object:nil];
    [[NSNotificationCenter defaultCenter] addObserver:self
                                             selector:@selector(keyboardDiDHide:)
                                                 name:UIKeyboardDidHideNotification
                                               object:nil];
    backView = [[UIView alloc] initWithFrame:CGRectMake(0, 0,self.view.frame.size.width, self.view.frame.size.height)];
    [self.view addSubview:backView];
    backView.hidden = YES;
    self.appVersionLabel.text = [NSString stringWithFormat:@"App Ver:%@\nBuild:%@\nSDK Ver:%@",[self getAPPVersion],[self getAPPBuild],[jvmaHandler getSDKVersion]];
//    self.versionLabel.text = [jvmaHandler getSDKVersion];
}
- (void)viewDidAppear:(BOOL)animated{
    [super viewDidAppear:animated];
    if (!searchView) {
        searchView = [[SearchView alloc] initWithFrame:CGRectMake(0, 0, self.view.frame.size.width * 2 / 3, self.view.frame.size.height * 2 / 3)];
        searchView.center = self.view.center;
        searchView.delegate = self;
        searchView.backView = [[UIView alloc] initWithFrame:self.view.frame];
        searchView.backView.alpha = 0.3;
        searchView.backView.backgroundColor = [UIColor grayColor];
    }
}
- (NSString *)getAPPBuild{
    NSDictionary *infoDictionary = [[NSBundle mainBundle] infoDictionary];
    NSString *app_Build = [infoDictionary objectForKey:@"CFBundleVersion"];
    return app_Build;
}

- (NSString *)getAPPVersion{
    NSDictionary *infoDictionary = [[NSBundle mainBundle] infoDictionary];
    NSString *app_Version = [infoDictionary objectForKey:@"CFBundleShortVersionString"];
    return app_Version;
}

- (void)setupData{
    [groupArray removeAllObjects];
    [self setupGroup0]; //集計データ収集
    [self setupGroup1]; //自販機データ収集クリア
    [self setupGroup2]; //設定データ収集
    [self setupGroup3]; //設定データ設定
    [self setupGroup4]; //自販機データオールクリア
    [self setupGroup5]; //バージョン取得
    [self setupGroup6]; //テキストデータ
}

- (void)setupGroup0{
    NSMutableArray *items = [NSMutableArray array];
    AddCellModel *addCellModel = [[AddCellModel alloc] init];
    addCellModel.title = @"DataID";
    addCellModel.isTestMode = testModel;
   
    CommandCellModel *commandCellModel = [[CommandCellModel alloc] init];
    commandCellModel.command = @"";
    commandCellModel.inputLength = 4;
    
    SendCellModel *sendCellModel = [[SendCellModel alloc] init];
    sendCellModel.title = @"収集";
    sendCellModel.cellMode = dataCollect;
    
    [items addObject:addCellModel];
    [items addObject:commandCellModel];
    [items addObject:sendCellModel];
    
    TableViewGroupModel *group0 = [[TableViewGroupModel alloc] init];
    group0.items = items;
    group0.headerTitle = @"集計データ収集";

    [groupArray addObject:group0];
}

- (void)setupGroup1{
    NSMutableArray *items = [NSMutableArray array];
    AddCellModel *addCellModel = [[AddCellModel alloc] init];
    addCellModel.title = @"DataID";
    addCellModel.isTestMode = testModel;
    
    CommandCellModel *commandCellModel = [[CommandCellModel alloc] init];
    commandCellModel.command = @"";
    commandCellModel.inputLength = 4;
    
    SendCellModel *sendCellModel1 = [[SendCellModel alloc] init];
    sendCellModel1.title = @"収集クリア1";
    sendCellModel1.cellMode = dataCollectClear1;
    
    ItemCellModel * itemCellModel = [[ItemCellModel alloc] init];
    itemCellModel.title = @"リトライ";
    itemCellModel.placeholder = @"０を記入または空の場合、５に設定される";
    itemCellModel.item = @"";
    itemCellModel.inputLength = 0;
    itemCellModel.keyboardType = UIKeyboardTypeNumberPad;
    itemCellModel.saveSendSettingDataRetryTimes = NO;
    
    SendCellModel *sendCellModel2 = [[SendCellModel alloc] init];
    sendCellModel2.title = @"収集クリア2";
    sendCellModel2.cellMode = dataCollectClear2;
    [items addObject:addCellModel];
    [items addObject:commandCellModel];
    [items addObject:sendCellModel1];
    [items addObject:itemCellModel];
    [items addObject:sendCellModel2];
    
    TableViewGroupModel *group0 = [[TableViewGroupModel alloc] init];
    group0.items = items;
    group0.headerTitle = @"自販機データ収集クリア";
    
    [groupArray addObject:group0];
}

- (void)setupGroup2{
    NSMutableArray *items = [NSMutableArray array];
    ItemCellModel *itemCellModel = [[ItemCellModel alloc] init];
    itemCellModel.title = @"コマンド";
    itemCellModel.placeholder = @"";
    itemCellModel.inputLength = 2;
    itemCellModel.item = @"03";
    itemCellModel.keyboardType = UIKeyboardTypeNumbersAndPunctuation;
    itemCellModel.isTestMode = testModel;
    itemCellModel.saveSendSettingDataRetryTimes = NO;
    
    SendCellModel *sendCellModel = [[SendCellModel alloc] init];
    sendCellModel.title = @"設定データ収集";
    sendCellModel.cellMode = settingDataCollect;
    
    [items addObject:itemCellModel];
    [items addObject:sendCellModel];
    TableViewGroupModel *group0 = [[TableViewGroupModel alloc] init];
    group0.items = items;
    group0.headerTitle = @"設定データ収集";
    
    [groupArray addObject:group0];
}

- (void)setupGroup3{
    NSMutableArray *items = [NSMutableArray array];
    
    ItemCellModel *itemCellModel = [[ItemCellModel alloc] init];
    itemCellModel.title = @"コマンド";
    itemCellModel.placeholder = @"";
    itemCellModel.item = @"41";
    itemCellModel.inputLength = 2;
    itemCellModel.keyboardType = UIKeyboardTypeNumbersAndPunctuation;
    itemCellModel.isTestMode = testModel;
    itemCellModel.saveSendSettingDataRetryTimes = NO;
    
    ItemCellModel * itemCellModel1 = [[ItemCellModel alloc] init];
    itemCellModel1.title = @"リトライ";
    itemCellModel1.placeholder = @"";
    itemCellModel1.item = [NSString stringWithFormat:@"%d",[jvmaHandler getSendSettingDataRetryTimes]];
    itemCellModel1.inputLength = 0;
    itemCellModel1.keyboardType = UIKeyboardTypeNumberPad;
    itemCellModel1.saveSendSettingDataRetryTimes = YES;
    
    AddCellModel *addCellModel = [[AddCellModel alloc] init];
    addCellModel.title = @"レコード";
    addCellModel.isTestMode = testModel;
    
    DataIdAddCellModel *dataIdAddCellModel = [[DataIdAddCellModel alloc] init];
    dataIdAddCellModel.dataIdText = @"0BC0";
    dataIdAddCellModel.isTestMode = testModel;
    dataIdAddCellModel.inputLength = 4;
    
    NSMutableArray *dataItems = [NSMutableArray array];
    DataItemCellModel *dataItemCellModel = [[DataItemCellModel alloc] init];
    dataItemCellModel.itemText = @"10513800000000";
    dataItemCellModel.isTestMode = testModel;
    [dataItems addObject:dataItemCellModel];
    
    dataItemCellModel = [[DataItemCellModel alloc] init];
    dataItemCellModel.itemText = @"12004400000000";
    dataItemCellModel.isTestMode = testModel;
    [dataItems addObject:dataItemCellModel];
    
    dataItemCellModel = [[DataItemCellModel alloc] init];
    dataItemCellModel.itemText = @"10500400000000";
    dataItemCellModel.isTestMode = testModel;
    [dataItems addObject:dataItemCellModel];
    
    dataItemCellModel = [[DataItemCellModel alloc] init];
    dataItemCellModel.itemText = @"10500300000000";
    dataItemCellModel.isTestMode = testModel;
    [dataItems addObject:dataItemCellModel];
    
    dataItemCellModel = [[DataItemCellModel alloc] init];
    dataItemCellModel.itemText = @"10515000000000";
    dataItemCellModel.isTestMode = testModel;
    [dataItems addObject:dataItemCellModel];
    
    dataItemCellModel = [[DataItemCellModel alloc] init];
    dataItemCellModel.itemText = @"10513900000000";
    dataItemCellModel.isTestMode = testModel;
    [dataItems addObject:dataItemCellModel];
    dataItemCellModel = [[DataItemCellModel alloc] init];
    dataItemCellModel.itemText = @"10501800000000";
    dataItemCellModel.isTestMode = testModel;
    [dataItems addObject:dataItemCellModel];
    
    dataItemCellModel = [[DataItemCellModel alloc] init];
    dataItemCellModel.itemText = @"12000300000000";
    dataItemCellModel.isTestMode = testModel;
    [dataItems addObject:dataItemCellModel];
    
    dataItemCellModel = [[DataItemCellModel alloc] init];
    dataItemCellModel.itemText = @"10500100000000";
    dataItemCellModel.isTestMode = testModel;
    [dataItems addObject:dataItemCellModel];
    
    dataItemCellModel = [[DataItemCellModel alloc] init];
    dataItemCellModel.itemText = @"10500200000000";
    dataItemCellModel.isTestMode = testModel;
    [dataItems addObject:dataItemCellModel];
    
    dataItemCellModel = [[DataItemCellModel alloc] init];
    dataItemCellModel.itemText = @"12000400000000";
    dataItemCellModel.isTestMode = testModel;
    [dataItems addObject:dataItemCellModel];
    
    dataItemCellModel = [[DataItemCellModel alloc] init];
    dataItemCellModel.itemText = @"12003800000000";
    dataItemCellModel.isTestMode = testModel;
    [dataItems addObject:dataItemCellModel];
    
    dataItemCellModel = [[DataItemCellModel alloc] init];
    dataItemCellModel.itemText = @"12003800000000";
    dataItemCellModel.isTestMode = testModel;
    [dataItems addObject:dataItemCellModel];
    
    dataItemCellModel = [[DataItemCellModel alloc] init];
    dataItemCellModel.itemText = @"49710200000000";
    dataItemCellModel.isTestMode = testModel;
    [dataItems addObject:dataItemCellModel];
    
    dataItemCellModel = [[DataItemCellModel alloc] init];
    dataItemCellModel.itemText = @"12004500000000";
    dataItemCellModel.isTestMode = testModel;
    [dataItems addObject:dataItemCellModel];
    
    dataItemCellModel = [[DataItemCellModel alloc] init];
    dataItemCellModel.itemText = @"16002700000000";
    dataItemCellModel.isTestMode = testModel;
    [dataItems addObject:dataItemCellModel];
    
    dataItemCellModel = [[DataItemCellModel alloc] init];
    dataItemCellModel.itemText = @"16000100000000";
    dataItemCellModel.isTestMode = testModel;
    [dataItems addObject:dataItemCellModel];
    
    dataItemCellModel = [[DataItemCellModel alloc] init];
    dataItemCellModel.itemText = @"16017900000000";
    dataItemCellModel.isTestMode = testModel;
    [dataItems addObject:dataItemCellModel];
    
    dataItemCellModel = [[DataItemCellModel alloc] init];
    dataItemCellModel.itemText = @"16000100000000";
    dataItemCellModel.isTestMode = testModel;
    [dataItems addObject:dataItemCellModel];
    
    dataItemCellModel = [[DataItemCellModel alloc] init];
    dataItemCellModel.itemText = @"16017900000000";
    dataItemCellModel.isTestMode = testModel;
    [dataItems addObject:dataItemCellModel];
    
    dataItemCellModel = [[DataItemCellModel alloc] init];
    dataItemCellModel.itemText = @"12500200000000";
    dataItemCellModel.isTestMode = testModel;
    [dataItems addObject:dataItemCellModel];
    
    dataItemCellModel = [[DataItemCellModel alloc] init];
    dataItemCellModel.itemText = @"16017400000000";
    dataItemCellModel.isTestMode = testModel;
    [dataItems addObject:dataItemCellModel];
    
    dataItemCellModel = [[DataItemCellModel alloc] init];
    dataItemCellModel.itemText = @"16018200000000";
    dataItemCellModel.isTestMode = testModel;
    [dataItems addObject:dataItemCellModel];
    
    dataItemCellModel = [[DataItemCellModel alloc] init];
    dataItemCellModel.itemText = @"16018300000000";
    dataItemCellModel.isTestMode = testModel;
    [dataItems addObject:dataItemCellModel];
    
    dataItemCellModel = [[DataItemCellModel alloc] init];
    dataItemCellModel.itemText = @"16017400000000";
    dataItemCellModel.isTestMode = testModel;
    [dataItems addObject:dataItemCellModel];
    
    RecordCellModel *recordCellModel = [[RecordCellModel alloc] init];
    recordCellModel.dataIdAddCellModel = dataIdAddCellModel;
    recordCellModel.items = dataItems;
    recordCellModel.isTestMode = testModel;
    
    SendCellModel *sendCellModel = [[SendCellModel alloc] init];
    sendCellModel.title = @"設定";
    sendCellModel.cellMode = settingDataSet;
    
    [items addObject:itemCellModel];
    [items addObject:itemCellModel1];
    [items addObject:addCellModel];
    [items addObject:recordCellModel];
    [items addObject:sendCellModel];
    TableViewGroupModel *group0 = [[TableViewGroupModel alloc] init];
    group0.items = items;
    group0.headerTitle = @"設定データ設定";
    
    [groupArray addObject:group0];
    
}

-(void)setupGroup4{
    NSMutableArray *items = [NSMutableArray array];
    SendCellModel *sendCellModel = [[SendCellModel alloc] init];
    sendCellModel.title = @"自販機データオールクリア";
    sendCellModel.cellMode = allClear;
    
    [items addObject:sendCellModel];
    TableViewGroupModel *group0 = [[TableViewGroupModel alloc] init];
    group0.items = items;
    group0.headerTitle = @"自販機データオールクリア";
    
    [groupArray addObject:group0];
}

- (void)setupGroup5{
    NSMutableArray *items = [NSMutableArray array];
    SendCellModel *sendCellModel = [[SendCellModel alloc] init];
    sendCellModel.title = @"バージョン取得";
    sendCellModel.cellMode = getVersion;
    
    [items addObject:sendCellModel];
    TableViewGroupModel *group0 = [[TableViewGroupModel alloc] init];
    group0.items = items;
    group0.headerTitle = @"バージョン取得";
    
    [groupArray addObject:group0];
}

- (void)setupGroup6{
    NSMutableArray *items = [NSMutableArray array];
    SendCellModel *sendCellModel1 = [[SendCellModel alloc] init];
    sendCellModel1.title = @"複数送信";
    sendCellModel1.cellMode = multipleSend;
    
    SendCellModel *sendCellModel2 = [[SendCellModel alloc] init];
    sendCellModel2.title = @"個別送信";
    sendCellModel2.cellMode = individualSend;
    
    [items addObject:sendCellModel1];
    [items addObject:sendCellModel2];
    TableViewGroupModel *group0 = [[TableViewGroupModel alloc] init];
    group0.items = items;
    group0.headerTitle = @"テキストデータ";
    
    [groupArray addObject:group0];
}

-(void)viewWillAppear:(BOOL)animated{
    [super viewWillAppear:animated];
    UIButton  * btn =[self.view viewWithTag:101];
    [btn setEnabled:NO];
}

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return groupArray.count;
}

-(NSString *)tableView:(UITableView *)tableView titleForHeaderInSection:(NSInteger)section {
    TableViewGroupModel *group = [groupArray objectAtIndex:section];
    return group.headerTitle;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    TableViewGroupModel *group = [groupArray objectAtIndex:section];
    return group.items.count;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath {
    TableViewGroupModel *group = [groupArray objectAtIndex:indexPath.section];
    id model = [group.items objectAtIndex:indexPath.row];
    if ([model isKindOfClass:[RecordCellModel class]]) {
        RecordCellModel *recordCellModel = (RecordCellModel *)model;
        return  recordCellModel.height;
    }else {
        return 60;
    }
}

- (BOOL)tableView:(UITableView *)tableView canEditRowAtIndexPath:(NSIndexPath *)indexPath{
    TableViewGroupModel *group = [groupArray objectAtIndex:indexPath.section];
    id model = [group.items objectAtIndex:indexPath.row];
    if ([model isKindOfClass:[CommandCellModel class]]) {
        return  YES;
    }
    
    return NO;
}

- (NSString *)tableView:(UITableView *)tableView titleForDeleteConfirmationButtonForRowAtIndexPath:(NSIndexPath *)indexPath{
    return @"削除";
}

- (void)tableView:(UITableView *)tableView commitEditingStyle:(UITableViewCellEditingStyle)editingStyle forRowAtIndexPath:(NSIndexPath *)indexPath{
    if (editingStyle == UITableViewCellEditingStyleDelete) {
        TableViewGroupModel *group = [groupArray objectAtIndex:indexPath.section];
        [group.items removeObjectAtIndex:indexPath.row];
        [self.tableview deleteRowsAtIndexPaths:@[indexPath] withRowAnimation:UITableViewRowAnimationFade];
    }
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {

    TableViewGroupModel *group = [groupArray objectAtIndex:indexPath.section];
    id model = [group.items objectAtIndex:indexPath.row];
    
    if ([model isKindOfClass:[AddCellModel class]]) {
        NSString *cellIdentifier = @"AddCell";
        AddCell *cell = [tableView dequeueReusableCellWithIdentifier:cellIdentifier];
        if(!cell) {
            cell = [[[NSBundle mainBundle] loadNibNamed:@"AddCell" owner:self options:nil] firstObject];
        }
        AddCellModel *addCellModel = (AddCellModel*)model;
        addCellModel.indexPath = indexPath;
        cell.viewModel = addCellModel;
        cell.delegate = self;
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        return cell;
    }
    
    if ([model isKindOfClass:[CommandCellModel class]]) {
        NSString *cellIdentifier = @"CommandCell";
        CommandCell *cell = [tableView dequeueReusableCellWithIdentifier:cellIdentifier];
        if(!cell) {
            cell = [[[NSBundle mainBundle] loadNibNamed:@"CommandCell" owner:self options:nil] firstObject];
        }
        cell.viewModel = (CommandCellModel*)model;
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        return cell;
    }
    
    if ([model isKindOfClass:[RecordCellModel class]]) {
        NSString *cellIdentifier = @"RecordCell";
        RecordCell *cell = [tableView dequeueReusableCellWithIdentifier:cellIdentifier];
        if(!cell) {
            cell = [[[NSBundle mainBundle] loadNibNamed:@"RecordCell" owner:self options:nil] firstObject];
        }
        RecordCellModel *recordCellModel = (RecordCellModel*)model;
        recordCellModel.indexPath = indexPath;
        cell.viewModel = recordCellModel;
        cell.delegate = self;
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        return cell;
    }
    
    if ([model isKindOfClass:[ItemCellModel class]]) {
        NSString *cellIdentifier = @"ItemCell";
        ItemCell *cell = [tableView dequeueReusableCellWithIdentifier:cellIdentifier];
        if(!cell) {
            cell = [[[NSBundle mainBundle] loadNibNamed:@"ItemCell" owner:self options:nil] firstObject];
        }
        cell.viewModel = (ItemCellModel*)model;;
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        return cell;
    }
    
    if ([model isKindOfClass:[SendCellModel class]]) {
        NSString *cellIdentifier = @"SendCell";
        SendCell *cell = [tableView dequeueReusableCellWithIdentifier:cellIdentifier];
        if(!cell) {
            cell = [[[NSBundle mainBundle] loadNibNamed:@"SendCell" owner:self options:nil] firstObject];
        }
        cell.viewModel = (SendCellModel*)model;
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        return cell;
    }
    
    return [[UITableViewCell alloc] init];
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath{
    TableViewGroupModel *group = [groupArray objectAtIndex:indexPath.section];
    id model = [group.items objectAtIndex:indexPath.row];
    if ([model isKindOfClass:[SendCellModel class]]) {
        SendCellModel *sendCellModel = (SendCellModel *)model;
        switch (sendCellModel.cellMode) {
            case dataCollect:{
                NSMutableArray *dataIDArray = [NSMutableArray array];
                for (id item in group.items) {
                    if ([item isKindOfClass:[CommandCellModel class]]) {
                        CommandCellModel *commandCellModel = (CommandCellModel*)item;
                        if (commandCellModel.command && ![commandCellModel.command isEqualToString:@""]) {
                            [dataIDArray addObject:commandCellModel.command];
                        }
                    }
                }
                
                [self.hud show:YES];
                [jvmaHandler getVmDataWithPassword:password terminalPassword:self.terminalPassWordText.text inputTimeRecord:inputTimeRecord dataIDArray:dataIDArray];
                break;
            }
                
            case dataCollectClear1:{
                NSMutableArray *dataIDArray = [NSMutableArray array];
                for (id item in group.items) {
                    if ([item isKindOfClass:[CommandCellModel class]]) {
                        CommandCellModel *commandCellModel = (CommandCellModel*)item;
                        if (commandCellModel.command && ![commandCellModel.command isEqualToString:@""]) {
                            [dataIDArray addObject:commandCellModel.command];
                        }
                    }
                }
       
                [self.hud show:YES];
                [jvmaHandler getVmDataClearWithPassword:password terminalPassword:self.terminalPassWordText.text inputTimeRecord:inputTimeRecord dataIDArray:dataIDArray retryTime:@"" buttonStatus:0];
                break;
            }
            case dataCollectClear2:{
                NSMutableArray *dataIDArray = [NSMutableArray array];
                NSString *retryTime = @"";
                for (id item in group.items) {
                    if ([item isKindOfClass:[CommandCellModel class]]) {
                        CommandCellModel *commandCellModel = (CommandCellModel*)item;
                        if (commandCellModel.command && ![commandCellModel.command isEqualToString:@""]) {
                            [dataIDArray addObject:commandCellModel.command];
                        }
                    }
                    if ([item isKindOfClass:[ItemCellModel class]]) {
                        ItemCellModel *itemCellModel = (ItemCellModel*)item;
                        if (itemCellModel.item && ![itemCellModel.item isEqualToString:@""]) {
                            retryTime = itemCellModel.item;
                        }
                    }
                }
                
                [self.hud show:YES];
                [jvmaHandler getVmDataClearWithPassword:password terminalPassword:self.terminalPassWordText.text inputTimeRecord:inputTimeRecord dataIDArray:dataIDArray retryTime:retryTime buttonStatus:1];
                break;
            }
            case settingDataCollect:{
                NSString *command = @"";
                for (id item in group.items) {
                    if ([item isKindOfClass:[ItemCellModel class]]) {
                        ItemCellModel *itemCellModel = (ItemCellModel*)item;
                        if (!itemCellModel.saveSendSettingDataRetryTimes && itemCellModel.item && ![itemCellModel.item isEqualToString:@""]) {
                            command = itemCellModel.item;
                        }
                    }
                }
                
                if ([command isEqualToString:@""]) {
                    return;
                }
                [self.hud show:YES];
                [jvmaHandler collectSettingDataWithPassword:password terminalPassword:self.terminalPassWordText.text inputTimeRecord:inputTimeRecord commandCode:command];
                break;
            }
            case settingDataSet:{
                NSString *command = @"";
                NSMutableArray *array = [NSMutableArray array];
                for (id item in group.items) {
                    if ([item isKindOfClass:[ItemCellModel class]]) {
                        ItemCellModel *itemCellModel = (ItemCellModel*)item;
                        if (!itemCellModel.saveSendSettingDataRetryTimes && itemCellModel.item && ![itemCellModel.item isEqualToString:@""]) {
                            command = itemCellModel.item;
                        }
                    }
                    
                    if ([item isKindOfClass:[RecordCellModel class]]) {
                        [array addObject:(RecordCellModel*)item];
                    }
                }
                [self.hud show:YES];
                [jvmaHandler sendSettingDataWithPassword:password terminalPassword:self.terminalPassWordText.text inputTimeRecord:inputTimeRecord records:array commandCode:command];
                break;
            }
            case allClear:{
                [self.hud show:YES];
                [jvmaHandler clearAllDataWithPassword:password terminalPassword:self.terminalPassWordText.text inputTimeRecord:inputTimeRecord];
                break;
            }
            case getVersion:{
                [self.hud show:YES];
                [jvmaHandler getJvmaVersion];
                break;
            }
            case multipleSend:{
                [self.hud show:YES];
                [jvmaHandler sendTestDatasWithJvmaDataSendModel:YES];
                break;
            }
            case individualSend:{
                [self.hud show:YES];
                [jvmaHandler sendTestDatasWithJvmaDataSendModel:NO];
                break;
            }
            default:
                break;
        }
    }
}

- (void)whenClickAdd:(AddCellModel*)model{
   
    NSIndexPath *indexPath = model.indexPath;
    NSIndexPath *newIndexPath;
    TableViewGroupModel *group = [groupArray objectAtIndex:indexPath.section];
    if (indexPath.section == 0) {
        CommandCellModel *commandCellModel = [[CommandCellModel alloc] init];
           commandCellModel.command = @"";
           commandCellModel.isTestMode = model.isTestMode;
           commandCellModel.inputLength = 4;
        [group.items insertObject:commandCellModel atIndex:group.items.count-1];
        newIndexPath = [NSIndexPath indexPathForRow:group.items.count-2 inSection:indexPath.section];
    }else if (indexPath.section == 1){
        CommandCellModel *commandCellModel = [[CommandCellModel alloc] init];
           commandCellModel.command = @"";
           commandCellModel.isTestMode = model.isTestMode;
           commandCellModel.inputLength = 4;
        [group.items insertObject:commandCellModel atIndex:group.items.count-3];
        newIndexPath = [NSIndexPath indexPathForRow:group.items.count-4 inSection:indexPath.section];
    }else if (indexPath.section == 2){
        
    }else if (indexPath.section == 3){
        DataIdAddCellModel *dataIdAddCellModel = [[DataIdAddCellModel alloc] init];
        dataIdAddCellModel.dataIdText = @"";
        dataIdAddCellModel.isTestMode = testModel;
        dataIdAddCellModel.inputLength = 4;
        
        NSMutableArray *dataItems = [NSMutableArray array];
        DataItemCellModel *dataItemCellModel = [[DataItemCellModel alloc] init];
        dataItemCellModel.itemText = @"";
        dataItemCellModel.isTestMode = testModel;
        [dataItems addObject:dataItemCellModel];
        
        RecordCellModel *recordCellModel = [[RecordCellModel alloc] init];
        recordCellModel.dataIdAddCellModel = dataIdAddCellModel;
        recordCellModel.items = dataItems;
        recordCellModel.isTestMode = testModel;
        [group.items insertObject:recordCellModel atIndex:group.items.count-1];
        newIndexPath = [NSIndexPath indexPathForRow:group.items.count-2 inSection:indexPath.section];
    }
    
    if (newIndexPath) {
        [self.tableview beginUpdates];
        [self.tableview insertRowsAtIndexPaths:@[newIndexPath] withRowAnimation:UITableViewRowAnimationRight];
        [self.tableview endUpdates];
    }
}

- (void)whenItemsChanged:(RecordCellModel*)model{
    [self.tableview reloadRowsAtIndexPaths:@[model.indexPath] withRowAnimation:UITableViewRowAnimationAutomatic];
}

- (void)whenDeleteRecord:(RecordCellModel*)model{
    NSIndexPath *indexPath = model.indexPath;
    TableViewGroupModel *group = [groupArray objectAtIndex:indexPath.section];
    NSMutableArray *array = group.items;
    [array removeObjectAtIndex:indexPath.row];
    group.items = array;
    [self.tableview deleteRowsAtIndexPaths:@[indexPath] withRowAnimation:UITableViewRowAnimationFade];
    [self.tableview reloadData];
}

-(void)touchesBegan:(NSSet *)touches withEvent:(UIEvent *)event{
    [self hidenKeyBoard];
}
- (IBAction)onClickBLEButton:(id)sender {
    [jvmaHandler startBluetoothScan];
    [searchView showWithlistTitle:@"Discovery" view:self.view];
}
- (void)whenSelectDevice:(BluetoothModule*)bluetoothModule{
    if ([bluetoothModule isConnected])
        [jvmaHandler disConnectBluetooth];
    else
        [jvmaHandler connectBluetooth:bluetoothModule];
    [searchView removeView];
}
- (void)whenClickCancel{
    [jvmaHandler stopBluetoothScan];
    [searchView removeView];
}

- (IBAction)onClickClear:(UIButton *)sender {
    self.textview.text = @"";
}
- (void)resultMessage:(NSNotification *)notification{
    NSString *str = [[self textview] text];
    self.textview.text =[NSString stringWithFormat:@"%@%@\n",str,notification.userInfo[@"result"]];
}
- (void)whenReceivedBatteryState:(int)battery{
    [[BatteryView sharedBatteryView] setHidden:NO];
    dispatch_async(dispatch_get_main_queue(),^{
        [batteryView setBatteryVolumeImage:battery];
    });
}

- (void)whenReceivedConnectedState:(BOOL)isConnected{
    self.textview.text =[NSString stringWithFormat:@"%@whenReceivedConnectedState:%d\n",self.textview.text,isConnected];
    if (isConnected) {
        self.connectStutas.text = @"Connected";
    }else{
        if ([System sharedSystem].ask.isBLEConnected) {
            [_bleButton setBackgroundImage:[UIImage imageNamed:@"ble_connect"] forState:UIControlStateNormal];
            self.connectStutas.text = @"BLE Connected";
        } else {
            self.connectStutas.text = @"Disconnected";
            [batteryView setBatteryVolumeImage:0];
            testModel = NO;
            [self changeStatus:isConnected];
        }
    }
}

- (void)whenReceivedBLEConnectedState:(BOOL)isConnected{
    self.textview.text =[NSString stringWithFormat:@"%@whenReceivedBLEConnectedState:%d\n",self.textview.text,isConnected];
    if (isConnected) {
        [_bleButton setBackgroundImage:[UIImage imageNamed:@"ble_connect"] forState:UIControlStateNormal];
        self.connectStutas.text = @"BLE Connected";
    }else{
        [_bleButton setBackgroundImage:[UIImage imageNamed:@"ble_disconnect"] forState:UIControlStateNormal];
        if ([System sharedSystem].ask.isConnected) {
            self.connectStutas.text = @"Connected";
        }else {
            self.connectStutas.text = @"Disconnected";
            [batteryView setBatteryVolumeImage:0];
            testModel = NO;
            [self changeStatus:isConnected];
        }
    }
}
- (void)whenReceivedBLEError:(NSError *)error{
    self.textview.text =[NSString stringWithFormat:@"%@whenReceivedBLEError:%@\n",self.textview.text,error];
}

- (void)whenBluetoothStateDidChange:(CBManagerState)state{
    if (state == CBManagerStatePoweredOn)
        [_bleButton setBackgroundImage:[UIImage imageNamed:@"ble_disconnect"] forState:UIControlStateNormal];
    else
        [_bleButton setBackgroundImage:[UIImage imageNamed:@"ble_off"] forState:UIControlStateNormal];
}
- (void)whenDiscoverBluetoothModule:(BluetoothModule *)bluetoothModule{
    [searchView addBluetoothModule:bluetoothModule];
}

- (void)whenReceivedTriggerState:(BOOL)isTriggerDown{
    if (isTriggerDown) {

    }else{
        
    }
    NSDictionary *dic = [[NSDictionary alloc] initWithObjectsAndKeys:[NSString stringWithFormat:@"TriggerDown:%d",isTriggerDown],@"result", nil];
    [[NSNotificationCenter defaultCenter] postNotificationName:@"RESULT" object:nil userInfo:dic];
}

- (IBAction)onClickTest {
    [[self hud] show:YES];
    dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
        if ([jvmaHandler test]) {
            testModel = YES;
        }else{
            testModel = NO;
        }
        // 2. 回到主线程更新视图
        dispatch_async(dispatch_get_main_queue(), ^{
            [[self hud] hide:YES];
            [self changeStatus:testModel];
        });
    });
}

- (void)changeStatus:(BOOL)status{
    if (status) {
        [_testBtn setTitle:@"Default Mode" forState:UIControlStateNormal];
        [self.view setBackgroundColor:[UIColor colorWithRed:230.0/255 green:204.0/255 blue:210.0/255 alpha:1]];
        [self.tableview setBackgroundColor:[UIColor colorWithRed:230.0/255 green:204.0/255 blue:210.0/255 alpha:1]];
        [self.textview setBackgroundColor:[UIColor colorWithRed:230.0/255 green:204.0/255 blue:210.0/255 alpha:1]];
        [self.statusView setBackgroundColor:[UIColor colorWithRed:230.0/255 green:204.0/255 blue:210.0/255 alpha:1]];
    }else{
        [_testBtn setTitle:@"Test Mode" forState:UIControlStateNormal];
        [self.view setBackgroundColor:[UIColor whiteColor]];
        [self.tableview setBackgroundColor:[UIColor whiteColor]];
        [self.textview setBackgroundColor:[UIColor whiteColor]];
        [self.statusView setBackgroundColor:[UIColor whiteColor]];
    }
    
    for (TableViewGroupModel *group in groupArray) {
        for (id model in group.items) {
            if ([model isKindOfClass:[AddCellModel class]]) {
                AddCellModel *addCellModel = (AddCellModel*)model;
                addCellModel.isTestMode = status;
            }
            
            if ([model isKindOfClass:[CommandCellModel class]]) {
                CommandCellModel *commandCellModel = (CommandCellModel*)model;
                commandCellModel.isTestMode = status;
            }
            
            if ([model isKindOfClass:[RecordCellModel class]]) {
                RecordCellModel *recordCellModel = (RecordCellModel*)model;
                recordCellModel.isTestMode = status;
            }
            
            if ([model isKindOfClass:[ItemCellModel class]]) {
                ItemCellModel *itemCellModel = (ItemCellModel*)model;
                itemCellModel.isTestMode = status;
            }
            
            if ([model isKindOfClass:[SendCellModel class]]) {
                SendCellModel *sendCellModel = (SendCellModel*)model;
                sendCellModel.isTestMode = status;
            }
        }
    }
    [self.tableview reloadData];
}

- (IBAction)swichValueChange:(id)sender {
    if (self.timeSwitch.on) {
        inputTimeRecord = YES;
    }else{
        inputTimeRecord = NO;
    }
}
- (void)textFieldDidEndEditing: (UITextField *)textField {
    if (textField==self.passWordText) {
        NSUserDefaults *userDefaults = [NSUserDefaults standardUserDefaults];
        [userDefaults setValue:textField.text forKey:PASSWORDWORDKEY];
        [userDefaults synchronize];
        password = textField.text;
        [textField resignFirstResponder];
    }else if (textField==self.terminalPassWordText){
        NSUserDefaults *userDefaults = [NSUserDefaults standardUserDefaults];
        [userDefaults setValue:textField.text forKey:TERMINALPASSWORDWORDKEY];
        [userDefaults synchronize];
        [textField resignFirstResponder];
    }else if (textField==self.communicationRetryTimesText){
        [jvmaHandler setCommunicationRetryTimes:[self.communicationRetryTimesText.text intValue]];
    }
}

- (IBAction)clickRestart {
   [jvmaHandler restartAsreader];
}

- (void)whenClickSendBtn:(int)command{
    if ([password length] != 10) {
        UIAlertController *alert = [UIAlertController
                                     alertControllerWithTitle:@"error"
                                     message:@"PasswordError"
                                     preferredStyle:UIAlertControllerStyleAlert];
        UIAlertAction *ok = [UIAlertAction
                             actionWithTitle:@"OK"
                             style:UIAlertActionStyleDefault
                             handler:nil];
        [alert addAction:ok];
        [self presentViewController:alert animated:YES completion:nil];
        return;
    }
}

- (void)keyboardWillShow:(NSNotification *)notification {
    backView.hidden = NO;
    UITapGestureRecognizer *tap = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(hidenKeyBoard)];
    [backView addGestureRecognizer:tap];
}

- (void)keyboardDiDHide:(NSNotification *)notification {
    [self hidenKeyBoard];
}

- (void)hidenKeyBoard{
    [self.view endEditing:YES];
    backView.hidden = YES;
}

- (void)initView{
    [self.tableview reloadData];
    [self.hud hide:YES];
    testModel = NO;
    [self changeStatus:NO];
}

- (void)whenReceivedMessageResult:(NSString *)result{
    [self initView];
    UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"" message:result delegate:self cancelButtonTitle:@"OK" otherButtonTitles:nil];
    [alert show];
}
- (void)whenErrorReceivedMessageResult:(NSString *)result{
    [self initView];
    UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"error" message:result delegate:self cancelButtonTitle:@"OK" otherButtonTitles:nil];
    [alert show];
}

- (IBAction)onClickMakeBeep:(id)sender {
    [jvmaHandler makeBeep];
}
- (IBAction)onClickMakeVibration:(id)sender {
    [jvmaHandler makeVibration];
}
- (IBAction)onClickMakeBeepVibration:(id)sender {
    [jvmaHandler makeBeepVibration];
}

@end
